/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.allVpay.request;

import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.model.allVpay.BaseRequest;
import com.efuture.business.model.allVpay.request.PayRequest;
import com.efuture.business.model.allVpay.request.RefundRequest;
import com.efuture.business.model.allVpay.request.ZhongbaiBill;
import com.efuture.business.model.allVpay.request.ZhongbaiSaleReserveIn;
import com.efuture.business.model.allVpay.request.ZhongbaiSaleVoidIn;
import com.efuture.business.util.RSAConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class VoidRequest
extends BaseRequest {
    private static final long serialVersionUID = 1L;

    public VoidRequest(ZhongbaiSaleVoidIn reqIn, RSAConfig rsaConfig, CacheModel cacheModel) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.voidsale.code());
        VoidRequestData data = new VoidRequestData(reqIn, cacheModel);
        this.setData(data);
    }

    public VoidRequest(PayRequest payReq, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.voidsale.code());
        VoidRequestData data = new VoidRequestData(payReq);
        this.setData(data);
    }

    public VoidRequest(ZhongbaiSaleReserveIn reqIn, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.voidsale.code());
        VoidRequestData data = new VoidRequestData(reqIn);
        this.setData(data);
    }

    public VoidRequest(RefundRequest refundReq, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.voidsale.code());
        VoidRequestData data = new VoidRequestData(refundReq);
        this.setData(data);
    }

    public static class VoidRequestData
    extends BaseRequest.RequestData {
        private static final long serialVersionUID = 1L;
        private String listNo;
        private String orderNo;
        private String refundNo;
        private ZhongbaiBill bill;

        public String getListNo() {
            return this.listNo;
        }

        public void setListNo(String listNo) {
            this.listNo = listNo;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getRefundNo() {
            return this.refundNo;
        }

        public void setRefundNo(String refundNo) {
            this.refundNo = refundNo;
        }

        public ZhongbaiBill getBill() {
            return this.bill;
        }

        public void setBill(ZhongbaiBill bill) {
            this.bill = bill;
        }

        public VoidRequestData(ZhongbaiSaleVoidIn reqIn, CacheModel cacheModel) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            String nowDateTime = dateTime.format(df).toString();
            this.setTransDate(nowDateTime);
            if ("002".equals(cacheModel.getOrder().getErpCode())) {
                this.setStoreCode(reqIn.getShopCode().substring(0, 4));
            } else {
                this.setStoreCode(reqIn.getShopCode());
            }
            this.setPosId(reqIn.getTerminalNo());
            this.setListNo(reqIn.getIdSheetNo());
            this.setOrderNo(reqIn.getOrderNo());
        }

        public VoidRequestData(PayRequest payReq) {
            PayRequest.PayRequestData payData = (PayRequest.PayRequestData)payReq.getData();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(payData.getStoreCode());
            this.setPosId(payData.getPosId());
            this.setListNo(payData.getListNo());
            this.setOrderNo(payData.getOrderNo());
        }

        public VoidRequestData(ZhongbaiSaleReserveIn reqIn) {
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            if ("002".equals(reqIn.getErpCode())) {
                this.setStoreCode(reqIn.getShopCode().substring(0, 4));
            } else {
                this.setStoreCode(reqIn.getShopCode());
            }
            this.setPosId(reqIn.getTerminalNo());
            this.setListNo(reqIn.getTerminalSno());
            this.setOrderNo(reqIn.getOrderNo());
            this.setRefundNo(reqIn.getRefundNo());
        }

        public VoidRequestData(RefundRequest refundReq) {
            RefundRequest.RefundRequestData refundData = (RefundRequest.RefundRequestData)refundReq.getData();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(refundData.getStoreCode());
            this.setPosId(refundData.getPosId());
            this.setListNo(refundData.getListNo());
            this.setOrderNo(refundData.getOrderNo());
            this.setRefundNo(refundData.getRefundNo());
        }

        public VoidRequestData() {
        }
    }
}

