/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.mzk.request;

import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.model.mzk.AliMzkActiveInfo;
import com.efuture.business.util.CastUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AliMzkActiveIn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String storeCode;
    private String operateNumber;
    private String receiptNumber;
    private String cashierDeskCode;
    private String orderNo;
    private String payUserSerial;
    private double payAmount;
    private List<AliMzkActiveInfo> sellCardList;

    public AliMzkActiveIn(CacheModel cacheModel) {
        this.storeCode = cacheModel.getOrder().getShopCode();
        this.operateNumber = cacheModel.getOrder().getTerminalOperator();
        this.receiptNumber = cacheModel.getOrder().getTerminalSno();
        this.cashierDeskCode = cacheModel.getOrder().getTerminalNo();
        this.orderNo = cacheModel.getFlowNo();
        this.payUserSerial = cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo() + System.currentTimeMillis();
        this.sellCardList = new ArrayList<AliMzkActiveInfo>();
        this.payAmount = cacheModel.getOrder().getOughtPay();
        for (Goods g : cacheModel.getGoodsList()) {
            AliMzkActiveInfo card = new AliMzkActiveInfo();
            card.setCardNumber(g.getTrack());
            card.setCardValue(g.getSalePrice());
            card.setItemCode(g.getGoodsNo());
            card.setItemName(g.getGoodsName());
            card.setIsRebate("0");
            String[] infos = g.getMemo().split(",");
            card.setCardKindId(CastUtil.castLong((Object)infos[0]));
            card.setCardKindName(infos[1]);
            card.setCardKindId(CastUtil.castLong((Object)infos[2]));
            card.setCardKindName(infos[3]);
            this.sellCardList.add(card);
            if (!"0".equals(g.getFlag())) continue;
            PopDetail popDetail = new PopDetail();
            popDetail.setPopEventBillId("0");
            popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)g.getFixedDiscountValue(), (int)6, (int)1));
            popDetail.setPopMode("0");
            popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
            popDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
            popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getDpAmountDes() + "]");
            popDetail.setPopMemo("PRE:0");
            popDetail.setGoodsRow((long)g.getFlowId());
            g.getPopDetailsInfo().add(popDetail);
        }
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public String getOperateNumber() {
        return this.operateNumber;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public String getCashierDeskCode() {
        return this.cashierDeskCode;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public String getPayUserSerial() {
        return this.payUserSerial;
    }

    public double getPayAmount() {
        return this.payAmount;
    }

    public List<AliMzkActiveInfo> getSellCardList() {
        return this.sellCardList;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public void setOperateNumber(String operateNumber) {
        this.operateNumber = operateNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public void setCashierDeskCode(String cashierDeskCode) {
        this.cashierDeskCode = cashierDeskCode;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setPayUserSerial(String payUserSerial) {
        this.payUserSerial = payUserSerial;
    }

    public void setPayAmount(double payAmount) {
        this.payAmount = payAmount;
    }

    public void setSellCardList(List<AliMzkActiveInfo> sellCardList) {
        this.sellCardList = sellCardList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AliMzkActiveIn)) {
            return false;
        }
        AliMzkActiveIn other = (AliMzkActiveIn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getPayAmount(), other.getPayAmount()) != 0) {
            return false;
        }
        String this$storeCode = this.getStoreCode();
        String other$storeCode = other.getStoreCode();
        if (this$storeCode == null ? other$storeCode != null : !this$storeCode.equals(other$storeCode)) {
            return false;
        }
        String this$operateNumber = this.getOperateNumber();
        String other$operateNumber = other.getOperateNumber();
        if (this$operateNumber == null ? other$operateNumber != null : !this$operateNumber.equals(other$operateNumber)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        String this$cashierDeskCode = this.getCashierDeskCode();
        String other$cashierDeskCode = other.getCashierDeskCode();
        if (this$cashierDeskCode == null ? other$cashierDeskCode != null : !this$cashierDeskCode.equals(other$cashierDeskCode)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        String this$payUserSerial = this.getPayUserSerial();
        String other$payUserSerial = other.getPayUserSerial();
        if (this$payUserSerial == null ? other$payUserSerial != null : !this$payUserSerial.equals(other$payUserSerial)) {
            return false;
        }
        List<AliMzkActiveInfo> this$sellCardList = this.getSellCardList();
        List<AliMzkActiveInfo> other$sellCardList = other.getSellCardList();
        return !(this$sellCardList == null ? other$sellCardList != null : !((Object)this$sellCardList).equals(other$sellCardList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AliMzkActiveIn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $payAmount = Double.doubleToLongBits(this.getPayAmount());
        result = result * 59 + (int)($payAmount >>> 32 ^ $payAmount);
        String $storeCode = this.getStoreCode();
        result = result * 59 + ($storeCode == null ? 43 : $storeCode.hashCode());
        String $operateNumber = this.getOperateNumber();
        result = result * 59 + ($operateNumber == null ? 43 : $operateNumber.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        String $cashierDeskCode = this.getCashierDeskCode();
        result = result * 59 + ($cashierDeskCode == null ? 43 : $cashierDeskCode.hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        String $payUserSerial = this.getPayUserSerial();
        result = result * 59 + ($payUserSerial == null ? 43 : $payUserSerial.hashCode());
        List<AliMzkActiveInfo> $sellCardList = this.getSellCardList();
        result = result * 59 + ($sellCardList == null ? 43 : ((Object)$sellCardList).hashCode());
        return result;
    }

    public String toString() {
        return "AliMzkActiveIn(storeCode=" + this.getStoreCode() + ", operateNumber=" + this.getOperateNumber() + ", receiptNumber=" + this.getReceiptNumber() + ", cashierDeskCode=" + this.getCashierDeskCode() + ", orderNo=" + this.getOrderNo() + ", payUserSerial=" + this.getPayUserSerial() + ", payAmount=" + this.getPayAmount() + ", sellCardList=" + this.getSellCardList() + ")";
    }
}

