/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.wsykt;

import com.efuture.business.model.wsykt.FieldInfo;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PacketInfo {
    private final Map<String, FieldInfo> fieldMap = new HashMap<String, FieldInfo>();
    private final Vector<FieldInfo> fieldVector = new Vector();
    private int size = 0;

    public void addField(String name, int fieldSize) {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.name = name;
        fieldInfo.size = fieldSize;
        fieldInfo.offset = this.size;
        this.fieldMap.put(name, fieldInfo);
        this.fieldVector.add(fieldInfo);
        this.size += fieldSize;
    }

    public int getPacketSize() {
        return this.size;
    }

    public int getFieldSize(String name) {
        FieldInfo fieldInfo = this.fieldMap.get(name);
        return fieldInfo.size;
    }

    public int getFieldOffset(String name) {
        FieldInfo fieldInfo = this.fieldMap.get(name);
        return fieldInfo.offset;
    }

    public String getFieldString(byte[] packet, int base, String name) throws UnsupportedEncodingException {
        FieldInfo fieldInfo = this.fieldMap.get(name);
        String value = new String(packet, base + fieldInfo.offset, fieldInfo.size, "GB2312");
        value = value.trim();
        return value;
    }

    public void setFieldString(String name, String value) {
        FieldInfo fieldInfo = this.fieldMap.get(name);
        fieldInfo.value = value == null ? "" : value.trim();
    }

    public String getPacketString() {
        Object packetString = "";
        FieldInfo fieldInfo = null;
        String fieldString = null;
        String errorText = null;
        for (int i = 0; i < this.fieldVector.size(); ++i) {
            fieldInfo = this.fieldVector.elementAt(i);
            if (fieldInfo.value == null) {
                errorText = fieldInfo.name + "FieldIsNull";
                throw new RuntimeException(errorText);
            }
            if (fieldInfo.value.length() > fieldInfo.size) {
                errorText = fieldInfo.name + "FieldLengthTooLong";
                throw new RuntimeException(errorText);
            }
            fieldString = PacketInfo.rightPad(fieldInfo.value, fieldInfo.size, fieldInfo.padChar);
            packetString = (String)packetString + fieldString;
        }
        return packetString;
    }

    public byte[] getPacketBytes() {
        int i;
        int packetSize = this.getPacketSize();
        byte[] packetBytes = new byte[packetSize];
        FieldInfo fieldInfo = null;
        byte[] fieldBytes = null;
        String errorText = null;
        for (i = 0; i < packetSize; ++i) {
            packetBytes[i] = 32;
        }
        for (i = 0; i < this.fieldVector.size(); ++i) {
            fieldInfo = this.fieldVector.elementAt(i);
            if (fieldInfo.value == null) {
                errorText = fieldInfo.name + "FieldIsNull";
                throw new RuntimeException(errorText);
            }
            fieldBytes = fieldInfo.value.getBytes();
            if (fieldBytes.length > fieldInfo.size) {
                errorText = fieldInfo.name + "FieldLengthTooLong";
                throw new RuntimeException(errorText);
            }
            int k = fieldInfo.offset;
            int j = 0;
            while (j < fieldBytes.length) {
                packetBytes[k] = fieldBytes[j];
                ++j;
                ++k;
            }
        }
        return packetBytes;
    }

    public static String rightPad(String text, int length, char pad) {
        int padLen = length - ((String)text).length();
        if (padLen > 0) {
            char[] tmp = new char[padLen];
            for (int i = 0; i < padLen; ++i) {
                tmp[i] = pad;
            }
            text = (String)text + new String(tmp);
        }
        return text;
    }
}

