/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.xjhj;

import com.efuture.business.model.xjhj.KeyCertInfo;
import com.efuture.business.util.CryptoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCrt {
    private static final Logger log = LoggerFactory.getLogger(ServerCrt.class);

    public static KeyCertInfo getKey(String p12name, String passwd) {
        FileInputStream resourceAsStream = null;
        try {
            resourceAsStream = new FileInputStream(new File(p12name));
        }
        catch (FileNotFoundException e) {
            log.error("ServerCrt getKey error: {0}", (Throwable)e);
        }
        String alias = "conname";
        String keyStoreType = "PKCS12";
        KeyCertInfo keyCertInfo = CryptoUtil.fileStreamToKeyCertInfo(resourceAsStream, passwd, keyStoreType, alias);
        return keyCertInfo;
    }

    public static Signature getSignture() {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA256withRSA", (Provider)bouncyCastleProvider);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("ServerCrt getSignture error: {0}", (Throwable)e);
        }
        return signature;
    }
}

