/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulateDateTime;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.Syspara;
import com.efuture.business.model.allVpay.request.CheckPayCodeIn;
import com.efuture.business.model.allVpay.response.CheckPayCodeOut;
import com.efuture.business.model.xjhj.Base64;
import com.efuture.business.model.xjhj.BestPayIn;
import com.efuture.business.model.xjhj.BestPayResult;
import com.efuture.business.model.xjhj.BestpayResponse;
import com.efuture.business.model.xjhj.CertificateUtil;
import com.efuture.business.service.BestPaySaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import com.product.util.TypeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class BestPaySaleBSImpl
implements BestPaySaleBS {
    private static final Logger log = LoggerFactory.getLogger(BestPaySaleBSImpl.class);
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    protected RestTemplate restTemplate;
    public static final String SIGNATURE_ALGORITHM_SHA1 = "SHA1withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA256 = "SHA256withRSA";
    protected String CHECKPAYCODE = "order.online.check.payCode";
    private final String barCodePay = "/mapi/uniformReceipt/barCodePay";
    private final String tradeRefund = "/mapi/uniformReceipt/tradeRefund";
    private final String tradeQuery = "/mapi/uniformReceipt/tradeQuery";
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    protected PosLogicCompoment posLogicCompoment;
    @Autowired
    public OrderTransfer orderTransfer;
    @Value(value="${filePath:}")
    private String filePath;
    @Value(value="${bestpay.storeCode:}")
    private String storeCode;
    @Value(value="${bestpay.version:}")
    private String version;
    @Value(value="${bestpay.cername:}")
    private String cername;
    @Value(value="${bestpay.p12name}")
    private String p12name;

    @Override
    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("BestPay salePay input===>{}", (Object)JSON.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo", "precision", "rate", "payCode", "payName", "terminalSno", "tradeAmt"});
        if (!check.getReturncode().equals("0")) {
            return Code.CODE_500001.getRespBase(new Object[]{check.getData()});
        }
        BestPayIn bestPayIn = (BestPayIn)((Object)JSONObject.toJavaObject((JSON)paramsObject, BestPayIn.class));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + bestPayIn.getShopCode() + bestPayIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        int maxSalePayCount = this.getMaxPayCount(obj);
        if (cacheModel.getPayments().size() >= maxSalePayCount) {
            return new RespBase(Code.CODE_50044, (Object)"\u8ba2\u5355\u8d85\u8fc7\u6700\u5927\u4ed8\u6b3e\u884c\u6570\u8bbe\u7f6e!", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - CastUtil.castDouble((Object)bestPayIn.getTradeAmt()) < 0.0) {
            return new RespBase(Code.CODE_500003.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        PaymentMode payMode = PayModeUtils.getPayMode((String)bestPayIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        if (null == payMode) {
            return Code.CODE_50015.getRespBase(new Object[]{bestPayIn.getPayCode() + "\u4ed8\u6b3e\u6a21\u677f\u4e3a\u7a7a"});
        }
        String merchantNo = this.getSysparaCodeByInstr(obj, "merchantNo");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"merchantNo"});
        }
        String url = this.getSysparaCodeByInstr(obj, "YZFpayUrl");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"YZFpayUrl"});
        }
        String passwd = this.getSysparaCodeByInstr(obj, "YZFpasswd");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"YZFpasswd"});
        }
        bestPayIn.setMerchantNo(merchantNo);
        String outTradeNo = this.createOutTradeNo(bestPayIn);
        String p12namePath = this.filePath + this.p12name + bestPayIn.getShopCode() + ".P12";
        log.info("p12namePath===>{}", (Object)p12namePath);
        PrivateKey privateKey = this.getPirvateKey(p12namePath, passwd, "PKCS12");
        TreeMap<String, String> map = this.getReqMap("/mapi/uniformReceipt/barCodePay", outTradeNo, bestPayIn);
        StringBuilder signData = new StringBuilder();
        for (String in : map.keySet()) {
            String str = map.get(in);
            signData.append(in).append("=").append(str).append("&");
        }
        String tobeSigned = signData.deleteCharAt(signData.length() - 1).toString();
        log.info("\u7ffc\u652f\u4ed8\u652f\u4ed8\u52a0\u7b7e\u539f\u6587\uff1a" + tobeSigned);
        String sign = this.sign(tobeSigned, SIGNATURE_ALGORITHM_SHA256, privateKey);
        log.info("\u7ffc\u652f\u4ed8\u652f\u4ed8\u52a0\u7b7e\u503csign:" + sign);
        map.put("sign", sign);
        BestpayResponse<String> bestpayR = this.doService(url + "/mapi/uniformReceipt/barCodePay?BESTPAY_MAPI_VERSION=" + this.version, JSONObject.toJSONString(map));
        if (!"200".equals(bestpayR.getCode())) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u8c03\u7528\u7ffc\u652f\u4ed8\u901a\u8baf\u5931\u8d25\uff1a" + bestpayR.getCode()});
        }
        JSONObject resJson = JSON.parseObject((String)bestpayR.getData());
        log.info("resJson===>{}", (Object)JSON.toJSONString((Object)resJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        boolean success = resJson.getBoolean("success");
        if (success) {
            log.info("\u7ffc\u652f\u4ed8\u4e0b\u5355\u6210\u529f....");
            JSONObject resultJson = resJson.getJSONObject("result");
            BestPayResult bestPayResult = (BestPayResult)JSONObject.toJavaObject((JSON)resultJson, BestPayResult.class);
            if (bestPayResult.getTradeStatus().equals("SUCCESS")) {
                Payment payment = this.createBestPayment(payMode, cacheModel, bestPayIn, bestPayResult);
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
            }
            if (bestPayResult.getTradeStatus().equals("WAITFORPAY")) {
                Object reqdate = outTradeNo.substring(0, 14);
                String date = ManipulateDateTime.getConversionDate((String)((String)reqdate).substring(0, 8), (char)'-');
                String time = ManipulateDateTime.getConversionTime((String)((String)reqdate).substring(8));
                reqdate = date + " " + time;
                bestPayIn.setQueryTradeNo(outTradeNo);
                bestPayIn.setTradeDate((String)reqdate);
                TreeMap<String, String> mapQuery = this.getReqMap("/mapi/uniformReceipt/tradeQuery", bestPayIn.getQueryTradeNo(), bestPayIn);
                StringBuilder signDataQuery = new StringBuilder();
                for (String in : mapQuery.keySet()) {
                    String str = mapQuery.get(in);
                    signDataQuery.append(in).append("=").append(str).append("&");
                }
                String tobeSignedquery = signDataQuery.deleteCharAt(signDataQuery.length() - 1).toString();
                log.info("\u652f\u4ed8\u8f6e\u8be2\u52a0\u7b7e\u539f\u6587\uff1a" + tobeSignedquery);
                String signquery = this.sign(tobeSignedquery, SIGNATURE_ALGORITHM_SHA256, privateKey);
                log.info("\u652f\u4ed8\u8f6e\u8be2\u52a0\u7b7e\u503csignquery:" + signquery);
                mapQuery.put("sign", signquery);
                int count = 0;
                do {
                    try {
                        log.info("\u7b2c" + count + "\u6b21\u652f\u4ed8\u8f6e\u8be2");
                        BestpayResponse<String> bestpayQuery = this.doService(url + "/mapi/uniformReceipt/tradeQuery?BESTPAY_MAPI_VERSION=" + this.version, JSONObject.toJSONString(mapQuery));
                        if (!"200".equals(bestpayQuery.getCode())) {
                            return new RespBase(Code.CODE_55555.getIndex(), outTradeNo, "");
                        }
                        JSONObject resJsonQ = JSON.parseObject((String)bestpayQuery.getData());
                        log.info("\u652f\u4ed8\u8f6e\u8be2resJsonQ===>{}", (Object)JSON.toJSONString((Object)resJsonQ, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        boolean success1 = resJsonQ.getBoolean("success");
                        if (success1) {
                            log.info("\u7ffc\u652f\u4ed8\u652f\u4ed8\u8f6e\u8be2\u6210\u529f....");
                            JSONObject resultInfoQ = resJsonQ.getJSONObject("result");
                            BestPayResult bestPayResultQ = (BestPayResult)JSONObject.toJavaObject((JSON)resultInfoQ, BestPayResult.class);
                            if (bestPayResultQ.getTradeStatus().equals("SUCCESS")) {
                                Payment payment = this.createBestPayment(payMode, cacheModel, bestPayIn, bestPayResult);
                                log.info("\u7ffc\u652f\u4ed8\u652f\u4ed8\u8f6e\u8be2\u6210\u529f\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                                vo.setCacheModel(cacheModel);
                                BaseOutModel out = new BaseOutModel();
                                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                            }
                        }
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                } while (++count < 5);
                log.info("\u7ffc\u652f\u4ed8\u652f\u4ed8\u81ea\u52a8\u8f6e\u8be25\u6b21\u7ed3\u675f");
                return new RespBase(Code.CODE_55555.getIndex(), outTradeNo, "");
            }
        }
        return Code.CODE_50015.getRespBase(new Object[]{resJson.getString("errorCode") + resJson.getString("errorMsg")});
    }

    public String getSysparaCodeByInstr(String obj, String inStr) {
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "";
        List sysParaList = modeDetailsVo.getSyspara();
        List newlist = sysParaList.stream().filter(syspara -> syspara.getCode().equals(inStr)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(newlist)) {
            paravalue = ((Syspara)newlist.get(0)).getParavalue();
        }
        return paravalue;
    }

    public String convertTradeAmt(double amt) {
        return String.valueOf((long)ManipulatePrecision.doubleConvert((double)(amt * 100.0), (int)2, (int)1));
    }

    public String createOutTradeNo(BestPayIn bestPayIn) {
        String shopCode = bestPayIn.getShopCode();
        String terminalNo = bestPayIn.getTerminalNo();
        String tradeAmt = this.convertTradeAmt(bestPayIn.getTradeAmt());
        String dateTime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String outTradeNo = dateTime + shopCode + terminalNo + "00" + tradeAmt;
        if (tradeAmt.length() > 8) {
            outTradeNo = dateTime + shopCode + "00" + tradeAmt;
        }
        return outTradeNo;
    }

    public PrivateKey getPirvateKey(String merchantCertificatePath, String pwd, String keyStroeType) {
        try {
            FileInputStream pubStream = new FileInputStream(new File(merchantCertificatePath));
            return CertificateUtil.getMerchantPirvateKey(pubStream, pwd, keyStroeType);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public PublicKey getPublicKey(String bestpayCertificatePath) {
        try {
            FileInputStream pubStream = new FileInputStream(new File(bestpayCertificatePath));
            return CertificateUtil.getPublicKey(pubStream);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RespBase salePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("BestPay salePayQuery input===>{}", (Object)JSON.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo", "precision", "rate", "payCode", "payName", "terminalSno", "queryTradeNo"});
        if (!check.getReturncode().equals("0")) {
            return Code.CODE_500001.getRespBase(new Object[]{check.getData()});
        }
        BestPayIn bestPayIn = (BestPayIn)((Object)JSONObject.toJavaObject((JSON)paramsObject, BestPayIn.class));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Boolean hasPayment = false;
        List cacheList = cacheModel.getPayments();
        log.info("cachePaymentList==>{}", (Object)JSONObject.toJSONString((Object)cacheList));
        log.info("QueryTradeNo==>{}", (Object)bestPayIn.getQueryTradeNo());
        if (bestPayIn.getQueryTradeNo().length() > 32) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u4ea4\u6613\u6d41\u6c34\u53f7\u8d85\u8fc7\u6700\u5927\u957f\u5ea6"});
        }
        for (Payment payment : cacheList) {
            if (!StringUtils.isNotBlank((String)payment.getPayNo()) || !payment.getPayNo().equals(bestPayIn.getQueryTradeNo())) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        JSONObject orderJson = new JSONObject();
        orderJson.put("shopCode", (Object)bestPayIn.getShopCode());
        orderJson.put("idSheetNo", (Object)bestPayIn.getQueryTradeNo());
        boolean b = this.checkPayCode(session, orderJson, cacheModel.getOrder().getErpCode());
        if (!b) {
            return Code.CODE_50103.getRespBase(new Object[0]);
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + bestPayIn.getShopCode() + bestPayIn.getTerminalNo());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        PaymentMode payMode = PayModeUtils.getPayMode((String)bestPayIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        if (null == payMode) {
            return Code.CODE_50015.getRespBase(new Object[]{bestPayIn.getPayCode() + "\u4ed8\u6b3e\u6a21\u677f\u4e3a\u7a7a"});
        }
        String merchantNo = this.getSysparaCodeByInstr(obj, "merchantNo");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"merchantNo"});
        }
        String url = this.getSysparaCodeByInstr(obj, "YZFpayUrl");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"YZFpayUrl"});
        }
        String passwd = this.getSysparaCodeByInstr(obj, "YZFpasswd");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"YZFpasswd"});
        }
        bestPayIn.setMerchantNo(merchantNo);
        String p12namePath = this.filePath + this.p12name + bestPayIn.getShopCode() + ".P12";
        log.info("p12namePath===>{}", (Object)p12namePath);
        PrivateKey privateKey = this.getPirvateKey(p12namePath, passwd, "PKCS12");
        if (bestPayIn.getQueryTradeNo().length() < 14) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u8ba2\u5355\u53f7\u683c\u5f0f\u9519\u8bef"});
        }
        Object reqdate = bestPayIn.getQueryTradeNo().substring(0, 14);
        String date = ManipulateDateTime.getConversionDate((String)((String)reqdate).substring(0, 8), (char)'-');
        String time = ManipulateDateTime.getConversionTime((String)((String)reqdate).substring(8));
        reqdate = date + " " + time;
        bestPayIn.setTradeDate((String)reqdate);
        TreeMap<String, String> map = this.getReqMap("/mapi/uniformReceipt/tradeQuery", bestPayIn.getQueryTradeNo(), bestPayIn);
        StringBuilder signData = new StringBuilder();
        for (String in : map.keySet()) {
            String str = map.get(in);
            signData.append(in).append("=").append(str).append("&");
        }
        String tobeSigned = signData.deleteCharAt(signData.length() - 1).toString();
        log.info("salePayQuery\u52a0\u7b7e\u539f\u6587\uff1a" + tobeSigned);
        String sign = this.sign(tobeSigned, SIGNATURE_ALGORITHM_SHA256, privateKey);
        log.info("salePayQuery\u52a0\u7b7e\u503csign:" + sign);
        map.put("sign", sign);
        BestpayResponse<String> bestpayR = this.doService(url + "/mapi/uniformReceipt/tradeQuery?BESTPAY_MAPI_VERSION=" + this.version, JSONObject.toJSONString(map));
        if (!"200".equals(bestpayR.getCode())) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u8c03\u7528\u7ffc\u652f\u4ed8\u901a\u8baf\u5931\u8d25\uff1a" + bestpayR.getCode()});
        }
        JSONObject resJson = JSON.parseObject((String)bestpayR.getData());
        log.info("resJson===>{}", (Object)JSON.toJSONString((Object)resJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        boolean success = resJson.getBoolean("success");
        if (success) {
            log.info("\u7ffc\u652f\u4ed8\u67e5\u8be2\u6210\u529f....");
            JSONObject resultInfo = resJson.getJSONObject("result");
            BestPayResult bestPayResult = (BestPayResult)JSONObject.toJavaObject((JSON)resultInfo, BestPayResult.class);
            if (bestPayResult.getTradeStatus().equals("SUCCESS")) {
                Payment payment = this.createBestPayment(payMode, cacheModel, bestPayIn, bestPayResult);
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
        }
        return Code.CODE_50015.getRespBase(new Object[]{resJson.getString("errorCode") + resJson.getString("errorMsg")});
    }

    @Override
    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("BestPay saleRefund input===>{}", (Object)JSON.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo", "tradeAmt", "precision", "rate", "payCode", "payName", "terminalSno", "oldTradeNo"});
        if (!check.getReturncode().equals("0")) {
            return Code.CODE_500001.getRespBase(new Object[]{check.getData()});
        }
        BestPayIn bestPayIn = (BestPayIn)((Object)JSONObject.toJavaObject((JSON)paramsObject, BestPayIn.class));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + bestPayIn.getShopCode() + bestPayIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        double money = ManipulatePrecision.doubleConvert((double)CastUtil.castDouble((Object)bestPayIn.getTradeAmt()), (int)2, (int)1);
        log.info("saleRefund\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - money < 0.0) {
            return new RespBase(Code.CODE_50110.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        PaymentMode payMode = PayModeUtils.getPayMode((String)bestPayIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        if (null == payMode) {
            return Code.CODE_50015.getRespBase(new Object[]{bestPayIn.getPayCode() + "\u4ed8\u6b3e\u6a21\u677f\u4e3a\u7a7a"});
        }
        String merchantNo = this.getSysparaCodeByInstr(obj, "merchantNo");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"merchantNo"});
        }
        String url = this.getSysparaCodeByInstr(obj, "YZFpayUrl");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"YZFpayUrl"});
        }
        String passwd = this.getSysparaCodeByInstr(obj, "YZFpasswd");
        if (StringUtils.isEmpty((String)merchantNo)) {
            return Code.CODE_500001.getRespBase(new Object[]{"YZFpasswd"});
        }
        bestPayIn.setMerchantNo(merchantNo);
        String p12namePath = this.filePath + this.p12name + bestPayIn.getShopCode() + ".P12";
        log.info("p12namePath===>{}", (Object)p12namePath);
        PrivateKey privateKey = this.getPirvateKey(p12namePath, passwd, "PKCS12");
        String outTradeNo = this.createOutTradeNo(bestPayIn);
        if (bestPayIn.getOldTradeNo().length() < 14) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u539f\u8ba2\u5355\u53f7\u683c\u5f0f\u9519\u8bef"});
        }
        Object reqdate = bestPayIn.getOldTradeNo().substring(0, 14);
        String date = ManipulateDateTime.getConversionDate((String)((String)reqdate).substring(0, 8), (char)'-');
        String time = ManipulateDateTime.getConversionTime((String)((String)reqdate).substring(8));
        reqdate = date + " " + time;
        bestPayIn.setOriginalTradeDate((String)reqdate);
        TreeMap<String, String> map = this.getReqMap("/mapi/uniformReceipt/tradeRefund", outTradeNo, bestPayIn);
        StringBuilder signData = new StringBuilder();
        for (String in : map.keySet()) {
            String str = map.get(in);
            signData.append(in).append("=").append(str).append("&");
        }
        String tobeSigned = signData.deleteCharAt(signData.length() - 1).toString();
        log.info("saleRefund\u52a0\u7b7e\u539f\u6587\uff1a" + tobeSigned);
        String sign = this.sign(tobeSigned, SIGNATURE_ALGORITHM_SHA256, privateKey);
        log.info("saleRefund\u52a0\u7b7e\u503csign:" + sign);
        map.put("sign", sign);
        BestpayResponse<String> bestpayR = this.doService(url + "/mapi/uniformReceipt/tradeRefund?BESTPAY_MAPI_VERSION=" + this.version, JSONObject.toJSONString(map));
        if (!"200".equals(bestpayR.getCode())) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u8c03\u7528\u7ffc\u652f\u4ed8\u901a\u8baf\u5931\u8d25\uff1a" + bestpayR.getCode()});
        }
        JSONObject resJson = JSON.parseObject((String)bestpayR.getData());
        log.info("resJson===>{}", (Object)JSON.toJSONString((Object)resJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        boolean success = resJson.getBoolean("success");
        if (success) {
            log.info("\u7ffc\u652f\u4ed8\u9000\u6b3e\u6210\u529f....");
            JSONObject resultInfo = resJson.getJSONObject("result");
            BestPayResult bestPayResult = (BestPayResult)JSONObject.toJavaObject((JSON)resultInfo, BestPayResult.class);
            if (bestPayResult.getTradeStatus().equals("SUCCESS")) {
                bestPayResult.setTradeAmt(bestPayResult.getRefundAmt());
                Payment payment = this.createBestPayment(payMode, cacheModel, bestPayIn, bestPayResult);
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            if (bestPayResult.getTradeStatus().equals("WAITFORPAY")) {
                // empty if block
            }
        }
        return Code.CODE_50015.getRespBase(new Object[]{resJson.getString("errorCode") + resJson.getString("errorMsg")});
    }

    public Payment createBestPayment(PaymentMode payMode, CacheModel cacheModel, BestPayIn bestPayIn, BestPayResult bestPayResult) {
        double je = ManipulatePrecision.doubleConvert((double)(Double.parseDouble(String.valueOf(bestPayResult.getTradeAmt())) / 100.0));
        Payment payment = new Payment();
        payment.setPayCode(bestPayIn.getPayCode());
        payment.setPayName(bestPayIn.getPayName());
        payment.setPayType(payMode.getPaytype());
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setRownoId(payment.getPuid());
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setPayNo(bestPayResult.getOutTradeNo());
        payment.setInvoiceFlag(bestPayIn.isInvoiceFlag());
        payment.setCreditsFlag(bestPayIn.isCreditsFlag());
        payment.setMoney(je);
        payment.setAmount(je);
        payment.setRate(bestPayIn.getRate());
        payment.setPrecision(String.valueOf(bestPayIn.getPrecision()));
        payment.setPrcutMode(bestPayIn.getCutMode());
        payment.setFlag("1");
        payment.setTerminalNo(bestPayIn.getTerminalNo());
        payment.setTerminalSno(bestPayIn.getTerminalSno());
        payment.setDiscountValue(0.0);
        payment.setMerchantDiscountValue(0.0);
        payment.setPayChannelDiscountValue(0.0);
        payment.setPayMemo(bestPayIn.getRequestDate());
        payment.setRefCode(bestPayResult.getTradeNo());
        payment.setIsSuccess(true);
        return payment;
    }

    public boolean checkPayCode(ServiceSession session, JSONObject json, String erpCode) {
        try {
            CheckPayCodeOut out;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            CheckPayCodeIn in = new CheckPayCodeIn();
            in.setBusiTakeMarketCode(json.getString("shopCode"));
            in.setErpCode(erpCode);
            in.setPayNo(json.getString("idSheetNo"));
            try {
                String searchDate = dateFormat.format(new Date());
                String data = DateHelpUtil.getYestoryDate((String)searchDate);
                Date whenDate = TypeUtils.castToDate((Object)data);
                in.setStartDateTime(whenDate);
                String afterHour = DateHelpUtil.getAfterHourByHour((int)9);
                Date afterDate = TypeUtils.castToDate((Object)afterHour);
                in.setEndDateTime(afterDate);
            }
            catch (Exception searchDate) {
                // empty catch block
            }
            HashMap<String, CheckPayCodeIn> map = new HashMap<String, CheckPayCodeIn>();
            map.put("data", in);
            ServiceResponse response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, this.CHECKPAYCODE, session, JSON.toJSONString(map), CheckPayCodeOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6821\u9a8c\u5546\u6237\u8ba2\u5355\u53f7");
            if ("0".equals(response.getReturncode()) && !(out = (CheckPayCodeOut)response.getData()).getExist().booleanValue()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getPayTerminalNoStrByKey(String obj, String key) {
        JSONObject syjmainVo = JSONObject.parseObject((String)obj).getJSONObject("syjmain");
        return syjmainVo.getString(key);
    }

    private int getMaxPayCount(String obj) {
        JSONObject object3;
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "1";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (!sysParaArray.isEmpty()) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("OZ")) continue;
                array.add((Object)sys);
            }
        }
        if (!array.isEmpty() && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        String[] temp = paravalue.split(",");
        return Integer.valueOf(temp[1]);
    }

    private TreeMap<String, String> getReqMap(String type, String outTradeNo, BestPayIn bestPayIn) {
        String je = String.valueOf(ManipulatePrecision.doubleConvert((double)(bestPayIn.getTradeAmt() * 100.0)));
        if (je.contains(".")) {
            je = je.substring(0, je.indexOf("."));
        }
        String tradeAmt = je;
        TreeMap<String, String> translateResultData = new TreeMap<String, String>();
        if (type.equals(this.barCodePay)) {
            translateResultData.put("merchantNo", bestPayIn.getMerchantNo());
            translateResultData.put("outTradeNo", outTradeNo);
            translateResultData.put("tradeAmt", tradeAmt);
            translateResultData.put("authCode", bestPayIn.getAuthCode());
            translateResultData.put("subject", "\u626b\u7801\u652f\u4ed8");
            translateResultData.put("tradeChannel", "APP");
            translateResultData.put("accessCode", "EXTERNAL_PAYMENT");
            translateResultData.put("ccy", "156");
            translateResultData.put("requestDate", bestPayIn.getRequestDate());
            translateResultData.put("operator", bestPayIn.getTerminalOperator());
            translateResultData.put("storeCode", this.storeCode);
            translateResultData.put("storeName", bestPayIn.getShopName());
        } else if (type.equals(this.tradeRefund)) {
            translateResultData.put("merchantNo", bestPayIn.getMerchantNo());
            translateResultData.put("outTradeNo", bestPayIn.getOldTradeNo());
            translateResultData.put("refundAmt", tradeAmt);
            translateResultData.put("requestDate", bestPayIn.getRequestDate());
            translateResultData.put("originalTradeDate", bestPayIn.getOriginalTradeDate());
            translateResultData.put("operator", bestPayIn.getTerminalOperator());
            translateResultData.put("tradeChannel", "APP");
            translateResultData.put("accessCode", "EXTERNAL_PAYMENT");
            translateResultData.put("ccy", "156");
            translateResultData.put("outRequestNo", outTradeNo);
        } else if (type.equals(this.tradeQuery)) {
            translateResultData.put("outTradeNo", outTradeNo);
            translateResultData.put("merchantNo", bestPayIn.getMerchantNo());
            translateResultData.put("tradeDate", bestPayIn.getTradeDate());
        }
        translateResultData.put("institutionType", "MERCHANT");
        translateResultData.put("institutionCode", bestPayIn.getMerchantNo());
        return translateResultData;
    }

    public boolean doVerifyInstanJsonArray(String response, PublicKey publicKey) {
        TreeMap map = new TreeMap();
        if (StringUtils.isEmpty((String)response)) {
            return false;
        }
        JSONObject mapTypes = JSON.parseObject((String)response);
        log.info("mapTypes=====:{}", (Object)mapTypes);
        Map<String, Object> data = this.translateResultData((Map<String, Object>)mapTypes);
        log.info("data=====:{}", data);
        String sign = String.valueOf(mapTypes.get("sign"));
        log.info("sign\uff1a" + sign);
        String tobeVerify = this.assembelSignaturingData(data);
        log.info("\u5f85\u9a8c\u7b7e tobeVerify\uff1a" + tobeVerify);
        try {
            return this.verify(tobeVerify, sign, SIGNATURE_ALGORITHM_SHA1, publicKey);
        }
        catch (Exception e) {
            log.error("\u7ffc\u652f\u4ed8\u9a8c\u7b7e\u5f02\u5e38\uff1a" + e);
            return false;
        }
    }

    public String sign(String tobeSigned, String algorithm, PrivateKey privateKey) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(tobeSigned.getBytes("UTF-8"));
            byte[] signBytes = signature.sign();
            return Base64.encode(signBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("sign\u7b7e\u540dNoSuchAlgorithmException:" + e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("sign\u7b7e\u540dUnsupportedEncodingException:" + e);
            throw new RuntimeException(e);
        }
        catch (SignatureException e) {
            log.error("sign\u7b7e\u540dSignatureException:" + e);
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            log.error("sign\u7b7e\u540dInvalidKeyException:" + e);
            throw new RuntimeException(e);
        }
    }

    public boolean verify(String plainText, String sign, String algorithm, PublicKey publicKey) {
        try {
            Signature verify = Signature.getInstance(algorithm);
            verify.initVerify(publicKey);
            verify.update(plainText.getBytes("UTF-8"));
            return verify.verify(Base64.decode(sign));
        }
        catch (Exception e) {
            log.info("verify\u9a8c\u7b7e\u5f02\u5e38\uff1a" + e);
            return false;
        }
    }

    public String assembelSignaturingData(Map data) {
        StringBuilder sb = new StringBuilder();
        TreeMap treeMap = new TreeMap(data);
        for (Map.Entry ent : treeMap.entrySet()) {
            String name = (String)ent.getKey();
            if ("sign".equals(name)) continue;
            sb.append(name).append('=').append(ent.getValue()).append('&');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public Map<String, Object> translateResultData(Map<String, Object> res) {
        HashMap<String, Object> resultDataMap = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> set = res.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(entry.getValue() instanceof String)) {
                if (entry.getValue() instanceof String[] || entry.getValue() instanceof Map || entry.getValue() instanceof List) {
                    resultDataMap.put(key, JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.UseISO8601DateFormat}));
                    continue;
                }
                resultDataMap.put(key, value);
                continue;
            }
            resultDataMap.put(key, (String)value);
        }
        return resultDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BestpayResponse<String> doService(String Url, String request) {
        log.info("\u8bf7\u6c42\u7ffc\u652f\u4ed8\u7684URL\u5730\u5740\uff1a" + Url);
        log.info("\u53d1\u9001\u7ed9\u7ffc\u652f\u4ed8\u7684http\u8bf7\u6c42\u62a5\u6587:" + request);
        HttpPost httpPost = new HttpPost(Url);
        httpPost.setHeader("Content-Type", "application/json");
        StringEntity se = new StringEntity(request, "utf-8");
        httpPost.setEntity((HttpEntity)se);
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        try {
            CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            int code = httpResponse.getStatusLine().getStatusCode();
            if (200 == code) {
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    String responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
                    log.info("\u6536\u5230\u7ffc\u652f\u4ed8\u7684http\u54cd\u5e94\u62a5\u6587:" + responseStr);
                    BestpayResponse<String> bestpayResponse = new BestpayResponse<String>(String.valueOf(code), "\u8c03\u7528Http\u670d\u52a1\u6210\u529f!", responseStr);
                    return bestpayResponse;
                }
                log.info("\u6536\u5230\u7ffc\u652f\u4ed8\u7684http\u54cd\u5e94,\u4f46\u62a5\u6587\u4e3a\u7a7a");
                BestpayResponse<Object> responseStr = new BestpayResponse<Object>(String.valueOf(code), "\u8c03\u7528Http\u670d\u52a1\u6210\u529f!", null);
                return responseStr;
            }
            log.info("\u8c03\u7528\u7ffc\u652f\u4ed8Http\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u7801\u4e3a\uff1a" + code);
            BestpayResponse<Object> entity = new BestpayResponse<Object>(String.valueOf(code), "\u8c03\u7528Http\u670d\u52a1\u5931\u8d25!", null);
            return entity;
        }
        catch (Exception e) {
            e.printStackTrace();
            BestpayResponse<Object> bestpayResponse = new BestpayResponse<Object>("999", "\u8c03\u7528Http\u670d\u52a1\u5931\u8d25!\u4f4d\u7f6e\u5f02\u5e38", null);
            return bestpayResponse;
        }
        finally {
            if (closeableHttpClient != null) {
                try {
                    closeableHttpClient.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

