/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.erajaya.EraJayaPointSaleReq;
import com.efuture.business.javaPos.struct.erajaya.ErajayaRespVo;
import com.efuture.business.javaPos.struct.request.DeletePaymentIn;
import com.efuture.business.model.erajaya.ErajayaPointRes;
import com.efuture.business.service.EraJayaPointSaleBs;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.SHA256Util;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class EraJayaPointSaleBsImpl
implements EraJayaPointSaleBs {
    private static final Logger log = LoggerFactory.getLogger(EraJayaPointSaleBsImpl.class);
    RestTemplate restTemplate;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Value(value="${pay.pointUrl}")
    protected String pointUrl;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initRemoteService;
    private static String POINTSALE = "/e-memberpoints/v1/memberships/points/redeem";
    private static String POINTCLEAN = "/e-memberpoints/v1/memberships/points/cancel";

    @Override
    public RespBase pointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("identifier"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"identifier"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("amount"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"amount"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("otp"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"otp"});
        }
        EraJayaPointSaleReq earJavPointSaleReq = (EraJayaPointSaleReq)JSONObject.parseObject((String)paramsObject.toString(), EraJayaPointSaleReq.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        String provider = "";
        if (null != order && null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getConsumersId())) {
            if (StringUtils.isNotBlank((String)order.getConsumersData().getEmail()) && !order.getConsumersData().getEmail().contains("*")) {
                earJavPointSaleReq.setIdentifier(order.getConsumersData().getEmail());
                provider = "email";
            } else {
                provider = "whatsapp";
                earJavPointSaleReq.setIdentifier(order.getConsumersData().getMobile());
            }
        } else {
            return Code.CODE_50147.getRespBase(new Object[0]);
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + earJavPointSaleReq.getShopCode() + earJavPointSaleReq.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"YNKEY");
        if (StringUtils.isBlank((String)mbkey) || mbkey.split(",").length < 2) {
            return Code.CODE_50129.getRespBase(new Object[]{"YNKEY"});
        }
        String[] split = mbkey.split(",");
        String jfxf = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JFXF");
        if (StringUtils.isBlank((String)jfxf)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b\u672a\u8bbe\u7f6e"});
        }
        double dkbl = CastUtil.castDouble((Object)jfxf.split(",")[0]);
        PaymentMode payModel = PayModeUtils.getPayMode((String)earJavPointSaleReq.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
        j.put("terminalNo", (Object)cacheModel.getOrder().getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() != res.getRetflag()) {
            return res;
        }
        JSONObject resp = (JSONObject)res.getData();
        token = resp.getString("token");
        String otp_Client = "eraspace";
        String deviceId = order.getShopCode() + order.getTerminalNo();
        String sign = SHA256Util.getSHA256String((String)(otp_Client + deviceId + earJavPointSaleReq.getIdentifier()));
        HashMap<String, Object> headMap = new HashMap<String, Object>();
        headMap.put("Authorization", token);
        headMap.put("Source", "grandlucky");
        headMap.put("Device-ID", deviceId);
        headMap.put("Otp-Client", otp_Client);
        headMap.put("Otp-provider", provider);
        headMap.put("x-eraspacegtw-apikey", split[0]);
        headMap.put("Signature", sign);
        earJavPointSaleReq.setPoint(String.valueOf((int)ManipulatePrecision.div((double)paramsObject.getDouble("amount"), (double)dkbl)));
        ServiceResponse resp2 = this.httpUtils.doErajayaPost("", this.pointUrl, "/v1.1/memberships/points/redeem", session, JSONObject.toJSONString((Object)earJavPointSaleReq), ErajayaRespVo.class, "ERAJAYA", "EARJAVA\u79ef\u5206\u6838\u9500", headMap);
        if ("0".equals(resp2.getReturncode())) {
            ErajayaRespVo res1 = (ErajayaRespVo)resp2.getData();
            if (null != res1.getData() && StringUtils.isBlank((String)res1.getErrorCode())) {
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(paramsObject.getString("payCode"));
                payment.setPayName(payModel.getName());
                payment.setPayType(payModel.getPaytype());
                payment.setPayNo(earJavPointSaleReq.getIdentifier());
                payment.setAmount(earJavPointSaleReq.getAmount());
                payment.setMoney(earJavPointSaleReq.getAmount());
                payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                payment.setPrecision(String.valueOf(payModel.getSswrjd()));
                payment.setPrcutMode(payModel.getSswrfs());
                payment.setIsAllowCharge(payModel.getIszl());
                payment.setIsOverage(payModel.getIsyy());
                payment.setRate(payModel.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setRefCode(res1.getData().getString("redemptionId"));
                payment.setPayMemo("EARJAVPOINT");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setRownoId(payment.getPuid());
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                cacheModel.getOrder().setThisTimeUsedPoint(Double.parseDouble(earJavPointSaleReq.getPoint()));
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "EARJAVPOINTPAY", cacheModel.getFlowNo());
            }
            return Code.CODE_50015.getRespBase(new Object[]{res1.getError_message()});
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    @Override
    public RespBase delPointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"YNKEY");
        if (StringUtils.isBlank((String)mbkey) || mbkey.split(",").length < 2) {
            return Code.CODE_50129.getRespBase(new Object[]{"YNKEY"});
        }
        String[] split = mbkey.split(",");
        session.setEnt_id(cacheModel.getOrder().getEntId());
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(in.getPuid())) continue;
            payment = p;
            break;
        }
        if (null == payment) {
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
        j.put("terminalNo", (Object)cacheModel.getOrder().getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() != res.getRetflag()) {
            return res;
        }
        JSONObject resp = (JSONObject)res.getData();
        token = resp.getString("token");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("redemptionId", (Object)payment.getRefCode());
        jsonObject.put("identifier", (Object)payment.getPayNo());
        String deviceId = in.getShopCode() + in.getTerminalNo();
        HashMap<String, Object> headMap = new HashMap<String, Object>();
        headMap.put("Authorization", token);
        headMap.put("Source", "grandlucky");
        headMap.put("Device-ID", deviceId);
        headMap.put("x-eraspacegtw-apikey", split[0]);
        ServiceResponse resp2 = this.httpUtils.doErajayaPost("", this.pointUrl, "/v1/memberships/points/cancel", session, jsonObject.toJSONString(), ErajayaPointRes.class, "ERAJAYA", "EARJAVA\u79ef\u5206\u64a4\u9500", headMap);
        if ("0".equals(resp2.getReturncode())) {
            ErajayaPointRes res1 = (ErajayaPointRes)resp2.getData();
            if (200 == res1.getStatus()) {
                if (payment != null) {
                    cacheModel.getOrder().setThisTimeUsedPoint(0.0);
                    cacheModel.getPayments().remove(payment);
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        String errCode = String.valueOf(Code.CODE_500000.getIndex());
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
                    }
                }
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ERAJAYAPOINTPAYCERTIFY", cacheModel.getFlowNo());
            }
            return Code.CODE_50053.getRespBase(new Object[]{res1.getError_message()});
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    @Override
    public RespBase pointConsume(ServiceSession session, JSONObject paramsObject) {
        log.info("EARJAVA\u79ef\u5206\u51b2\u6b63 \u5165\u53c2 ==>{}", (Object)paramsObject.toJSONString());
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, null, POINTCLEAN, session, paramsObject.toJSONString(), null, "EARJAVA\u79ef\u5206", "EARJAVA\u79ef\u5206\u51b2\u6b63", null);
        log.info("EARJAVA\u79ef\u5206\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(Integer.parseInt(response.getReturncode().trim()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        if (response.getData() == null) {
            return new RespBase(Code.CODE_50128.getIndex(), "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
        }
        return new RespBase(Code.SUCCESS);
    }

    public static void main(String[] args) {
        String s = "{\"app_name\":\"External Memberpoint Service\",\"trace\":\"d7391db2-8c05-42ea-ae39-e4b84096d435\",\"data\":\"Success Cancel Redeem Point\",\"app_version\":\"1.0.0\",\"status\":200}";
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        System.out.println(jsonObject.toJSONString());
        ErajayaPointRes res1 = (ErajayaPointRes)JSONObject.toJavaObject((JSON)jsonObject, ErajayaPointRes.class);
        System.out.println(JSON.toJSONString((Object)res1));
    }
}

