/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.klxy.KlxyRespVo;
import com.efuture.business.javaPos.struct.klxy.KlxyRespVo1;
import com.efuture.business.javaPos.struct.klxy.TradeGoods;
import com.efuture.business.model.klxy.MbCoupon;
import com.efuture.business.model.klxy.MbCouponIn;
import com.efuture.business.model.klxy.MbCouponOut;
import com.efuture.business.model.klxy.MbCouponPayIn;
import com.efuture.business.model.klxy.MbCouponPayOut;
import com.efuture.business.model.klxy.ShareDetail;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.MbCouponSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MbCouponSaleBSImpl
implements MbCouponSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(MbCouponSaleBSImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initRemoteService;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;

    @Override
    public RespBase couponQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[payCode]"});
        }
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        for (Payment p : cacheModel.getPayments()) {
            if (!"MBCOUPON".equals(p.getPayMemo()) || !StringUtils.isNotBlank((String)p.getDescription()) || !"2".equals(p.getDescription())) continue;
            return Code.CODE_50025.getRespBase(new Object[]{"\u4e00\u7b14\u8ba2\u5355\u4e0d\u652f\u6301\u6279\u91cf\u6838\u9500\u5238\u4e0e\u5355\u5f20\u6838\u9500\u5238\u540c\u65f6\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u67e5\u8be2\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        String couponNo = paramsObject.getString("couponNo");
        ServiceResponse resp = this.httpUtils.doKlxyGetById(mbkey, GlobalInfo.mburl, "/api/v3/coupon/sn/", session, couponNo, KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u5238\u67e5\u8be2", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                MbCoupon mbCoupon = (MbCoupon)JSON.toJavaObject((JSON)res1.getBody(), MbCoupon.class);
                String couponTypeName = mbCoupon.getCouponType().getName();
                String minusValue = mbCoupon.getCouponType().getDiscountWay().getDiscountWayContent().getMinusValue();
                if ("\u901a\u7528\u4f59\u989d\u5238".equals(couponTypeName) || "\u7ebf\u4e0b\u4f59\u989d\u5238".equals(couponTypeName)) {
                    String value = mbCoupon.getValue();
                    if (CastUtil.castDouble((Object)minusValue) > CastUtil.castDouble((Object)value)) {
                        mbCoupon.setUsableMoney(value);
                    } else {
                        mbCoupon.setUsableMoney(minusValue);
                    }
                    return new RespBase(Code.CHECKCOUPON_SUCCESS, (Object)mbCoupon);
                }
                MbCouponPayIn in = this.loadRequestPara(cacheModel, mbCoupon);
                in.setMallId(mallId);
                rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
                in.setFlowNo(rnd);
                resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/writeBack", session, JSON.toJSONString((Object)in), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u6838\u9500\u5355\u5f20\u4f18\u60e0\u5238", token, rnd);
                if ("0".equals(resp.getReturncode())) {
                    res1 = (KlxyRespVo)resp.getData();
                    if ("PUB-00000".equals(res1.getErrorCode())) {
                        MbCouponPayOut mbCouponPayOut = (MbCouponPayOut)JSON.toJavaObject((JSON)res1.getBody(), MbCouponPayOut.class);
                        Payment payment = new Payment();
                        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                        payment.setPayCode(paramsObject.getString("payCode"));
                        payment.setPayName(payMode.getName());
                        payment.setPayType(payMode.getCode());
                        payment.setPayNo(in.getCouponSn());
                        payment.setRefCode(rnd);
                        payment.setAmount(CastUtil.castDouble((Object)mbCouponPayOut.getAmount()));
                        payment.setMoney(CastUtil.castDouble((Object)mbCouponPayOut.getAmount()));
                        payment.setCopType(mbCoupon.getCouponType().getDiscountWay().getType());
                        if ("plusMinus".equals(payment.getCopType())) {
                            payment.setCashCost(CastUtil.castDouble((Object)mbCoupon.getCouponType().getDiscountWay().getDiscountWayContent().getPlusValue()));
                        }
                        payment.setTerminalNo(order.getTerminalNo());
                        payment.setPrecision(String.valueOf(payMode.getSswrjd()));
                        payment.setPrcutMode(payMode.getSswrfs());
                        payment.setRate(payMode.getZlhl().doubleValue());
                        payment.setIsAllowCharge(payMode.getIszl());
                        payment.setIsOverage(payMode.getIsyy());
                        payment.setFlag("1");
                        payment.setPayMemo("MBCOUPON");
                        payment.setDescription("1");
                        payment.setRowno(cacheModel.getPayments().size() + 1);
                        payment.setRownoId(payment.getPuid());
                        payment.setCouponGroup("B");
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                        if (cacheModel.getCalcResult() == -1) {
                            Object errMsg = cacheModel.getErrMsg();
                            String rnd1 = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
                            in.setFlowNo(rnd1);
                            in.setOriFlowNo(rnd);
                            in.setType("2");
                            resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/writeBack", session, JSON.toJSONString((Object)in), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9000\u8fd8\u5355\u5f20\u4f18\u60e0\u5238", token, rnd1);
                            errMsg = "0".equals(resp.getReturncode()) ? ("PUB-00000".equals((res1 = (KlxyRespVo)resp.getData()).getErrorCode()) ? (String)errMsg + ",\u5238\u5df2\u9000\u8fd8" : (String)errMsg + ",\u5238\u672a\u9000\u8fd8\uff1a" + res1.getErrorMessage()) : (String)errMsg + ",\u5238\u672a\u9000\u8fd8\uff1a\u8fde\u63a5\u5f02\u5e38";
                            return new RespBase(10000, (String)errMsg);
                        }
                        if (StringUtils.isNotBlank((String)mbCouponPayOut.getVerifyAmount())) {
                            order.setTempRandomDiscount(CastUtil.castDouble((Object)mbCouponPayOut.getVerifyAmount()));
                        }
                        if (null != mbCouponPayOut.getShareDetails() && mbCouponPayOut.getShareDetails().size() > 0) {
                            for (ShareDetail o : mbCouponPayOut.getShareDetails()) {
                                for (Goods g : cacheModel.getGoodsList()) {
                                    if (g.getFlowId() != CastUtil.castInt((Object)o.getIndex())) continue;
                                    CouponUse couponUse = new CouponUse();
                                    couponUse.setAmount(Math.abs(CastUtil.castDouble((Object)o.getShareValue())));
                                    couponUse.setOriAmount(Math.abs(CastUtil.castDouble((Object)o.getShareValue())));
                                    couponUse.setCouponType(payment.getCopType());
                                    couponUse.setCouponGroup("B");
                                    couponUse.setPayRowNo(payment.getRowno());
                                    couponUse.setPayCode(payment.getPayCode());
                                    couponUse.setRownoId(payment.getRownoId());
                                    couponUse.setGoodsRowNo(g.getFlowId());
                                    g.getOutCouponUses().add(couponUse);
                                }
                            }
                        }
                        BaseOutModel out = new BaseOutModel();
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo);
                    }
                    return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6838\u9500\u5931\u8d25\uff1a" + res1.getErrorMessage()});
                }
                return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6838\u9500\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u67e5\u8be2\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u67e5\u8be2\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase couponListQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        JSONObject resp;
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersId())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff1a\u8bf7\u5148\u767b\u5f55\u4f1a\u5458\uff01"});
        }
        String consumersId = order.getConsumersData().getConsumersId();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        resp = this.httpUtils.doKlxyGetById(mbkey, GlobalInfo.mburl, "/api/v3/external/coupon/", session, consumersId, KlxyRespVo1.class, "\u58a8\u535a\u4e91\u821f", "\u5238\u5217\u8868\u67e5\u8be2", token, rnd, "/coupons");
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo1 res1 = (KlxyRespVo1)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                List couponList = JSONObject.parseArray((String)JSON.toJSONString((Object)res1.getBody()), MbCoupon.class);
                for (MbCoupon mbCoupon : couponList) {
                    String couponTypeName = mbCoupon.getCouponType().getName();
                    String minusValue = mbCoupon.getCouponType().getDiscountWay().getDiscountWayContent().getMinusValue();
                    mbCoupon.setUsableMoney(minusValue);
                    if (!"\u901a\u7528\u4f59\u989d\u5238".equals(couponTypeName) && !"\u7ebf\u4e0b\u4f59\u989d\u5238".equals(couponTypeName)) continue;
                    String value = mbCoupon.getValue();
                    if (CastUtil.castDouble((Object)minusValue) > CastUtil.castDouble((Object)value)) {
                        mbCoupon.setUsableMoney(value);
                    } else {
                        mbCoupon.setUsableMoney(minusValue);
                    }
                    mbCoupon.setYeq(true);
                }
                return new RespBase(Code.SUCCESS, (Object)couponList);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u5217\u8868\u67e5\u8be2\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase couponPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[payCode]"});
        }
        MbCouponIn in = (MbCouponIn)((Object)JSON.parseObject((String)paramsObject.toJSONString(), MbCouponIn.class));
        if (null != in.getCouponList() && in.getCouponList().size() > 0) {
            return this.couponListPay(session, vo, paramsObject);
        }
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode payMode = PayModeUtils.getPayMode((String)in.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6838\u9500\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbCouponPayIn mbCouponPayIn = this.loadRequestPara(cacheModel, in.getCoupon());
        mbCouponPayIn.setAmount(in.getCoupon().getUseMoney());
        mbCouponPayIn.setMallId(mallId);
        mbCouponPayIn.setFlowNo(rnd);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/writeBack", session, JSON.toJSONString((Object)mbCouponPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u6838\u9500\u5355\u5f20\u4f18\u60e0\u5238", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                MbCouponPayOut mbCouponPayOut = (MbCouponPayOut)JSON.toJavaObject((JSON)res1.getBody(), MbCouponPayOut.class);
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(paramsObject.getString("payCode"));
                payment.setPayName(payMode.getName());
                payment.setPayType(payMode.getCode());
                payment.setPayNo(in.getCoupon().getCouponSn());
                payment.setRefCode(rnd);
                payment.setAmount(CastUtil.castDouble((Object)mbCouponPayOut.getAmount()));
                payment.setMoney(CastUtil.castDouble((Object)mbCouponPayOut.getAmount()));
                payment.setCopType(in.getCoupon().getCouponType().getDiscountWay().getType());
                if ("plusMinus".equals(payment.getCopType())) {
                    payment.setCashCost(CastUtil.castDouble((Object)in.getCoupon().getCouponType().getDiscountWay().getDiscountWayContent().getPlusValue()));
                }
                payment.setTerminalNo(order.getTerminalNo());
                payment.setPrecision(String.valueOf(payMode.getSswrjd()));
                payment.setPrcutMode(payMode.getSswrfs());
                payment.setIsAllowCharge(payMode.getIszl());
                payment.setIsOverage(payMode.getIsyy());
                payment.setRate(payMode.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setPayMemo("MBCOUPON");
                payment.setDescription("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setRownoId(payment.getPuid());
                payment.setCouponGroup("B");
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                if (cacheModel.getCalcResult() == -1) {
                    Object errMsg = cacheModel.getErrMsg();
                    String rnd1 = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
                    mbCouponPayIn.setFlowNo(rnd1);
                    mbCouponPayIn.setOriFlowNo(rnd);
                    mbCouponPayIn.setType("2");
                    resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/writeBack", session, JSON.toJSONString((Object)mbCouponPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9000\u8fd8\u5355\u5f20\u4f18\u60e0\u5238", token, rnd1);
                    errMsg = "0".equals(resp.getReturncode()) ? ("PUB-00000".equals((res1 = (KlxyRespVo)resp.getData()).getErrorCode()) ? (String)errMsg + ",\u5238\u5df2\u9000\u8fd8" : (String)errMsg + ",\u5238\u672a\u9000\u8fd8\uff1a" + res1.getErrorMessage()) : (String)errMsg + ",\u5238\u672a\u9000\u8fd8\uff1a\u8fde\u63a5\u5f02\u5e38";
                    return new RespBase(10000, (String)errMsg);
                }
                if (StringUtils.isNotBlank((String)mbCouponPayOut.getVerifyAmount())) {
                    order.setTempRandomDiscount(CastUtil.castDouble((Object)mbCouponPayOut.getVerifyAmount()));
                }
                if (null != mbCouponPayOut.getShareDetails() && mbCouponPayOut.getShareDetails().size() > 0) {
                    for (ShareDetail o : mbCouponPayOut.getShareDetails()) {
                        for (Goods g : cacheModel.getGoodsList()) {
                            if (g.getFlowId() != CastUtil.castInt((Object)o.getIndex())) continue;
                            CouponUse couponUse = new CouponUse();
                            couponUse.setAmount(Math.abs(CastUtil.castDouble((Object)o.getShareValue())));
                            couponUse.setOriAmount(Math.abs(CastUtil.castDouble((Object)o.getShareValue())));
                            couponUse.setCouponType(payment.getCopType());
                            couponUse.setCouponGroup("B");
                            couponUse.setPayRowNo(payment.getRowno());
                            couponUse.setPayCode(payment.getPayCode());
                            couponUse.setRownoId(payment.getRownoId());
                            couponUse.setGoodsRowNo(g.getFlowId());
                            g.getOutCouponUses().add(couponUse);
                        }
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6838\u9500\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6838\u9500\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    public RespBase couponListPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[payCode]"});
        }
        MbCouponIn in = (MbCouponIn)((Object)JSON.parseObject((String)paramsObject.toJSONString(), MbCouponIn.class));
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode payMode = PayModeUtils.getPayMode((String)in.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6838\u9500\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        for (Payment p : cacheModel.getPayments()) {
            if (!"MBCOUPON".equals(p.getPayMemo()) || !StringUtils.isNotBlank((String)p.getDescription())) continue;
            if ("2".equals(p.getDescription())) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u4e00\u7b14\u8ba2\u5355\u4e0d\u652f\u6301\u591a\u6b21\u6279\u91cf\u6838\u9500\u4f18\u60e0\u5238\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u9009\u62e9\uff01"});
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u4e00\u7b14\u8ba2\u5355\u4e0d\u652f\u6301\u6279\u91cf\u6838\u9500\u5238\u4e0e\u5355\u5f20\u6838\u9500\u5238\u540c\u65f6\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01"});
        }
        MbCouponPayIn mbCouponPayIn = this.loadRequestPara(cacheModel, in.getCouponList());
        mbCouponPayIn.setMallId(mallId);
        mbCouponPayIn.setFlowNo(rnd);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/batchWriteBack", session, JSON.toJSONString((Object)mbCouponPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u6279\u91cf\u6838\u9500\u4f18\u60e0\u5238", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                MbCouponPayOut mbCouponPayOut = (MbCouponPayOut)JSON.toJavaObject((JSON)res1.getBody(), MbCouponPayOut.class);
                for (MbCouponOut coupon : mbCouponPayOut.getCouponList()) {
                    Payment payment = new Payment();
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setPayCode(payMode.getCode());
                    payment.setPayName(payMode.getName());
                    payment.setPayType(payMode.getPaytype());
                    payment.setPayNo(coupon.getCouponSn());
                    payment.setRefCode(rnd);
                    payment.setAmount(CastUtil.castDouble((Object)coupon.getAmount()));
                    payment.setMoney(CastUtil.castDouble((Object)coupon.getAmount()));
                    payment.setCopType(coupon.getCouponTypeName());
                    payment.setTerminalNo(order.getTerminalNo());
                    payment.setPrecision(String.valueOf(payMode.getSswrjd()));
                    payment.setPrcutMode(payMode.getSswrfs());
                    payment.setRate(payMode.getZlhl().doubleValue());
                    payment.setIsAllowCharge(payMode.getIszl());
                    payment.setIsOverage(payMode.getIsyy());
                    payment.setFlag("1");
                    payment.setPayMemo("MBCOUPON");
                    payment.setDescription("2");
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    payment.setRownoId(payment.getPuid());
                    payment.setCouponGroup("B");
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    if (cacheModel.getCalcResult() == -1) {
                        Object errMsg = cacheModel.getErrMsg();
                        String rnd1 = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
                        mbCouponPayIn.setFlowNo(rnd1);
                        mbCouponPayIn.setOriFlowNo(rnd);
                        mbCouponPayIn.setType("2");
                        resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/batchWriteBack", session, JSON.toJSONString((Object)mbCouponPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u6279\u91cf\u9000\u8fd8\u5355\u5f20\u4f18\u60e0\u5238", token, rnd1);
                        errMsg = "0".equals(resp.getReturncode()) ? ("PUB-00000".equals((res1 = (KlxyRespVo)resp.getData()).getErrorCode()) ? (String)errMsg + ",\u5238\u5df2\u9000\u8fd8" : (String)errMsg + ",\u5238\u672a\u9000\u8fd8\uff1a" + res1.getErrorMessage()) : (String)errMsg + ",\u5238\u672a\u9000\u8fd8\uff1a\u8fde\u63a5\u5f02\u5e38";
                        return new RespBase(10000, (String)errMsg);
                    }
                    if (null == coupon.getShareDetails() || coupon.getShareDetails().size() <= 0) continue;
                    for (ShareDetail o : coupon.getShareDetails()) {
                        for (Goods g : cacheModel.getGoodsList()) {
                            if (g.getFlowId() != CastUtil.castInt((Object)o.getIndex())) continue;
                            CouponUse couponUse = new CouponUse();
                            couponUse.setAmount(Math.abs(CastUtil.castDouble((Object)o.getShareValue())));
                            couponUse.setOriAmount(Math.abs(CastUtil.castDouble((Object)o.getShareValue())));
                            couponUse.setCouponType(payment.getCopType());
                            couponUse.setCouponGroup("B");
                            couponUse.setPayRowNo(payment.getRowno());
                            couponUse.setPayCode(payment.getPayCode());
                            couponUse.setRownoId(payment.getRownoId());
                            couponUse.setGoodsRowNo(g.getFlowId());
                            g.getOutCouponUses().add(couponUse);
                        }
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6279\u91cf\u6838\u9500\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6279\u91cf\u6838\u9500\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase couponCancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        String puid = paramsObject.getString("puid");
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            preDeletePayment = p;
            break;
        }
        if ("2".equals(preDeletePayment.getDescription())) {
            return this.couponListCancelPay(session, vo, paramsObject);
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u5238\u652f\u4ed8\u884c\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbCouponPayIn in = this.loadRequestPara(cacheModel, preDeletePayment);
        in.setMallId(mallId);
        in.setFlowNo(rnd);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/writeBack", session, JSON.toJSONString((Object)in), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9000\u8fd8\u5355\u5f20\u4f18\u60e0\u5238", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                if (preDeletePayment != null) {
                    cacheModel.getPayments().remove(preDeletePayment);
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                    if ("plusMinus".equals(preDeletePayment.getCopType()) && preDeletePayment.getCashCost() > 0.0) {
                        cacheModel.getOrder().setTempRandomDiscount(ManipulatePrecision.add((double)cacheModel.getOrder().getTempRandomDiscount(), (double)preDeletePayment.getCashCost()));
                    }
                    block1: for (Goods g : cacheModel.getGoodsList()) {
                        if (null == g.getOutCouponUses() || g.getOutCouponUses().size() <= 0) continue;
                        for (int i = 0; i < g.getOutCouponUses().size(); ++i) {
                            CouponUse couponUse = (CouponUse)g.getOutCouponUses().get(i);
                            if (couponUse.getPayRowNo() != preDeletePayment.getRowno()) continue;
                            g.getOutCouponUses().remove(i);
                            continue block1;
                        }
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u5238\u652f\u4ed8\u884c\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u5238\u652f\u4ed8\u884c\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    public RespBase couponListCancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        ArrayList<Payment> preDeletePayment = new ArrayList<Payment>();
        for (Payment p : cacheModel.getPayments()) {
            if (!"MBCOUPON".equals(p.getPayMemo())) continue;
            preDeletePayment.add(p);
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u5238\u652f\u4ed8\u884c\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbCouponPayIn in = this.loadRequestPara(preDeletePayment);
        in.setMallId(mallId);
        in.setFlowNo(rnd);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/batchWriteBack", session, JSON.toJSONString((Object)in), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u6279\u91cf\u9000\u8fd8\u4f18\u60e0\u5238", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                if (preDeletePayment != null && preDeletePayment.size() > 0) {
                    for (Payment p : preDeletePayment) {
                        cacheModel.getPayments().remove(p);
                        block2: for (Goods g : cacheModel.getGoodsList()) {
                            if (null == g.getOutCouponUses() || g.getOutCouponUses().size() <= 0) continue;
                            for (int i = 0; i < g.getOutCouponUses().size(); ++i) {
                                CouponUse couponUse = (CouponUse)g.getOutCouponUses().get(i);
                                if (couponUse.getPayRowNo() != p.getRowno()) continue;
                                g.getOutCouponUses().remove(i);
                                continue block2;
                            }
                        }
                    }
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u6279\u91cf\u5220\u9664\u5238\u652f\u4ed8\u884c\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u6279\u91cf\u5220\u9664\u5238\u652f\u4ed8\u884c\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RespBase couponRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[payCode]"});
        }
        Order order = cacheModel.getOrder();
        boolean isAllReturn = order.getIsAllReturn();
        if (!isAllReturn) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5168\u5355\u9000\u6b3e\u624d\u9000\u5238\uff01"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u9000\u6b3e\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        if (!cacheModel.getOrder().getIsAllReturn()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u9000\u6b3e\u5931\u8d25\uff1a\u9000\u5238\u53ea\u652f\u6301\u539f\u5355\u9000\u8d27"});
        }
        String hxfs = "";
        ArrayList<Payment> paymentList = new ArrayList<Payment>();
        if (null == cacheModel.getReturnPayments() || cacheModel.getReturnPayments().size() <= 0) return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u9000\u6b3e\u5931\u8d25\uff1a\u9000\u5238\u53ea\u652f\u6301\u539f\u5355\u9000\u8d27"});
        for (Payment p : cacheModel.getReturnPayments()) {
            if (!"MBCOUPON".equals(p.getPayMemo())) continue;
            if (StringUtils.isBlank((String)hxfs)) {
                hxfs = p.getDescription();
            }
            paymentList.add(p);
        }
        if (paymentList.size() == 0) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u9000\u6b3e\u5931\u8d25\uff1a\u539f\u5355\u6ca1\u6709\u4f7f\u7528\u5238\u652f\u4ed8"});
        }
        if ("1".equals(hxfs)) {
            for (Payment p : paymentList) {
                MbCouponPayIn in = this.loadRequestPara(cacheModel, p);
                rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
                in.setFlowNo(rnd);
                in.setMallId(mallId);
                ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/writeBack", session, JSON.toJSONString((Object)in), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9000\u8fd8\u5355\u5f20\u4f18\u60e0\u5238", token, rnd);
                if (!"0".equals(resp.getReturncode())) return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u9000\u6b3e\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
                KlxyRespVo res1 = (KlxyRespVo)resp.getData();
                if (!"PUB-00000".equals(res1.getErrorCode())) return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u9000\u6b3e\u5931\u8d25\uff1a" + res1.getErrorMessage()});
                MbCouponPayOut mbCouponPayOut = (MbCouponPayOut)JSON.toJavaObject((JSON)res1.getBody(), MbCouponPayOut.class);
                p.setPuid(String.valueOf(UniqueID.getUniqueID()));
                p.setRefCode(rnd);
                p.setRowno(cacheModel.getPayments().size() + 1);
                p.setPrecision(String.valueOf(payMode.getSswrjd()));
                p.setPrcutMode(payMode.getSswrfs());
                p.setIsAllowCharge(payMode.getIszl());
                p.setIsOverage(payMode.getIsyy());
                p.setIsSuccess(true);
                if ((cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, p)).getCalcResult() != -1) continue;
                return new RespBase(10000, cacheModel.getErrMsg());
            }
        } else {
            MbCouponPayIn in = this.loadRequestPara(paymentList);
            in.setFlowNo(rnd);
            in.setMallId(mallId);
            ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/coupon/batchWriteBack", session, JSON.toJSONString((Object)in), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u6279\u91cf\u9000\u8fd8\u5355\u5f20\u4f18\u60e0\u5238", token, rnd);
            if (!"0".equals(resp.getReturncode())) return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6279\u91cf\u9000\u6b3e\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if (!"PUB-00000".equals(res1.getErrorCode())) return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u6279\u91cf\u9000\u6b3e\u5931\u8d25\uff1a" + res1.getErrorMessage()});
            for (Payment p : paymentList) {
                p.setPuid(String.valueOf(UniqueID.getUniqueID()));
                p.setRefCode(rnd);
                p.setRowno(cacheModel.getPayments().size() + 1);
                p.setPrecision(String.valueOf(payMode.getSswrjd()));
                p.setPrcutMode(payMode.getSswrfs());
                p.setIsAllowCharge(payMode.getIszl());
                p.setIsOverage(payMode.getIsyy());
                p.setIsSuccess(true);
                if ((cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, p)).getCalcResult() != -1) continue;
                return new RespBase(10000, cacheModel.getErrMsg());
            }
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    private MbCouponPayIn loadRequestPara(CacheModel cacheModel, MbCoupon mbCoupon) {
        Order order = cacheModel.getOrder();
        MbCouponPayIn mbCouponPayIn = new MbCouponPayIn();
        mbCouponPayIn.setAmount(mbCoupon.getCouponType().getDiscountWay().getDiscountWayContent().getMinusValue());
        mbCouponPayIn.setCouponSn(mbCoupon.getCouponSn());
        mbCouponPayIn.setOrderAmount(String.valueOf(order.getOughtPay()));
        mbCouponPayIn.setType("1");
        if ("plusMinus".equals(mbCoupon.getCouponType().getDiscountWay().getType())) {
            if (order.getTempRandomDiscount() > 0.0) {
                mbCouponPayIn.setVerifyAmount(String.valueOf(order.getTempRandomDiscount()));
            } else {
                mbCouponPayIn.setVerifyAmount(String.valueOf(order.getOughtPay()));
            }
        }
        ArrayList<TradeGoods> tradeGoodsList = new ArrayList<TradeGoods>();
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            for (Goods g : cacheModel.getGoodsList()) {
                TradeGoods tradeGoods = new TradeGoods();
                tradeGoods.setCount(String.valueOf(g.getQty()));
                tradeGoods.setMemoniCode(g.getGoodsCode());
                tradeGoods.setThirdSkuId(g.getGoodsCode());
                tradeGoods.setIndex(String.valueOf(g.getFlowId()));
                double shareValue = 0.0;
                if (null != g.getOutCouponUses() && g.getOutCouponUses().size() > 0) {
                    for (CouponUse c : g.getOutCouponUses()) {
                        shareValue = ManipulatePrecision.add((double)shareValue, (double)c.getAmount());
                    }
                }
                tradeGoods.setSellPrice(String.valueOf(ManipulatePrecision.sub((double)g.getSalePrice(), (double)shareValue)));
                tradeGoodsList.add(tradeGoods);
            }
        }
        mbCouponPayIn.setAutoFilterConflictGoods(true);
        mbCouponPayIn.setTradeGoods(tradeGoodsList);
        return mbCouponPayIn;
    }

    private MbCouponPayIn loadRequestPara(CacheModel cacheModel, Payment payment) {
        Order order = cacheModel.getOrder();
        MbCouponPayIn in = new MbCouponPayIn();
        in.setAmount(String.valueOf(payment.getAmount()));
        in.setCouponSn(payment.getPayNo());
        in.setType("2");
        in.setOrderAmount(String.valueOf(order.getOughtPay()));
        in.setOriFlowNo(payment.getRefCode());
        return in;
    }

    private MbCouponPayIn loadRequestPara(List<Payment> paymentList) {
        MbCouponPayIn in = new MbCouponPayIn();
        in.setType("2");
        ArrayList<JSONObject> couponList = new ArrayList<JSONObject>();
        for (Payment payment : paymentList) {
            JSONObject j = new JSONObject();
            j.put("couponSn", (Object)payment.getPayNo());
            j.put("couponType", (Object)payment.getCopType());
            couponList.add(j);
            if (!StringUtils.isBlank((String)in.getOriFlowNo())) continue;
            in.setOriFlowNo(payment.getRefCode());
        }
        in.setCouponList(couponList);
        return in;
    }

    private MbCouponPayIn loadRequestPara(CacheModel cacheModel, List<MbCoupon> mbCouponList) {
        Order order = cacheModel.getOrder();
        MbCouponPayIn in = new MbCouponPayIn();
        in.setType("1");
        ArrayList<JSONObject> couponList = new ArrayList<JSONObject>();
        for (MbCoupon coupon : mbCouponList) {
            JSONObject j = new JSONObject();
            j.put("couponSn", (Object)coupon.getCouponSn());
            if (StringUtils.isNotBlank((String)coupon.getUseMoney())) {
                j.put("amount", (Object)coupon.getUseMoney());
            }
            couponList.add(j);
        }
        in.setCouponList(couponList);
        in.setVerifyAmount(String.valueOf(order.getOughtPay()));
        ArrayList<TradeGoods> tradeGoodsList = new ArrayList<TradeGoods>();
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            for (Goods g : cacheModel.getGoodsList()) {
                TradeGoods tradeGoods = new TradeGoods();
                tradeGoods.setCount(String.valueOf(g.getQty()));
                tradeGoods.setMemoniCode(g.getGoodsCode());
                tradeGoods.setThirdSkuId(g.getGoodsCode());
                tradeGoods.setIndex(String.valueOf(g.getFlowId()));
                tradeGoods.setSellPrice(String.valueOf(g.getSalePrice()));
                tradeGoodsList.add(tradeGoods);
            }
        }
        in.setAutoFilterConflictGoods(true);
        in.setTradeGoods(tradeGoodsList);
        return in;
    }
}

