/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.klxy.KlxyRespVo;
import com.efuture.business.javaPos.struct.klxy.TradeGoods;
import com.efuture.business.javaPos.struct.request.PaymentIn;
import com.efuture.business.model.allVpay.request.CheckPayCodeIn;
import com.efuture.business.model.allVpay.response.CheckPayCodeOut;
import com.efuture.business.model.klxy.MbMzkIn;
import com.efuture.business.model.klxy.MbMzkOut;
import com.efuture.business.model.klxy.MbMzkPayQueryOut;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.MbMzkSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class MbMzkSaleBSImpl
implements MbMzkSaleBS {
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initRemoteService;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    protected RestTemplate restTemplate;
    protected String CHECKPAYCODE = "order.online.check.payCode";
    @Autowired
    protected RedisUtil redisUtil;

    @Override
    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u4f59\u989d\u67e5\u8be2\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        String cardNo = paramsObject.getString("cardNo");
        ServiceResponse resp = this.httpUtils.doKlxyGetById(mbkey, GlobalInfo.mburl, "/api/v3/external/credit/card/", session, cardNo, KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u50a8\u503c\u5361\u4f59\u989d\u67e5\u8be2", token, rnd, "/info");
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                JSONObject body = res1.getBody();
                String balance = body.getString("balance");
                JSONObject json = new JSONObject();
                json.put("money", (Object)balance);
                return new RespBase(Code.SUCCESS, (Object)json);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", cacheModel.getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - paramsObject.getDouble("amount") < 0.0 && "N".equals(mzkPayMode.getIsyy())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbMzkIn mbMzkIn = this.loadMzkRequestPara(cacheModel, paramsObject);
        mbMzkIn.setOutTradeNo(rnd);
        mbMzkIn.setTradeShopId("00");
        mbMzkIn.setMallId(mallId);
        mbMzkIn.setAutoFilterConflictGoods(true);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/external/credit/card/pos/scan", session, JSON.toJSONString((Object)mbMzkIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u50a8\u503c\u5361\u6d88\u8d39", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                for (int i = 0; i < 15; ++i) {
                    String rnd1 = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
                    resp = this.httpUtils.doKlxyGetById(mbkey, GlobalInfo.mburl, "/api/v3/external/credit/card/", session, rnd, KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u50a8\u503c\u5361\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2", token, rnd1, "/pay/status");
                    if ("0".equals(resp.getReturncode())) {
                        res1 = (KlxyRespVo)resp.getData();
                        if ("PUB-00000".equals(res1.getErrorCode())) {
                            MbMzkPayQueryOut mbMzkOut = (MbMzkPayQueryOut)JSON.toJavaObject((JSON)res1.getBody(), MbMzkPayQueryOut.class);
                            if (1 == mbMzkOut.getPayStatus()) {
                                Payment payment = new Payment();
                                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                                payment.setPayCode(paramsObject.getString("payCode"));
                                payment.setPayName(mzkPayMode.getName());
                                payment.setPayType(mzkPayMode.getCode());
                                payment.setPayNo(rnd);
                                payment.setRefCode(mbMzkOut.getTradeNo());
                                payment.setTrackData(mbMzkOut.getCreditCardNo());
                                payment.setAmount(CastUtil.castDouble((Object)mbMzkOut.getTradeAmount()));
                                payment.setMoney(CastUtil.castDouble((Object)mbMzkOut.getTradeAmount()));
                                payment.setTerminalNo(order.getTerminalNo());
                                payment.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
                                payment.setPrcutMode(mzkPayMode.getSswrfs());
                                payment.setRate(mzkPayMode.getZlhl().doubleValue());
                                payment.setFlag("1");
                                payment.setRowno(cacheModel.getPayments().size() + 1);
                                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                                if (cacheModel.getCalcResult() == -1) {
                                    return new RespBase(10000, cacheModel.getErrMsg());
                                }
                                BaseOutModel out = new BaseOutModel();
                                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                                return new RespBase(Code.SUCCESS, (Object)resqVo);
                            }
                            if (3 == mbMzkOut.getPayStatus()) {
                                return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a\u5ba2\u6237\u652f\u4ed8\u53d6\u6d88\uff01"});
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a" + res1.getErrorMessage()});
                    }
                    return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
                }
                return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u72b6\u6001\u4e0d\u660e\u786e\uff01"});
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase salePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        JSONObject resp;
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u6d41\u6c34\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", cacheModel.getFlowNo());
        }
        String tradeNo = paramsObject.getString("idSheetNo");
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        for (Payment payment : cacheModel.getPayments()) {
            if (!StringUtils.isNotBlank((String)payment.getPayNo()) || !payment.getPayNo().equals(tradeNo)) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        boolean b = this.checkPayCode(session, paramsObject, cacheModel.getOrder().getErpCode());
        if (!b) {
            return new RespBase(Code.CODE_50015.getIndex(), "\u5546\u6236\u8ba2\u5355\u53f7\u6821\u9a8c\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        resp = this.httpUtils.doKlxyGetById(mbkey, GlobalInfo.mburl, "/api/v3/external/credit/card/", session, tradeNo, KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u50a8\u503c\u5361\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2", token, rnd, "/pay/status");
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                MbMzkPayQueryOut mbMzkOut = (MbMzkPayQueryOut)JSON.toJavaObject((JSON)res1.getBody(), MbMzkPayQueryOut.class);
                if (1 == mbMzkOut.getPayStatus()) {
                    if (tradeNo.equals(mbMzkOut.getTradeNo())) {
                        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u6d41\u6c34\u53f7\u67e5\u8be2\u652f\u4ed8\uff0c\u8bf7\u8f93\u5165\u8ba2\u5355\u53f7\uff01"});
                    }
                    if (SellType.ISSALE((String)order.getOrderType()) && !"1".equals(mbMzkOut.getTradeType()) || SellType.ISBACK((String)order.getOrderType()) && !"-1".equals(mbMzkOut.getTradeType())) {
                        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff1a\u4ea4\u6613\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u8f93\u5165\u7684\u8ba2\u5355\u53f7\u662f\u5426\u6b63\u786e\uff01"});
                    }
                    Payment payment = new Payment();
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setPayCode(paramsObject.getString("payCode"));
                    payment.setPayName(mzkPayMode.getName());
                    payment.setPayType(mzkPayMode.getCode());
                    payment.setPayNo(tradeNo);
                    payment.setTrackData(mbMzkOut.getCreditCardNo());
                    payment.setRefCode(mbMzkOut.getTradeNo());
                    payment.setAmount(CastUtil.castDouble((Object)mbMzkOut.getTradeAmount()));
                    payment.setMoney(CastUtil.castDouble((Object)mbMzkOut.getTradeAmount()));
                    payment.setTerminalNo(order.getTerminalNo());
                    payment.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
                    payment.setPrcutMode(mzkPayMode.getSswrfs());
                    payment.setRate(mzkPayMode.getZlhl().doubleValue());
                    payment.setFlag("1");
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    if (cacheModel.getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo);
                }
                if (2 == mbMzkOut.getPayStatus()) {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u8ba2\u5355\u5df2\u9000\u6b3e,\u8bf7\u786e\u8ba4\u8f93\u5165\u7684\u8ba2\u5355\u53f7\uff01"});
                }
                return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u72b6\u6001\u4e0d\u660e\u786e\uff01"});
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u67e5\u8be2\u652f\u4ed8\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        String puid = paramsObject.getString("puid");
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            break;
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u50a8\u503c\u5361\u652f\u4ed8\u884c\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbMzkIn mbMzkIn = this.loadMzkRequestPara(cacheModel, paramsObject);
        mbMzkIn.setOutTradeNo(rnd);
        mbMzkIn.setMallId(mallId);
        mbMzkIn.setOutTradeNoOrigin(PreDeletePayment.getPayNo());
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/external/credit/card/refund", session, JSON.toJSONString((Object)mbMzkIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u50a8\u503c\u5361\u9000\u6b3e", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                if (PreDeletePayment != null) {
                    cacheModel.getPayments().remove(PreDeletePayment);
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u50a8\u503c\u5361\u652f\u4ed8\u884c\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u50a8\u503c\u5361\u652f\u4ed8\u884c\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        PaymentIn in = (PaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), PaymentIn.class);
        double remainValue = (cacheModel = this.posLogicCompoment.calcBalance(cacheModel)).getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        if (remainValue - in.getAmount() < 0.0 && "N".equals(in.getIsOverage())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode model = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u9000\u6b3e\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbMzkIn mbMzkIn = this.loadMzkRequestPara(cacheModel, paramsObject);
        mbMzkIn.setOutTradeNo(rnd);
        mbMzkIn.setMallId(mallId);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/external/credit/card/refund", session, JSON.toJSONString((Object)mbMzkIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u50a8\u503c\u5361\u9000\u6b3e", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                MbMzkOut mbMzkOut = (MbMzkOut)JSON.toJavaObject((JSON)res1.getBody(), MbMzkOut.class);
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(paramsObject.getString("payCode"));
                payment.setPayNo(rnd);
                payment.setTrackData(mbMzkOut.getCardNo());
                payment.setRefCode(mbMzkOut.getTradeNo());
                payment.setCouponBalance(CastUtil.castDouble((Object)mbMzkOut.getBalance()));
                payment.setAmount(CastUtil.castDouble((Object)mbMzkOut.getRefundAmount()));
                payment.setMoney(CastUtil.castDouble((Object)mbMzkOut.getRefundAmount()));
                payment.setPayCode(in.getPayCode());
                payment.setPayName(model.getName());
                payment.setPayType(model.getCode());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setPrecision(String.valueOf(model.getSswrjd()));
                payment.setPrcutMode(model.getSswrfs());
                payment.setRate(model.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                if (cacheModel.getCalcResult() == -1) {
                    return new RespBase(10000, cacheModel.getErrMsg());
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u9000\u6b3e\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u9000\u6b3e\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    private MbMzkIn loadMzkRequestPara(CacheModel cacheModel, JSONObject paramsObject) {
        Order order = cacheModel.getOrder();
        MbMzkIn in = new MbMzkIn();
        in.setCardNo(paramsObject.getString("cardNo"));
        in.setTradeAmount(paramsObject.getString("amount"));
        ArrayList<TradeGoods> tradeGoodsList = new ArrayList<TradeGoods>();
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            for (Goods g : cacheModel.getGoodsList()) {
                TradeGoods tradeGoods = new TradeGoods();
                tradeGoods.setCount(String.valueOf((int)g.getQty()));
                tradeGoods.setMemoniCode(g.getGoodsCode());
                tradeGoods.setThirdSkuId(g.getGoodsCode());
                tradeGoods.setIndex(String.valueOf(g.getFlowId()));
                tradeGoods.setSellPrice(String.valueOf(g.getSalePrice()));
                tradeGoodsList.add(tradeGoods);
            }
        }
        in.setTradeGoods(tradeGoodsList);
        in.setPosNo(order.getTerminalNo());
        if (StringUtils.isNotBlank((String)paramsObject.getString("oriRefCode"))) {
            in.setOutTradeNoOrigin(paramsObject.getString("oriRefCode"));
        }
        return in;
    }

    public boolean checkPayCode(ServiceSession session, JSONObject json, String erpCode) {
        try {
            CheckPayCodeOut out;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            CheckPayCodeIn in = new CheckPayCodeIn();
            in.setBusiTakeMarketCode(json.getString("shopCode"));
            in.setErpCode(erpCode);
            in.setPayNo(json.getString("idSheetNo"));
            try {
                String searchDate = dateFormat.format(new Date());
                String data = DateHelpUtil.getYestoryDate((String)searchDate);
                Date whenDate = TypeUtils.castToDate((Object)data);
                in.setStartDateTime(whenDate);
                String afterHour = DateHelpUtil.getAfterHourByHour((int)9);
                Date afterDate = TypeUtils.castToDate((Object)afterHour);
                in.setEndDateTime(afterDate);
            }
            catch (Exception searchDate) {
                // empty catch block
            }
            HashMap<String, CheckPayCodeIn> map = new HashMap<String, CheckPayCodeIn>();
            map.put("data", in);
            ServiceResponse response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, this.CHECKPAYCODE, session, JSON.toJSONString(map), CheckPayCodeOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6821\u9a8c\u5546\u6237\u8ba2\u5355\u53f7");
            if ("0".equals(response.getReturncode()) && !(out = (CheckPayCodeOut)response.getData()).getExist().booleanValue()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

