/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.MLVicPayInfoIn;
import com.efuture.business.model.MLVicPayReq;
import com.efuture.business.model.MLVicPayRes;
import com.efuture.business.service.MlMzkSaleBS;
import com.efuture.business.service.MlMzkService;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MlMzkSaleBSImpl
implements MlMzkSaleBS {
    private static final Logger log = LoggerFactory.getLogger(MlMzkSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    MlMzkService mlMzkService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PosLogicCompoment posLogicCompoment;
    @Value(value="${localize.type}")
    private String localize;

    @Override
    public RespBase mlVicPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payNo") || null == paramsObject.getString("payNo")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("payNo")});
        }
        if (!paramsObject.containsKey((Object)"payCode") || null == paramsObject.getString("payCode")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("payCode")});
        }
        if (!paramsObject.containsKey((Object)"tradeAmt") || null == paramsObject.getString("tradeAmt")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("tradeAmt")});
        }
        if (!paramsObject.containsKey((Object)"transType") || null == paramsObject.getString("transType")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("transType")});
        }
        MLVicPayInfoIn mlVicPayInfoIn = (MLVicPayInfoIn)((Object)JSONObject.toJavaObject((JSON)paramsObject, MLVicPayInfoIn.class));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + mlVicPayInfoIn.getShopCode() + mlVicPayInfoIn.getTerminalNo());
        if (StringUtils.isEmpty((String)obj)) {
            return new RespBase(Code.CODE_1087.getIndex(), vo.getCacheModel().getFlowNo());
        }
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)mlVicPayInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
        if (null == mzkPayMode) {
            return new RespBase(Code.CODE_50102.getIndex(), mlVicPayInfoIn.getPayCode(), vo.getCacheModel().getFlowNo());
        }
        int maxSalePayCount = this.getMaxPayCount(obj);
        if (cacheModel.getPayments().size() >= maxSalePayCount) {
            return new RespBase(Code.CODE_50044, vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if ("01".equals(mlVicPayInfoIn.getTransType()) || "03".equals(mlVicPayInfoIn.getTransType())) {
            if (remainValue <= 0.0) {
                return new RespBase(Code.CODE_500000.getIndex(), vo.getCacheModel().getFlowNo());
            }
            if (remainValue - CastUtil.castDouble((Object)mlVicPayInfoIn.getTradeAmt()) < 0.0) {
                return new RespBase(Code.CODE_500000.getIndex(), vo.getCacheModel().getFlowNo());
            }
        }
        Payment payment = null;
        if ("05".equals(mlVicPayInfoIn.getTransType()) || "06".equals(mlVicPayInfoIn.getTransType())) {
            String puid = mlVicPayInfoIn.getPuid();
            for (Payment p : cacheModel.getPayments()) {
                if (!p.getPuid().equals(puid)) continue;
                payment = p;
                break;
            }
            if (payment == null) {
                return new RespBase(Code.CODE_50053.getIndex(), "\u51b2\u6b63\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!", "");
            }
        }
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            mlVicPayInfoIn.setOrderType("1");
            mlVicPayInfoIn.setFlowNo(cacheModel.getOrder().getFlowNo());
        } else if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            mlVicPayInfoIn.setOrderType("4");
            mlVicPayInfoIn.setFlowNo(cacheModel.getOrder().getOriginFlowNo());
        }
        if (StringUtils.isBlank((String)mlVicPayInfoIn.getTransId())) {
            mlVicPayInfoIn.setTransId(String.valueOf(new Random().nextInt(999999999) % 1000000000));
        }
        mlVicPayInfoIn.setChannelId(cacheModel.getOrder().getChannel());
        MLVicPayReq payRequest = new MLVicPayReq(mlVicPayInfoIn);
        if ("05".equals(mlVicPayInfoIn.getTransType()) || "06".equals(mlVicPayInfoIn.getTransType())) {
            payRequest.setCardno(payment.getPayNo());
        }
        log.info("\u6d88\u8d39\uff1a{}", (Object)JSONObject.toJSONString((Object)payRequest));
        ServiceResponse resp = null;
        try {
            resp = this.mlMzkService.vicPay(null, session, JSONObject.toJSONString((Object)payRequest), this.localize);
            log.info("R10\u50a8\u503c\u5361\u6d88\u8d39\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
            if (!"0".equals(resp.getReturncode())) {
                return new RespBase(Integer.parseInt(resp.getReturncode()), resp.getData().toString());
            }
        }
        catch (Exception e) {
            log.error("R10\u50a8\u503c\u5361\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            try {
                if ("01".equals(mlVicPayInfoIn.getTransType())) {
                    payRequest.setTrans_type("02");
                } else if ("03".equals(mlVicPayInfoIn.getTransType())) {
                    payRequest.setTrans_type("04");
                }
                payRequest.setCardno(payment.getPayNo());
                if ("01".equals(mlVicPayInfoIn.getTransType()) || "03".equals(mlVicPayInfoIn.getTransType())) {
                    log.info("R10\u50a8\u503c\u5361\u81ea\u52a8\u51b2\u6b63\uff1a{}", (Object)JSONObject.toJSONString((Object)payRequest));
                    resp = this.mlMzkService.vicPay(null, session, JSONObject.toJSONString((Object)payRequest), this.localize);
                    log.info("R10\u50a8\u503c\u5361\u81ea\u52a8\u51b2\u6b63\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
                }
            }
            catch (Exception ex) {
                log.error("\u51b2\u6b63\u5f02\u5e38", (Throwable)ex);
                return Code.CODE_64.getRespBase(new Object[]{ex.getMessage()});
            }
            return new RespBase(Code.CODE_50135.getIndex(), Code.CODE_50135.getMsg());
        }
        if ("01".equals(mlVicPayInfoIn.getTransType()) || "03".equals(mlVicPayInfoIn.getTransType())) {
            log.info("\u50a8\u503c\u5361\u9500\u552e/\u9000\u8d27");
            return this.callSalePayServiceHandle(resp, session, cacheModel, mlVicPayInfoIn, mzkPayMode);
        }
        if ("05".equals(mlVicPayInfoIn.getTransType()) || "06".equals(mlVicPayInfoIn.getTransType())) {
            log.info("\u50a8\u503c\u5361\u64a4\u9500");
            return this.callSaleCancelPayServiceHandle(resp, session, cacheModel, payment);
        }
        return new RespBase(Code.CODE_50136.getIndex(), Code.CODE_50136.getMsg(), cacheModel.getFlowNo());
    }

    private RespBase callSalePayServiceHandle(ServiceResponse response, ServiceSession session, CacheModel cacheModel, MLVicPayInfoIn in, PaymentMode mzkPayMode) {
        if (!"0".equals(response.getReturncode())) {
            return new RespBase(Integer.parseInt(response.getReturncode()), response.getData().toString(), JSON.toJSONString((Object)response));
        }
        MLVicPayRes mlVicPayRes = (MLVicPayRes)JSONObject.toJavaObject((JSON)((JSONObject)JSON.toJSON((Object)response.getData())), MLVicPayRes.class);
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayCode(in.getPayCode());
        payment.setPayName(mzkPayMode.getName());
        payment.setPayType(mzkPayMode.getCode());
        payment.setPayNo(mlVicPayRes.getCardno());
        payment.setRefCode(in.getTransId());
        payment.setCouponBalance(CastUtil.castDouble((Object)mlVicPayRes.getBalance()));
        payment.setAmount(in.getTradeAmt());
        payment.setMoney(in.getTradeAmt());
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(in.getTerminalSno());
        payment.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
        payment.setPrcutMode(mzkPayMode.getSswrfs());
        payment.setRate(mzkPayMode.getZlhl().doubleValue());
        payment.setFlag("1");
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setPayMemo(in.getCid());
        payment.setTrackData(in.getPayNo());
        payment.setIsDirectDel(true);
        log.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("R10\u50a8\u503c\u5361\u6d88\u8d39" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "MLVICPAY")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "MLVICPAY");
    }

    private RespBase callSaleCancelPayServiceHandle(ServiceResponse response, ServiceSession session, CacheModel cacheModel, Payment payment) {
        if ("0".equals(response.getReturncode())) {
            if (payment != null) {
                cacheModel.getPayments().remove(payment);
                PayUtil.sortPayments(cacheModel.getPayments());
                cacheModel.setPayments(cacheModel.getPayments());
                cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
                if (cacheModel.getCalcResult() == -1) {
                    String errCode = String.valueOf(Code.CODE_500000.getIndex());
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    return Code.CODE_64.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
            }
        } else {
            return new RespBase(Integer.parseInt(response.getReturncode()), response.getData().toString(), JSON.toJSONString((Object)response));
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("R10\u50a8\u503c\u5361\u51b2\u6b63" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "MLVICPAY")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "MLVICPAY");
    }

    @Override
    public RespBase mlVicCheck(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"erpCode")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("erpCode")});
        }
        if (!paramsObject.containsKey((Object)"shopCode")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("shopCode")});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || null == paramsObject.getString("cardNo")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("cardNo")});
        }
        JSONObject vic = new JSONObject();
        vic.put("cardno", (Object)paramsObject.getString("cardNo"));
        if (paramsObject.containsKey((Object)"passWord") || null != paramsObject.getString("passWord")) {
            vic.put("secrety", (Object)paramsObject.getString("passWord"));
        }
        log.info("R10\u50a8\u503c\u5361\u6821\u9a8c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)vic));
        ServiceResponse resp = null;
        try {
            resp = this.mlMzkService.vicCheck(null, session, vic.toJSONString(), this.localize);
            log.info("R10\u50a8\u503c\u5361\u6821\u9a8c\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
            if (!"0".equals(resp.getReturncode())) {
                return new RespBase(Integer.parseInt(resp.getReturncode()), resp.getData().toString(), "MLVICCHECK");
            }
        }
        catch (Exception e) {
            log.error("R10\u50a8\u503c\u5361\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return Code.CODE_64.getRespBase(new Object[]{e.getMessage()});
        }
        return new RespBase(Code.SUCCESS, resp.getData(), "MLVICCHECK");
    }

    @Override
    public RespBase mlVicCodeQuery(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"erpCode")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("erpCode")});
        }
        if (!paramsObject.containsKey((Object)"shopCode")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("shopCode")});
        }
        if (!paramsObject.containsKey((Object)"payNo") || null == paramsObject.getString("payNo")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("payNo")});
        }
        JSONObject vic = new JSONObject();
        vic.put("channel_id", (Object)paramsObject.getString("channelId"));
        vic.put("rcode", (Object)paramsObject.getString("payNo"));
        log.info("R10\u50a8\u503c\u5361\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)vic.toJSONString());
        ServiceResponse resp = null;
        try {
            resp = this.mlMzkService.vicQuery(null, session, vic.toJSONString(), this.localize);
            log.info("R10\u50a8\u503c\u5361\u67e5\u8be2\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
            if (!"0".equals(resp.getReturncode())) {
                return new RespBase(Integer.parseInt(resp.getReturncode()), resp.getData().toString(), "MLVICCODEQUERY");
            }
        }
        catch (Exception e) {
            log.error("R10\u50a8\u503c\u5361\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return Code.CODE_64.getRespBase(new Object[]{e.getMessage()});
        }
        return new RespBase(Code.SUCCESS, resp.getData(), "");
    }

    @Override
    public RespBase r10MobileQuery(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"mobile")) {
            return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("mobile")});
        }
        JSONObject vic = new JSONObject();
        vic.put("mobile", (Object)paramsObject.getString("mobile"));
        log.info("R10\u50a8\u503c\u5361\u624b\u673a\u53f7\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)vic.toJSONString());
        ServiceResponse resp = null;
        try {
            resp = this.mlMzkService.vicMobileQuery(null, session, vic.toJSONString(), this.localize);
            log.info("R10\u50a8\u503c\u5361\u624b\u673a\u53f7\u67e5\u8be2\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
            if (!"0".equals(resp.getReturncode())) {
                return new RespBase(Integer.parseInt(resp.getReturncode()), resp.getData().toString(), "MLVICCODEQUERY");
            }
        }
        catch (Exception e) {
            log.error("R10\u50a8\u503c\u5361\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return Code.CODE_64.getRespBase(new Object[]{e.getMessage()});
        }
        return new RespBase(Code.SUCCESS, resp.getData(), "MLVICCODEQUERY");
    }

    private int getMaxPayCount(String obj) {
        JSONObject object3;
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "1";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("OZ")) continue;
                array.add((Object)sys);
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        String[] temp = paravalue.split(",");
        int maxSalePayCount = Integer.valueOf(temp[1]);
        return maxSalePayCount;
    }
}

