/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.posManager.request.SendBankLogIn;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.javaPos.struct.wslf.lpk.HttpClientCBC;
import com.efuture.business.model.Syspara;
import com.efuture.business.model.lpk.CardActivationInVo;
import com.efuture.business.model.lpk.CardData;
import com.efuture.business.model.lpk.ConsumeInVo;
import com.efuture.business.model.lpk.QueryCardInfoInVo;
import com.efuture.business.model.lpk.QueryCardInfoOutVo;
import com.efuture.business.model.lpk.ReverseUnifyConsumeInVo;
import com.efuture.business.model.lpk.UnActivationInVo;
import com.efuture.business.model.lpk.UnifyConsumeOutVo;
import com.efuture.business.model.mzk.request.MzkPayRequestHttp;
import com.efuture.business.model.mzk.request.MzkRequestDef;
import com.efuture.business.model.mzk.request.MzkRequestHttp;
import com.efuture.business.model.mzk.response.CardInfo;
import com.efuture.business.model.mzk.response.MzkResultDef;
import com.efuture.business.service.ALiMzkService;
import com.efuture.business.service.MzkSaleBS;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.HttpClientUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.MzkSaleUtil;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.client.RestTemplate;

public class MzkSaleBSImpl
implements MzkSaleBS {
    private static final Logger log = LoggerFactory.getLogger(MzkSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    @Qualifier(value="jdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    @Value(value="${java_sendmzk}")
    protected String java_sendmzk;
    @Value(value="${java_sendmzkIn}")
    protected String java_sendmzkIn;
    @Value(value="${java_sendmzkOut}")
    protected String java_sendmzkOut;
    @Value(value="${java_senddzk}")
    protected String java_senddzk;
    protected String dataCharacter = "ISO8859_1#GBK";
    @Value(value="${globalinfo.myshopMzkURL:http://172.17.12.182:30080}")
    private String myshopMzkURL;
    protected DbTools dbTools = new DbTools();
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    private ALiMzkService aLiMzkService;

    @Override
    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        if (trainingMode) {
            JSONObject json = new JSONObject();
            json.put("money", (Object)100);
            return new RespBase(Code.SUCCESS, (Object)json, "MZKQUERY");
        }
        MzkIn in = MzkSaleUtil.loadRequestPara(paramsObject);
        CacheModel cacheModel = vo.getCacheModel();
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("05");
        mzkreq.setVmemo("");
        mzkreq.setMkt(cacheModel.getSyjmain().getMkt());
        RespBase res = this.executeCzk(session, (JSONObject)JSON.toJSON((Object)mzkreq));
        log.info("executeCzk response==>{}", (Object)JSONObject.toJSONString((Object)res));
        if (0 == res.getRetflag()) {
            MzkResultDef mzkres = (MzkResultDef)res.getData();
            if ("00".equals(mzkres.getRetcode())) {
                double money = ManipulatePrecision.mul((double)CastUtil.castDouble((Object)mzkres.getRamount()), (double)0.01);
                JSONObject json = new JSONObject();
                json.put("money", (Object)money);
                return new RespBase(Code.SUCCESS, (Object)json, "ZBMZKQUERY");
            }
            return new RespBase(Code.CODE_50058.getIndex(), "\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff1a" + mzkres.getRerrmsg());
        }
        return new RespBase(Code.CODE_50058.getIndex(), "\u67e5\u8be2\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    @Override
    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("\u50a8\u503c\u5361\u5165\u53c21\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn in = this.loadRequestPara(paramsObject, syjMain, mzkPayMode);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo1 = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo1.isTrainingMode();
        if (trainingMode) {
            return this.trainingModeSalePay(cacheModel, in);
        }
        double remainValue = (cacheModel = this.posLogicCompoment.calcBalance(cacheModel)).getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        log.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + JSON.toJSONString((Object)in));
        if (remainValue - in.getAmount() < 0.0 && "N".equals(in.getIsOverage())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("01");
        mzkreq.setVmemo("");
        SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
        sendBankLogIn.setErpCode(cacheModel.getOrder().getErpCode());
        RespBase res = this.executeCzk(session, (JSONObject)JSON.toJSON((Object)mzkreq));
        if (0 != res.getRetflag()) {
            return res;
        }
        MzkResultDef mzkres = (MzkResultDef)res.getData();
        sendBankLogIn.setType("0");
        if ("00".equals(mzkres.getRetcode())) {
            Payment payment = new Payment();
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setRefCode(in.getOrderNo());
            payment.setPayCode(in.getPayCode());
            payment.setPayName(in.getPayName());
            payment.setPayType(in.getPayType());
            payment.setPayNo(mzkres.getRcardno());
            payment.setPasswd(in.getPasswd());
            payment.setCouponBalance(ManipulatePrecision.mul((double)CastUtil.castDouble((Object)mzkres.getRamount()), (double)0.01));
            payment.setTrackData(mzkreq.getVtrack2());
            payment.setAmount(in.getAmount());
            payment.setMoney(in.getAmount());
            payment.setTerminalNo(in.getTerminalNo());
            payment.setTerminalSno(mzkreq.getVinvno());
            payment.setCustmnerName(mzkres.getRname());
            payment.setPrecision(in.getPrecision());
            payment.setPrcutMode(in.getCutMode());
            payment.setRate(in.getRate());
            payment.setFlag("1");
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setIsAllowCharge(in.getIsAllowCharge());
            payment.setIsOverage(in.getIsOverage());
            log.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            sendBankLogIn.setRetbz("Y");
            sendBankLogIn.setRetmsg("\u6210\u529f");
            sendBankLogIn.setVbal(CastUtil.castDouble((Object)mzkres.getRamount()) * 0.01);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKPAY");
        }
        sendBankLogIn.setRetbz("N");
        sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
        return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a" + mzkres.getRerrmsg());
    }

    private RespBase trainingModeSalePay(CacheModel cacheModel, MzkIn in) {
        Payment payment = new Payment();
        payment.setPuid(UUIDUtils.buildPuid());
        payment.setRefCode("001");
        payment.setPayCode(in.getPayCode());
        payment.setPayName(in.getPayName());
        payment.setPayType(in.getPayType());
        payment.setPayNo("000000001");
        payment.setPasswd(in.getPasswd());
        payment.setCouponBalance(100.0);
        payment.setAmount(in.getAmount());
        payment.setMoney(in.getAmount());
        payment.setTerminalNo(in.getTerminalNo());
        payment.setCustmnerName("\u5f20\u4e09");
        payment.setTrackData("000000001");
        payment.setPrecision(in.getPrecision());
        payment.setPrcutMode(in.getCutMode());
        payment.setRate(in.getRate());
        payment.setFlag("1");
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setIsAllowCharge(in.getIsAllowCharge());
        payment.setIsOverage(in.getIsOverage());
        log.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "MZKPAY");
    }

    @Override
    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String obj;
        ModeDetailsVo modeDetailsVo1;
        boolean trainingMode;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_60.getRespBase(new Object[]{"\u9000\u8d27\u4e0d\u5141\u8bb8 \u5220\u9664\u652f\u4ed8\u65b9\u5f0f"});
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn in = this.loadRequestPara(paramsObject, syjMain, mzkPayMode);
        in.setPuid(paramsObject.getString("puid"));
        String puid = in.getPuid();
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            break;
        }
        if (trainingMode = (modeDetailsVo1 = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"))), ModeDetailsVo.class)).isTrainingMode()) {
            return this.trainingModeCancelPay(cacheModel, PreDeletePayment);
        }
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        if (PreDeletePayment == null) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]");
        }
        mzkreq.setVpasswd(PreDeletePayment.getPasswd());
        mzkreq.setVtrack2(PreDeletePayment.getTrackData());
        mzkreq.setVtype("02");
        mzkreq.setVmemo("");
        RespBase res = this.executeCzk(session, (JSONObject)JSON.toJSON((Object)mzkreq));
        BaseOutModel out = new BaseOutModel();
        if (0 == res.getRetflag()) {
            MzkResultDef mzkres = (MzkResultDef)res.getData();
            SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
            sendBankLogIn.setErpCode(cacheModel.getOrder().getErpCode());
            sendBankLogIn.setType("1");
            if ("00".equals(mzkres.getRetcode())) {
                if (PreDeletePayment != null) {
                    cacheModel.getPayments().remove(PreDeletePayment);
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        String errCode = "100000";
                        if (cacheModel.getErrCode().length() > 0) {
                            errCode = cacheModel.getErrCode();
                        }
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKCANCEL");
                    }
                }
                sendBankLogIn.setRetbz("Y");
                sendBankLogIn.setRetmsg("\u6210\u529f");
                sendBankLogIn.setVbal(CastUtil.castDouble((Object)mzkres.getRamount()) * 0.01);
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKCANCEL");
            }
            sendBankLogIn.setRetbz("N");
            sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5931\u8d25\uff1a" + mzkres.getRerrmsg());
        }
        return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    private RespBase trainingModeCancelPay(CacheModel cacheModel, Payment preDeletePayment) {
        BaseOutModel out = new BaseOutModel();
        if (preDeletePayment != null) {
            cacheModel.getPayments().remove(preDeletePayment);
            PayUtil.sortPayments(cacheModel.getPayments());
            cacheModel.setPayments(cacheModel.getPayments());
            cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "MZKCANCEL");
        }
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "MZKCANCEL");
    }

    @Override
    public RespBase executeCzk(ServiceSession session, JSONObject paramsObject) {
        MzkRequestDef mzkreq = (MzkRequestDef)JSON.parseObject((String)paramsObject.toJSONString(), MzkRequestDef.class);
        MzkResultDef mzkres = new MzkResultDef();
        String cardNo = mzkreq.getVtrack2();
        String dataSource = "";
        try {
            if (cardNo.contains("=")) {
                String first = cardNo.substring(0, 1);
                if ("7".equals(first) || cardNo.split("=")[0].length() < 13) {
                    dataSource = "xykDataSource";
                } else if ("8".equals(first)) {
                    dataSource = "lmsDataSource";
                } else if ("5".equals(first)) {
                    dataSource = "hkyhDataSource";
                } else if ("9".equals(first)) {
                    dataSource = "xmsDataSource";
                } else if ("6".equals(first)) {
                    dataSource = "zqDataSource";
                } else {
                    return new RespBase(Code.CODE_50060.getIndex(), "\u4ea4\u6613\u5931\u8d25\uff1a\u5361\u53f7\u9519\u8bef");
                }
                mzkres = this.sendMzk(JSON.toJSONString((Object)mzkreq), dataSource);
            } else {
                dataSource = "dzkDataSource";
                mzkres = this.sendDzk(JSON.toJSONString((Object)mzkreq), dataSource);
            }
        }
        catch (Exception e) {
            return new RespBase(Code.CODE_50066);
        }
        RespBase rep = new RespBase();
        int ret = mzkres.getRet();
        rep.setRetflag(Integer.valueOf(ret).intValue());
        if (ret != 0) {
            rep.setRetflag(0);
        }
        rep.setData((Object)mzkres);
        return rep;
    }

    @Override
    public RespBase saleReserve(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String flowNo = paramsObject.getString("flowNo");
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", flowNo);
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", flowNo);
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn in = this.loadRequestPara(paramsObject, syjMain, mzkPayMode);
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("02");
        MzkResultDef mzkres = new MzkResultDef();
        String cardNo = in.getCardNo();
        String dataSource = "";
        try {
            if (cardNo.contains("=")) {
                String first = cardNo.substring(0, 1);
                if ("7".equals(first) || cardNo.split("=")[0].length() < 13) {
                    dataSource = "xykDataSource";
                } else if ("8".equals(first)) {
                    dataSource = "lmsDataSource";
                } else if ("5".equals(first)) {
                    dataSource = "hkyhDataSource";
                } else if ("9".equals(first)) {
                    dataSource = "xmsDataSource";
                } else {
                    return new RespBase(Code.CODE_50059.getIndex(), "\u51b2\u6b63\u5931\u8d25\uff1a\u5361\u53f7\u9519\u8bef");
                }
                mzkreq.setMkt(vo.getCacheModel().getSyjmain().getMkt());
                mzkres = this.sendMzk(JSON.toJSONString((Object)mzkreq), dataSource);
            } else {
                dataSource = "dzkDataSource";
                mzkres = this.sendDzk(JSON.toJSONString((Object)mzkreq), dataSource);
            }
        }
        catch (Exception e) {
            return new RespBase(Code.CODE_50066.getIndex(), "\u50a8\u503c\u5361\u51b2\u6b63\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38");
        }
        if ("00".equals(mzkres.getRetcode())) {
            if (null != vo && StringUtils.isNotBlank((String)flowNo) && StringUtils.isNotBlank((String)in.getOrderNo())) {
                boolean needCalc = false;
                CacheModel cacheModel = vo.getCacheModel();
                if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                    for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
                        Payment p = (Payment)cacheModel.getPayments().get(i);
                        if (!p.getRefCode().equals(in.getOrderNo())) continue;
                        cacheModel.getPayments().remove(i);
                        needCalc = true;
                        break;
                    }
                }
                if (needCalc) {
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKCANCEL");
            }
            return Code.SUCCESS.getRespBase(new Object[0]);
        }
        return new RespBase(Code.CODE_50059.getIndex(), "\u50a8\u503c\u5361\u51b2\u6b63\u5931\u8d25\uff1a" + mzkres.getRerrmsg());
    }

    @Override
    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn in = this.loadRequestPara(paramsObject, syjMain, mzkPayMode);
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo1 = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo1.isTrainingMode();
        if (trainingMode) {
            return this.trainingModeSalePay(cacheModel, in);
        }
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("03");
        RespBase res = this.executeCzk(session, (JSONObject)JSON.toJSON((Object)mzkreq));
        if (0 == res.getRetflag()) {
            MzkResultDef mzkres = (MzkResultDef)res.getData();
            SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
            sendBankLogIn.setErpCode(cacheModel.getOrder().getErpCode());
            sendBankLogIn.setType("1");
            BaseOutModel out = new BaseOutModel();
            if ("00".equals(mzkres.getRetcode())) {
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(in.getPayCode());
                payment.setPayName(in.getPayName());
                payment.setPayType(in.getPayType());
                payment.setPayNo(mzkres.getRcardno());
                payment.setCouponBalance(ManipulatePrecision.mul((double)CastUtil.castDouble((Object)mzkres.getRamount()), (double)0.01));
                payment.setTrackData(mzkreq.getVtrack2());
                payment.setAmount(in.getAmount());
                payment.setMoney(in.getAmount());
                payment.setMisTerminalId(mzkreq.getVtermno());
                payment.setTerminalSno(mzkreq.getVinvno());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setPrcutMode(in.getCutMode());
                payment.setPrecision(in.getPrecision());
                payment.setRate(in.getRate());
                payment.setCustmnerName(mzkres.getRname());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                sendBankLogIn.setRetbz("Y");
                sendBankLogIn.setRetmsg("\u6210\u529f");
                sendBankLogIn.setVbal(CastUtil.castDouble((Object)mzkres.getRamount()) * 0.01);
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ZBMZKREFUND");
            }
            sendBankLogIn.setRetbz("N");
            sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
            return new RespBase(Code.CODE_50057.getIndex(), "\u6d88\u5355\u5931\u8d25\uff1a" + mzkres.getRerrmsg());
        }
        return new RespBase(Code.CODE_50057.getIndex(), "\u6d88\u5355\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    @Override
    public RespBase queryStatus(ServiceSession session, JSONObject jsonObject) {
        return null;
    }

    @Override
    public RespBase cardActivation(ServiceSession session, JSONObject body) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        if (!body.containsKey((Object)"cardNo") || body.getString("cardNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cardNo"});
        }
        CardActivationInVo invo = (CardActivationInVo)JSONObject.parseObject((String)body.toJSONString(), CardActivationInVo.class);
        JSONObject request = new JSONObject();
        request.put("secretKey", (Object)"AB1BEB395475A37426211475E5340064");
        request.put("apikey", (Object)"20230418");
        request.put("timestamp", (Object)timestamp);
        request.put("v", (Object)"1");
        request.put("signType", (Object)"MD5");
        request.put("returnType", (Object)"json");
        String orderId = invo.getShopCode() + invo.getTerminalNo() + System.currentTimeMillis();
        request.put("orderId", (Object)orderId);
        request.put("merId", (Object)"102335053110002");
        request.put("machineId", (Object)"102335053110002");
        request.put("orderAmount", (Object)String.valueOf(invo.getAmount().multiply(BigDecimal.valueOf(100L)).longValue()));
        request.put("cardNum", (Object)"1");
        request.put("userId", (Object)invo.getTerminalOperator());
        JSONArray cardData = new JSONArray();
        JSONObject data = new JSONObject();
        data.put("cardNo", (Object)invo.getCardNo());
        data.put("amount", (Object)String.valueOf(invo.getAmount().multiply(BigDecimal.valueOf(100L)).longValue()));
        cardData.add((Object)data);
        request.put("cardData", (Object)cardData.toJSONString());
        String url = "http://wechat.66card.com:8788/culsite/culapp/unifyIslv";
        request.put("url", (Object)url);
        Map map = (Map)JSONObject.parseObject((String)request.toJSONString(), HashMap.class);
        ArrayList list = new ArrayList(map.values());
        Collections.sort(list);
        Object[] values = list.toArray(new String[0]);
        String mac = DigestUtils.md5Hex((String)StringUtils.join((Object[])values));
        log.info("mac==>{}", (Object)mac);
        request.put("mac", (Object)mac);
        log.info("\u6fc0\u6d3b\u5165\u53c2==>{}", (Object)request.toJSONString());
        map = (Map)JSONObject.parseObject((String)request.toJSONString(), HashMap.class);
        HttpClientCBC hc = new HttpClientCBC("http://wechat.66card.com:8788/culsite/culapp/unifyIslv");
        try {
            String resultString = "";
            int status = hc.send(map, "utf-8");
            if (200 == status) {
                resultString = hc.getResult();
                JSONObject response = JSONObject.parseObject((String)resultString);
                if ("00".equals(response.getString("code"))) {
                    log.info("\u6210\u529f:{}", (Object)resultString);
                    Object centerUrl = GlobalInfo.ourl;
                    if (StringUtils.isNotBlank((String)centerUrl)) {
                        centerUrl = ((String)centerUrl).split("rest?")[0] + "rest?ent_id=0&method=order.online.fdcElecCard.saveCardInfo";
                        String token = HttpUtils.getToken();
                        centerUrl = (String)centerUrl + "&token=" + token;
                    }
                    log.info("\u5730\u5740==>{}", centerUrl);
                    JSONObject requestCenter = new JSONObject();
                    requestCenter.put("orderId", (Object)orderId);
                    requestCenter.put("txnId", (Object)response.getString("txnId"));
                    requestCenter.put("shopCode", (Object)invo.getShopCode());
                    requestCenter.put("cardNo", (Object)invo.getCardNo());
                    requestCenter.put("amount", (Object)invo.getAmount());
                    requestCenter.put("orderType", (Object)"1");
                    requestCenter.put("terminalNo", (Object)invo.getTerminalNo());
                    requestCenter.put("terminalOperator", (Object)invo.getTerminalOperator());
                    log.info("\u53d1\u9001\u4e2d\u53f0\u8bb0\u5f55\u65e5\u5fd7==>{}", (Object)requestCenter.toJSONString());
                    String result = HttpClientUtil.postJson((String)centerUrl, (String)requestCenter.toJSONString());
                    log.info("\u53d1\u9001\u4e2d\u53f0\u8bb0\u5f55\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)result);
                    return new RespBase(Code.SUCCESS, (Object)response, "");
                }
                return Code.CODE_50138.getRespBase(new Object[]{response.getString("msg")});
            }
            log.info("\u6fc0\u6d3b\u5931\u8d25");
            return Code.CODE_50138.getRespBase(new Object[]{"\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a"});
        }
        catch (Exception e) {
            log.info("\u6fc0\u6d3b\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50138.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase unActivation(ServiceSession session, JSONObject body) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        UnActivationInVo invo = (UnActivationInVo)JSONObject.parseObject((String)body.toJSONString(), UnActivationInVo.class);
        JSONObject request = new JSONObject();
        request.put("secretKey", (Object)"AB1BEB395475A37426211475E5340064");
        request.put("apikey", (Object)"20230418");
        request.put("timestamp", (Object)timestamp);
        request.put("v", (Object)"1");
        request.put("signType", (Object)"MD5");
        request.put("returnType", (Object)"json");
        String orderId = invo.getShopCode() + invo.getTerminalNo() + System.currentTimeMillis();
        request.put("reverseOrderId", (Object)orderId);
        request.put("merId", (Object)"102335053110002");
        request.put("machineId", (Object)"102335053110002");
        request.put("userId", (Object)invo.getTerminalOperator());
        if (StringUtils.isNotBlank((String)invo.getOrderId())) {
            request.put("orderId", (Object)invo.getOrderId());
        }
        if (StringUtils.isNotBlank((String)invo.getTxnId())) {
            request.put("txnId", (Object)invo.getTxnId());
        }
        String url = "http://wechat.66card.com:8788/culsite/culapp/reverseUnifyIslv";
        request.put("url", (Object)url);
        HashMap map = (HashMap)JSONObject.parseObject((String)request.toJSONString(), HashMap.class);
        ArrayList list = new ArrayList(map.values());
        Collections.sort(list);
        Object[] values = list.toArray(new String[0]);
        String mac = DigestUtils.md5Hex((String)StringUtils.join((Object[])values));
        request.put("mac", (Object)mac);
        log.info("\u53cd\u6fc0\u6d3b\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)request));
        HttpClientCBC hc = new HttpClientCBC("http://wechat.66card.com:8788/culsite/culapp/reverseUnifyIslv");
        map = (HashMap)JSONObject.parseObject((String)request.toJSONString(), HashMap.class);
        String resultString = "";
        try {
            int status = hc.send((Map)map, "utf-8");
            if (200 == status) {
                resultString = hc.getResult();
                JSONObject response = JSONObject.parseObject((String)resultString);
                if ("00".equals(response.getString("code"))) {
                    log.info("\u6210\u529f:{}", (Object)resultString);
                    Object centerUrl = GlobalInfo.ourl;
                    if (StringUtils.isNotBlank((String)centerUrl)) {
                        centerUrl = ((String)centerUrl).split("rest?")[0] + "rest?ent_id=0&method=order.online.fdcElecCard.saveCardInfo";
                        String token = HttpUtils.getToken();
                        centerUrl = (String)centerUrl + "&token=" + token;
                    }
                    JSONObject requestCenter = new JSONObject();
                    requestCenter.put("orderId", (Object)orderId);
                    requestCenter.put("txnId", (Object)response.getString("txnId"));
                    requestCenter.put("shopCode", (Object)invo.getShopCode());
                    requestCenter.put("cardNo", (Object)response.getJSONArray("cardData").getJSONObject(0).getString("cardNo"));
                    requestCenter.put("amount", (Object)response.getJSONArray("cardData").getJSONObject(0).getBigDecimal("amount").multiply(BigDecimal.valueOf(0.01)).doubleValue());
                    requestCenter.put("terminalNo", (Object)invo.getTerminalNo());
                    requestCenter.put("orderType", (Object)"2");
                    requestCenter.put("terminalOperator", (Object)invo.getTerminalOperator());
                    log.info("\u53d1\u9001\u4e2d\u53f0\u8bb0\u5f55\u65e5\u5fd7==>{}", (Object)requestCenter.toJSONString());
                    String result = HttpClientUtil.postJson((String)centerUrl, (String)requestCenter.toJSONString());
                    log.info("\u53d1\u9001\u4e2d\u53f0\u8bb0\u5f55\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)result);
                    return new RespBase(Code.SUCCESS, (Object)response, "");
                }
                return Code.CODE_50138.getRespBase(new Object[]{response.getString("msg")});
            }
            log.info("\u64a4\u9500\u6fc0\u6d3b\u5931\u8d25");
            return Code.CODE_50138.getRespBase(new Object[]{"\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a"});
        }
        catch (Exception e) {
            log.info("\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50138.getRespBase(new Object[]{"\u8c03\u7528\u94f6\u5546\u63a5\u53e3\u5f02\u5e38:" + e.getMessage()});
        }
    }

    @Override
    public RespBase unifyConsume(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("\u50a8\u503c\u5361\u5165\u53c21\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cardNo"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"amount"});
        }
        ConsumeInVo inVo = (ConsumeInVo)((Object)JSONObject.parseObject((String)paramsObject.toJSONString(), ConsumeInVo.class));
        HttpClientCBC hc = new HttpClientCBC("http://wechat.66card.com:8788/culsite/culapp/unifyConsume");
        HashMap<String, Object> data = new HashMap<String, Object>();
        String terminal = "33500022";
        String isPartConsume = "Y";
        String consumeChannel = "UT";
        String merchantNo = "102335053110002";
        String consumeType = "B";
        data.put("checkTrack2", "N");
        String orderId = "UT" + System.currentTimeMillis();
        JSONArray redeemArrays = new JSONArray();
        JSONObject redeemCardInfo0 = new JSONObject();
        BigDecimal totalAmount = inVo.getAmount().multiply(BigDecimal.valueOf(100L));
        redeemCardInfo0.put("amount", (Object)totalAmount.longValue());
        redeemCardInfo0.put("passwdType", (Object)"OFFLINE");
        data.put("totalAmount", totalAmount.toPlainString());
        data.put("checkPwd", "N");
        if (StringUtils.isNotBlank((String)inVo.getPasswd())) {
            data.put("checkPwd", "Y");
            redeemCardInfo0.put("cardNo", (Object)inVo.getCardNo());
            redeemCardInfo0.put("pwd", (Object)inVo.getPasswd());
            if (StringUtils.isNotBlank((String)inVo.getTrack2Data())) {
                data.put("checkTrack2", "Y");
                redeemCardInfo0.put("track2Data", (Object)inVo.getTrack2Data());
            }
            redeemArrays.add((Object)redeemCardInfo0);
            data.put("redeemInfos", JSONArray.toJSONString((Object)redeemArrays));
        } else {
            log.info("\u7535\u5b50\u5361\u6d88\u8d39");
            consumeType = "A";
            data.put("tranId", inVo.getCardNo());
        }
        String txndate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String txntime = new SimpleDateFormat("HHmmss").format(new Date());
        data.put("txndate", txndate);
        data.put("txntime", txntime);
        data.put("isPartConsume", isPartConsume);
        data.put("consumeChannel", consumeChannel);
        data.put("merId", merchantNo);
        data.put("terminal", terminal);
        data.put("orderId", orderId);
        data.put("consumeType", consumeType);
        String url = "http://wechat.66card.com:8788/culsite/culapp/unifyConsume";
        data.put("url", url);
        String apikey = "20230418";
        String secretKey = "AB1BEB395475A37426211475E5340064";
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        data.put("secretKey", secretKey);
        data.put("apikey", apikey);
        data.put("timestamp", timestamp);
        ArrayList list = new ArrayList(data.values());
        Collections.sort(list);
        Object[] values = list.toArray(new String[0]);
        log.info(Arrays.toString(values));
        String mac = DigestUtils.md5Hex((String)StringUtils.join((Object[])values));
        data.put("mac", mac);
        log.info("mac:" + mac);
        String cache = this.redisUtil.get(RedisKey.CACHEID + inVo.getShopCode() + inVo.getTerminalNo());
        CacheModel cacheModel = vo.getCacheModel();
        String resultString = "";
        try {
            int status = hc.send(data, "utf-8");
            if (200 == status) {
                resultString = hc.getResult();
                log.info("\u6838\u9500\u8fd4\u56de:{}", (Object)resultString);
                UnifyConsumeOutVo outVo = (UnifyConsumeOutVo)JSONObject.parseObject((String)resultString, UnifyConsumeOutVo.class);
                if ("00".equals(outVo.getCode())) {
                    cacheModel = this.creatLpkPayment(inVo, cache, cacheModel, outVo);
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, inVo.getFlowNo());
                }
                return Code.CODE_50138.getRespBase(new Object[]{outVo.getMsg()});
            }
            log.info("\u64a4\u9500\u6fc0\u6d3b\u5931\u8d25:{}", (Object)resultString);
            return Code.CODE_50138.getRespBase(new Object[]{resultString});
        }
        catch (Exception e) {
            log.info("\u64a4\u9500\u6fc0\u6d3b\u5931\u8d25", (Throwable)e);
            return Code.CODE_50138.getRespBase(new Object[]{e.getMessage()});
        }
    }

    private CacheModel creatLpkPayment(ConsumeInVo inVo, String cache, CacheModel cacheModel, UnifyConsumeOutVo outVo) {
        for (UnifyConsumeOutVo.Info.CardData card : outVo.getInfo().getCardData()) {
            PaymentMode paymode = PayModeUtils.getPayMode((String)inVo.getPayCode(), (JSONObject)JSONObject.parseObject((String)cache));
            Payment payment = new Payment();
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setFlag("1");
            log.info("\u652f\u4ed8\u65b9\u5f0f==>{}", (Object)JSONObject.toJSONString((Object)paymode));
            payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
            payment.setTerminalSno(cacheModel.getOrder().getTerminalSno());
            payment.setPayCode(inVo.getPayCode());
            payment.setPayNo(card.getCardNo());
            payment.setRate(paymode.getZlhl().doubleValue());
            payment.setAmount(BigDecimal.valueOf(Integer.parseInt(card.getPoints())).divide(BigDecimal.valueOf(100L)).doubleValue());
            payment.setMoney(payment.getAmount());
            payment.setOverage(0.0);
            payment.setChargeRate(paymode.getZlhl().doubleValue());
            payment.setIsAllowCharge(paymode.getIszl());
            payment.setIsOverage(paymode.getIsyy());
            payment.setRefCode(outVo.getInfo().getTxnId());
            payment.setTerminalNo(inVo.getTerminalNo());
            payment.setPrcutMode(paymode.getSswrfs());
            payment.setPrecision(paymode.getSswrjd().toString());
            payment.setPayType(paymode.getPaytype());
            payment.setPayName(paymode.getName());
            payment.setIsDirectDel(true);
            payment.setPayMemo("LPK");
            payment.setDeductMoney(true);
            payment.setOctopusTranscationTime(DateHelpUtil.nowToString());
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        }
        return cacheModel;
    }

    @Override
    public RespBase queryCardInfo(ServiceSession session, JSONObject body) {
        if (StringUtils.isBlank((String)body.getString("cardNo"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"cardNo"});
        }
        QueryCardInfoInVo inVo = (QueryCardInfoInVo)JSONObject.parseObject((String)body.toJSONString(), QueryCardInfoInVo.class);
        HashMap<String, String> data = new HashMap<String, String>();
        String url = "http://wechat.66card.com:8788/culsite/culapp/queryCardInfo";
        data.put("url", url);
        String apikey = "20230418";
        String secretKey = "AB1BEB395475A37426211475E5340064";
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        data.put("secretKey", secretKey);
        data.put("apikey", apikey);
        data.put("timestamp", timestamp);
        JSONArray cardData = new JSONArray();
        JSONObject cardInfos = new JSONObject();
        cardInfos.put("cardNo", (Object)inVo.getCardNo());
        if (StringUtils.isNotBlank((String)inVo.getCardPwd())) {
            data.put("checkPwd", "Y");
            cardInfos.put("cardPwd", (Object)inVo.getCardPwd());
        }
        if (StringUtils.isNotBlank((String)inVo.getTrack2Data())) {
            data.put("checkTrack2", "Y");
            cardInfos.put("track2Data", (Object)inVo.getTrack2Data());
        }
        cardData.add((Object)cardInfos);
        data.put("cardData", cardData.toJSONString());
        ArrayList list = new ArrayList(data.values());
        Collections.sort(list);
        Object[] values = list.toArray(new String[0]);
        log.info(Arrays.toString(values));
        String mac = DigestUtils.md5Hex((String)StringUtils.join((Object[])values));
        data.put("mac", mac);
        String resultString = "";
        try {
            HttpClientCBC hc = new HttpClientCBC("http://wechat.66card.com:8788/culsite/culapp/queryCardInfo");
            int status = hc.send(data, "utf-8");
            if (200 == status) {
                resultString = hc.getResult();
                log.info("resultString===>{}", (Object)resultString);
                QueryCardInfoOutVo outVo = (QueryCardInfoOutVo)JSONObject.parseObject((String)resultString, QueryCardInfoOutVo.class);
                if ("00".equals(outVo.getCode())) {
                    log.info("outVo===>{}", (Object)JSONObject.toJSONString((Object)outVo));
                    CardData cardData1 = outVo.getCardData().get(0);
                    cardData1.setBalance(BigDecimal.valueOf(Integer.parseInt(cardData1.getBalance())).divide(BigDecimal.valueOf(100L)).toPlainString());
                    return new RespBase(Code.SUCCESS, (Object)cardData1, "");
                }
                return Code.CODE_50138.getRespBase(new Object[]{outVo.getMsg()});
            }
            log.info("\u5361\u67e5\u8be2\u5931\u8d25:{}", (Object)resultString);
            return Code.CODE_50138.getRespBase(new Object[]{resultString});
        }
        catch (Exception e) {
            log.info("\u5361\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50138.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase reverseUnifyConsume(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ReverseUnifyConsumeInVo inVo = (ReverseUnifyConsumeInVo)JSON.parseObject((String)paramsObject.toJSONString(), ReverseUnifyConsumeInVo.class);
        if (null == inVo) {
            return new RespBase(-1, "\u5165\u53c2\u8f6c\u6362\u5931\u8d25", "");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        List paymentList = cacheModel.getPayments().stream().filter(r -> r.getPuid().equals(inVo.getPuid())).collect(Collectors.toList());
        if (ArrayUtils.isEmpty(paymentList)) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u652f\u4ed8\u884c\u672a\u627e\u5230"});
        }
        Payment payment = (Payment)ArrayUtils.getFirstOne(paymentList);
        if (!"LPK".equals(payment.getPayMemo())) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u975e\u793c\u54c1\u5361\u652f\u4ed8\u65e0\u6cd5\u4f7f\u7528\u6b64\u63a5\u53e3"});
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        String url = "http://wechat.66card.com:8788/culsite/culapp/reverseUnifyConsume";
        data.put("url", url);
        String apikey = "20230418";
        String secretKey = "AB1BEB395475A37426211475E5340064";
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        data.put("secretKey", secretKey);
        data.put("apikey", apikey);
        data.put("timestamp", timestamp);
        String reverseOrderId = "UT" + System.currentTimeMillis();
        data.put("txnId", payment.getRefCode());
        data.put("reverseOrderId", reverseOrderId);
        data.put("merId", "102335053110002");
        data.put("terminal", "33500022");
        data.put("machineId", "102335053110002");
        data.put("userId", inVo.getTerminalOperator());
        data.put("txnDate", new SimpleDateFormat("yyyyMMdd").format(new Date()));
        ArrayList list = new ArrayList(data.values());
        Collections.sort(list);
        Object[] values = list.toArray(new String[0]);
        log.info(Arrays.toString(values));
        String mac = DigestUtils.md5Hex((String)StringUtils.join((Object[])values));
        data.put("mac", mac);
        String resultString = "";
        try {
            HttpClientCBC hc = new HttpClientCBC("http://wechat.66card.com:8788/culsite/culapp/reverseUnifyConsume");
            int status = hc.send(data, "utf-8");
            if (200 == status) {
                resultString = hc.getResult();
                QueryCardInfoOutVo outVo = (QueryCardInfoOutVo)JSONObject.parseObject((String)resultString, QueryCardInfoOutVo.class);
                if ("00".equals(outVo.getCode())) {
                    List payments = cacheModel.getPayments();
                    payments.remove(payment.getRowno() - 1);
                    PayUtil.sortPayments(payments);
                    cacheModel.setPayments(payments);
                    this.posLogicCompoment.calcPayBalance(cacheModel);
                    Integer calcResult = cacheModel.getCalcResult();
                    if (calcResult != null && calcResult == -1) {
                        String errCode = "100000";
                        if (cacheModel.getErrCode().length() > 0) {
                            errCode = cacheModel.getErrCode();
                        }
                        return new RespBase(-1, errCode, vo.getCacheModel().getFlowNo());
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, inVo.getFlowNo());
            }
            log.info("\u5361\u67e5\u8be2\u5931\u8d25:{}", (Object)resultString);
            return Code.CODE_50138.getRespBase(new Object[]{resultString});
        }
        catch (Exception e) {
            log.info("\u5361\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50138.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase refundUnifyConsume(ServiceSession session, ResqVo buildReqVo, JSONObject body) {
        return null;
    }

    public SendBankLogIn toSendBankLogIn(MzkIn mzkin) {
        SendBankLogIn in = new SendBankLogIn();
        in.setCardno(mzkin.getCardNo());
        in.setErpCode(in.getErpCode());
        in.setMkt(mzkin.getShopCode());
        in.setFphm(mzkin.getInvno());
        in.setJe(mzkin.getAmount());
        in.setTermno(mzkin.getMzkTerminalNo());
        in.setPayCode(mzkin.getPayCode());
        Date date = new Date();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        in.setRqsj(s.format(date));
        in.setSyjh(mzkin.getTerminalNo());
        in.setSyyh(mzkin.getTerminalOperator());
        in.setTrace(mzkin.getOrderNo());
        return in;
    }

    public ServiceResponse executeCzkProcess(RestTemplate restTemplate, ServiceSession session, MzkRequestDef in) {
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)in);
        RespBase respBase = this.executeCzk(session, jsonObject);
        ServiceResponse resp = new ServiceResponse();
        resp.setReturncode(String.valueOf(respBase.getRetflag()));
        resp.setData(respBase.getData());
        return resp;
    }

    public JSONObject getRedisData(JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        return JSONObject.parseObject((String)obj);
    }

    public JSONObject getSyjMain(JSONObject modeDetailsVo) {
        JSONObject syjMain = null;
        if (modeDetailsVo.containsKey((Object)"syjmain")) {
            syjMain = modeDetailsVo.getJSONObject("syjmain");
        }
        return syjMain;
    }

    public MzkIn loadRequestPara(JSONObject paramsObject, JSONObject syjMain, PaymentMode mzkPayMode) {
        MzkIn in = new MzkIn();
        in.setCardNo(paramsObject.getString("cardNo"));
        in.setPasswd(paramsObject.getString("passwd"));
        in.setAmount(paramsObject.getDouble("amount").doubleValue());
        in.setInvno(paramsObject.getString("terminalSno"));
        in.setPayCode(paramsObject.getString("payCode"));
        in.setOrderNo(paramsObject.getString("orderNo"));
        in.setMzkTerminalNo(paramsObject.getString("mzkTerminalNo"));
        in.setTerminalOperator(paramsObject.getString("terminalOperator"));
        in.setMemo(paramsObject.getString("memo"));
        in.setShopCode(paramsObject.getString("shopCode"));
        in.setPuid(UUIDUtils.buildPuid());
        in.setCutMode(mzkPayMode.getSswrfs());
        in.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
        in.setPayName(mzkPayMode.getName());
        in.setPayType(mzkPayMode.getPaytype());
        in.setRate(mzkPayMode.getZlhl().doubleValue());
        if (StringUtils.isNotBlank((String)mzkPayMode.getIszl())) {
            in.setIsAllowCharge(mzkPayMode.getIszl());
        } else {
            in.setIsAllowCharge("N");
        }
        if (StringUtils.isNotBlank((String)mzkPayMode.getIsyy())) {
            in.setIsOverage(mzkPayMode.getIsyy());
        } else {
            in.setIsOverage("N");
        }
        if (syjMain != null && syjMain.containsKey((Object)"erpCode")) {
            in.setErpcode(syjMain.getString("erpCode"));
        }
        return in;
    }

    public String getSysparaByCode(JSONObject modeDetailsVo, String code) {
        JSONArray sysParaList = null;
        if (modeDetailsVo.containsKey((Object)"syspara")) {
            sysParaList = modeDetailsVo.getJSONArray("syspara");
        }
        String SJKDZ = "";
        if (sysParaList.size() != 0) {
            for (int i = 0; i < sysParaList.size(); ++i) {
                Syspara syspara = (Syspara)JSONObject.parseObject((String)sysParaList.get(i).toString(), Syspara.class);
                Object o = sysParaList.get(i);
                if (!syspara.getCode().equals(code)) continue;
                SJKDZ = syspara.getParavalue();
            }
        }
        return SJKDZ;
    }

    private MzkResultDef sendMzkQueryHttp(MzkRequestDef mzkResultDef) {
        MzkRequestHttp request = new MzkRequestHttp();
        request.setStore_code(mzkResultDef.getMkt());
        if (mzkResultDef.getVtrack2().startsWith("@")) {
            request.setId_type("04");
        } else {
            request.setId_type("01");
        }
        request.setId_code(mzkResultDef.getVtrack2());
        request.setPassword("");
        log.info("\u50a8\u503c\u5361\u67e5\u8be2\u63a5\u53e3\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)request));
        log.info("\u91d1\u5b89\u50a8\u503c\u5361\u8bf7\u6c42\u5730\u5740:" + this.myshopMzkURL + "/pcm-ecard-webin/rest?method=efuture.pcm.ecard.ipos.getCardInfo");
        String response = HttpClientUtil.postJson((String)(this.myshopMzkURL + "/pcm-ecard-webin/rest?method=efuture.pcm.ecard.ipos.getCardInfo"), (String)JSONObject.toJSONString((Object)request));
        log.info("\u50a8\u503c\u5361\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de==>{}", (Object)response);
        if (StringUtils.isBlank((String)response)) {
            return null;
        }
        JSONObject res = JSONObject.parseObject((String)response);
        MzkResultDef mzk = new MzkResultDef();
        if (!"0".equals(res.getString("returncode"))) {
            mzk.setRetcode(res.getString("returncode"));
            mzk.setRerrmsg(res.getString("data"));
            return mzk;
        }
        JSONObject data = res.getJSONObject("data");
        mzk.setRcardno(data.getString("card_no"));
        mzk.setRamount(String.valueOf(ManipulatePrecision.mul((double)data.getDoubleValue("balance"), (double)100.0)));
        mzk.setRetcode("00");
        return mzk;
    }

    private MzkResultDef sendMzkPayHttp(MzkRequestDef mzkResultDef) {
        MzkPayRequestHttp request = new MzkPayRequestHttp();
        request.setStore_code(mzkResultDef.getMkt());
        request.setTran_type(mzkResultDef.getVtype());
        request.setAmount(BigDecimal.valueOf(ManipulatePrecision.mul((double)Double.parseDouble(mzkResultDef.getVamount()), (double)0.01)));
        request.setTran_id(mzkResultDef.getVseqno());
        CardInfo cardInfo = new CardInfo();
        cardInfo.setAmount(BigDecimal.valueOf(ManipulatePrecision.mul((double)Double.parseDouble(mzkResultDef.getVamount()), (double)0.01)));
        String cardNo = mzkResultDef.getVtrack2();
        if (cardNo.contains("=")) {
            cardNo = cardNo.split("=")[0];
        }
        cardInfo.setCard_no(cardNo);
        cardInfo.setGather_no(mzkResultDef.getVinvno());
        cardInfo.setPassword("");
        cardInfo.setPos_no(mzkResultDef.getVtermno());
        if (mzkResultDef.getVtrack2().startsWith("@")) {
            cardInfo.setId_type("04");
        } else {
            cardInfo.setId_type("01");
        }
        cardInfo.setOperator(mzkResultDef.getVsyyh());
        cardInfo.setStore_code(mzkResultDef.getMkt());
        request.setCards(Arrays.asList(cardInfo));
        log.info("\u50a8\u503c\u5361\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)request));
        String response = HttpClientUtil.postJson((String)(this.myshopMzkURL + "/pcm-ecard-webin/rest?method=efuture.pcm.ecard.ipos.cardPay"), (String)JSONObject.toJSONString((Object)request));
        log.info("\u50a8\u503c\u5361\u8fd4\u56de==>{}", (Object)response);
        JSONObject res = JSONObject.parseObject((String)response);
        MzkResultDef mzk = new MzkResultDef();
        if (!"0".equals(res.getString("returncode"))) {
            mzk.setRetcode(res.getString("returncode"));
            mzk.setRerrmsg(res.getString("data"));
            return mzk;
        }
        JSONObject data = res.getJSONObject("data");
        JSONArray jsonArray = data.getJSONArray("cards");
        JSONObject cardInfo1 = jsonArray.getJSONObject(0);
        mzk.setRcardno(cardInfo1.getString("card_no"));
        mzk.setRamount(String.valueOf(ManipulatePrecision.mul((double)cardInfo1.getDoubleValue("balance"), (double)100.0)));
        mzk.setVadjustseq(cardInfo1.getIntValue("charge_id"));
        mzk.setRetcode("00");
        return mzk;
    }

    public MzkResultDef sendMzk(String json, String dataSource) {
        log.info("\u50a8\u503c\u5361\u5f00\u59cb");
        if (StringUtils.isNotBlank((String)this.myshopMzkURL)) {
            MzkRequestDef mzk = (MzkRequestDef)JSONObject.parseObject((String)json, MzkRequestDef.class);
            log.info("\u8fdb\u5165\u91d1\u5b89\u50a8\u503c\u5361>>>>>>>>{}", (Object)JSONObject.toJSONString((Object)mzk));
            if ("05".equals(mzk.getVtype())) {
                return this.sendMzkQueryHttp(mzk);
            }
            return this.sendMzkPayHttp(mzk);
        }
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(dataSource));
        log.info("mzk_processIn\uff1a" + json);
        HashMap ropValue = (HashMap)this.jdbcTemplate.execute(con -> {
            try {
                String storedProc = this.java_sendmzk;
                CallableStatement cs = con.prepareCall(storedProc);
                return this.dbTools.paseCallableStatementRes(cs, json, this.java_sendmzkIn, this.java_sendmzkOut, this.dataCharacter);
            }
            catch (Exception e) {
                log.info("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e38\uff1a" + e);
                e.printStackTrace();
                return null;
            }
        }, cs -> {
            try {
                cs.execute();
                HashMap hashMap = this.dbTools.paseCallableStatementRop(cs, this.java_sendmzkIn, this.java_sendmzkOut, this.dataCharacter);
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e382\uff1a" + e);
            }
            finally {
                if (null != cs) {
                    cs.close();
                }
            }
            return null;
        });
        log.info("mzk_processOut:" + ropValue);
        String retcode = "";
        if (ropValue != null && ropValue.get("retcode") != null) {
            retcode = (String)ropValue.get("retcode");
        } else {
            log.info("retcode is null!");
        }
        MzkResultDef mzk = new MzkResultDef();
        try {
            DbTools.ConvertToObjectNoTranscoding((Object)mzk, (HashMap)ropValue, (String[])MzkResultDef.ref);
            if (!retcode.equals("00")) {
                log.info("Retcode is not right: " + mzk.getRerrmsg());
            }
        }
        catch (Exception e) {
            mzk.setRetcode("1");
            mzk.setRerrmsg(e.toString());
            log.info("Return convert to Bean error:" + e.toString());
        }
        MultipleDataSource.clearDataSource();
        return mzk;
    }

    public MzkResultDef sendDzk(String json, String dataSource) {
        log.info("dzk_processIn\uff1a" + json);
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc(dataSource));
        HashMap ropValue = (HashMap)this.jdbcTemplate.execute(con -> {
            try {
                String storedProc = this.java_senddzk;
                CallableStatement cs = con.prepareCall(storedProc);
                return this.dbTools.paseCallableStatementRes(cs, json, this.java_sendmzkIn, this.java_sendmzkOut, this.dataCharacter);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u7535\u5b50\u5361\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e38\uff1a" + e);
                return null;
            }
        }, cs -> {
            try {
                cs.execute();
                HashMap hashMap = this.dbTools.paseCallableStatementRop(cs, this.java_sendmzkIn, this.java_sendmzkOut, this.dataCharacter);
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("\u7535\u5b50\u5361\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5f02\u5e382\uff1a" + e);
            }
            finally {
                if (null != cs) {
                    cs.close();
                }
            }
            return null;
        });
        log.info("dzk_processOut:" + ropValue);
        String retcode = "";
        if (ropValue != null && ropValue.get("retcode") != null) {
            retcode = (String)ropValue.get("retcode");
        } else {
            log.info("\u7535\u5b50\u5361\u6267\u884c\u8fd4\u56de\u4e3a\u7a7a\uff1a");
        }
        MzkResultDef mzk = new MzkResultDef();
        try {
            DbTools.ConvertToObjectNoTranscoding((Object)mzk, (HashMap)ropValue, (String[])MzkResultDef.ref);
            if (!retcode.equals("00")) {
                log.info("DZKRetcode is not right: " + mzk.getRerrmsg());
            }
        }
        catch (Exception e) {
            mzk.setRetcode("1");
            mzk.setRerrmsg("sendmzksale proc HASHMAP convert to Bean error");
            log.info("DZKReturn convert to Bean error:" + e.toString());
        }
        MultipleDataSource.clearDataSource();
        return mzk;
    }
}

