/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentInfo;
import com.efuture.business.javaPos.struct.SysPara;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcCancelOrderIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcafFirmIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcafFirmOut;
import com.efuture.business.javaPos.struct.request.CancelPayIn;
import com.efuture.business.javaPos.struct.request.DeletePaymentIn;
import com.efuture.business.javaPos.struct.request.PaymentIn;
import com.efuture.business.javaPos.struct.request.UpdatePaymentStatusIn;
import com.efuture.business.javaPos.struct.response.CancelPayOut;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.CouponCentreService;
import com.efuture.business.service.PaySaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.HttpZexUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.SubmitUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.DigestUtils;
import org.springframework.web.client.RestTemplate;

public class PaySaleBSImpl
implements PaySaleBS {
    private static final Logger log = LoggerFactory.getLogger(PaySaleBSImpl.class);
    private static Logger logger = LoggerFactory.getLogger(PaySaleBSImpl.class);
    RestTemplate restTemplate;
    @Autowired
    public RedisUtil redisUtil;
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    public CalcPopRemoteService promotionService;
    @Autowired
    public CouponCentreService couponCentreService;
    @Autowired
    public PosLogicService posLogicService;
    @Autowired
    public PosLogicCompoment posLogicCompoment;
    @Autowired
    public OrderTransfer orderTransfer;
    @Value(value="${globalinfo.signKey:000}")
    public String signKey;
    public static final String ORDERCANCLE = "efuture.omp.event.salereturn.ordercancel";
    @Resource(name="possvHttpUtils")
    public HttpUtils httpUtils;

    @Override
    public RespBase getRateAmt(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001, (Object)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", "\u4ed8\u6b3e\u91d1\u989d");
        }
        Double newRateAmt = 0.0;
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List sysParaList = modeDetailsVo.getSyspara();
        newRateAmt = this.posLogicCompoment.getNewRateAmt(paramsObject.getDouble("amount").doubleValue(), sysParaList);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("newRateAmt", (Object)newRateAmt);
        return new RespBase(Code.SUCCESS.getIndex(), Code.SUCCESS.getMsg(), (Object)jsonObject, "GETRATEAMT");
    }

    @Override
    public RespBase Payment(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        JSONObject object3;
        logger.info("\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[0]);
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"amount"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payCode"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payName"});
        }
        if (!paramsObject.containsKey((Object)"flag") || paramsObject.getString("flag").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"flag"});
        }
        if (!paramsObject.containsKey((Object)"scene") || paramsObject.getString("scene").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"scene"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getString("rate").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"rate"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"precision"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cutMode"});
        }
        if (!paramsObject.containsKey((Object)"maxVal") || paramsObject.getDouble("maxVal").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"maxVal"});
        }
        if (!paramsObject.containsKey((Object)"isAllowCharge") || paramsObject.getString("isAllowCharge").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"isAllowCharge"});
        }
        if (!paramsObject.containsKey((Object)"isOverage") || paramsObject.getString("isOverage").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"isOverage"});
        }
        if (!paramsObject.containsKey((Object)"minVal") || paramsObject.getDouble("minVal").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"minVal"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        PaymentIn in = (PaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), PaymentIn.class);
        logger.info("PaymentIn\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        log.info("paymentList1:" + JSONObject.toJSONString((Object)cacheModel.getPayments()));
        double tmpRAmt = cacheModel.getOrder().getNewRateRemainValue();
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        String paravalue = "1";
        String[] hlms = null;
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (sys.get((Object)"code").equals("OZ")) {
                    array.add((Object)sys);
                }
                if (!sys.get((Object)"code").equals("HLMS")) continue;
                hlms = sys.getString("paravalue").split("\\|");
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        double rate = 0.0;
        String rateMode = "";
        String isOpenRateMode = "";
        String code = "";
        String jdms = "";
        if (null != hlms && hlms.length >= 3) {
            rate = Double.parseDouble((String)hlms[0]);
            rateMode = hlms[1];
            isOpenRateMode = hlms[2];
            code = hlms[4];
            jdms = hlms[5];
        }
        String[] temp = paravalue.split(",");
        int maxSalePayCount = Integer.valueOf(temp[1]);
        if (cacheModel.getPayments().size() >= maxSalePayCount) {
            return Code.CODE_50044.getRespBase(new Object[0]);
        }
        if (in.getAmount() < in.getMinVal() || in.getAmount() > in.getMaxVal()) {
            return new RespBase(Code.CODE_50045, vo.getCacheModel().getFlowNo());
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && !"2".equals(cacheModel.getOrder().getOrderType()) && in.getAmount() > ManipulatePrecision.getMoneyByPrecision((double)cacheModel.getOrder().getRemainValue(), (String)in.getCutMode(), (String)in.getPrecision()) && !"Y".equals(in.getIsOverage())) {
            return Code.CODE_500003.getRespBase(new Object[0]);
        }
        logger.info("\u8ba1\u7b97\u5269\u4f59\u4ed8\u6b3e");
        Payment pay = PaymentIn.creatPayment((PaymentIn)in, (CacheModel)cacheModel);
        if ("1".equals(in.getScene())) {
            pay.setIsAutoDelOnly(true);
            pay.setIsDirectDel(false);
        }
        if (null != hlms && "Y".equals(in.getIsCalcForRate()) && 0.0 != in.getNewRateAmt()) {
            pay.setMoney(ManipulatePrecision.doubleConvert((double)ManipulatePrecision.div((double)in.getNewRateAmt(), (double)rate), (int)2, (int)1));
            pay.setAmount(ManipulatePrecision.doubleConvert((double)ManipulatePrecision.div((double)in.getNewRateAmt(), (double)rate), (int)2, (int)1));
            pay.setAdditionalData(String.valueOf(in.getNewRateAmt()));
            pay.setDeliveryMemoNumber(hlms[0]);
        }
        if ((cacheModel = this.posLogicService.CalcOrderAmountByPayReturn(cacheModel, pay)).getCalcResult() == -1) {
            String errCode = String.valueOf(Code.CODE_500000.getIndex());
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            Code.FAIL.setMsg(cacheModel.getErrMsg());
            return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
        }
        if (null != hlms) {
            for (Payment payment : cacheModel.getPayments()) {
                if (!"2".equals(payment.getFlag())) continue;
                log.info("payment.getPayCode()=====\u300b" + payment.getPayCode());
                log.info("code=====\u300b" + code);
                if (in.getPayCode().equals(code)) {
                    log.info("in.getNewRateAmt()=====\u300b" + in.getNewRateAmt());
                    log.info("cacheModel.getOrder().getNewRateRemainValue()=====\u300b" + tmpRAmt);
                    payment.setAdditionalData(String.valueOf(ManipulatePrecision.getDetailOverFlow((double)(in.getNewRateAmt() - tmpRAmt), (String)jdms)));
                } else {
                    payment.setAdditionalData(String.valueOf(this.posLogicCompoment.getNewRateAmt(payment.getAmount(), sysParaList)));
                }
                payment.setDeliveryMemoNumber(hlms[0]);
                break;
            }
        }
        log.info("paymentList2:" + JSONObject.toJSONString((Object)cacheModel.getPayments()));
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "PAYCERTIFY");
    }

    @Override
    public RespBase deletePayment(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        Payment payment = null;
        for (Object p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(in.getPuid())) continue;
            payment = p;
            break;
        }
        if (payment != null) {
            if ("0".equals(in.getScene()) && !payment.getIsDirectDel()) {
                return Code.CODE_50030.getRespBase(new Object[0]);
            }
            boolean isNeedCalcOrder = false;
            for (Payment p : cacheModel.getPayments()) {
                if (!p.getIsHaveDelDiscount()) continue;
                isNeedCalcOrder = true;
            }
            cacheModel.getPayments().remove(payment);
            PayUtil.sortPayments(cacheModel.getPayments());
            cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
            if (cacheModel.getCalcResult() == -1) {
                String errCode = String.valueOf(Code.CODE_500000.getIndex());
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
            }
            vo.setCacheModel(cacheModel);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "DELPAYCERTIFY");
    }

    @Override
    public RespBase updatePaymentStatus(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[0]);
        }
        UpdatePaymentStatusIn in = (UpdatePaymentStatusIn)JSON.parseObject((String)paramsObject.toJSONString(), UpdatePaymentStatusIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        List successList = in.getSuccessList();
        List failList = in.getFailList();
        ArrayList<Payment> deletePayments = new ArrayList<Payment>();
        block0: for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment p = (Payment)cacheModel.getPayments().get(i);
            if (null != successList && successList.size() > 0) {
                for (PaymentInfo success : successList) {
                    if (!p.getPuid().equals(success.getPuid())) continue;
                    if (StringUtils.isNotBlank((String)success.getRefCode())) {
                        ((Payment)cacheModel.getPayments().get(i)).setRefCode(success.getRefCode());
                    }
                    if (StringUtils.isNotBlank((String)success.getAmount())) {
                        ((Payment)cacheModel.getPayments().get(i)).setAmount(CastUtil.castDouble((Object)success.getAmount()));
                    }
                    if (StringUtils.isNotBlank((String)success.getTrace())) {
                        ((Payment)cacheModel.getPayments().get(i)).setTrace(CastUtil.castLong((Object)success.getTrace()));
                    }
                    if (!StringUtils.isNotBlank((String)success.getCouponBalance())) continue block0;
                    ((Payment)cacheModel.getPayments().get(i)).setCouponBalance(CastUtil.castDouble((Object)success.getCouponBalance()));
                    continue block0;
                }
            }
            if (null == failList || failList.size() <= 0) continue;
            for (PaymentInfo fail : failList) {
                if (!p.getPuid().equals(fail.getPuid())) continue;
                deletePayments.add(p);
                continue block0;
            }
        }
        if (deletePayments.size() > 0) {
            for (Payment payment : deletePayments) {
                cacheModel.getPayments().remove(payment);
            }
        }
        cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
        vo.setCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "UPDATEPAYMENTSTATUS");
    }

    @Override
    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        logger.info("\u53d6\u6d88\u6574\u5355\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        try {
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, jsonObject);
            if (!paramsValidateUtils.validate()) {
                return Code.CODE_3.getRespBase(new Object[0]);
            }
            CancelPayIn cancelPayIn = (CancelPayIn)JSON.parseObject((String)jsonObject.toJSONString(), CancelPayIn.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return new RespBase(Code.CODE_60, vo.getCacheModel().getFlowNo());
            }
            if (cacheModel.getOrder().getSendSuccess()) {
                return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            log.info("cacheModel.getOrder().getAllowEditGoods()==>{}", (Object)cacheModel.getOrder().getAllowEditGoods());
            if (cacheModel.getOrder().getAllowEditGoods()) {
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPosSingle(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "CANCELPAYCERTIFY");
            }
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                boolean isAllowedDel = true;
                for (Payment p : cacheModel.getPayments()) {
                    if (p.getIsAutoDelOnly()) continue;
                    isAllowedDel = false;
                    break;
                }
                if (!isAllowedDel) {
                    return new RespBase(Code.CODE_50030, vo.getCacheModel().getFlowNo());
                }
                cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel);
            }
            if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                CancelPayOut cancelPayOut = new CancelPayOut();
                cancelPayOut.setFlowNo(cancelPayIn.getFlowNo());
                log.info("\u662f\u5426\u767b\u5f55\u5458\u5de5\u5361==>{}", (Object)cacheModel.getOrder().getStaffLogin());
                if (StringUtils.isNotBlank((String)cacheModel.getOrder().getStaffNo())) {
                    if (!(cacheModel.getOrder().getStaffSale() || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 100.0 && cacheModel.getOrder().getTempZzk() != 0.0)) {
                        log.info("\u6ca1\u6709\u624b\u5de5\u6298\u6263,\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u53ef\u7528");
                        cacheModel.getOrder().setStaffSale(true);
                    } else if (cacheModel.getOrder().getDiscAmount() != 0.0 || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 100.0 && cacheModel.getOrder().getTempZzk() != 0.0) {
                        log.info("\u53d6\u6d88\u4ed8\u6b3e\u4fee\u6539\u5458\u5de5\u5361\u6807\u8bc6===false");
                        cacheModel.getOrder().setStaffSale(false);
                    }
                    cacheModel.setLimitedPayDetails(new ArrayList());
                }
                if (!"5".equals(cacheModel.getOrder().getOrderType()) && !this.isNoBackup(cacheModel) && !SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType()) && StringUtils.isNotEmpty((String)cacheModel.getOrder().getSeqNo())) {
                    try {
                        CalcafFirmIn calcafFirmIn = new CalcafFirmIn();
                        calcafFirmIn.setType("1");
                        calcafFirmIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
                        ServiceResponse response = this.couponCentreService.calcaffirm(this.restTemplate, session, calcafFirmIn);
                        if (!response.getReturncode().equals("0")) {
                            logger.info("\u53d6\u6d88\u9501\u5b9a\u9650\u91cf\u5931\u8d25:{}", (Object)JSONObject.toJSONString((Object)response));
                        } else {
                            CalcafFirmOut calcafFirmOut = (CalcafFirmOut)response.getData();
                        }
                    }
                    catch (Exception e) {
                        log.info("\u5f02\u5e38", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (!"5".equals(cacheModel.getOrder().getOrderType()) && !this.isNoBackup(cacheModel)) {
                    logger.info("\u5220\u9664\u5907\u4efd\u5546\u54c1");
                    cacheModel.restoreGoodsAndPayments();
                }
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                this.posLogicCompoment.calcPayBalance(cacheModel);
                cacheModel.getOrder().setAllowEditGoods(true);
                cacheModel.setRn(null);
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                if (cacheModel.getOrder().getUseZex().booleanValue()) {
                    String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
                    ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
                    String zexIp = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ZEXIP");
                    JSONObject jsonRequest = new JSONObject();
                    jsonRequest.put("shopId", (Object)cacheModel.getSyjmain().getMkt().substring(0, 4));
                    jsonRequest.put("listNo", (Object)cacheModel.getOrder().getTerminalSno());
                    jsonRequest.put("posNo", (Object)cacheModel.getSyjmain().getSyjh());
                    String url = zexIp + "/zex/ws/cancelAll";
                    log.info("\u77e5\u800c\u884c\u8bf7\u6c42\u5730\u5740==>{}", (Object)url);
                    log.info("json request ==>{}", (Object)JSONObject.toJSONString((Object)jsonRequest));
                    Map sParaTemp = SubmitUtil.paraFilter((Map)jsonRequest);
                    Object prestr = SubmitUtil.createLinkString((Map)sParaTemp);
                    prestr = (String)prestr + "&" + this.signKey;
                    log.info("\u6392\u5e8f=>{}", prestr);
                    String sign = DigestUtils.md5DigestAsHex((byte[])((String)prestr).getBytes());
                    jsonRequest.put("sign", (Object)sign);
                    log.info("\u77e5\u800c\u884c\u6574\u5355\u53d6\u6d88\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)jsonRequest));
                    String response = HttpZexUtils.post(url, JSONObject.toJSONString((Object)jsonRequest));
                    log.info("\u77e5\u800c\u884c\u6574\u5355\u53d6\u6d88\u63a5\u53e3\u8fd4\u56de==>{}", (Object)response);
                }
                return new RespBase(Code.SUCCESS, (Object)resqVo, "CANCELPAYCERTIFY");
            }
            if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                if (cacheModel.getOrder().getElectronicStamp() > 0.0) {
                    cacheModel.getOrder().setTempElectronicStamp(cacheModel.getOrder().getElectronicStamp());
                    cacheModel.getOrder().setElectronicStamp(0.0);
                }
                if (!this.isNoBackup(cacheModel)) {
                    cacheModel.restoreGoodsAndPayments();
                }
                String calcurl = ORDERCANCLE;
                CalcCancelOrderIn cancelOrderIn = new CalcCancelOrderIn();
                cancelOrderIn.setBillno(cacheModel.getOrder().getOriginFlowNo());
                cancelOrderIn.setChannel(cacheModel.getOrder().getChannel());
                cancelOrderIn.setType("1");
                String inParams = JSON.toJSONString((Object)cancelOrderIn);
                log.info("\u7ea2\u51b2\u53d6\u6d88\u4ed8\u6b3e cancelOrder====>" + inParams);
                ServiceResponse resp = null;
                inParams = JSON.toJSONString((Object)cancelOrderIn);
                resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.PROMOTION, calcurl, session, inParams, Object.class, "\u8425\u9500\u4e2d\u5fc3", "\u53d6\u6d88\u8ba2\u5355");
                log.info("\u7ea2\u51b2\u53d6\u6d88\u4ed8\u6b3e cancelOrder====>" + JSONObject.toJSON((Object)resp).toString());
            }
            if (-1 == (cacheModel = this.cancelPayWork(session, cacheModel)).getCalcResult()) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
            }
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            this.posLogicCompoment.calcPayBalance(cacheModel);
            cacheModel.getOrder().setAllowEditGoods(true);
            if (!(SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno()) || this.isNoBackup(cacheModel) || !StringUtils.isNotEmpty((String)cacheModel.getOrder().getSeqNo()))) {
                RespBase respBase = this.promotionService.calcSinglePopAll(session, "0", cacheModel, false);
                if (respBase.getRetflag() != 0) {
                    return respBase;
                }
                cacheModel = (CacheModel)respBase.getData();
            }
            vo.setCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
                    out.setOrder(this.orderTransfer.toOrderForReturnQuery(cacheModel));
                } else {
                    out.setOrder(this.orderTransfer.toOrderForNoTerminalSno(cacheModel));
                }
            }
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "CANCELPAYCERTIFY");
        }
        catch (Exception e) {
            logger.info("\u53d6\u6d88\u4ed8\u6b3e\u5f02\u5e38!", (Throwable)e);
            e.printStackTrace();
            return new RespBase(-1, "\u53d6\u6d88\u4ed8\u6b3e\u5f02\u5e38", vo.getCacheModel().getFlowNo());
        }
    }

    @Override
    public CacheModel cancelPayWork(ServiceSession session, CacheModel cacheModel) {
        return cacheModel;
    }

    public boolean isNoBackup(CacheModel cacheModel) {
        return false;
    }
}

