/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.CalcTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PaymentTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponReverse;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseGetOnlineIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.PointsPayIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponPayOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponuseGetOnlineOut;
import com.efuture.business.javaPos.struct.request.AddQrCodeTicketIn;
import com.efuture.business.javaPos.struct.request.CouponQueryIn;
import com.efuture.business.javaPos.struct.response.AddQrCodeOut;
import com.efuture.business.model.CouponDeleteIn;
import com.efuture.business.model.CouponRemoveIn;
import com.efuture.business.service.CouponCentreService;
import com.efuture.business.service.PointSaleBS;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class PointSaleBSImpl
implements PointSaleBS {
    private static final Logger log = LoggerFactory.getLogger(PointSaleBSImpl.class);
    RestTemplate restTemplate;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    public PaymentTransfer paymentTransfer;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    public CouponCentreService couponCentreService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    CalcTransfer calcTransfer;

    public RespBase pointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CouponPayOut couponPayOut;
        AddQrCodeOut addQrCodeOut;
        List sellPayment;
        List goods;
        log.info("\u79ef\u5206\u5229\u7528\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return new RespBase(Code.CODE_500001, (Object)"\u53c2\u6570\u6548\u9a8c\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u79ef\u5206\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801]", vo.getCacheModel().getFlowNo());
        }
        if (StringUtils.isBlank((String)paramsObject.getString("amount"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u79ef\u5206\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u79ef\u5206\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        AddQrCodeTicketIn addQrCodeIn = (AddQrCodeTicketIn)JSON.parseObject((String)paramsObject.toJSONString(), AddQrCodeTicketIn.class);
        if (addQrCodeIn == null) {
            return new RespBase(Code.CODE_500001, (Object)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder() == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a", vo.getCacheModel().getFlowNo());
        }
        if (null != cacheModel.getPayments()) {
            for (Payment payment : cacheModel.getPayments()) {
                if (!addQrCodeIn.getPayCode().equals(payment.getPayCode())) continue;
                return new RespBase(Code.CODE_500001.getIndex(), "\u5df2\u5b58\u5728\u8be5\u652f\u4ed8\u65b9\u5f0f", vo.getCacheModel().getFlowNo());
            }
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if ("1".equals(cacheModel.getOrder().getOrderType()) && StringUtils.isBlank((String)paramsObject.getString("accntNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u79ef\u5206\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[accntNo]", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + addQrCodeIn.getShopCode() + addQrCodeIn.getTerminalNo());
        PaymentMode model = null;
        if (obj != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)obj);
            model = PayModeUtils.getPayMode((String)addQrCodeIn.getPayCode(), (JSONObject)jsonObject);
            addQrCodeIn.setIsAllowCharge(model.getIszl());
            addQrCodeIn.setIsOverage(model.getIsyy());
            addQrCodeIn.setPrcutMode(model.getSswrfs());
            addQrCodeIn.setPrecision(String.valueOf(model.getSswrjd()));
        }
        if ("2".equals(cacheModel.getOrder().getOrderType()) || "4".equals(cacheModel.getOrder().getOrderType())) {
            for (Payment pay : cacheModel.getReturnPayments()) {
                if (!paramsObject.getString("payCode").equals(pay.getPayCode())) continue;
                pay.setPrcutMode(addQrCodeIn.getPrcutMode());
                pay.setPrecision(addQrCodeIn.getPrecision());
                pay.setIsAllowCharge(addQrCodeIn.getIsAllowCharge());
                pay.setIsOverage(addQrCodeIn.getIsOverage());
                pay.setIsSuccess(true);
                cacheModel = this.posLogicService.CalcOrderAmountByPayReturn(cacheModel, pay);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, Code.SUCCESS.getMsg(), (Object)resqVo, "POINTPAY");
            }
        }
        if ((goods = cacheModel.getGoodsList()) == null || goods.size() == 0) {
            return new RespBase(Code.CODE_60, (Object)"\u6ca1\u6709\u5546\u54c1\u4e0d\u5141\u8bb8\u4f7f\u7528\u79ef\u5206\u652f\u4ed8", vo.getCacheModel().getFlowNo());
        }
        if (null != cacheModel.getOrder().getConsumersData()) {
            log.info("\u5df2\u767b\u9646\u4f1a\u5458[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
        }
        log.info("\u79ef\u5206\u652f\u4ed8\u63a5\u53e3\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)addQrCodeIn));
        ModeDetailsVo modeDetailsVo1 = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo1.isTrainingMode();
        if (trainingMode) {
            return this.trainingModeSalePay(cacheModel, addQrCodeIn, model);
        }
        PointsPayIn pointsPayIn = new PointsPayIn();
        pointsPayIn.setAccntNo(addQrCodeIn.getAccntNo());
        pointsPayIn.setPayCode(addQrCodeIn.getPayCode());
        pointsPayIn.setPayje(addQrCodeIn.getAmount());
        pointsPayIn = this.calcTransfer.transferPointsPayIn(cacheModel, pointsPayIn);
        String xphm = cacheModel.getOrder().getTerminalSno();
        if (xphm.length() != cacheModel.getOrder().getSysPara().getXpws()) {
            xphm = xphm.substring(xphm.length() - cacheModel.getOrder().getSysPara().getXpws());
        }
        pointsPayIn.setRownoid(UniqueID.getUniqueID((String)xphm));
        ServiceResponse response = null;
        try {
            log.info("\u79ef\u5206\u5229\u7528\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)pointsPayIn));
            response = this.couponCentreService.pointsPay(this.restTemplate, session, pointsPayIn);
            log.info("\u79ef\u5206\u5229\u7528\u8fd4\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.info("\u8425\u9500\u79ef\u5206\u652f\u4ed8\u8bbf\u95ee\u5f02\u5e38" + e.getLocalizedMessage());
            return new RespBase(-1, "\u8425\u9500\u79ef\u5206\u652f\u4ed8\u8bbf\u95ee\u5f02\u5e38", "");
        }
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(-1, response.getData().toString(), "");
        }
        if (response.getData() == null) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8425\u9500\u79ef\u5206\u4f7f\u7528\u8fd4\u56de\u652f\u4ed8\u884c\u4e3a\u7a7a!");
        }
        if ((sellPayment = (addQrCodeOut = this.paymentTransfer.transferToAddQrCodeOut((couponPayOut = (CouponPayOut)response.getData()).getSellPayments(), couponPayOut.getCouponUses(), false)).getSellPayment()) == null || sellPayment.isEmpty()) {
            return new RespBase(-1, "\u8425\u9500\u79ef\u5206\u4f7f\u7528\u8fd4\u56de\u652f\u4ed8\u884c\u4e3a\u7a7a", "");
        }
        List oldPayment = cacheModel.getPayments();
        for (Payment payment : sellPayment) {
            Integer calcResult;
            boolean isExitPay = false;
            for (int i = 0; i < oldPayment.size(); ++i) {
                Payment oldPay = (Payment)oldPayment.get(i);
                if (!payment.getRownoId().equals(oldPay.getRownoId())) continue;
                isExitPay = true;
                break;
            }
            if (isExitPay) continue;
            payment.setIsCoupon("Y");
            if ("1".equals(addQrCodeIn.getScene())) {
                payment.setIsDirectDel(false);
                payment.setIsAutoDelOnly(true);
            } else {
                payment.setIsDirectDel(true);
            }
            payment.setPayMemo("YJFXF");
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setPrcutMode(addQrCodeIn.getPrcutMode());
            payment.setPrecision(addQrCodeIn.getPrecision());
            payment.setIsAllowCharge(addQrCodeIn.getIsAllowCharge());
            payment.setIsOverage(addQrCodeIn.getIsOverage());
            payment.setCopType(payment.getPayType());
            if (StringUtils.isNotBlank((String)payment.getConsumersId())) {
                payment.setPayNo(payment.getConsumersId());
            }
            if (model != null) {
                payment.setPayType(model.getPaytype());
                payment.setPayName(model.getName());
            }
            if ((calcResult = Integer.valueOf((cacheModel = this.posLogicService.CalcOrderAmountByPayReturn(cacheModel, payment)).getCalcResult())) == null || calcResult != -1) continue;
            new RespBase(10000, cacheModel.getErrMsg(), "POINTPAY");
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, Code.SUCCESS.getMsg(), (Object)resqVo, "POINTPAY");
    }

    private RespBase trainingModeSalePay(CacheModel cacheModel, AddQrCodeTicketIn in, PaymentMode model) {
        Payment payment = new Payment();
        payment.setPuid(UUIDUtils.buildPuid());
        payment.setRefCode("001");
        payment.setPayCode(in.getPayCode());
        payment.setPayName(model.getName());
        payment.setPayType(model.getPaytype());
        payment.setPayNo("000000001");
        payment.setAmount(1.0);
        payment.setMoney(1.0);
        payment.setTerminalNo(in.getTerminalNo());
        payment.setCustmnerName("\u5f20\u4e09");
        payment.setPrecision(in.getPrecision());
        payment.setPrcutMode(model.getSswrfs());
        payment.setRate(model.getZlhl().doubleValue());
        payment.setFlag("1");
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setIsAllowCharge(in.getIsAllowCharge());
        payment.setIsOverage(in.getIsOverage());
        payment.setPayMemo("POINT");
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
    }

    @Override
    public RespBase<ResqVo> availablePoint(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return new RespBase(Code.CODE_500001, (Object)"\u53c2\u6570\u6548\u9a8c\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
            return new RespBase(Code.CODE_500001, (Object)"\u79ef\u5206\u8ba1\u7b97\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u4ee3\u7801]", vo.getCacheModel().getFlowNo());
        }
        CouponQueryIn couponQueryIn = (CouponQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), CouponQueryIn.class);
        if (null == couponQueryIn) {
            return new RespBase(Code.CODE_500001, (Object)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (null == vo.getCacheModel()) {
            return new RespBase(Code.CODE_500001, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", vo.getCacheModel().getFlowNo());
        }
        String obj1 = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo1 = (ModeDetailsVo)JSONObject.parseObject((String)obj1, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo1.isTrainingMode();
        if (trainingMode) {
            JSONObject obj = new JSONObject();
            obj.put("available", (Object)10000);
            obj.put("accntNo", (Object)"000001");
            obj.put("maxAvailable", (Object)100);
            obj.put("pointExchange", (Object)100);
            obj.put("pointExchangeMoney", (Object)1);
            obj.put("rate", (Object)0.01);
            obj.put("maxRefundPoints", (Object)100);
            obj.put("message", (Object)"");
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)obj)));
            return new RespBase(Code.SUCCESS, Code.SUCCESS.getMsg(), (Object)resqVo, "AVAILABLEPOINT");
        }
        Order order = cacheModel.getOrder();
        ConsumersData member = order.getConsumersData();
        couponQueryIn.setChannel(order.getChannel());
        couponQueryIn.setTerminalSno(order.getTerminalSno());
        couponQueryIn.setConsumersId(member.getConsumersId());
        couponQueryIn.setCouponGroup("01");
        couponQueryIn.setDistinct("Y");
        if (SellType.ISBACK((String)order.getOrderType())) {
            couponQueryIn.setStatus("7");
        }
        ServiceResponse response = null;
        try {
            log.info("\u8c03\u7528\u53ef\u7528\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42=>{}", (Object)JSONObject.toJSONString((Object)couponQueryIn));
            CouponuseGetOnlineIn couponuseGetOnlineIn = this.calcTransfer.transferCouponGetIn(cacheModel, couponQueryIn);
            response = this.couponCentreService.couponuseGetOnline(this.restTemplate, session, couponuseGetOnlineIn);
            log.info("\u8c03\u7528\u53ef\u7528\u79ef\u5206\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u53ef\u7528\u79ef\u5206\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50017.getRespBase(new Object[0]);
        }
        if (!"0".equals(response.getReturncode())) {
            return new RespBase(Code.CODE_50017, response.getData(), vo.getCacheModel().getFlowNo());
        }
        CouponuseGetOnlineOut out = (CouponuseGetOnlineOut)response.getData();
        List couponUses = out.getCouponUses();
        double available = 0.0;
        String account = null;
        double maxAvailable = 0.0;
        long pointExchange = 0L;
        double pointExchangeMoney = 0.0;
        double maxRefundPoints = 0.0;
        double rate = 0.0;
        String message = "";
        if (null != couponUses) {
            for (int i = 0; i < couponUses.size(); ++i) {
                SellCoupon couponUse = (SellCoupon)couponUses.get(i);
                if (!"01".equals(couponUse.getCouponGroup()) || !"JFXF".equals(couponUse.getCouponType())) continue;
                available = ManipulatePrecision.add((double)available, (double)couponUse.getAvailable());
                if ((double)couponUse.getPointExchange() > 0.0) {
                    String limitJe = couponUse.getLimitJe();
                    if (StringUtils.isNotBlank((String)limitJe)) {
                        maxRefundPoints = Double.parseDouble(limitJe);
                    }
                    if ((double)couponUse.getPointExchange() > 0.0) {
                        if (order.getOrderType().equals("4")) {
                            available = maxRefundPoints;
                        }
                        maxAvailable = ManipulatePrecision.getDetailOverFlow((double)ManipulatePrecision.mul((double)Math.floor(ManipulatePrecision.div((double)available, (double)couponUse.getPointExchange())), (double)couponUse.getPointExchangeMoney()), (String)"0");
                    }
                    account = couponUse.getAccount();
                    pointExchange = couponUse.getPointExchange();
                    pointExchangeMoney = couponUse.getPointExchangeMoney();
                    rate = couponUse.getRate();
                    break;
                }
                message = couponUse.getDescribe();
            }
        }
        if ("\u4e0d\u53ef\u7528".equals(message)) {
            message = "\u6ca1\u6709\u627e\u5230\u6709\u6548\u79ef\u5206\u62b5\u6263\u89c4\u5219";
        }
        JSONObject obj = new JSONObject();
        obj.put("available", (Object)available);
        obj.put("accntNo", account);
        obj.put("maxAvailable", (Object)maxAvailable);
        obj.put("pointExchange", (Object)pointExchange);
        obj.put("pointExchangeMoney", (Object)pointExchangeMoney);
        obj.put("rate", (Object)rate);
        obj.put("maxRefundPoints", (Object)maxRefundPoints);
        obj.put("message", (Object)message);
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)obj)));
        return new RespBase(Code.SUCCESS, Code.SUCCESS.getMsg(), (Object)resqVo, "AVAILABLEPOINT");
    }

    public RespBase deletePointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return new RespBase(Code.CODE_500003, (Object)"\u53c2\u6570\u6548\u9a8c\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        CouponDeleteIn couponDeleteIn = (CouponDeleteIn)JSON.parseObject((String)paramsObject.toJSONString(), CouponDeleteIn.class);
        if (null == couponDeleteIn) {
            return new RespBase(-1, "\u5165\u53c2\u8f6c\u6362\u5931\u8d25", "");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder() == null) {
            return new RespBase(-1, "\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a", "");
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return new RespBase(-1, "\u9000\u8d27\u4e0d\u5141\u8bb8\u5220\u9664\u8be5\u652f\u4ed8\u884c", "");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        List goods = cacheModel.getGoodsList();
        if (goods == null || goods.size() == 0) {
            return new RespBase(-1, "\u6ca1\u6709\u5546\u54c1\u4e0d\u5141\u8bb8\u5220\u9664\u652f\u4ed8\u884c", "");
        }
        List pays = cacheModel.getPayments();
        Payment oldPayment = new Payment();
        if (!"3".equals(couponDeleteIn.getScene())) {
            if (pays == null || pays.size() == 0) {
                return new RespBase(-1, "\u83b7\u53d6\u652f\u4ed8\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a", "");
            }
        } else if (null == cacheModel.getReverseCoupons() || cacheModel.getReverseCoupons().size() <= 0) {
            return new RespBase(-1, "\u83b7\u53d6\u6263\u56de\u652f\u4ed8\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a", "");
        }
        boolean hasPayment = false;
        if (!"3".equals(couponDeleteIn.getScene())) {
            for (Payment payment : pays) {
                if (!payment.getPuid().equals(couponDeleteIn.getPuid().trim())) continue;
                hasPayment = true;
                oldPayment = payment;
                break;
            }
        } else {
            for (Payment payment : cacheModel.getReverseCoupons()) {
                if (!payment.getPuid().equals(couponDeleteIn.getPuid().trim())) continue;
                hasPayment = true;
                oldPayment = payment;
                break;
            }
        }
        if (!hasPayment) {
            return new RespBase(-1, "\u83b7\u53d6\u79ef\u5206\u652f\u4ed8\u884c\u4fe1\u606f\u5931\u8d25", "");
        }
        String obj1 = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo1 = (ModeDetailsVo)JSONObject.parseObject((String)obj1, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo1.isTrainingMode();
        if (trainingMode) {
            return this.trainingModeDeletePointPay(cacheModel, oldPayment);
        }
        ServiceResponse response = null;
        List payments = cacheModel.getPayments();
        try {
            response = this.couponCentreService.couponuseRemovePay(this.restTemplate, session, new CouponRemoveIn().transferRemovePayIn(cacheModel, oldPayment.getRownoId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(-1, "\u79ef\u5206\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38", vo.getCacheModel().getFlowNo());
        }
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(-1, "\u79ef\u5206\u652f\u4ed8\u63a5\u53e3\u5220\u9664\u5931\u8d25", vo.getCacheModel().getFlowNo());
        }
        if (!"3".equals(couponDeleteIn.getScene())) {
            payments.remove(oldPayment);
            PayUtil.sortPayments(payments);
            cacheModel.setPayments(payments);
        } else {
            payments = cacheModel.getReverseCoupons();
            for (int j = 0; j < payments.size(); ++j) {
                SellCouponReverse couponReverse = (SellCouponReverse)cacheModel.getDeductedCoupons().get(j);
                if (!oldPayment.getCouponType().equals(couponReverse.getCouponType()) || !oldPayment.getCouponGroup().equals(couponReverse.getCouponGroup())) continue;
                couponReverse.setIsReverse(false);
                couponReverse.setRemainAmount(ManipulatePrecision.add((double)couponReverse.getRemainAmount(), (double)oldPayment.getAmount()));
                break;
            }
            payments.remove(oldPayment);
            PayUtil.sortPayments(payments);
            cacheModel.setReverseCoupons(payments);
        }
        this.posLogicCompoment.calcPayBalance(cacheModel);
        Integer calcResult = cacheModel.getCalcResult();
        if (calcResult != null && calcResult == -1) {
            String errCode = "100000";
            if (cacheModel.getErrCode().length() > 0) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(-1, cacheModel.getErrMsg(), vo.getCacheModel().getFlowNo());
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "DELETEPOINT");
    }

    private RespBase trainingModeDeletePointPay(CacheModel cacheModel, Payment oldPayment) {
        cacheModel.getPayments().remove(oldPayment);
        PayUtil.sortPayments(cacheModel.getPayments());
        this.posLogicCompoment.calcPayBalance(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "DELETEPOINT");
    }

    @Override
    public RespBase<ResqVo> refundPointPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        return null;
    }
}

