/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.myshopr10.R10CouponInfo;
import com.efuture.business.javaPos.struct.myshopr10.R10CouponUse;
import com.efuture.business.javaPos.struct.myshopr10.R10CouponUseResp;
import com.efuture.business.javaPos.struct.myshopr10.R10Order;
import com.efuture.business.javaPos.struct.request.AddQrCodeTicketIn;
import com.efuture.business.javaPos.struct.request.CouponQueryIn;
import com.efuture.business.javaPos.struct.request.DeletePaymentIn;
import com.efuture.business.service.CouponCentreService;
import com.efuture.business.service.R10CouponSaleBS;
import com.efuture.business.util.HttpClientUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayTools;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class R10CouponSaleBSImpl
implements R10CouponSaleBS {
    private static final Logger log = LoggerFactory.getLogger(R10CouponSaleBSImpl.class);
    RestTemplate restTemplate;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    public CouponCentreService couponCentreService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    PayTools payTools;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    private static String COUPONCHECKMETHOD = "sale.coupon.check";
    private static String COUPONUSEMETHOD = "sale.coupon.use";
    private static String GETTOKEN = "auth.token.create";

    @Override
    public RespBase couponQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        String token = "";
        try {
            if (!paramsValidateUtils.validate()) {
                return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
            }
            CouponQueryIn couponQueryIn = (CouponQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), CouponQueryIn.class);
            if (null == couponQueryIn) {
                return new RespBase(Code.CODE_6, vo.getCacheModel().getFlowNo());
            }
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return new RespBase(Code.CODE_60, vo.getCacheModel().getFlowNo());
            }
            if (null == cacheModel.getOrder()) {
                return new RespBase(Code.CODE_100025, vo.getCacheModel().getFlowNo());
            }
            session.setEnt_id(cacheModel.getOrder().getEntId());
            String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            if (null == modeDetailsVo || null == modeDetailsVo.getPaymode()) {
                return new RespBase(Code.CODE_100010, (Object)cacheModel.getOrder().getTerminalNo(), vo.getCacheModel().getFlowNo());
            }
            token = this.getToken();
            if (!StringUtils.isNotEmpty((String)token)) {
                return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
            }
            R10Order r10Order = R10Order.paseToR10Order((CacheModel)cacheModel, (String)couponQueryIn.getCoupoonno());
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)r10Order);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("data", (Object)jsonArray);
            log.info("R10\u5238\u67e5\u8be2 \u5165\u53c2 ==>{}", (Object)r10Order);
            ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, COUPONCHECKMETHOD, session, jsonObject.toJSONString(), null, "myShop\u5238", "R10\u5238\u67e5\u8be2", token);
            log.info("R10\u5238\u67e5\u8be2  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if ("0".equals(response.getReturncode())) {
                R10CouponInfo r10CouponQueryResp = (R10CouponInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), R10CouponInfo.class);
                if (0 != r10CouponQueryResp.getRetcode()) {
                    return new RespBase(r10CouponQueryResp.getRetcode().intValue(), r10CouponQueryResp.getRetmsg());
                }
                Coupon coupon = new Coupon();
                String[] payCodes = null;
                if (StringUtils.isNotEmpty((String)r10CouponQueryResp.getPaytype())) {
                    payCodes = r10CouponQueryResp.getPaytype().split(",");
                    log.info("\u9650\u5236\u652f\u4ed8\u65b9\u5f0f\uff1a" + payCodes);
                    if (payCodes.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < payCodes.length; ++i) {
                            String code = PayModeUtils.toR10PayCode((String)payCodes[i], (ModeDetailsVo)modeDetailsVo);
                            sb.append(code);
                            if (i >= payCodes.length - 1) continue;
                            sb.append(",");
                        }
                        coupon.setMedia(sb.toString());
                    } else {
                        coupon.setMedia(PayModeUtils.toR10PayCode((String)r10CouponQueryResp.getPaytype(), (ModeDetailsVo)modeDetailsVo));
                    }
                }
                coupon.setQty(1.0);
                coupon.setAmount(r10CouponQueryResp.getValue().doubleValue());
                if (4 == r10CouponQueryResp.getCouponflag()) {
                    coupon.setCash(r10CouponQueryResp.getValue().doubleValue());
                } else {
                    coupon.setCash(r10CouponQueryResp.getOldvalue().doubleValue());
                }
                coupon.setCouponName(couponQueryIn.getCoupoonno());
                coupon.setAccount(couponQueryIn.getCoupoonno());
                ArrayList<Coupon> coupons2 = new ArrayList<Coupon>();
                coupons2.add(coupon);
                JSONObject jsonObject1 = new JSONObject();
                jsonObject1.put("coupons", coupons2);
                jsonObject1.put("transno", (Object)UniqueID.getUniqueID((String)vo.getCacheModel().getOrder().getTerminalSno()));
                return new RespBase(Code.SUCCESS, (Object)jsonObject1, "COUPONQUERY");
            }
            return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSONString((Object)response.getData()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_64.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase<ResqVo> couponPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("\u5238\u6838\u9500\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)paramsObject));
        String token = "";
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        R10CouponUse r10CouponUse = null;
        CacheModel cacheModel = null;
        AddQrCodeTicketIn addQrCodeIn = null;
        ServiceResponse response = null;
        Payment payment = null;
        try {
            if (!paramsValidateUtils.validate()) {
                return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
            }
            if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
                return Code.CODE_500001.getRespBase(new Object[]{paramsObject.getString("payCode")});
            }
            addQrCodeIn = (AddQrCodeTicketIn)JSON.parseObject((String)paramsObject.toJSONString(), AddQrCodeTicketIn.class);
            if (addQrCodeIn == null) {
                return new RespBase(Code.CODE_6, vo.getCacheModel().getFlowNo());
            }
            cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            if (cacheModel.getOrder() == null) {
                return new RespBase(Code.CODE_100025, vo.getCacheModel().getFlowNo());
            }
            session.setEnt_id(cacheModel.getOrder().getEntId());
            String obj = this.redisUtil.get(RedisKey.CACHEID + addQrCodeIn.getShopCode() + addQrCodeIn.getTerminalNo());
            PaymentMode payModel = null;
            if (obj != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)obj);
                payModel = PayModeUtils.getPayMode((String)addQrCodeIn.getPayCode(), (JSONObject)jsonObject);
            }
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                token = this.getToken();
                if (!StringUtils.isNotEmpty((String)token)) {
                    return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
                }
                r10CouponUse = new R10CouponUse(cacheModel, addQrCodeIn, "01");
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)r10CouponUse);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)jsonArray);
                log.info("couponusePay==>{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                log.info("R10\u5238\u6838\u9500 \u5165\u53c2 ==>{}", (Object)r10CouponUse);
                response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, COUPONUSEMETHOD, session, jsonObject.toJSONString(), null, "myShop\u5238", "R10\u5238\u6838\u9500", token);
                log.info("R10\u5238\u6838\u9500  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
                if (!"0".equals(response.getReturncode().trim())) {
                    return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSON((Object)response.getData()).toString());
                }
                if ("60003".equals(response.getReturncode())) {
                    r10CouponUse = new R10CouponUse(cacheModel, addQrCodeIn, "02");
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)r10CouponUse);
                    jsonObject = new JSONObject();
                    jsonObject.put("data", (Object)jsonArray);
                    log.info("couponusePay==>{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                    log.info("R10\u5238\u6838\u9500 \u5165\u53c2 ==>{}", (Object)r10CouponUse);
                    response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, COUPONUSEMETHOD, session, jsonObject.toJSONString(), null, "myShop\u5238", "R10\u5238\u6838\u9500", token);
                    log.info("R10\u5238\u6838\u9500  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
                    return new RespBase(Code.CODE_50127.getIndex(), "\u5238\u63a5\u53e3\u8bf7\u6c42\u8d85\u65f6");
                }
                if (response.getData() == null) {
                    return new RespBase(Code.CODE_50128.getIndex(), "\u5238\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
                }
                JSONArray jsonArray1 = JSONArray.parseArray((String)JSONObject.toJSONString((Object)response.getData()));
                R10CouponUseResp r10CouponUseResp = (R10CouponUseResp)JSONObject.parseObject((String)jsonArray1.get(0).toString(), R10CouponUseResp.class);
                if (0 != r10CouponUseResp.getRetcode()) {
                    return new RespBase(r10CouponUseResp.getRetcode(), r10CouponUseResp.getRetmsg());
                }
                payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(paramsObject.getString("payCode"));
                payment.setPayName(payModel.getName());
                payment.setPayType(payModel.getPaytype());
                payment.setPayNo(addQrCodeIn.getAccntNo());
                payment.setAmount(addQrCodeIn.getAmount());
                payment.setMoney(addQrCodeIn.getAmount());
                payment.setCopType(String.valueOf(r10CouponUseResp.getCouponflag()));
                payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                payment.setPrecision(String.valueOf(payModel.getSswrjd()));
                payment.setPrcutMode(payModel.getSswrfs());
                payment.setIsAllowCharge(payModel.getIszl());
                payment.setIsOverage(payModel.getIsyy());
                payment.setRate(payModel.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setMemo(String.valueOf(addQrCodeIn.getTransno()));
                payment.setPayMemo("R10COUPON");
                payment.setDescription("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setRownoId(payment.getPuid());
                payment.setCouponGroup("B");
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            } else if ("2".equals(cacheModel.getOrder().getOrderType())) {
                if (null != cacheModel.getReturnPayments()) {
                    for (Payment payment1 : cacheModel.getReturnPayments()) {
                        if (!"R10COUPON".equals(payment1.getPayMemo())) continue;
                        payment1.setPuid(String.valueOf(UniqueID.getUniqueID()));
                        payment1.setRowno(cacheModel.getPayments().size() + 1);
                        payment1.setPrecision(String.valueOf(payModel.getSswrjd()));
                        payment1.setPrcutMode(payModel.getSswrfs());
                        payment1.setIsAllowCharge(payModel.getIszl());
                        payment1.setIsOverage(payModel.getIsyy());
                        payment1.setRate(payModel.getZlhl().doubleValue());
                        payment1.setIsSuccess(true);
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment1);
                    }
                }
            } else if ("4".equals(cacheModel.getOrder().getOrderType())) {
                payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(paramsObject.getString("payCode"));
                payment.setPayName(payModel.getName());
                payment.setPayType(payModel.getPaytype());
                payment.setPayNo(addQrCodeIn.getAccntNo());
                payment.setAmount(addQrCodeIn.getAmount());
                payment.setMoney(addQrCodeIn.getAmount());
                payment.setCopType("1");
                payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                payment.setPrecision(String.valueOf(payModel.getSswrjd()));
                payment.setPrcutMode(payModel.getSswrfs());
                payment.setIsAllowCharge(payModel.getIszl());
                payment.setIsOverage(payModel.getIsyy());
                payment.setRate(payModel.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setPayMemo("R10COUPON");
                payment.setDescription("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setRownoId(payment.getPuid());
                payment.setCouponGroup("B");
                payment.setIsSuccess(true);
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            }
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "R10GCOUPONPAY");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                r10CouponUse = new R10CouponUse(cacheModel, addQrCodeIn, "02");
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)r10CouponUse);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)jsonArray);
                log.info("couponusePay==>{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                log.info("R10\u5238\u6838\u9500\u5931\u8d25\u51b2\u6b63\u5165\u53c2 ==>{}", (Object)r10CouponUse);
                response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, COUPONUSEMETHOD, session, jsonObject.toJSONString(), null, "myShop\u5238", "R10\u5238\u6838\u9500", token);
                log.info("R10\u5238\u6838\u9500\u5931\u8d25\u51b2\u6b63\u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            }
            return new RespBase(Code.CODE_50130.getIndex(), "\u5238\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38" + e.getMessage());
        }
    }

    @Override
    public RespBase couponConsume(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        String token = "";
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        token = this.getToken();
        if (!StringUtils.isNotEmpty((String)token)) {
            return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
        }
        R10CouponUse r10CouponUse = new R10CouponUse(paramsObject, "02");
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)r10CouponUse);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)jsonArray);
        log.info("couponConsume==>{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        log.info("R10\u5238\u51b2\u6b63 \u5165\u53c2 ==>{}", (Object)r10CouponUse);
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, COUPONUSEMETHOD, session, jsonObject.toJSONString(), null, "myShop\u5238", "R10\u5238\u51b2\u6b63", token);
        log.info("R10\u5238\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        if (response.getData() == null) {
            return new RespBase(Code.CODE_50128.getIndex(), "\u5238\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
        }
        JSONArray jsonArray1 = JSONArray.parseArray((String)JSONObject.toJSONString((Object)response.getData()));
        R10CouponUseResp r10CouponUseResp = (R10CouponUseResp)JSONObject.parseObject((String)jsonArray1.get(0).toString(), R10CouponUseResp.class);
        if (0 != r10CouponUseResp.getRetcode()) {
            return new RespBase(r10CouponUseResp.getRetcode(), r10CouponUseResp.getRetmsg());
        }
        return new RespBase(Code.SUCCESS);
    }

    @Override
    public RespBase delCouponPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        String token = "";
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(in.getPuid())) continue;
            payment = p;
            break;
        }
        if (payment != null) {
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                token = this.getToken();
                if (!StringUtils.isNotEmpty((String)token)) {
                    return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
                }
                R10CouponUse r10CouponUse = new R10CouponUse(cacheModel, payment, "02");
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)r10CouponUse);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)jsonArray);
                log.info("couponusePay==>{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                log.info("R10\u5238\u51b2\u6b63 \u5165\u53c2 ==>{}", (Object)r10CouponUse);
                ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, COUPONUSEMETHOD, session, jsonObject.toJSONString(), null, "myShop\u5238\u5220\u9664\u652f\u4ed8\u884c", "R10\u5238\u51b2\u6b63", token);
                log.info("R10\u5238\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
                if (!"0".equals(response.getReturncode().trim())) {
                    return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
                }
                if (response.getData() == null) {
                    return new RespBase(Code.CODE_50128.getIndex(), "\u5238\u51b2\u6b63\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
                }
                JSONArray jsonArray1 = JSONArray.parseArray((String)JSONObject.toJSONString((Object)response.getData()));
                R10CouponUseResp r10CouponUseResp = (R10CouponUseResp)JSONObject.parseObject((String)jsonArray1.get(0).toString(), R10CouponUseResp.class);
                if (0 != r10CouponUseResp.getRetcode()) {
                    return new RespBase(r10CouponUseResp.getRetcode(), r10CouponUseResp.getRetmsg());
                }
            }
            cacheModel.getPayments().remove(payment);
            PayUtil.sortPayments(cacheModel.getPayments());
            cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
            if (cacheModel.getCalcResult() == -1) {
                String errCode = String.valueOf(Code.CODE_500000.getIndex());
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
            }
            vo.setCacheModel(cacheModel);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "R10DELCOUPONPAYCERTIFY");
    }

    private String getToken() {
        JSONObject jsonResponse;
        String token = "";
        JSONObject tokenObj = new JSONObject();
        tokenObj.put("usercode", (Object)GlobalInfo.getMyshopTokenUseName());
        tokenObj.put("password", (Object)GlobalInfo.getMyshopTokenPassWord());
        log.info("\u83b7\u53d6R10 Token\u5f00\u59cb:{}", JSONObject.toJSON((Object)tokenObj));
        String res = HttpClientUtil.postJson((String)(GlobalInfo.getMyShopGroupUrl() + "?method=" + GETTOKEN), (String)tokenObj.toJSONString());
        log.info("\u83b7\u53d6R10 Token\u8fd4\u56de:{}", (Object)res);
        if (StringUtils.isNotBlank((String)res) && "0".equals((jsonResponse = JSONObject.parseObject((String)res)).getString("returncode"))) {
            token = jsonResponse.getJSONObject("data").getString("access_token");
        }
        if (StringUtils.isBlank((String)token)) {
            return "";
        }
        log.info("token:" + token);
        return token;
    }
}

