/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.myshopr10.R10PointAcc;
import com.efuture.business.javaPos.struct.myshopr10.R10PointAccIn;
import com.efuture.business.javaPos.struct.myshopr10.R10PointsExchange;
import com.efuture.business.javaPos.struct.myshopr10.R10QueryPointInfo;
import com.efuture.business.javaPos.struct.request.DeletePaymentIn;
import com.efuture.business.service.MlMzkService;
import com.efuture.business.service.R10PointSaleBS;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.R10GetToken;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class R10PointSaleBSImpl
implements R10PointSaleBS {
    private static final Logger log = LoggerFactory.getLogger(R10PointSaleBSImpl.class);
    RestTemplate restTemplate;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    MlMzkService mlMzkService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    public static String POINTACC = "sale.point.acc";
    public static String POINTQUERY = "sale.pointgain.get";
    public static String POINTEXCHANGE = "sale.memberintswap.get";

    @Override
    public RespBase pointWriteOff(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = null;
        R10GetToken r10GetToken = new R10GetToken();
        String token = r10GetToken.getToken();
        if (!StringUtils.isNotEmpty((String)token)) {
            return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
        }
        cacheModel = vo.getCacheModel();
        R10PointAcc r10PointAcc = null;
        for (Payment payment : cacheModel.getPayments()) {
            if (!"R10POINTVIRTUE".equals(payment.getPayMemo())) continue;
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                r10PointAcc = new R10PointAcc(cacheModel, payment, "01");
            }
            log.info("R10\u4f1a\u5458\u79ef\u5206\u6838\u9500 \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString(r10PointAcc));
            ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTACC, session, JSONObject.toJSONString((Object)r10PointAcc), null, "myShop\u4f1a\u5458\u79ef\u5206", "R10\u4f1a\u5458\u79ef\u5206\u6838\u9500", token);
            log.info("R10\u4f1a\u5458\u79ef\u5206\u6838\u9500  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if ("0".equals(response.getReturncode())) continue;
            return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        return new RespBase(Code.SUCCESS, (Object)vo);
    }

    public RespBase pointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = null;
        R10GetToken r10GetToken = new R10GetToken();
        String token = r10GetToken.getToken();
        if (!StringUtils.isNotEmpty((String)token)) {
            return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
        }
        R10PointAccIn r10PointAccIn = (R10PointAccIn)JSONObject.parseObject((String)paramsObject.toString(), R10PointAccIn.class);
        cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder() == null) {
            return new RespBase(Code.CODE_100025, vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + r10PointAccIn.getShopCode() + r10PointAccIn.getTerminalNo());
        PaymentMode payModel = null;
        if (obj != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)obj);
            payModel = PayModeUtils.getPayMode((String)r10PointAccIn.getPayCode(), (JSONObject)jsonObject);
        }
        R10PointAcc r10PointAcc = null;
        if ("1".equals(cacheModel.getOrder().getOrderType())) {
            r10PointAcc = new R10PointAcc(cacheModel, r10PointAccIn, "01");
        } else if ("4".equals(cacheModel.getOrder().getOrderType())) {
            r10PointAcc = new R10PointAcc(cacheModel, r10PointAccIn, "03");
            if (cacheModel.getOrder().getRemainValue() < r10PointAcc.getSalevalue()) {
                return new RespBase(Code.CODE_50124, vo.getCacheModel().getFlowNo());
            }
        }
        log.info("R10\u4f1a\u5458\u79ef\u5206\u6838\u9500 \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)r10PointAcc));
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTACC, session, JSONObject.toJSONString((Object)r10PointAcc), null, "myShop\u4f1a\u5458\u79ef\u5206", "R10\u4f1a\u5458\u79ef\u5206\u6838\u9500", token);
        log.info("R10\u4f1a\u5458\u79ef\u5206\u6838\u9500  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if (!"0".equals(response.getReturncode())) {
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                r10PointAcc.setVtype("02");
            } else if ("4".equals(cacheModel.getOrder().getOrderType())) {
                r10PointAcc.setVtype("04");
            }
            log.info("R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63 \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)r10PointAcc));
            response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTACC, session, JSONObject.toJSONString((Object)r10PointAcc), null, "myShop\u4f1a\u5458\u79ef\u5206", "R10\u4f1a\u5458\u79ef\u5206\u6838\u9500", token);
            log.info("R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            return new RespBase(-1, JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayCode(paramsObject.getString("payCode"));
        payment.setPayName(payModel.getName());
        payment.setPayType(payModel.getPaytype());
        payment.setPayNo(r10PointAccIn.getCardNo());
        payment.setRate(r10PointAccIn.getPointRate());
        payment.setAmount(r10PointAccIn.getPoint());
        payment.setMoney(ManipulatePrecision.mul((double)r10PointAccIn.getPoint(), (double)r10PointAccIn.getPointRate()));
        payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
        payment.setPrecision(String.valueOf(payModel.getSswrjd()));
        payment.setPrcutMode(payModel.getSswrfs());
        payment.setIsAllowCharge(payModel.getIszl());
        payment.setIsOverage(payModel.getIsyy());
        payment.setFlag("1");
        payment.setRefCode(String.valueOf(r10PointAccIn.getSqno()));
        payment.setPayMemo("R10POINT");
        payment.setDescription("1");
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setRownoId(payment.getPuid());
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        cacheModel.getOrder().setThisTimeUsedPoint(r10PointAccIn.getPoint());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "R10POINTPAY", cacheModel.getFlowNo());
    }

    @Override
    public RespBase delPointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        String token = "";
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(in.getPuid())) continue;
            payment = p;
            break;
        }
        if (payment != null) {
            R10GetToken r10GetToken = new R10GetToken();
            token = r10GetToken.getToken();
            if (!StringUtils.isNotEmpty((String)token)) {
                return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
            }
            R10PointAcc r10PointAcc = null;
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                r10PointAcc = new R10PointAcc(cacheModel, payment, "02");
            } else if ("4".equals(cacheModel.getOrder().getOrderType())) {
                r10PointAcc = new R10PointAcc(cacheModel, payment, "04");
            }
            log.info("R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63\u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)r10PointAcc));
            ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTACC, session, JSONObject.toJSONString((Object)r10PointAcc), null, "myShop\u4f1a\u5458\u79ef\u5206", "R10\u4f1a\u5458\u79ef\u5206\u6838\u9500", token);
            log.info("R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if (!"0".equals(response.getReturncode().trim())) {
                return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
            }
            if (response.getData() == null) {
                return new RespBase(Code.CODE_50128.getIndex(), "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", cacheModel.getFlowNo());
            }
        }
        cacheModel.getOrder().setThisTimeUsedPoint(0.0);
        cacheModel.getPayments().remove(payment);
        PayUtil.sortPayments(cacheModel.getPayments());
        cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
        if (cacheModel.getCalcResult() == -1) {
            String errCode = String.valueOf(Code.CODE_500000.getIndex());
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
        }
        vo.setCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "R10DELPOINTPAYCERTIFY", cacheModel.getFlowNo());
    }

    @Override
    public RespBase<ResqVo> pointQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        R10GetToken r10GetToken = new R10GetToken();
        String token = r10GetToken.getToken();
        if (!StringUtils.isNotEmpty((String)token)) {
            return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
        }
        log.info("R10\u4f1a\u5458\u79ef\u5206\u67e5\u8be2 \u5165\u53c2 ==>{}", (Object)jsonObject.toJSONString());
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTQUERY, session, jsonObject.toJSONString(), null, "myShop\u4f1a\u5458\u79ef\u5206", "R10\u4f1a\u5458\u79ef\u5206\u67e5\u8be2", token);
        log.info("R10\u4f1a\u5458\u79ef\u5206\u67e5\u8be2  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if ("0".equals(response.getReturncode())) {
            R10QueryPointInfo r10QueryPointInfo = (R10QueryPointInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), R10QueryPointInfo.class);
            r10QueryPointInfo.setRate(Double.valueOf(ManipulatePrecision.div((double)r10QueryPointInfo.getGainvalue(), (double)r10QueryPointInfo.getGainaccuvalue())));
            r10QueryPointInfo.setSqno(Long.valueOf(UniqueID.getUniqueID((String)vo.getCacheModel().getOrder().getTerminalSno())));
            return new RespBase(Code.SUCCESS, (Object)r10QueryPointInfo, "R10POINTQUERY", vo.getCacheModel().getFlowNo());
        }
        return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSONString((Object)response.getData()));
    }

    @Override
    public RespBase pointConsume(ServiceSession session, JSONObject paramsObject) {
        R10GetToken r10GetToken = new R10GetToken();
        String token = r10GetToken.getToken();
        if (!StringUtils.isNotEmpty((String)token)) {
            return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
        }
        R10PointAcc r10PointAcc = new R10PointAcc(paramsObject, "02");
        log.info("R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63 \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)r10PointAcc));
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTACC, session, JSONObject.toJSONString((Object)r10PointAcc), null, "myShop\u4f1a\u5458\u79ef\u5206", "R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63", token);
        log.info("R10\u4f1a\u5458\u79ef\u5206\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(Integer.parseInt(response.getReturncode().trim()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        if (response.getData() == null) {
            return new RespBase(Code.CODE_50128.getIndex(), "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
        }
        return new RespBase(Code.SUCCESS);
    }

    @Override
    public RespBase pointsQueryAndVirtuePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + vo.getCacheModel().getOrder().getShopCode() + vo.getCacheModel().getOrder().getTerminalNo());
        PaymentMode payModel = null;
        if (obj != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)obj);
            payModel = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)jsonObject);
        }
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayCode(paramsObject.getString("payCode"));
        payment.setPayName(payModel.getName());
        payment.setPayType(payModel.getPaytype());
        payment.setPayNo(vo.getCacheModel().getOrder().getConsumersData().getConsumersCard());
        payment.setRate(1.0);
        payment.setAmount(paramsObject.getDouble("amount").doubleValue());
        payment.setMoney(paramsObject.getDouble("amount").doubleValue());
        payment.setCashCost(paramsObject.getDouble("point").doubleValue());
        payment.setTerminalNo(vo.getCacheModel().getOrder().getTerminalNo());
        payment.setPrecision(String.valueOf(payModel.getSswrjd()));
        payment.setPrcutMode(payModel.getSswrfs());
        payment.setIsAllowCharge(payModel.getIszl());
        payment.setIsOverage(payModel.getIsyy());
        payment.setIsDirectDel(true);
        payment.setFlag("1");
        payment.setRefCode(String.valueOf(UniqueID.getUniqueID((String)vo.getCacheModel().getOrder().getTerminalSno())));
        payment.setPayMemo("R10POINTVIRTUE");
        payment.setRowno(vo.getCacheModel().getPayments().size() + 1);
        payment.setRownoId(payment.getPuid());
        vo.setCacheModel(this.posLogicCompoment.calcPayAmout(vo.getCacheModel(), payment));
        vo.getCacheModel().getOrder().setThisTimeUsedPoint(vo.getCacheModel().getOrder().getThisTimeUsedPoint() + paramsObject.getDouble("point"));
        for (Goods goods : vo.getCacheModel().getGoodsList()) {
            if (!goods.getGuid().equals(paramsObject.getString("guid"))) continue;
            goods.setRemark(String.valueOf(payment.getRowno()) + "|" + goods.getOrgR10ExchangePoint() + "|" + goods.getOrgR10ExchangeAmount() + "|" + goods.getR10ExchangeRate());
            break;
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(vo.getCacheModel()));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)vo.getCacheModel(), (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "R10POINTQUERYANDVIRTUEPAY", vo.getCacheModel().getFlowNo());
    }

    @Override
    public RespBase pointsExchange(ServiceSession session, JSONObject paramsObject) {
        R10GetToken r10GetToken = new R10GetToken();
        String token = r10GetToken.getToken();
        if (!StringUtils.isNotEmpty((String)token)) {
            return new RespBase(Code.CODE_50123.getIndex(), "\u672a\u83b7\u53d6\u5230token");
        }
        log.info("R10\u79ef\u5206\u6362\u8d2d\u67e5\u8be2 \u5165\u53c2 ==>{}", (Object)paramsObject.toJSONString());
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPBACKREBATE, POINTEXCHANGE, session, JSONObject.toJSONString((Object)paramsObject), null, "myShop\u79ef\u5206\u6362\u8d2d\u67e5\u8be2", "R10\u79ef\u5206\u6362\u8d2d\u67e5\u8be2", token);
        log.info("R10\u79ef\u5206\u6362\u8d2d\u67e5\u8be2  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(Integer.parseInt(response.getReturncode().trim()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        if (response.getData() == null) {
            return new RespBase(Code.CODE_50128.getIndex(), "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
        }
        R10PointsExchange r10PointsExchange = (R10PointsExchange)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), R10PointsExchange.class);
        return new RespBase(Code.SUCCESS, (Object)r10PointsExchange);
    }
}

