/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.allVpay.request.CheckPayCodeIn;
import com.efuture.business.model.allVpay.response.CheckPayCodeOut;
import com.efuture.business.model.sjgw.AckParamDO;
import com.efuture.business.model.sjgw.Attributes;
import com.efuture.business.model.sjgw.PayCancelParamDO;
import com.efuture.business.model.sjgw.PayParamDO;
import com.efuture.business.model.sjgw.SjgwPayRes;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.SjMzkSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class SjMzkSaleBSImpl
implements SjMzkSaleBS {
    private static final Logger log = Logger.getLogger(SjMzkSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initRemoteService;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    protected RestTemplate restTemplate;
    protected String CHECKPAYCODE = "order.online.check.payCode";
    @Autowired
    protected RedisUtil redisUtil;

    @Override
    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = null;
        if (null != vo && (cacheModel = vo.getCacheModel()) == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String sjkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJKEY");
        String url = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJPAYURL");
        if (StringUtils.isBlank((String)url)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)sjkey)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u7b7e\u540dKey\u672a\u8bbe\u7f6e"});
        }
        AckParamDO in = this.loadQueryRequestPara(cacheModel, paramsObject);
        JSONObject j = new JSONObject();
        j.put("ackParamDO", (Object)in);
        ServiceResponse resp = this.httpUtils.doSjgw(sjkey, url, "/payment/ack", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u67e5\u8be2");
        if ("0".equals(resp.getReturncode())) {
            SjgwPayRes res1 = (SjgwPayRes)resp.getData();
            if ("0".equals(res1.getErrorCode())) {
                JSONObject body = res1.getAckResultDO();
                double balance = body.getDouble("balance");
                body.put("balance", (Object)ManipulatePrecision.div((double)balance, (double)100.0));
                return new RespBase(Code.SUCCESS, (Object)body);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cardNo"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"amount"});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        double balance = 0.0;
        if (null != paramsObject.getDouble("balance") && paramsObject.getDouble("balance") > 0.0) {
            balance = paramsObject.getDouble("balance");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paycodes = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CZKDI");
        if (StringUtils.isBlank((String)paycodes) || !paycodes.contains(",")) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u50a8\u503c\u5361\u53cd\u5199code\u672a\u8bbe\u7f6e"});
        }
        String pmCode = "";
        pmCode = "deposit_card".equals(paramsObject.getString("accountType")) ? paycodes.split(",")[0] : paycodes.split(",")[1];
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - paramsObject.getDouble("amount") < 0.0 && "N".equals(mzkPayMode.getIsyy())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        String sjkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJKEY");
        if (StringUtils.isBlank((String)sjkey)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u7b7e\u540dKey\u672a\u8bbe\u7f6e"});
        }
        String url = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJPAYURL");
        if (StringUtils.isBlank((String)url)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u672a\u8bbe\u7f6e"});
        }
        PayParamDO in = this.loadPayRequestPara(cacheModel, paramsObject);
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        in.setOutTradeNo(rnd);
        if (StringUtils.isNotBlank((String)paramsObject.getString("rnd"))) {
            in.setOutTradeNo(paramsObject.getString("rnd"));
        }
        JSONObject j = new JSONObject();
        j.put("payParamDO", (Object)in);
        ServiceResponse resp = this.httpUtils.doSjgw(sjkey, url, "/payment/pay", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u652f\u4ed8");
        if ("0".equals(resp.getReturncode())) {
            SjgwPayRes res1 = (SjgwPayRes)resp.getData();
            if ("0".equals(res1.getErrorCode())) {
                Payment payment = this.creatPayment(paramsObject, cacheModel, mzkPayMode, in, rnd, paramsObject.getDouble("amount"));
                this.checkPayName(obj, paramsObject, payment, pmCode);
                if (balance > 0.0) {
                    payment.setCouponBalance(ManipulatePrecision.sub((double)balance, (double)payment.getAmount()));
                }
                if ((cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment)).getCalcResult() == -1) {
                    return new RespBase(10000, cacheModel.getErrMsg());
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        int i = 0;
        while (i < 12) {
            ++i;
            resp = this.httpUtils.doSjgw(sjkey, url, "/payment/pay", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u652f\u4ed8");
            if ("0".equals(resp.getReturncode())) {
                SjgwPayRes res1 = (SjgwPayRes)resp.getData();
                if ("0".equals(res1.getErrorCode()) || "990002".equals(res1.getErrorCode())) {
                    Payment payment = this.creatPayment(paramsObject, cacheModel, mzkPayMode, in, rnd, paramsObject.getDouble("amount"));
                    this.checkPayName(obj, paramsObject, payment, pmCode);
                    if (balance > 0.0) {
                        payment.setCouponBalance(ManipulatePrecision.sub((double)balance, (double)payment.getAmount()));
                    }
                    if ((cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment)).getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo);
                }
                if ("990001".equals(res1.getErrorCode())) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u56de\u6536\u5931\u8d25\uff1a" + res1.getErrorMessage()});
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u652f\u4ed8\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    private Payment creatPayment(JSONObject paramsObject, CacheModel cacheModel, PaymentMode mzkPayMode, PayParamDO in, String rnd, double amount) {
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayCode(paramsObject.getString("payCode"));
        payment.setPayName(mzkPayMode.getName());
        payment.setPayType(mzkPayMode.getCode());
        payment.setAuthCode(in.getAccountType());
        payment.setPayNo(in.getDeductAccount());
        payment.setRefCode(rnd);
        payment.setTrackData(in.getDeductAccount());
        payment.setAmount(amount);
        payment.setMoney(amount);
        payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
        payment.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
        payment.setPrcutMode(mzkPayMode.getSswrfs());
        payment.setRate(mzkPayMode.getZlhl().doubleValue());
        payment.setPayMemo(in.getAttributes());
        payment.setFlag("1");
        payment.setRowno(cacheModel.getPayments().size() + 1);
        return payment;
    }

    public RespBase salePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return null;
    }

    @Override
    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        String puid = paramsObject.getString("puid");
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            if (!"deposit_card".equals(p.getAuthCode())) break;
            return Code.CODE_50053.getRespBase(new Object[]{"IC\u50a8\u503c\u5361\u4e0d\u5141\u8bb8\u5220\u9664\u652f\u4ed8\u884c"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String sjkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJKEY");
        if (StringUtils.isBlank((String)sjkey)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u7b7e\u540dKey\u672a\u8bbe\u7f6e"});
        }
        String url = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJPAYURL");
        if (StringUtils.isBlank((String)url)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u672a\u8bbe\u7f6e"});
        }
        PayCancelParamDO in = this.loadCancelRequestPara(PreDeletePayment);
        JSONObject jo = new JSONObject();
        jo.put("bizOrderNo", (Object)order.getFlowNo());
        in.setAttributes(jo.toJSONString());
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        in.setRequestId(rnd);
        if (StringUtils.isNotBlank((String)paramsObject.getString("rnd"))) {
            in.setRequestId(paramsObject.getString("rnd"));
        }
        JSONObject j = new JSONObject();
        j.put("payCancelParamDO", (Object)in);
        ServiceResponse resp = this.httpUtils.doSjgw(sjkey, url, "/payment/cancel", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u652f\u4ed8\u64a4\u9500");
        if ("0".equals(resp.getReturncode())) {
            SjgwPayRes res1 = (SjgwPayRes)resp.getData();
            if ("0".equals(res1.getErrorCode())) {
                if (PreDeletePayment != null) {
                    cacheModel.getPayments().remove(PreDeletePayment);
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u50a8\u503c\u5361\u652f\u4ed8\u884c\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        int i = 0;
        while (i < 12) {
            ++i;
            resp = this.httpUtils.doSjgw(sjkey, url, "/payment/cancel", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u652f\u4ed8\u64a4\u9500");
            if ("0".equals(resp.getReturncode())) {
                SjgwPayRes res1 = (SjgwPayRes)resp.getData();
                if ("0".equals(res1.getErrorCode()) || "990004".equals(res1.getErrorCode())) {
                    if (PreDeletePayment != null) {
                        cacheModel.getPayments().remove(PreDeletePayment);
                        PayUtil.sortPayments(cacheModel.getPayments());
                        cacheModel.setPayments(cacheModel.getPayments());
                        cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                        if (cacheModel.getCalcResult() == -1) {
                            return new RespBase(10000, cacheModel.getErrMsg());
                        }
                    }
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo);
                }
                if ("990003".equals(res1.getErrorCode())) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u56de\u6536\u5931\u8d25\uff1a" + res1.getErrorMessage()});
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u50a8\u503c\u5361\u652f\u4ed8\u884c\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase saleRecovery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        RespBase respBase = this.saleQuery(session, vo, paramsObject);
        if (0 != respBase.getRetflag()) {
            return respBase;
        }
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)respBase.getData());
        double balance = jsonObject.getDouble("balance");
        String cardStatus = jsonObject.getString("cardStatus");
        if (balance != 0.0 || !"\u6b63\u5e38".equals(cardStatus)) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u8be5\u5361\u4e0d\u53ef\u56de\u6536"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", cacheModel.getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String sjkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJKEY");
        String hs = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CZKHS");
        if (StringUtils.isBlank((String)sjkey)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u7b7e\u540dKey\u672a\u8bbe\u7f6e"});
        }
        String url = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"SJPAYURL");
        if (StringUtils.isBlank((String)url)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u652f\u4ed8\u8bf7\u6c42\u5730\u5740\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)hs) || !hs.contains(",")) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u50a8\u503c\u5361\u56de\u6536\u53c2\u6570\u672a\u6b63\u786e\u914d\u7f6e"});
        }
        String czkhs = hs.split(",")[1];
        paramsObject.put("amount", (Object)CastUtil.castDouble((Object)czkhs));
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - CastUtil.castDouble((Object)czkhs) < 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5269\u4f59\u4ed8\u6b3e\u5c0f\u4e8e\u50a8\u503c\u5361\u56de\u6536\u91d1\u989d,\u4e0d\u5141\u8bb8\u56de\u6536\u8be5\u50a8\u503c\u5361\uff01"});
        }
        PayParamDO in = this.loadPayRequestPara(cacheModel, paramsObject);
        in.setAccountType("recovery_card");
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        in.setOutTradeNo(rnd);
        JSONObject j = new JSONObject();
        j.put("payParamDO", (Object)in);
        ServiceResponse resp = this.httpUtils.doSjgw(sjkey, url, "/payment/pay", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u652f\u4ed8");
        if ("0".equals(resp.getReturncode())) {
            SjgwPayRes res1 = (SjgwPayRes)resp.getData();
            if ("0".equals(res1.getErrorCode())) {
                Payment payment = this.creatPayment(paramsObject, cacheModel, mzkPayMode, in, rnd, CastUtil.castDouble((Object)czkhs));
                if ((cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment)).getCalcResult() == -1) {
                    return new RespBase(10000, cacheModel.getErrMsg());
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u56de\u6536\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        int i = 0;
        while (i < 12) {
            ++i;
            resp = this.httpUtils.doSjgw(sjkey, url, "/payment/pay", session, j.toJSONString(), SjgwPayRes.class, "\u4e09\u6c5fCRM", "\u50a8\u503c\u5361\u652f\u4ed8");
            if ("0".equals(resp.getReturncode())) {
                SjgwPayRes res1 = (SjgwPayRes)resp.getData();
                if ("0".equals(res1.getErrorCode()) || "990002".equals(res1.getErrorCode())) {
                    Payment payment = this.creatPayment(paramsObject, cacheModel, mzkPayMode, in, rnd, CastUtil.castDouble((Object)czkhs));
                    if ((cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment)).getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo);
                }
                if ("990001".equals(res1.getErrorCode())) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u56de\u6536\u5931\u8d25\uff1a" + res1.getErrorMessage()});
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u50a8\u503c\u5361\u56de\u6536\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    private AckParamDO loadMzkRequestPara(JSONObject paramsObject) {
        AckParamDO in = new AckParamDO();
        in.setAccountType(paramsObject.getString("accountType"));
        in.setAccountId(paramsObject.getString("accountId"));
        Attributes attributes = new Attributes();
        attributes.setPosId(paramsObject.getString("terminalNo"));
        attributes.setStoreId(paramsObject.getString("shopCode"));
        attributes.setOperatorId(paramsObject.getString("terminalOperator"));
        in.setAttributes(JSON.toJSONString((Object)attributes));
        return in;
    }

    private AckParamDO loadQueryRequestPara(CacheModel cacheModel, JSONObject paramsObject) {
        AckParamDO in = new AckParamDO();
        in.setAccountType(paramsObject.getString("accountType"));
        in.setAccountId(paramsObject.getString("accountId"));
        Attributes attributes = new Attributes();
        attributes.setPosId(paramsObject.getString("terminalNo"));
        attributes.setStoreId(paramsObject.getString("shopCode"));
        attributes.setOperatorId(paramsObject.getString("terminalOperator"));
        if (null != cacheModel) {
            attributes.setOrigTradeNo(cacheModel.getFlowNo());
        }
        in.setAttributes(JSON.toJSONString((Object)attributes));
        return in;
    }

    private PayParamDO loadPayRequestPara(CacheModel cacheModel, JSONObject paramsObject) {
        PayParamDO in = new PayParamDO();
        in.setAccountType(paramsObject.getString("accountType"));
        in.setDeductAccount(paramsObject.getString("deductAccount"));
        in.setAmount((int)ManipulatePrecision.mul((double)paramsObject.getDouble("amount"), (double)100.0));
        Attributes attributes = new Attributes();
        attributes.setPosId(paramsObject.getString("terminalNo"));
        attributes.setStoreId(paramsObject.getString("shopCode"));
        attributes.setOperatorId(paramsObject.getString("terminalOperator"));
        if ("member_card".equals(in.getAccountType())) {
            attributes.setOrigTradeNo(cacheModel.getFlowNo());
        } else {
            attributes.setOrderFlowId(cacheModel.getFlowNo());
            if (null != paramsObject.getString("orderFlowId")) {
                attributes.setOrderFlowId(paramsObject.getString("orderFlowId"));
            }
        }
        in.setAttributes(JSON.toJSONString((Object)attributes));
        return in;
    }

    private PayCancelParamDO loadCancelRequestPara(Payment payment) {
        PayCancelParamDO in = new PayCancelParamDO();
        in.setAccountType(payment.getAuthCode());
        in.setDeductAccount(payment.getPayNo());
        in.setOutTradeNo(payment.getRefCode());
        return in;
    }

    public boolean checkPayCode(ServiceSession session, JSONObject json, String erpCode) {
        try {
            CheckPayCodeOut out;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            CheckPayCodeIn in = new CheckPayCodeIn();
            in.setBusiTakeMarketCode(json.getString("shopCode"));
            in.setErpCode(erpCode);
            in.setPayNo(json.getString("idSheetNo"));
            try {
                String searchDate = dateFormat.format(new Date());
                String data = DateHelpUtil.getYestoryDate((String)searchDate);
                Date whenDate = TypeUtils.castToDate((Object)data);
                in.setStartDateTime(whenDate);
                String afterHour = DateHelpUtil.getAfterHourByHour((int)9);
                Date afterDate = TypeUtils.castToDate((Object)afterHour);
                in.setEndDateTime(afterDate);
            }
            catch (Exception searchDate) {
                // empty catch block
            }
            HashMap<String, CheckPayCodeIn> map = new HashMap<String, CheckPayCodeIn>();
            map.put("data", in);
            ServiceResponse response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, this.CHECKPAYCODE, session, JSON.toJSONString(map), CheckPayCodeOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6821\u9a8c\u5546\u6237\u8ba2\u5355\u53f7");
            if ("0".equals(response.getReturncode()) && !(out = (CheckPayCodeOut)response.getData()).getExist().booleanValue()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void checkPayName(String redisObj, JSONObject paramsObject, Payment payment, String pmCode) {
        log.info((Object)("pmCode:" + pmCode + ";"));
        JSONObject jsonObject = JSONObject.parseObject((String)redisObj);
        for (int k = 0; k < jsonObject.getJSONArray("paymentmethodposref").size(); ++k) {
            JSONObject paymentmethodposref = jsonObject.getJSONArray("paymentmethodposref").getJSONObject(k);
            if (!paramsObject.getString("payCode").equalsIgnoreCase(paymentmethodposref.getString("payCode")) || !pmCode.equals(paymentmethodposref.getString("pmCode"))) continue;
            payment.setPayCode(paymentmethodposref.getString("posAbleCode"));
            payment.setPayName(paymentmethodposref.getString("posAbleName"));
            return;
        }
    }
}

