/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.request.PaymentIn;
import com.efuture.business.model.allVpay.request.CheckPayCodeIn;
import com.efuture.business.model.allVpay.response.CheckPayCodeOut;
import com.efuture.business.model.xhd.TgCouponOut;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.TgCouponSaleBS;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.Http;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.common.utils.MD5Util;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class TgCouponSaleServiceIml
implements TgCouponSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(TgCouponSaleServiceIml.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    protected String CHECKPAYCODE = "order.online.check.payCode";
    protected RestTemplate restTemplate;

    @Override
    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("payNo"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5238\u53f7/\u624b\u673a\u53f7]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("authCode"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u9a8c\u8bc1\u7801/\u8eab\u4efd\u8bc1\u540e\u56db\u4f4d]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("type"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5238\u7c7b\u578b]"});
        }
        HashMap<String, String> header = new HashMap<String, String>();
        Object apiurl = this.convertHeader(jsonObject, header);
        if (StringUtils.isEmpty((String)apiurl)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38:\u8bf7\u786e\u8ba4TGQPZ\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u914d\u7f6e\u5b8c\u6210!"});
        }
        PaymentIn payin = (PaymentIn)JSON.parseObject((String)jsonObject.toJSONString(), PaymentIn.class);
        String type = jsonObject.getString("type");
        JSONObject json = new JSONObject();
        if ("1".equals(type)) {
            json.put("TGDH", (Object)payin.getPayNo());
            json.put("CHECKNO", (Object)payin.getAuthCode());
            apiurl = (String)apiurl + "/api/Tgitem/GetTGDH";
        } else {
            json.put("phone", (Object)payin.getPayNo());
            json.put("CardNo", (Object)payin.getAuthCode());
            apiurl = (String)apiurl + "/api/CardItem/GetCardDH";
            for (Payment p : vo.getCacheModel().getPayments()) {
                if (!StringUtils.isNotEmpty((String)p.getAuthCode()) || !p.getAuthCode().equals(payin.getPayNo() + "_" + payin.getAuthCode())) continue;
                return Code.CODE_50025.getRespBase(new Object[]{"\u624b\u673a\u53f7\u548c\u8eab\u4efd\u8bc1\u5c3e\u53f7\u91cd\u590d"});
            }
        }
        json.put("SHOPID", (Object)vo.getCacheModel().getOrder().getShopCode());
        json.put("CHECKER", (Object)vo.getCacheModel().getOrder().getTerminalOperator());
        json.put("IPAddress", (Object)vo.getCacheModel().getSyjmain().getSyjip());
        json.put("SNBILLNO", (Object)vo.getCacheModel().getOrder().getTerminalSno());
        Http http = new Http();
        logger.info("\u8bf7\u6c42url\u4e3a:{},\u5165\u53c2\u4e3a{}", apiurl, (Object)json.toJSONString());
        String returnStr = this.httpPostData((String)apiurl, json.toJSONString(), 60000, false, header);
        logger.info("\u83b7\u53d6\u5238\u53f7\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)returnStr));
        if (StringUtils.isNotEmpty((String)returnStr)) {
            TgCouponOut tgCouponOut = (TgCouponOut)JSONObject.parseObject((String)returnStr, TgCouponOut.class);
            if (tgCouponOut.isStatus() && "0".equals(tgCouponOut.getCode())) {
                JSONObject returnJson = new JSONObject();
                if ("1".equals(type)) {
                    if (tgCouponOut.getData().getSALEBZ() != 1) {
                        String msg = "";
                        switch (tgCouponOut.getData().getSALEBZ()) {
                            case 0: {
                                msg = "\u672a\u5f00\u901a";
                                break;
                            }
                            case 2: {
                                msg = "\u5df2\u6d88\u8d39";
                                break;
                            }
                            case 3: {
                                msg = "\u672a\u542f\u7528";
                            }
                        }
                        return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38:\u56e2\u8d2d\u5238" + msg});
                    }
                    returnJson.put("couponNo", (Object)tgCouponOut.getData().getTGDH());
                    returnJson.put("faceValue", (Object)tgCouponOut.getData().getQMZ());
                } else {
                    returnJson.put("couponNo", (Object)tgCouponOut.getData().getPHONE());
                    returnJson.put("balance", (Object)tgCouponOut.getData().getJE());
                }
                returnJson.put("company", (Object)"");
                if (StringUtils.isNotEmpty((String)tgCouponOut.getData().getCOMPANY())) {
                    returnJson.put("company", (Object)tgCouponOut.getData().getCOMPANY());
                }
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)vo.getCacheModel(), (JSONObject)returnJson);
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38:" + tgCouponOut.getMsg()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38"});
    }

    protected String convertHeader(JSONObject jsonObject, HashMap<String, String> header) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String TGQPZ = ModeDetailsVo.getSysParaValue((List)syspara, (String)"TGQPZ");
        if (StringUtils.isEmpty((String)TGQPZ) || TGQPZ.split(",").length != 3) {
            return "";
        }
        String[] TGQPZs = TGQPZ.split(",");
        String apiurl = TGQPZs[0];
        String ApiKey = TGQPZs[1];
        String SignStr = TGQPZs[2];
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        header.put("X-Api-Key", ApiKey);
        header.put("timestamp", timestamp);
        header.put("sign", new MD5Util().md5(SignStr + timestamp + ApiKey));
        return apiurl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        double remainValue;
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (StringUtils.isEmpty((String)jsonObject.getString("payNo"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5238\u53f7/\u624b\u673a\u53f7]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("authCode"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u9a8c\u8bc1\u7801/\u8eab\u4efd\u8bc1\u540e\u56db\u4f4d]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("type"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5238\u7c7b\u578b]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("orderNo"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5916\u90e8\u8ba2\u5355\u53f7]"});
        }
        HashMap<String, String> header = new HashMap<String, String>();
        Object apiurl = this.convertHeader(jsonObject, header);
        if (StringUtils.isEmpty((String)apiurl)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u652f\u4ed8\u5f02\u5e38:\u8bf7\u786e\u8ba4TGQPZ\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u914d\u7f6e\u5b8c\u6210!"});
        }
        PaymentIn payin = (PaymentIn)JSON.parseObject((String)jsonObject.toJSONString(), PaymentIn.class);
        PaymentMode model = null;
        String obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        if (obj != null) {
            JSONObject jsonObj = JSONObject.parseObject((String)obj);
            model = PayModeUtils.getPayMode((String)payin.getPayCode(), (JSONObject)jsonObj);
            payin.setIsAllowCharge(model.getIszl());
            payin.setIsOverage(model.getIsyy());
            payin.setCutMode(model.getSswrfs());
            payin.setPrecision(String.valueOf(model.getSswrjd()));
            payin.setPayName(model.getName());
            payin.setPayType(model.getPaytype());
            payin.setRate(1.0);
            payin.setCutMode(model.getSswrfs());
            payin.setPrecision(String.valueOf(model.getSswrjd()));
        }
        if ((remainValue = (cacheModel = this.posLogicCompoment.calcBalance(cacheModel)).getOrder().getRemainValue()) <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        if (remainValue - payin.getAmount() < 0.0 && "N".equals(payin.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        Payment payment = PaymentIn.creatPayment((PaymentIn)payin, (CacheModel)cacheModel);
        payment.setRefCode(jsonObject.getString("orderNo"));
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u6d88\u8d39\u5931\u8d25:" + cacheModel.getErrMsg()});
        }
        JSONObject json = new JSONObject();
        String type = jsonObject.getString("type");
        if ("1".equals(type)) {
            apiurl = (String)apiurl + "/api/Tgitem/CHECKTGDH";
            json.put("TGDH", (Object)payin.getPayNo());
            json.put("CHECKNO", (Object)payin.getAuthCode());
        } else {
            apiurl = (String)apiurl + "/api/CardItem/CheckCardDH";
            json.put("phone", (Object)payin.getPayNo());
            json.put("CardNo", (Object)payin.getAuthCode());
            json.put("SALEJE", (Object)payment.getMoney());
            for (Payment p : vo.getCacheModel().getPayments()) {
                if (!StringUtils.isNotEmpty((String)p.getAuthCode()) || !p.getAuthCode().equals(payin.getPayNo() + "_" + payin.getAuthCode())) continue;
                return Code.CODE_50025.getRespBase(new Object[]{"\u624b\u673a\u53f7\u548c\u8eab\u4efd\u8bc1\u5c3e\u53f7\u91cd\u590d"});
            }
        }
        json.put("SHOPID", (Object)vo.getCacheModel().getOrder().getShopCode());
        json.put("CHECKER", (Object)vo.getCacheModel().getOrder().getTerminalOperator());
        json.put("IPAddress", (Object)vo.getCacheModel().getSyjmain().getSyjip());
        json.put("SNBILLNO", (Object)jsonObject.getString("orderNo"));
        Http http = new Http();
        logger.info("\u8bf7\u6c42url\u4e3a:{},\u5165\u53c2\u4e3a{}", apiurl, (Object)json.toJSONString());
        String returnStr = this.httpPostData((String)apiurl, json.toJSONString(), 60000, false, header);
        logger.info("\u6838\u9500\u5238\u53f7\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)returnStr));
        if (!StringUtils.isNotEmpty((String)returnStr)) return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38"});
        TgCouponOut tgCouponOut = (TgCouponOut)JSONObject.parseObject((String)returnStr, TgCouponOut.class);
        if (!tgCouponOut.isStatus() || !"0".equals(tgCouponOut.getCode())) return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38:" + tgCouponOut.getMsg()});
        JSONObject returnJson = new JSONObject();
        if ("1".equals(type)) {
            payment.setCusName(tgCouponOut.getData().getCUSTOMERNO());
            payment.setAuthCode("");
            payment.setMoney(tgCouponOut.getData().getQMZ());
            payment.setAmount(tgCouponOut.getData().getQMZ());
        } else {
            payment.setCouponBalance(tgCouponOut.getData().getCSYJE());
            payment.setPayNo(tgCouponOut.getData().getSALEBILLNO());
            payment.setAuthCode(tgCouponOut.getData().getPHONE() + "_" + payin.getAuthCode());
            payment.setMoney(tgCouponOut.getData().getSALEJE());
            payment.setAmount(tgCouponOut.getData().getSALEJE());
        }
        payment.setCashCost(tgCouponOut.getData().getQZJE());
        payment.setIsDirectDel(false);
        cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    @Override
    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("puid"))) {
            return Code.CODE_64.getRespBase(new Object[]{"\u64a4\u9500\u652f\u4ed8puid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("type"))) {
            return Code.CODE_64.getRespBase(new Object[]{"\u64a4\u9500\u652f\u4ed8\u5238\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(jsonObject.getString("puid"))) continue;
            preDeletePayment = p;
            break;
        }
        if (null == preDeletePayment) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!"});
        }
        HashMap<String, String> header = new HashMap<String, String>();
        Object apiurl = this.convertHeader(jsonObject, header);
        if (StringUtils.isEmpty((String)apiurl)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u64a4\u9500\u5f02\u5e38:\u8bf7\u786e\u8ba4TGQPZ\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u914d\u7f6e\u5b8c\u6210!"});
        }
        String type = jsonObject.getString("type");
        JSONObject json = new JSONObject();
        if ("1".equals(type)) {
            apiurl = (String)apiurl + "/api/Tgitem/RECALLTGDH";
            json.put("TGDH", (Object)preDeletePayment.getPayNo());
        } else {
            apiurl = (String)apiurl + "/api/CardItem/RECALLCardDH";
            json.put("phone", (Object)preDeletePayment.getAuthCode().split("_")[0]);
            json.put("SALEJE", (Object)(-preDeletePayment.getAmount()));
            json.put("CBILLNO", (Object)preDeletePayment.getPayNo());
        }
        json.put("SHOPID", (Object)vo.getCacheModel().getOrder().getShopCode());
        json.put("CHECKER", (Object)vo.getCacheModel().getOrder().getTerminalOperator());
        json.put("IPAddress", (Object)vo.getCacheModel().getSyjmain().getSyjip());
        json.put("SNBILLNO", (Object)preDeletePayment.getRefCode());
        Http http = new Http();
        logger.info("\u8bf7\u6c42url\u4e3a:{},\u5165\u53c2\u4e3a{},hearder{}", new Object[]{apiurl, json.toJSONString(), header});
        String returnStr = this.httpPostData((String)apiurl, json.toJSONString(), 60000, false, header);
        logger.info("\u5238\u64a4\u9500\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)returnStr));
        if (StringUtils.isNotEmpty((String)returnStr)) {
            TgCouponOut tgCouponOut = (TgCouponOut)JSONObject.parseObject((String)returnStr, TgCouponOut.class);
            if (!tgCouponOut.isStatus() || !"0".equals(tgCouponOut.getCode())) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u64a4\u9500\u5f02\u5e38:" + tgCouponOut.getMsg()});
            }
        } else {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u64a4\u9500\u5f02\u5e38"});
        }
        cacheModel.getPayments().remove(preDeletePayment);
        PayUtil.sortPayments(cacheModel.getPayments());
        cacheModel.setPayments(cacheModel.getPayments());
        cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    @Override
    public RespBase payQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        TgCouponOut tgCouponOut;
        Payment payment2;
        double remainValue;
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (StringUtils.isEmpty((String)jsonObject.getString("payNo"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5238\u53f7]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("authCode"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u9a8c\u8bc1\u7801]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("orderNo"))) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5916\u90e8\u8ba2\u5355\u53f7]"});
        }
        HashMap<String, String> header = new HashMap<String, String>();
        Object apiurl = this.convertHeader(jsonObject, header);
        if (StringUtils.isEmpty((String)apiurl)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u652f\u4ed8\u5f02\u5e38:\u8bf7\u786e\u8ba4TGQPZ\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u914d\u7f6e\u5b8c\u6210!"});
        }
        PaymentIn payin = (PaymentIn)JSON.parseObject((String)jsonObject.toJSONString(), PaymentIn.class);
        PaymentMode model = null;
        String obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        if (obj != null) {
            JSONObject jsonObj = JSONObject.parseObject((String)obj);
            model = PayModeUtils.getPayMode((String)payin.getPayCode(), (JSONObject)jsonObj);
            payin.setIsAllowCharge(model.getIszl());
            payin.setIsOverage(model.getIsyy());
            payin.setCutMode(model.getSswrfs());
            payin.setPrecision(String.valueOf(model.getSswrjd()));
            payin.setPayName(model.getName());
            payin.setPayType(model.getPaytype());
            payin.setRate(1.0);
            payin.setCutMode(model.getSswrfs());
            payin.setPrecision(String.valueOf(model.getSswrjd()));
        }
        if ((remainValue = (cacheModel = this.posLogicCompoment.calcBalance(cacheModel)).getOrder().getRemainValue()) <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        if (remainValue - payin.getAmount() < 0.0 && "N".equals(payin.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        JSONObject orderJson = new JSONObject();
        orderJson.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
        orderJson.put("idSheetNo", (Object)payin.getPayNo());
        for (Payment payment2 : cacheModel.getPayments()) {
            if (!StringUtils.isNotBlank((String)payment2.getPayNo()) || !payment2.getPayNo().equals(payin.getPayNo())) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        boolean b = this.checkPayCode(session, orderJson, cacheModel.getOrder().getErpCode());
        if (!b) {
            return Code.CODE_50103.getRespBase(new Object[0]);
        }
        payment2 = PaymentIn.creatPayment((PaymentIn)payin, (CacheModel)cacheModel);
        payment2.setRefCode(jsonObject.getString("orderNo"));
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment2));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment2);
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u6d88\u8d39\u5931\u8d25:" + cacheModel.getErrMsg()});
        }
        JSONObject json = new JSONObject();
        apiurl = (String)apiurl + "/api/Tgitem/GetSnBillnoToTGDH";
        json.put("TGDH", (Object)payin.getPayNo());
        json.put("CHECKNO", (Object)payin.getAuthCode());
        json.put("SHOPID", (Object)vo.getCacheModel().getOrder().getShopCode());
        json.put("CHECKER", (Object)vo.getCacheModel().getOrder().getTerminalOperator());
        json.put("IPAddress", (Object)vo.getCacheModel().getSyjmain().getSyjip());
        json.put("SNBILLNO", (Object)jsonObject.getString("orderNo"));
        Http http = new Http();
        logger.info("\u8bf7\u6c42url\u4e3a:{},\u5165\u53c2\u4e3a{}", apiurl, (Object)json.toJSONString());
        String returnStr = this.httpPostData((String)apiurl, json.toJSONString(), 60000, false, header);
        logger.info("\u6838\u9500\u67e5\u8be2\u5238\u53f7\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)returnStr));
        if (StringUtils.isNotEmpty((String)returnStr)) {
            tgCouponOut = (TgCouponOut)JSONObject.parseObject((String)returnStr, TgCouponOut.class);
            if (!tgCouponOut.isStatus() || !"0".equals(tgCouponOut.getCode())) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38:" + tgCouponOut.getMsg()});
            }
        } else {
            return Code.CODE_50025.getRespBase(new Object[]{"\u56e2\u8d2d\u5238\u67e5\u8be2\u5f02\u5e38"});
        }
        JSONObject returnJson = new JSONObject();
        payment2.setCusName(tgCouponOut.getData().getCUSTOMERNO());
        payment2.setAuthCode("");
        payment2.setMoney(tgCouponOut.getData().getQMZ());
        payment2.setAmount(tgCouponOut.getData().getQMZ());
        payment2.setCashCost(tgCouponOut.getData().getQZJE());
        payment2.setIsDirectDel(false);
        cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public String httpPostData(String url, String urlvalue, int timeout, boolean isPing, HashMap<String, String> header) {
        String rev = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = "" + System.currentTimeMillis();
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)timeout);
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("X-Api-Key", header.get("X-Api-Key"));
            httppost.addHeader("timestamp", header.get("timestamp"));
            httppost.addHeader("sign", header.get("sign"));
            httppost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httppost.setEntity((HttpEntity)new StringEntity(urlvalue, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                rev = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            logger.info("[" + time + "]response=====>" + rev);
            if (isPing) {
                logger.info("[isPing] end");
                return "SUCC";
            }
            return rev;
        }
        catch (ClientProtocolException e) {
            logger.error("[{}]ClientProtocolException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (IOException e) {
            logger.error("[{}]IOException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (Exception e) {
            logger.error("[{}]Exception:{}", (Object)time, (Object)e);
            return null;
        }
    }

    public boolean checkPayCode(ServiceSession session, JSONObject json, String erpCode) {
        try {
            CheckPayCodeOut out;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            CheckPayCodeIn in = new CheckPayCodeIn();
            in.setBusiTakeMarketCode(json.getString("shopCode"));
            in.setErpCode(erpCode);
            in.setPayNo(json.getString("idSheetNo"));
            try {
                String searchDate = dateFormat.format(new Date());
                String data = DateHelpUtil.getYestoryDate((String)searchDate);
                Date whenDate = TypeUtils.castToDate((Object)data);
                in.setStartDateTime(whenDate);
                String afterHour = DateHelpUtil.getAfterHourByHour((int)9);
                Date afterDate = TypeUtils.castToDate((Object)afterHour);
                in.setEndDateTime(afterDate);
            }
            catch (Exception searchDate) {
                // empty catch block
            }
            HashMap<String, CheckPayCodeIn> map = new HashMap<String, CheckPayCodeIn>();
            map.put("data", in);
            ServiceResponse response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, this.CHECKPAYCODE, session, JSON.toJSONString(map), CheckPayCodeOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6821\u9a8c\u5546\u6237\u8ba2\u5355\u53f7");
            if ("0".equals(response.getReturncode()) && !(out = (CheckPayCodeOut)response.getData()).getExist().booleanValue()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

