/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.gzyy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.dao.PointsSaleDaoGzyy;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.model.mzk.request.SendFaceValueJFCardInDto;
import com.efuture.business.service.PointSaleBS;
import com.efuture.business.service.impl.gzyy.MzkSaleServiceImlGzyy;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.PointsSaleUtil;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceSession;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PointSaleBSImplGzyy
implements PointSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(MzkSaleServiceImlGzyy.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Resource
    protected PointsSaleDaoGzyy pointsSaleDaoGzyy;

    @Override
    public RespBase<ResqVo> pointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!SellType.ISSALE((String)vo.getCacheModel().getOrder().getOrderType())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5f53\u524d\u8ba2\u5355\u975e\u9500\u552e\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u79ef\u5206\u6d88\u8d39"});
        }
        MzkIn mzkIn = PointsSaleUtil.getMzkIn(session, paramsObject, this.redisUtil);
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        logger.info("\u79ef\u5206\u6d88\u8d39\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        if (remainValue - mzkIn.getAmount() < 0.0 && "N".equals(mzkIn.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        SendFaceValueJFCardInDto sendFaceValueJFCardInDto = new SendFaceValueJFCardInDto(mzkIn);
        sendFaceValueJFCardInDto.setVtype("A");
        int sendjf = this.pointsSaleDaoGzyy.sendjf(sendFaceValueJFCardInDto);
        if (1 != sendjf) {
            return Code.CODE_55565.getRespBase(new Object[0]);
        }
        Payment payment = PointsSaleUtil.buildPayment(mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    @Override
    public RespBase<ResqVo> refundPointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!SellType.ISBACK((String)vo.getCacheModel().getOrder().getOrderType())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5f53\u524d\u8ba2\u5355\u975e\u9000\u8d27\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u79ef\u5206\u6d88\u8d39\u9000\u8d27"});
        }
        MzkIn mzkIn = PointsSaleUtil.getMzkIn(session, paramsObject, this.redisUtil);
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        logger.info("\u79ef\u5206\u6d88\u8d39\u9000\u8d27\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        if (remainValue - mzkIn.getAmount() < 0.0 && "N".equals(mzkIn.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        SendFaceValueJFCardInDto sendFaceValueJFCardInDto = new SendFaceValueJFCardInDto(mzkIn, true);
        sendFaceValueJFCardInDto.setVtype("A");
        int sendjf = this.pointsSaleDaoGzyy.sendjf(sendFaceValueJFCardInDto);
        if (1 != sendjf) {
            return Code.CODE_55565.getRespBase(new Object[0]);
        }
        Payment payment = PointsSaleUtil.buildPayment(mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    @Override
    public RespBase<ResqVo> deletePointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (StringUtils.isEmpty((String)paramsObject.getString("puid"))) {
            return Code.CODE_64.getRespBase(new Object[]{"\u64a4\u9500\u652f\u4ed8puid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        MzkIn mzkIn = PointsSaleUtil.getMzkIn(session, paramsObject, this.redisUtil);
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Payment delpayment = null;
        List paymentList = cacheModel.getPayments();
        if ("2".equals(vo.getCacheModel().getOrder().getOrderType())) {
            paymentList = cacheModel.getReturnPayments();
        }
        for (Payment p : paymentList) {
            if (!p.getPuid().equals(paramsObject.getString("puid"))) continue;
            delpayment = p;
            break;
        }
        if (null == delpayment) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u672a\u627e\u5230\u652f\u4ed8\u884c\u4fe1\u606f"});
        }
        mzkIn.setOrderNo(delpayment.getRefCode());
        mzkIn.setAmountJF(delpayment.getAmountJF());
        mzkIn.setAmount(delpayment.getAmount());
        mzkIn.setCardNo(delpayment.getPayNo());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        logger.info("\u79ef\u5206\u6d88\u8d39\u64a4\u9500\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        boolean b = false;
        if (SellType.ISBACK((String)vo.getCacheModel().getOrder().getOrderType())) {
            b = true;
        }
        SendFaceValueJFCardInDto sendFaceValueJFCardInDto = new SendFaceValueJFCardInDto(mzkIn, b);
        sendFaceValueJFCardInDto.setVtype("B");
        int sendjf = this.pointsSaleDaoGzyy.sendjf(sendFaceValueJFCardInDto);
        if (1 != sendjf) {
            return Code.CODE_55565.getRespBase(new Object[0]);
        }
        if (!"2".equals(vo.getCacheModel().getOrder().getOrderType())) {
            cacheModel.getPayments().remove(delpayment);
            PayUtil.sortPayments(cacheModel.getPayments());
            cacheModel.setPayments(cacheModel.getPayments());
            cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
        } else {
            Payment payment = PointsSaleUtil.buildPayment(mzkIn);
            payment.setRowno(cacheModel.getPayments().size() + 1);
            logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    @Override
    public RespBase<ResqVo> availablePoint(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        return null;
    }
}

