/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.klxy.KlxyRespVo;
import com.efuture.business.javaPos.struct.request.PaymentIn;
import com.efuture.business.model.klxy.MbPointIn;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.PointSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PointSaleBSImpl_KLXY
implements PointSaleBS {
    private static final Logger log = LoggerFactory.getLogger(PointSaleBSImpl_KLXY.class);
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    private RedisUtil redisUtil;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initRemoteService;

    public RespBase pointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersId())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u652f\u4ed8\u5931\u8d25\uff1a\u8bf7\u5148\u767b\u5f55\u4f1a\u5458\uff01"});
        }
        String consumersCard = order.getConsumersData().getConsumersCard();
        PaymentIn in = (PaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), PaymentIn.class);
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode model = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        String jfxf = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JFXF");
        if (StringUtils.isBlank((String)jfxf)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b\u672a\u8bbe\u7f6e"});
        }
        double dkbl = CastUtil.castDouble((Object)jfxf.split(",")[0]);
        paramsObject.put("dkbl", (Object)dkbl);
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u652f\u4ed8\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbPointIn pointPayIn = this.loadRequestPara(order, paramsObject);
        pointPayIn.setClientTradeSn(rnd);
        pointPayIn.setMallId(mallId);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/card/credit/trade", session, JSON.toJSONString((Object)pointPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u4f1a\u5458\u79ef\u5206\u4f59\u989d\u589e\u51cf\uff08\u6d88\u8d39\uff09", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                JSONObject body = res1.getBody();
                String canRefund = body.getString("balance");
                String accountValue = body.getString("accountValue");
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(in.getPayCode());
                payment.setPayName(model.getName());
                payment.setPayType(model.getCode());
                payment.setPayNo(consumersCard);
                payment.setRefCode(rnd);
                payment.setCouponBalance(CastUtil.castDouble((Object)canRefund));
                payment.setAmount(in.getAmount());
                payment.setMoney(in.getAmount());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setPrecision(String.valueOf(model.getSswrjd()));
                payment.setPrcutMode(model.getSswrfs());
                payment.setRate(model.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                log.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                if (cacheModel.getCalcResult() == -1) {
                    return new RespBase(10000, cacheModel.getErrMsg());
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u652f\u4ed8\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u652f\u4ed8\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase<ResqVo> availablePoint(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersId())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a\u8bf7\u5148\u767b\u5f55\u4f1a\u5458\uff01"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String jfxf = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JFXF");
        if (StringUtils.isBlank((String)jfxf)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b\u672a\u8bbe\u7f6e"});
        }
        double dkbl = CastUtil.castDouble((Object)jfxf.split(",")[0]);
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u4f59\u989d\u67e5\u8be2\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        String consumersId = order.getConsumersData().getConsumersId();
        ServiceResponse resp = this.httpUtils.doKlxyGetById(mbkey, GlobalInfo.mburl, "/api/v3/card/accountBalance/query/", session, consumersId, KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u79ef\u5206\u4f59\u989d\u67e5\u8be2", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                JSONObject body = res1.getBody();
                double canRefund = body.getDouble("pointString");
                int pointMoney = (int)ManipulatePrecision.mul((double)canRefund, (double)dkbl);
                JSONObject json = new JSONObject();
                json.put("pointMoney", (Object)pointMoney);
                json.put("point", (Object)canRefund);
                json.put("dkbl", (Object)dkbl);
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)json);
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    public RespBase deletePointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        String puid = paramsObject.getString("puid");
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            break;
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        String jfxf = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JFXF");
        if (StringUtils.isBlank((String)jfxf)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b\u672a\u8bbe\u7f6e"});
        }
        double dkbl = CastUtil.castDouble((Object)jfxf.split(",")[0]);
        paramsObject.put("dkbl", (Object)dkbl);
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u79ef\u5206\u652f\u4ed8\u884c\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbPointIn pointPayIn = this.loadRequestPara(order, paramsObject, true);
        pointPayIn.setClientTradeSn(rnd);
        pointPayIn.setMallId(mallId);
        pointPayIn.setOriginClientTradeSn(PreDeletePayment.getRefCode());
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/card/credit/trade", session, JSON.toJSONString((Object)pointPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u4f1a\u5458\u79ef\u5206\u4f59\u989d\u589e\u51cf\uff08\u51b2\u6b63\uff09", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                if (PreDeletePayment != null) {
                    cacheModel.getPayments().remove(PreDeletePayment);
                    PayUtil.sortPayments(cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        return new RespBase(10000, cacheModel.getErrMsg());
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u79ef\u5206\u652f\u4ed8\u884c\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u5220\u9664\u79ef\u5206\u652f\u4ed8\u884c\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    @Override
    public RespBase<ResqVo> refundPointPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersId())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u9000\u6b3e\u5931\u8d25\uff1a\u8bf7\u5148\u767b\u5f55\u4f1a\u5458\uff01"});
        }
        String consumersCard = order.getConsumersData().getConsumersCard();
        PaymentIn in = (PaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), PaymentIn.class);
        double remainValue = (cacheModel = this.posLogicCompoment.calcBalance(cacheModel)).getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        if (remainValue - in.getAmount() < 0.0 && "N".equals(in.getIsOverage())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        PaymentMode model = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        String jfxf = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JFXF");
        if (StringUtils.isBlank((String)jfxf)) {
            return Code.CODE_1009.getRespBase(new Object[]{"\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b\u672a\u8bbe\u7f6e"});
        }
        double dkbl = CastUtil.castDouble((Object)jfxf.split(",")[0]);
        paramsObject.put("dkbl", (Object)dkbl);
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = order.getShopCode() + order.getTerminalNo() + System.currentTimeMillis();
        String token = "";
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u9000\u6b3e\u5931\u8d25\uff1atoken\u83b7\u53d6\u5931\u8d25"});
        }
        MbPointIn pointPayIn = this.loadRequestPara(order, paramsObject);
        pointPayIn.setClientTradeSn(rnd);
        pointPayIn.setMallId(mallId);
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/card/credit/trade", session, JSON.toJSONString((Object)pointPayIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u4f1a\u5458\u79ef\u5206\u4f59\u989d\u589e\u51cf\uff08\u9000\u8d27\uff09", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                JSONObject body = res1.getBody();
                String canRefund = body.getString("balance ");
                String accountValue = body.getString("accountValue");
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(in.getPayCode());
                payment.setPayName(model.getName());
                payment.setPayType(model.getCode());
                payment.setPayNo(consumersCard);
                payment.setRefCode(rnd);
                payment.setCouponBalance(CastUtil.castDouble((Object)canRefund));
                payment.setAmount(in.getAmount());
                payment.setMoney(in.getAmount());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setPrecision(String.valueOf(model.getSswrjd()));
                payment.setPrcutMode(model.getSswrfs());
                payment.setRate(model.getZlhl().doubleValue());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                log.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                if (cacheModel.getCalcResult() == -1) {
                    return new RespBase(10000, cacheModel.getErrMsg());
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u9000\u6b3e\u5931\u8d25\uff1a" + res1.getErrorMessage()});
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u9000\u6b3e\u5931\u8d25\uff1a\u8fde\u63a5\u5f02\u5e38"});
    }

    private MbPointIn loadRequestPara(Order order, JSONObject paramsObject) {
        return this.loadRequestPara(order, paramsObject, false);
    }

    private MbPointIn loadRequestPara(Order order, JSONObject paramsObject, boolean isDel) {
        MbPointIn in = new MbPointIn();
        double dkbl = paramsObject.getDouble("dkbl");
        double amount = ManipulatePrecision.div((double)paramsObject.getDouble("amount"), (double)dkbl);
        in.setCardNo(order.getConsumersData().getConsumersCard());
        if (SellType.ISBACK((String)order.getOrderType())) {
            in.setTradeType("recharge");
            in.setTradeAmount(String.valueOf(amount));
            in.setRemark("\u58a8\u535a\u4e91\u821f\u9000\u8d27\u79ef\u5206\u62b5\u73b0--\u8fd4\u8fd8");
        } else {
            in.setTradeAmount(String.valueOf(amount * -1.0));
            in.setTradeType("consume");
            in.setRemark("\u58a8\u535a\u4e91\u821f\u9500\u552e\u79ef\u5206\u62b5\u73b0--\u51cf\u5c11");
        }
        if (isDel) {
            in.setTradeType("revoke");
            in.setTradeAmount(String.valueOf(amount));
        }
        return in;
    }
}

