/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.model.xjhj.KeyCertInfo;
import com.efuture.business.util.RsaCipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);
    private static BouncyCastleProvider bouncyCastleProvider;
    private static final Object LOCK;
    private static CertificateFactory factory;

    private static CertificateFactory initFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException var1) {
            throw new RuntimeException(var1);
        }
    }

    public static String getSHA256(String str, String algorithm) {
        String encdeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encdeStr;
    }

    public static String getSHA256Com(String str) {
        MessageDigest md = null;
        String result = "";
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes("utf-8"));
            byte[] digest = md.digest();
            result = new String(org.bouncycastle.util.encoders.Base64.encode((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] getSHA256Byte(String str, String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BouncyCastleProvider getInstanceProvider() {
        if (bouncyCastleProvider == null) {
            Object var0 = LOCK;
            Object object = LOCK;
            synchronized (object) {
                if (bouncyCastleProvider == null) {
                    bouncyCastleProvider = new BouncyCastleProvider();
                }
            }
        }
        return bouncyCastleProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] enDecryptByRsa(byte[] data, Key key, int mode) throws GeneralSecurityException {
        byte[] var21;
        BouncyCastleProvider provider = CryptoUtil.getInstanceProvider();
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            Cipher cp = Cipher.getInstance("RSA/ECB/PKCS1Padding", (Provider)provider);
            cp.init(mode, key);
            int blockSize = cp.getBlockSize();
            int blocksNum = (int)Math.ceil((double)data.length / (double)blockSize);
            int calcSize = blockSize;
            Object buffer = null;
            for (int i = 0; i < blocksNum; ++i) {
                if (i == blocksNum - 1) {
                    calcSize = data.length - i * blockSize;
                }
                byte[] var22 = cp.doFinal(data, i * blockSize, calcSize);
                try {
                    outputStream.write(var22);
                    continue;
                }
                catch (IOException var19) {
                    throw new GeneralSecurityException("RSA\u52a0/\u89e3\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38", var19);
                }
            }
            var21 = outputStream.toByteArray();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var21;
    }

    public static X509Certificate base64StrToCert(String base64Cert) throws GeneralSecurityException {
        ByteArrayInputStream ex = new ByteArrayInputStream(new Base64().decode(base64Cert));
        X509Certificate cert = (X509Certificate)factory.generateCertificate(ex);
        if (cert == null) {
            throw new GeneralSecurityException("\u5c06cer\u4ecebase64\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
        }
        return cert;
    }

    public static String signWithSHA2(InputStream fisP12, String pwd, String plainText) {
        String result = "";
        KeyStore inputKeyStore = null;
        try {
            if (fisP12 == null || pwd == null || plainText == null || pwd.equals("") || plainText.equals("")) {
                return result;
            }
            inputKeyStore = KeyStore.getInstance("PKCS12");
            char[] inPassword = pwd == null ? null : pwd.toCharArray();
            inputKeyStore.load(fisP12, inPassword);
            PrivateKey privateKey = (PrivateKey)inputKeyStore.getKey("conname", inPassword);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(plainText.getBytes("utf-8"));
            byte[] digest = md.digest();
            byte[] signData = RsaCipher.enDecryptByRsa(digest, (Key)privateKey, RsaCipher.EncryptMode.ENCRYPT);
            result = new String(org.bouncycastle.util.encoders.Base64.encode((byte[])signData));
            return result;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getCert(InputStream fisP12, String pwd) {
        char[] inPassword = pwd == null ? null : pwd.toCharArray();
        try {
            KeyStore inputKeyStore = KeyStore.getInstance("PKCS12");
            inputKeyStore.load(fisP12, inPassword);
            X509Certificate x509Certificate = (X509Certificate)inputKeyStore.getCertificate("conname");
            byte[] encoded = x509Certificate.getEncoded();
            return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])encoded));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static KeyCertInfo fileStreamToKeyCertInfo(InputStream fisP12, String pwd, String keyStoreType, String alias) {
        KeyCertInfo result = null;
        try {
            KeyStore inputKeyStore = KeyStore.getInstance(keyStoreType);
            char[] inPassword = pwd == null ? null : pwd.toCharArray();
            inputKeyStore.load(fisP12, inPassword);
            PrivateKey privateKey = (PrivateKey)inputKeyStore.getKey(alias, inPassword);
            X509Certificate x509Certificate = (X509Certificate)inputKeyStore.getCertificate(alias);
            byte[] encoded = x509Certificate.getEncoded();
            String base64Cert = new String(org.bouncycastle.util.encoders.Base64.encode((byte[])encoded));
            result = new KeyCertInfo();
            result.setBase64Cert(base64Cert);
            result.setPrivateKey(privateKey);
            return result;
        }
        catch (Exception e) {
            log.error("fileStreamToKeyCertInfo:{0}", (Throwable)e);
            return result;
        }
    }

    public static String signWithSHA2(String plainText, Key privateKey) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(plainText.getBytes("utf-8"));
            byte[] digest = md.digest();
            byte[] signData = RsaCipher.enDecryptByRsa(digest, privateKey, RsaCipher.EncryptMode.ENCRYPT);
            return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])signData));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] getSHA2Digest(String plainText) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(plainText.getBytes("utf-8"));
            byte[] digest = md.digest();
            return digest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String signWithBase(byte[] digest, Key privateKey) {
        Object md = null;
        try {
            byte[] signData = RsaCipher.enDecryptByRsa(digest, privateKey, RsaCipher.EncryptMode.ENCRYPT);
            return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])signData));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static PrivateKey byte2PrivateKey(byte[] src, String algorithm) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(src);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PublicKey byte2PublicKey(byte[] src, String algorithm) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            X509EncodedKeySpec x509KeySpec2 = new X509EncodedKeySpec(src);
            PublicKey privateKey = keyFactory.generatePublic(x509KeySpec2);
            return privateKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        LOCK = new Object();
        factory = CryptoUtil.initFactory();
    }
}

