/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.wsykt.EcardPacket;
import com.efuture.business.model.wsykt.PacketInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECardClient {
    private static final Logger log = LoggerFactory.getLogger(ECardClient.class);
    public static final String TAG = "ECardClient";
    static final int DATABASE_ERROR = -100;
    static final int CARD_CANCEL_COMMAND = 0;
    static final int CARD_READNO_TO_NO_COMMAND = 1;
    static final int CARD_WITHDRAW_COMMAND = 2;
    static final int MEMBER_QUERY_COMMAND = 3;
    static final int PROMOTION_QUERY_COMMAND = 4;
    static final int PROMOTION_SUBMIT_COMMAND = 5;
    static final int TICKET_GRANT_COMMAND = 6;
    static final int TICKET_QUERY_COMMAND = 7;
    static final int VIC_QUERY_COMMAND = 8;
    static final int VIC_WITHDRAW_QUERY_COMMAND = 9;
    private final Map<String, String> cardChargeMap = new HashMap<String, String>();
    private final Map<String, String> cardNoMap = new HashMap<String, String>();
    private final Map<String, String> amtMap = new HashMap<String, String>();
    private final String charset = "GB2312";
    private InetSocketAddress address;
    private int connTimeout = 9000;
    private int sendTimeout = 9000;
    private int recvTimeout = 9000;
    private Socket socket;
    private int version = 0;
    public String storeCode = "";
    private int errorCode = 0;
    public static String errorText = "";
    private String tranId = "";
    private String chargeId = "";
    private String serverIp;
    private int port;
    private int timeOut = 9000;
    private String branCode = "";

    public ECardClient() {
        log.info("address:{},ip:{}", (Object)GlobalInfo.ytkIp, (Object)GlobalInfo.ytkPort);
        this.address = new InetSocketAddress(GlobalInfo.ytkIp, GlobalInfo.ytkPort);
        this.storeCode = this.branCode;
    }

    protected ECardClient(String ip, int port, String storeCode) {
        this.address = new InetSocketAddress(ip, port);
        this.storeCode = storeCode;
    }

    private void connect() throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.address, this.timeOut);
        this.socket.setSoTimeout(this.timeOut);
    }

    private void disconnect() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
    }

    private void sendBlock(byte[] data, int offset, int count) throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(data, offset, count);
    }

    private void recvBlock(byte[] buffer, int offset, int count) throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        while (count > 0) {
            int recv = inputStream.read(buffer, offset, count);
            if (recv < 0) {
                throw new RuntimeException("\u4e00\u5361\u901a\u8fde\u63a5\u4e2d\u65ad");
            }
            count -= recv;
            offset += recv;
        }
    }

    private void sendInteger(int data) throws IOException {
        byte[] buffer = new byte[4];
        buffer[3] = (byte)(data >>> 24);
        buffer[2] = (byte)(data >>> 16);
        buffer[1] = (byte)(data >>> 8);
        buffer[0] = (byte)data;
        this.sendBlock(buffer, 0, 4);
    }

    private int recvInteger() throws IOException {
        byte[] buffer = new byte[4];
        this.recvBlock(buffer, 0, 4);
        int n = (buffer[3] & 0xFF) << 24;
        n += (buffer[2] & 0xFF) << 16;
        n += (buffer[1] & 0xFF) << 8;
        return n += buffer[0] & 0xFF;
    }

    private void sendString(String data) throws IOException {
        byte[] buffer = data.getBytes("GB2312");
        int length = buffer.length;
        this.sendInteger(length);
        this.sendBlock(buffer, 0, length);
    }

    private String recvString() throws IOException {
        int length = this.recvInteger();
        byte[] buffer = new byte[length];
        this.recvBlock(buffer, 0, length);
        return new String(buffer, 0, length, "GB2312");
    }

    public byte[] memberQuery(byte[] memberData) throws IOException {
        try {
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(3);
            this.sendBlock(memberData, 0, memberData.length);
            this.errorCode = this.recvInteger();
            if (this.errorCode > 0) {
                PacketInfo memberPacket;
                int length = this.recvInteger();
                if (length != (memberPacket = EcardPacket.getMemberPacket()).getPacketSize()) {
                    throw new RuntimeException("\u4e00\u5361\u901a\u534f\u8bae\u9519\u8bef");
                }
                memberData = new byte[length];
                this.recvBlock(memberData, 0, length);
                byte[] byArray = memberData;
                return byArray;
            }
            errorText = this.recvString();
            throw new RuntimeException(errorText);
        }
        finally {
            this.disconnect();
        }
    }

    public byte[] vicQuery(byte[] cardIdData) throws IOException {
        log.info("\u5f00\u59cb\u4e8e\u540c\u57ce\u8fdb\u884c\u4e00\u5361\u901a\u67e5\u8be2\u5bf9\u63a5");
        Date startTime = new Date();
        try {
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(8);
            this.sendBlock(cardIdData, 0, cardIdData.length);
            this.errorCode = this.recvInteger();
            log.info("", (Object)("Vic Query return code : " + this.errorCode));
            if (this.errorCode >= 0) {
                PacketInfo vicPacket = EcardPacket.getVicPacket();
                int length = this.recvInteger();
                if (length != vicPacket.getPacketSize()) {
                    throw new RuntimeException("\u4e00\u5361\u901a\u534f\u8bae\u9519\u8bef");
                }
                byte[] vicData = new byte[length];
                this.recvBlock(vicData, 0, vicData.length);
                log.info(TAG, (Object)("startTime == " + startTime + ",Vic Query"));
                byte[] byArray = vicData;
                return byArray;
            }
            errorText = this.recvString();
            log.info(TAG, (Object)("startTime == " + startTime + ",Vic Query Error | " + errorText));
            throw new RuntimeException(errorText);
        }
        finally {
            this.disconnect();
        }
    }

    public byte[] ticketQuery(byte[] ticketData) throws IOException {
        try {
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(7);
            this.sendBlock(ticketData, 0, ticketData.length);
            this.errorCode = this.recvInteger();
            if (this.errorCode > 0) {
                PacketInfo ticketPacket = EcardPacket.getTicketPacket();
                int length = this.recvInteger();
                if (length != ticketPacket.getPacketSize()) {
                    throw new RuntimeException("\u4e00\u5361\u901a\u534f\u8bae\u9519\u8bef");
                }
                this.recvBlock(ticketData, 0, ticketData.length);
                byte[] byArray = ticketData;
                return byArray;
            }
            errorText = this.recvString();
            throw new RuntimeException(errorText);
        }
        finally {
            this.disconnect();
        }
    }

    public void cardWithdraw(int packetCount, byte[] packetData) throws IOException {
        block7: {
            log.info("\u5f00\u59cb\u4e00\u5361\u901a\u6263\u6b3e");
            Date startTime = new Date();
            try {
                this.cardChargeMap.clear();
                this.cardNoMap.clear();
                this.amtMap.clear();
                this.tranId = "";
                PacketInfo withdrawPacket = EcardPacket.getCardWithdrawPacket();
                this.connect();
                this.sendInteger(this.version);
                this.sendString(this.storeCode);
                this.sendInteger(2);
                this.sendInteger(packetCount);
                this.sendBlock(packetData, 0, packetCount * withdrawPacket.getPacketSize());
                this.tranId = this.recvString();
                this.sendInteger(1);
                this.errorCode = this.recvInteger();
                if (this.errorCode > 0) {
                    int byteCount = this.recvInteger();
                    byte[] tmp = new byte[byteCount];
                    this.recvBlock(tmp, 0, byteCount);
                    log.info("\u4e00\u5361\u901a\u6263\u6b3e\u8fd4\u56de\uff1a{}", (Object)new String(tmp));
                    int packetSize = withdrawPacket.getPacketSize();
                    int count = byteCount / packetSize;
                    for (int i = 0; i < count; ++i) {
                        String chargeId = withdrawPacket.getFieldString(tmp, i * packetSize, "ChargeId");
                        log.info(TAG, (Object)("Ecard | chargeId : " + chargeId));
                        String cardReadNo = withdrawPacket.getFieldString(tmp, i * packetSize, "CardReadNo");
                        String remainAmount = withdrawPacket.getFieldString(tmp, i * packetSize, "RemainAmount");
                        String cardNo = withdrawPacket.getFieldString(tmp, i * packetSize, "CardNo");
                        this.cardNoMap.put(cardReadNo, cardNo);
                        this.cardChargeMap.put(cardReadNo, chargeId);
                        this.amtMap.put(cardReadNo, remainAmount);
                    }
                    log.info(TAG, (Object)("startTime == " + startTime + ",CardWithdraw"));
                    break block7;
                }
                errorText = this.recvString();
                log.info("\u6838\u9500\u9519\u8bef\uff1a{}", (Object)errorText);
                log.info(TAG, (Object)("startTime == " + startTime + "CardWithdraw Error"));
                throw new RuntimeException(errorText);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(TAG, (Object)"CardWithdraw Error");
                throw new IOException(e.getMessage());
            }
            finally {
                this.disconnect();
            }
        }
    }

    public void cardCancel(String tranId) throws IOException {
        try {
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(0);
            this.sendString(tranId);
            this.errorCode = this.recvInteger();
            errorText = this.recvString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recovery(byte[] cardIdData) throws IOException {
        block4: {
            Date startTime = new Date();
            try {
                this.connect();
                PacketInfo withdrawPacket = EcardPacket.getCardWithdrawPacket();
                this.sendInteger(this.version);
                this.sendString(this.storeCode);
                this.sendInteger(2);
                this.sendInteger(1);
                this.sendBlock(cardIdData, 0, withdrawPacket.getPacketSize());
                this.tranId = this.recvString();
                this.sendInteger(1);
                this.errorCode = this.recvInteger();
                if (this.errorCode > 0) {
                    int byteCount = this.recvInteger();
                    byte[] tmp = new byte[byteCount];
                    this.recvBlock(tmp, 0, byteCount);
                    this.chargeId = withdrawPacket.getFieldString(tmp, 0, "ChargeId");
                    log.info(TAG, (Object)("startTime == " + startTime + ",Card Recovery | ChargeId : " + this.chargeId + " | tranId : " + this.tranId));
                    break block4;
                }
                errorText = this.recvString();
                log.info(TAG, (Object)"Card Recovery Error");
                throw new RuntimeException(errorText);
            }
            finally {
                this.disconnect();
            }
        }
    }

    public Map<String, String> getCardChargeMap() {
        return this.cardChargeMap;
    }

    public Map<String, String> getCardNoMap() {
        return this.cardNoMap;
    }

    public String getTranId() {
        return this.tranId;
    }

    public void setTranId(String tranId) {
        this.tranId = tranId;
    }

    public String getChargeId() {
        return this.chargeId;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    public void setRecvTimeout(int recvTimeout) {
        this.recvTimeout = recvTimeout;
    }

    public Map<String, String> getAmtMap() {
        return this.amtMap;
    }

    public static void main(String[] args) {
        String storeCode = "130001";
        String host = "168.0.1.132";
        int port = 8000;
        try {
            ECardClient client = new ECardClient(host, port, storeCode);
            PacketInfo cardIdPacket = EcardPacket.getCardIdPacket();
            cardIdPacket.setFieldString("CardNo", "000002");
            cardIdPacket.setFieldString("CardReadNo", "43222506700608295");
            byte[] cardIdData = cardIdPacket.getPacketBytes();
            PacketInfo vicPacket = EcardPacket.getVicPacket();
            byte[] vicData = client.vicQuery(cardIdData);
            System.out.println("CardType:" + vicPacket.getFieldString(vicData, 0, "CardType"));
            System.out.println("CardNo:" + vicPacket.getFieldString(vicData, 0, "CardNo"));
            System.out.println("CardReadNo:" + vicPacket.getFieldString(vicData, 0, "CardReadNo"));
            System.out.println("RemainAmount:" + vicPacket.getFieldString(vicData, 0, "RemainAmount"));
            System.out.println("KeepAmount:" + vicPacket.getFieldString(vicData, 0, "KeepAmount"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }
}

