/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Component
public class SocketClientUtil {
    private static Integer timeout;

    public static String sendCIPMessage(String message, String ip, Integer port, Integer shutdownFlag, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(ip, (int)port), timeout);
        socket.setSoTimeout(timeout);
        System.out.println(".... timeout = " + timeout);
        OutputStream ots = socket.getOutputStream();
        PrintWriter pw = new PrintWriter(ots);
        pw.write(message);
        pw.flush();
        InputStream is = socket.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String info = null;
        StringBuffer result = new StringBuffer();
        while ((info = br.readLine()) != null) {
            result.append(info);
        }
        br.close();
        isr.close();
        is.close();
        if (shutdownFlag == 1) {
            System.out.println(".... close output stream ...");
            socket.shutdownOutput();
        }
        pw.close();
        ots.close();
        socket.close();
        return result.toString();
    }

    public static String sendMessage(String message, String ip, Integer port) throws IOException {
        Socket socket = new Socket(ip, (int)port);
        int timeout = 30000;
        socket.setSoTimeout(timeout);
        System.out.println(".... timeout = " + timeout);
        OutputStream ots = socket.getOutputStream();
        PrintWriter pw = new PrintWriter(ots);
        pw.write(message);
        pw.flush();
        socket.shutdownOutput();
        InputStream is = socket.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String info = null;
        StringBuffer result = new StringBuffer();
        while ((info = br.readLine()) != null) {
            result.append(info);
        }
        br.close();
        isr.close();
        is.close();
        pw.close();
        ots.close();
        socket.close();
        return result.toString();
    }

    public static <T> T parseResponseText(String message, String[] cols, Class<T> cls) {
        try {
            T obj = cls.newInstance();
            int beginIndex = 0;
            int endIndex = 0;
            int i = 0;
            for (String s : cols) {
                Field f;
                int len;
                String field;
                String[] fieldDefArr;
                if (++i == cols.length) {
                    fieldDefArr = s.split(":");
                    if (fieldDefArr.length != 2) {
                        throw new Exception("\u5b57\u6bb5\u4e0e\u957f\u5ea6\u7684\u914d\u7f6e\u9519\u8bef");
                    }
                    field = fieldDefArr[0];
                    len = Integer.parseInt(fieldDefArr[1]);
                    endIndex = beginIndex + len;
                    f = cls.getDeclaredField(field);
                    f.setAccessible(true);
                    f.set(obj, message.substring(beginIndex));
                    break;
                }
                fieldDefArr = s.split(":");
                if (fieldDefArr.length != 2) {
                    throw new Exception("\u5b57\u6bb5\u4e0e\u957f\u5ea6\u7684\u914d\u7f6e\u9519\u8bef");
                }
                field = fieldDefArr[0];
                len = Integer.parseInt(fieldDefArr[1]);
                endIndex = beginIndex + len;
                f = cls.getDeclaredField(field);
                f.setAccessible(true);
                f.set(obj, message.substring(beginIndex, endIndex));
                beginIndex += len;
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        String msg = SocketClientUtil.sendCIPMessage("000020MI||2150998|001|0584", "172.23.2.16", 5000, 0, 15000);
        System.out.println(msg);
    }
}

