/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketShuttleDes {
    private static final Logger log = LoggerFactory.getLogger(SocketShuttleDes.class);
    private OutputStream ostream = null;
    private InputStream istr = null;

    public SocketShuttleDes(Socket sock) throws IOException {
        this.istr = sock.getInputStream();
        this.ostream = sock.getOutputStream();
    }

    public String recvData() throws Exception {
        byte[] len_b = this.recvByte(6);
        String sLen = new String(len_b, "GBK");
        int len = Integer.parseInt(sLen);
        if (len > 0) {
            byte[] data = this.recvByte(len);
            byte[] data1 = SocketShuttleDes.byteMerger(len_b, data);
            String sData = new String(data1, "GBK");
            return sData;
        }
        return "";
    }

    public String recvDataDes(String deskey) throws Exception {
        byte[] len_b = this.recvByte(6);
        String sLen = new String(len_b, "GBK");
        int len = Integer.parseInt(sLen);
        if (len > 0) {
            byte[] data = this.recvByteDes(len, deskey, sLen);
            String sData = new String(data, "GBK");
            return sData;
        }
        return "";
    }

    public void sendByte(byte[] data, int offset, int len) throws Exception {
        try {
            this.ostream.write(data, offset, len);
            this.ostream.flush();
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    private byte[] recvByte(int len) throws Exception {
        byte[] data = new byte[len];
        try {
            int n;
            for (int len_recved = 0; len_recved < data.length; len_recved += n) {
                n = this.istr.read(data, len_recved, data.length - len_recved);
            }
        }
        catch (IOException e) {
            log.info("recvByte error: " + e.getMessage());
            throw new Exception(e);
        }
        return data;
    }

    private byte[] recvByteDes(int len, String deskey, String sLen) throws Exception {
        byte[] data = new byte[len];
        try {
            int n;
            for (int len_recved = 0; len_recved < data.length; len_recved += n) {
                n = this.istr.read(data, len_recved, data.length - len_recved);
            }
        }
        catch (IOException e) {
            log.info("recvByte error: " + e.getMessage());
            throw new Exception(e);
        }
        byte[] data1 = SocketShuttleDes.decrypt(data, deskey);
        return data1;
    }

    public void close() {
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.istr != null) {
            try {
                this.istr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ostream = null;
        this.istr = null;
    }

    protected void finalize() {
        this.close();
    }

    public static String sendSocketByDes(String host, int port, Long timeOut, String param, String privateKey) {
        if (timeOut == null) {
            timeOut = 60L;
        }
        try {
            Socket clientsock = null;
            SocketShuttleDes shuttle = null;
            clientsock = new Socket(host, port);
            clientsock.setSoTimeout(timeOut.intValue() * 1000);
            shuttle = new SocketShuttleDes(clientsock);
            byte[] sendByte = param.getBytes("GBK");
            byte[] sendByte2 = SocketShuttleDes.encrypt(sendByte, privateKey);
            String lengthStr = null;
            if (sendByte2 != null) {
                lengthStr = String.valueOf(sendByte2.length);
            }
            String data1 = "000000".substring(0, 6 - lengthStr.length()) + lengthStr;
            log.info("\u8bf7\u6c42\uff1a6 \u4f4d\u5b57\u7b26\u4e32(\u8868\u793a\u52a0\u5bc6\u540e\u7684\u5b57\u8282\u6570\u7ec4\u957f\u5ea6)=" + data1);
            byte[] sendByte1 = data1.getBytes();
            byte[] sendByte3 = SocketShuttleDes.byteMerger(sendByte1, sendByte2);
            shuttle.sendByte(sendByte3, 0, sendByte3.length);
            String reData = shuttle.recvDataDes(privateKey);
            log.info("\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de(\u89e3\u5bc6\u540e):{}", (Object)reData);
            return reData;
        }
        catch (Exception ex) {
            log.info("Error: ", (Throwable)ex);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Socket clientsock = null;
            SocketShuttleDes shuttle = null;
            clientsock = new Socket("47.111.142.100", 8895);
            clientsock.setSoTimeout(60000);
            shuttle = new SocketShuttleDes(clientsock);
            String data = "000160019900088888A001 1 0002 64285 2001200520170899000005 284835195629500723 1 20170814145810 1800011234 1234 \u5343\u5e74\u91ce\u751f\u845b\u6839\u7c89 1170503 1 1000 \u888b ";
            String deskey = "1234567812345678";
            log.info("\u6d4b\u8bd5\u7684 DES \u5bc6\u94a5=" + deskey);
            log.info("\u8bf7\u6c42\uff1a\u5f85\u5904\u7406\u5b57\u7b26\u4e32=" + new String(data));
            byte[] sendByte = data.getBytes();
            log.info("\u8bf7\u6c42\uff1a\u5b57\u7b26\u4e32\u8f6c\u5f85\u52a0\u5bc6\u7684\u5b57\u8282\u6570\u7ec4=" + Arrays.toString(sendByte));
            byte[] sendByte2 = SocketShuttleDes.encrypt(sendByte, deskey);
            log.info("\u8bf7\u6c42\uff1aDES \u52a0\u5bc6\u540e\u7684\u5b57\u8282\u6570\u7ec4=" + Arrays.toString(sendByte2));
            String length_str = String.valueOf(sendByte2.length);
            log.info("\u8bf7\u6c42\uff1a\u52a0\u5bc6\u540e\u7684\u5b57\u8282\u6570\u7ec4\u7684\u957f\u5ea6=" + length_str);
            String data1 = "000000".substring(0, 6 - length_str.length()) + length_str;
            log.info("\u8bf7\u6c42\uff1a6 \u4f4d\u5b57\u7b26\u4e32(\u8868\u793a\u52a0\u5bc6\u540e\u7684\u5b57\u8282\u6570\u7ec4\u957f\u5ea6)=" + data1);
            byte[] sendByte1 = data1.getBytes();
            byte[] sendByte3 = SocketShuttleDes.byteMerger(sendByte1, sendByte2);
            log.info(" \u8bf7 \u6c42 \uff1a \u8868 \u793a \u957f \u5ea6 \u7684 6 \u4f4d \u5b57 \u7b26 \u4e32 \u8f6c \u5b57 \u8282 \u6570 \u7ec4 =" + Arrays.toString(sendByte1));
            log.info(" \u8bf7 \u6c42 \uff1a \u53d1 \u9001 \u7684 \u5185 \u5bb9 = \u8868 \u793a \u957f \u5ea6 \u7684 \u5b57 \u8282 \u6570 \u7ec4 +DES \u52a0 \u5bc6 \u540e \u7684 \u5b57 \u8282 \u6570 \u7ec4 =" + Arrays.toString(sendByte3));
            shuttle.sendByte(sendByte3, 0, sendByte3.length);
            String revData = shuttle.recvDataDes(deskey);
            log.info("\u8fd4\u56de\uff1a\u89e3\u5bc6\u540e\u5b57\u8282\u6570\u7ec4\u8f6c\u5b57\u7b26\u4e32=" + revData);
        }
        catch (Exception ex) {
            ex.getStackTrace();
            log.info("Error: " + ex.getMessage());
        }
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static byte[] encrypt(byte[] datasource, String password) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)securekey, random);
            return cipher.doFinal(datasource);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] src, String password) throws Exception {
        SecureRandom random = new SecureRandom();
        DESKeySpec desKey = new DESKeySpec(password.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)securekey, random);
        return cipher.doFinal(src);
    }
}

