/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.allVpay.request;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.model.GetPayInfoIn;
import com.efuture.business.model.GetPayReFundInfoIn;
import com.efuture.business.model.GetRepealPayInfoIn;
import com.efuture.business.model.allVpay.PayCommon;
import org.springframework.util.StringUtils;

public class RepealPayRequest
extends PayCommon {
    String messageLen = "000142";
    String exchangeCode = "05";
    String payType;
    String payShopCode;
    String terminalOperator;
    String terminalNo;
    String terminalSno;
    String idSheetNo;
    String originalIdSheetNo;
    String originalCreateTime;
    String money;
    String refundMoney;
    String createTime;

    public RepealPayRequest(GetPayInfoIn jsonObject) {
        this.setPayType(jsonObject.getPayType());
        this.setPayShopCode(jsonObject.getPayShopCode());
        this.setTerminalNo(jsonObject.getPayTerminalNo());
        this.setTerminalOperator(jsonObject.getTerminalOperator());
        this.setTerminalSno(jsonObject.getTerminalSno());
        this.setOriginalIdSheetNo(jsonObject.getOriginalIdSheetNo());
        this.setOriginalCreateTime(jsonObject.getOriginalCreateTime());
        int amount = (int)ManipulatePrecision.doubleConvert((double)(jsonObject.getMoney() * 100.0));
        this.setMoney(String.valueOf(amount));
        if ("67".equals(this.payType)) {
            this.messageLen = "000154";
        }
    }

    public RepealPayRequest(JSONObject jsonObject) {
        this.setPayType(jsonObject.getString("payType"));
        this.setPayShopCode(jsonObject.getString("payShopCode"));
        this.setTerminalNo(jsonObject.getString("payTerminalNo"));
        this.setTerminalOperator(jsonObject.getString("terminalOperator"));
        this.setTerminalSno(jsonObject.getString("terminalSno"));
        this.setOriginalIdSheetNo(jsonObject.getString("originalIdSheetNo"));
        this.setOriginalCreateTime(jsonObject.getString("originalCreateTime"));
        int amount = (int)ManipulatePrecision.doubleConvert((double)(jsonObject.getDoubleValue("money") * 100.0));
        this.setMoney(String.valueOf(amount));
        if ("67".equals(this.payType)) {
            this.messageLen = "000154";
            this.setTerminalNo(jsonObject.getString("payTerminalNo"));
            this.exchangeCode = "06";
        }
    }

    public RepealPayRequest(GetPayReFundInfoIn getPayReFundInfoIn) {
        this.setPayType(getPayReFundInfoIn.getPayType());
        this.setPayShopCode("AAAA");
        this.setTerminalNo(getPayReFundInfoIn.getPayTerminalNo());
        this.setTerminalOperator(getPayReFundInfoIn.getTerminalOperator());
        this.setTerminalSno(getPayReFundInfoIn.getTerminalSno());
        this.setOriginalIdSheetNo(getPayReFundInfoIn.getOriginalIdSheetNo());
        this.setOriginalCreateTime(getPayReFundInfoIn.getOriginalCreateTime());
        int amount = (int)ManipulatePrecision.doubleConvert((double)(getPayReFundInfoIn.getMoney() * 100.0));
        this.setMoney(String.valueOf(amount));
        if ("67".equals(this.payType)) {
            this.messageLen = "000154";
        }
    }

    public RepealPayRequest(GetRepealPayInfoIn jsonObject) {
        this.setPayType(jsonObject.getPayType());
        this.setPayShopCode("AAAA");
        this.setTerminalNo(jsonObject.getPayTerminalNo());
        this.setTerminalOperator(jsonObject.getTerminalOperator());
        this.setTerminalSno(jsonObject.getTerminalSno());
        this.setOriginalIdSheetNo(jsonObject.getOriginalIdSheetNo());
        this.setOriginalCreateTime(jsonObject.getOriginalCreateTime());
        int amount = (int)ManipulatePrecision.doubleConvert((double)(jsonObject.getMoney() * 100.0));
        this.setMoney(String.valueOf(amount));
        if ("67".equals(this.payType)) {
            this.messageLen = "000154";
        }
    }

    public String getMessageLen() {
        return this.messageLen;
    }

    public void setMessageLen(String messageLen) {
        this.messageLen = messageLen;
    }

    public String getExchangeCode() {
        return this.exchangeCode;
    }

    public void setExchangeCode(String exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPayShopCode() {
        return this.payShopCode;
    }

    public void setPayShopCode(String payShopCode) {
        this.payShopCode = payShopCode;
    }

    public String getTerminalOperator() {
        return this.terminalOperator;
    }

    public void setTerminalOperator(String terminalOperator) {
        this.terminalOperator = terminalOperator;
    }

    public String getTerminalNo() {
        return this.terminalNo;
    }

    public void setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
    }

    public String getTerminalSno() {
        return this.terminalSno;
    }

    public void setTerminalSno(String terminalSno) {
        this.terminalSno = terminalSno;
    }

    public String getRefundMoney() {
        return this.refundMoney;
    }

    public void setRefundMoney(String refundMoney) {
        this.refundMoney = refundMoney;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getIdSheetNo() {
        return this.idSheetNo;
    }

    public void setIdSheetNo(String idSheetNo) {
        this.idSheetNo = idSheetNo;
    }

    public String getOriginalIdSheetNo() {
        return this.originalIdSheetNo;
    }

    public void setOriginalIdSheetNo(String originalIdSheetNo) {
        this.originalIdSheetNo = originalIdSheetNo;
    }

    public String getOriginalCreateTime() {
        return this.originalCreateTime;
    }

    public void setOriginalCreateTime(String originalCreateTime) {
        this.originalCreateTime = originalCreateTime;
    }

    public String getMoney() {
        return this.money;
    }

    public void setMoney(String money) {
        this.money = money;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.messageLen);
        sb.append(this.exchangeCode);
        sb.append(this.payType);
        sb.append(Convert.increaseChar((String)this.payShopCode, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.terminalOperator, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.terminalNo, (char)' ', (int)15));
        sb.append(Convert.increaseChar((String)this.terminalSno, (char)' ', (int)15));
        if (!StringUtils.isEmpty((Object)this.idSheetNo) && ("67".equals(this.payType) || "C5".equals(this.payType))) {
            sb.append(Convert.increaseChar((String)this.idSheetNo, (char)' ', (int)64));
        }
        sb.append(Convert.increaseChar((String)this.originalIdSheetNo, (char)' ', (int)64));
        sb.append(Convert.increaseChar((String)this.originalCreateTime, (char)' ', (int)14));
        sb.append(Convert.increaseChar((String)this.money, (char)' ', (int)12));
        if (!StringUtils.isEmpty((Object)this.refundMoney) && ("67".equals(this.payType) || "C5".equals(this.payType))) {
            sb.append(Convert.increaseChar((String)this.refundMoney, (char)' ', (int)12));
        }
        if (!StringUtils.isEmpty((Object)this.createTime) && ("67".equals(this.payType) || "C5".equals(this.payType))) {
            sb.append(Convert.increaseChar((String)this.createTime, (char)' ', (int)14));
        }
        return sb.toString();
    }
}

