/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.model.xjhj;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtil {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtil.class);
    public static final String KEYSTORETYPE_JKS = "JKS";
    public static final String KEYSTORETYPE_PKCS12 = "PKCS12";

    public static PublicKey getPublicKey(InputStream pubKey) {
        X509Certificate x509cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509cert = (X509Certificate)cf.generateCertificate(pubKey);
        }
        catch (CertificateException e) {
            if (pubKey != null) {
                try {
                    pubKey.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38", e1);
                }
            }
            throw new RuntimeException("\u521d\u59cb\u5316\u516c\u94a5\u5f02\u5e38", e);
        }
        return x509cert.getPublicKey();
    }

    public static PrivateKey getMerchantPirvateKey(InputStream priKey, String keyPassword, String keyStoreType) {
        PrivateKey privateKey = null;
        try {
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(priKey, keyPassword.toCharArray());
            Enumeration<String> myEnum = ks.aliases();
            while (myEnum.hasMoreElements()) {
                String keyAlias = myEnum.nextElement();
                if (!ks.isKeyEntry(keyAlias)) continue;
                privateKey = (PrivateKey)ks.getKey(keyAlias, keyPassword.toCharArray());
                break;
            }
        }
        catch (Exception e) {
            if (priKey != null) {
                try {
                    priKey.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException("\u6d41\u5173\u95ed\u5f02\u5e38", e1);
                }
            }
            throw new RuntimeException("\u52a0\u8f7d\u79c1\u94a5\u5931\u8d25", e);
        }
        if (privateKey == null) {
            throw new RuntimeException("\u79c1\u94a5\u4e0d\u5b58\u5728");
        }
        return privateKey;
    }

    public static PublicKey base64StrToCert(String base64Cert) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream streamCert = new ByteArrayInputStream(new Base64().decode(base64Cert));
            X509Certificate cert = (X509Certificate)factory.generateCertificate(streamCert);
            if (cert == null) {
                throw new GeneralSecurityException("\u5c06cer\u4ecebase64\u8f6c\u6362\u4e3a\u5bf9\u8c61\u5931\u8d25");
            }
            return cert.getPublicKey();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String certToBase64(PublicKey publicKey) {
        byte[] keyBytes = publicKey.getEncoded();
        String s = new Base64().encodeToString(keyBytes);
        return s;
    }

    public static PublicKey getRsaPublicKey(String key) throws Exception {
        byte[] keyBytes = org.bouncycastle.util.encoders.Base64.decode((String)key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }
}

