/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.request.ALiMzkIn;
import com.efuture.business.javaPos.struct.request.GetAliMzkGoodsIn;
import com.efuture.business.model.Item;
import com.efuture.business.model.Transaction;
import com.efuture.business.model.mzk.request.ALiMzkPayIn;
import com.efuture.business.model.mzk.request.ALiMzkQueryIn;
import com.efuture.business.model.mzk.request.ALiMzkSaleInfoIn;
import com.efuture.business.model.mzk.request.AliMzkActiveIn;
import com.efuture.business.model.mzk.request.AliMzkGiftIn;
import com.efuture.business.model.mzk.response.ALiMzkBatchCancerOut;
import com.efuture.business.model.mzk.response.ALiMzkQueryOut;
import com.efuture.business.model.mzk.response.ALiMzkResult;
import com.efuture.business.model.mzk.response.ALiMzkSaleInfoOut;
import com.efuture.business.model.mzk.response.AliMzkActiveOut;
import com.efuture.business.model.mzk.response.AliMzkGiftOut;
import com.efuture.business.service.ALiMzkSaleBS;
import com.efuture.business.service.ALiMzkService;
import com.efuture.business.service.GoodsRemoteService;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ALiMzkSaleBSImpl
implements ALiMzkSaleBS {
    private static final Logger log = LoggerFactory.getLogger(ALiMzkSaleBSImpl.class);
    protected static Logger logger = LoggerFactory.getLogger(ALiMzkSaleBSImpl.class);
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    private ALiMzkService aLiMzkService;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    public PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiGoodsRemoteService.do")
    protected GoodsRemoteService goodsRemoteService;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    public GoodsTransfer goodsTransfer;

    public RespBase getCardInfoByMagTrack(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cardNo"});
        }
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        ALiMzkQueryIn mzkreq = new ALiMzkQueryIn(in);
        ServiceResponse resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "\u5237\u5361\u4fe1\u606f\u67e5\u8be2", "getCardInfoByMagTrack");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult out = (ALiMzkResult)resp.getData();
            if (out.isSuccess()) {
                ALiMzkQueryOut aLiMzkQueryOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)out.getData(), ALiMzkQueryOut.class);
                JSONObject json = new JSONObject();
                json.put("money", (Object)aLiMzkQueryOut.getBalance());
                return new RespBase(Code.SUCCESS, (Object)json);
            }
            return Code.CODE_50070.getRespBase(new Object[]{out.getMessage()});
        }
        return Code.CODE_50070.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
    }

    public RespBase getAliMzkSaleInfo(ServiceSession session, ResqVo vo) {
        try {
            JSONObject paramsObject = vo.getJsonObject();
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_20103.getRespBase(new Object[0]);
            }
            if (!"U".equals(cacheModel.getOrder().getOrderType())) {
                return Code.CODE_20001.getRespBase(new Object[0]);
            }
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return Code.CODE_20000.getRespBase(new Object[0]);
            }
            GetAliMzkGoodsIn in = (GetAliMzkGoodsIn)JSONObject.toJavaObject((JSON)vo.getJsonObject(), GetAliMzkGoodsIn.class);
            ALiMzkSaleInfoIn mzkreq = new ALiMzkSaleInfoIn(in);
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!in.getTrack().equals(sg.getTrack())) continue;
                return Code.CODE_50073.getRespBase(new Object[]{"\u5361\u53f7\u91cd\u590d"});
            }
            ServiceResponse resp = this.aLiMzkService.queryMzkSaleInfo(session, JSON.toJSONString((Object)mzkreq), "\u552e\u5361\u4fe1\u606f\u67e5\u8be2", "getSellCardByMagTrack");
            if (!"0".equals(resp.getReturncode())) {
                return Code.CODE_50070.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
            }
            ALiMzkSaleInfoOut out = (ALiMzkSaleInfoOut)resp.getData();
            if (null == out || !out.isSuccess() || null == out.getData() || null == out.getData().getItemCode()) {
                if (StringUtils.isNotBlank((String)out.getMessage())) {
                    return Code.CODE_50070.getRespBase(new Object[]{out.getMessage()});
                }
                return Code.CODE_50070.getRespBase(new Object[]{"\u67e5\u8be2\u5931\u8d25"});
            }
            Goods goods = new Goods();
            GoodsInfo goodsInfo = null;
            GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
            List goodsInfos = null;
            boolean isdzcm = false;
            boolean isNeedFindMdm = true;
            Object dzc = null;
            boolean isNeedFindDzc = true;
            int disMode = 0;
            double disValue = 0.0;
            String serchType = "1";
            getGoodsDetailIn.setEntId(session.getEnt_id());
            getGoodsDetailIn.setShopCode(paramsObject.getString("shopCode"));
            getGoodsDetailIn.setTerminalNo(paramsObject.getString("terminalNo"));
            getGoodsDetailIn.setCode(out.getData().getItemCode());
            getGoodsDetailIn.setSearchType(serchType);
            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
            RespBase result = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSONObject.toJSON((Object)getGoodsDetailIn));
            if (0 != result.getRetflag()) {
                return Code.CODE_30070.getRespBase(new Object[]{"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25"});
            }
            JSONObject gifJson = (JSONObject)result.getData();
            GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)JSONObject.toJavaObject((JSON)gifJson, GetGoodsDetailOut.class);
            if (null == goodsDetailOut || null == goodsDetailOut.getGoods()) {
                return Code.CODE_20087.getRespBase(new Object[0]);
            }
            goodsInfos = goodsDetailOut.getGoods();
            if (null == goodsInfos || goodsInfos.size() == 0) {
                return Code.CODE_20087.getRespBase(new Object[0]);
            }
            goodsInfo = (GoodsInfo)goodsInfos.get(0);
            goodsInfo.fixGoodsInfoStr();
            goodsInfo.setSalePrice(ManipulatePrecision.doubleConvert((double)out.getData().getCardValue()));
            if (in.getGiftMoney() > 0.0) {
                goodsInfo.setSalePrice(in.getGiftMoney());
            }
            this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goods.setEscaleFlag("N");
            goodsInfo.setEscaleFlag(0);
            goods.setFlag("0");
            String guid = UUIDUtils.buildGuid();
            goods.setGuid(guid);
            goods.setFlowNo(cacheModel.getFlowNo());
            goods.setGoodsNo(out.getData().getItemCode());
            goods.setGoodsName(out.getData().getItemName());
            goods.setRemark(out.getData().getCardNumber());
            goods.setMemo(out.getData().getCardKindId() + "," + out.getData().getCardKindName() + "," + out.getData().getCardTypeId() + "," + out.getData().getCardTypeName());
            goods.setTrack(in.getTrack());
            goods.setFlowId(cacheModel.getGoodsList().size() + 1);
            if (in.getGiftMoney() > 0.0) {
                goods.setFixedDiscountValue(goods.getSaleValue());
            }
            goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            cacheModel.getGoodsList().add(goods);
            cacheModel.getOrder().setSaleDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            BaseOutModel orderOut = new BaseOutModel();
            orderOut.setOrder(this.orderTransfer.toOrderForPos(vo.getCacheModel()));
            vo.setJsonObject((JSONObject)JSON.toJSON((Object)orderOut));
            return new RespBase(Code.SUCCESS, (Object)vo, "GETALIMZKGOODS");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return Code.CODE_20029.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase<CacheModel> aliActive(ServiceSession session, ResqVo vo) {
        try {
            CacheModel cacheModel = vo.getCacheModel();
            AliMzkActiveIn in = new AliMzkActiveIn(cacheModel);
            ServiceResponse resp = this.aLiMzkService.active(session, JSON.toJSONString((Object)in), "\u552e\u5361\u6fc0\u6d3b", "cardSell");
            if (!"0".equals(resp.getReturncode())) {
                for (int i = 0; i < 3; ++i) {
                    resp = this.aLiMzkService.cancelactive(session, JSON.toJSONString((Object)in), "\u552e\u5361\u6fc0\u6d3b\u64a4\u9500", "cardSellCancel");
                    if (null == resp) {
                        Thread.sleep(3000L);
                        continue;
                    }
                    AliMzkActiveOut out = (AliMzkActiveOut)resp.getData();
                    if (null != out && out.isSuccess() && out.isData()) break;
                    Thread.sleep(3000L);
                }
                return Code.CODE_50098.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
            }
            AliMzkActiveOut out = (AliMzkActiveOut)resp.getData();
            if (null == out || !out.isSuccess() || !out.isData()) {
                return Code.CODE_50098.getRespBase(new Object[]{"\u5931\u8d25"});
            }
            cacheModel.getOrder().setMemberActionSno(in.getPayUserSerial());
            return new RespBase(Code.SUCCESS, (Object)cacheModel);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return Code.CODE_60031.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase getAliGift(ServiceSession session, ResqVo vo) {
        try {
            CacheModel cacheModel = vo.getCacheModel();
            AliMzkGiftIn in = new AliMzkGiftIn(cacheModel);
            ServiceResponse resp = this.aLiMzkService.getGift(session, JSON.toJSONString((Object)in), "\u8ba1\u7b97\u8fd4\u5229", "calculateRebateAmount");
            JSONObject json = new JSONObject();
            if (!"0".equals(resp.getReturncode())) {
                json.put("money", (Object)0);
            }
            AliMzkGiftOut out = (AliMzkGiftOut)resp.getData();
            double giftMoney = 0.0;
            if (null == out || !out.isSuccess() || out.getData() <= 0.0) {
                giftMoney = 0.0;
            }
            giftMoney = CastUtil.castDouble((Object)out.getData());
            return new RespBase(Code.SUCCESS, (Object)giftMoney);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            JSONObject json = new JSONObject();
            json.put("money", (Object)0);
            return new RespBase(Code.SUCCESS, (Object)json);
        }
    }

    public RespBase queryConsumerCard(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ServiceResponse resp;
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        ALiMzkQueryIn mzkreq = new ALiMzkQueryIn(in);
        if (StringUtils.isBlank((String)paramsObject.getString("flowNo"))) {
            resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "\u5237\u5361\u4fe1\u606f\u67e5\u8be2", "getCardInfoByMagTrack");
        } else {
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
            }
            List goodsList = cacheModel.getGoodsList();
            if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "\u9000\u6b3e\u5361\u4fe1\u606f\u67e5\u8be2", "getRetreatCardByMagTrack");
            } else {
                for (Goods g : goodsList) {
                    Item i = new Item();
                    i.setItemCode(g.getGoodsCode());
                    i.setItemName(g.getGoodsName());
                    mzkreq.getItemList().add(i);
                }
                resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "\u6d88\u8d39\u5361\u4fe1\u606f\u67e5\u8be2", "getConsumeCardByMagTrack");
            }
        }
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult out = (ALiMzkResult)resp.getData();
            if (out.isSuccess()) {
                ALiMzkQueryOut aLiMzkQueryOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)out.getData(), ALiMzkQueryOut.class);
                JSONObject json = new JSONObject();
                json.put("money", (Object)aLiMzkQueryOut.getBalance());
                return new RespBase(Code.SUCCESS, (Object)json);
            }
            return Code.CODE_50070.getRespBase(new Object[]{out.getMessage()});
        }
        return Code.CODE_50070.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
    }

    public RespBase cardConsume(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        logger.info("\u963f\u91cc\u50a8\u503c\u5361\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        in = this.loadRequestPara(in, syjMain, mzkPayMode);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        logger.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + JSON.toJSONString((Object)in));
        if (remainValue - in.getAmount() < 0.0 && "N".equals(in.getIsOverage())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        ALiMzkPayIn mzkreq = new ALiMzkPayIn(in);
        mzkreq.setReceiptNumber(cacheModel.getOrder().getTerminalSno());
        mzkreq.setStoreName(cacheModel.getOrder().getShopName());
        ServiceResponse resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39", "cardConsume");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult res = (ALiMzkResult)resp.getData();
            if (res.isSuccess()) {
                ALiMzkQueryOut payOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)res.getData(), ALiMzkQueryOut.class);
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setRefCode(mzkreq.getPayUserSerial());
                payment.setPayCode(in.getPayCode());
                payment.setPayName(in.getPayName());
                payment.setPayType(in.getPayType());
                payment.setPayNo(payOut.getCardNumber());
                payment.setPasswd(in.getPasswd());
                payment.setCouponBalance(payOut.getBalance());
                payment.setAmount(in.getAmount());
                payment.setMoney(in.getAmount());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setTerminalSno(mzkreq.getReceiptNumber());
                payment.setCustmnerName(payOut.getMemberName());
                payment.setPrecision(in.getPrecision());
                payment.setPrcutMode(in.getCutMode());
                payment.setRate(in.getRate());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setIsAllowCharge(in.getIsAllowCharge());
                payment.setIsOverage(in.getIsOverage());
                logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return Code.CODE_50071.getRespBase(new Object[]{res.getMessage()});
        }
        for (int i = 0; i < 3; ++i) {
            ALiMzkResult res;
            resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u51b2\u6b63", "cardConsumeReversal");
            if ("0".equals(resp.getReturncode()) && (res = (ALiMzkResult)resp.getData()).isSuccess()) {
                return Code.CODE_50071.getRespBase(new Object[]{"\u672c\u6b21\u50a8\u503c\u5361\u4ea4\u6613\u8d85\u65f6\u5931\u8d25"});
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return Code.CODE_50071.getRespBase(new Object[]{"\u8d85\u65f6\u5931\u8d25\uff0c\u653e\u5f03\u672c\u8f6e\u51b2\u6b63\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u4eba\u5de5\u5e72\u9884\u5904\u7406"});
    }

    public RespBase cardConsumeCancel(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        in = this.loadRequestPara(in, syjMain, mzkPayMode);
        String puid = in.getPuid();
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            preDeletePayment = p;
            break;
        }
        if (null == preDeletePayment) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5931\u8d25\uff1a\u83b7\u53d6\u652f\u4ed8\u884c\u5931\u8d25");
        }
        ALiMzkPayIn mzkreq = new ALiMzkPayIn(in);
        mzkreq.setReceiptNumber(cacheModel.getOrder().getTerminalSno());
        mzkreq.setStoreName(cacheModel.getOrder().getShopName());
        mzkreq.setRelatedPayUserSerial(preDeletePayment.getRefCode());
        ServiceResponse resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u64a4\u9500\uff08\u5355\u4e2a\uff09", "cardConsumeCancel");
        BaseOutModel out = new BaseOutModel();
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult res = (ALiMzkResult)resp.getData();
            if (res.isSuccess()) {
                if (preDeletePayment != null) {
                    cacheModel.getPayments().remove(preDeletePayment);
                    PayUtil.sortPayments((List)cacheModel.getPayments());
                    cacheModel.setPayments(cacheModel.getPayments());
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo);
                    }
                }
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5931\u8d25\uff1a" + res.getMessage());
        }
        return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    public RespBase batchCardConsumeCancel(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        in = this.loadRequestPara(in, syjMain, mzkPayMode);
        ALiMzkPayIn mzkreq = new ALiMzkPayIn(in);
        ArrayList<Transaction> list = new ArrayList<Transaction>();
        for (Payment p : cacheModel.getReturnPayments()) {
            if (!p.getPayCode().equals(in.getPayCode())) continue;
            Transaction t = new Transaction();
            t.setCardNumber(p.getPayNo());
            t.setConsumeAmount(p.getAmount());
            t.setRelatedPayUserSerial(p.getRefCode());
            list.add(t);
        }
        mzkreq.setTransactionList(list);
        mzkreq.setReceiptNumber(cacheModel.getOrder().getTerminalSno());
        mzkreq.setStoreName(cacheModel.getOrder().getShopName());
        ServiceResponse resp = this.aLiMzkService.executeBatch(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u64a4\u9500\uff08\u6279\u91cf\uff09", "batchCardConsumeCancel");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkBatchCancerOut res = (ALiMzkBatchCancerOut)resp.getData();
            if (res.isSuccess()) {
                for (int i = 0; i < res.getData().size(); ++i) {
                    JSONObject jsonObject = res.getData().getJSONObject(i);
                    ALiMzkQueryOut reOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)jsonObject, ALiMzkQueryOut.class);
                    Payment payment = new Payment();
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setPayCode(in.getPayCode());
                    payment.setPayName(in.getPayName());
                    payment.setPayType(in.getPayType());
                    payment.setPayNo(in.getCardNo());
                    payment.setCouponBalance(reOut.getBalance());
                    payment.setAmount(in.getAmount());
                    payment.setMoney(in.getAmount());
                    payment.setTerminalNo(in.getTerminalNo());
                    payment.setTerminalSno(mzkreq.getReceiptNumber());
                    payment.setCustmnerName(reOut.getMemberName());
                    payment.setPrcutMode(in.getCutMode());
                    payment.setPrecision(in.getPrecision());
                    payment.setRate(in.getRate());
                    payment.setFlag("1");
                    payment.setRowno(cacheModel.getPayments().size());
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return new RespBase(Code.CODE_50057.getIndex(), "\u6d88\u5355\u5931\u8d25\uff1a" + res.getMessage());
        }
        for (int i = 0; i < 3; ++i) {
            ALiMzkResult res;
            resp = this.aLiMzkService.executeBatch(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u64a4\u9500\u51b2\u6b63(\u6279\u91cf)", "cardConsumeCancelsReversal");
            if ("0".equals(resp.getReturncode()) && (res = (ALiMzkResult)resp.getData()).isSuccess()) {
                return Code.CODE_50072.getRespBase(new Object[]{"\u672c\u6b21\u50a8\u503c\u5361\u4ea4\u6613\u9000\u6b3e\u5931\u8d25"});
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Transaction t : list) {
            Payment payment = new Payment();
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setPayCode(in.getPayCode());
            payment.setPayName(in.getPayName());
            payment.setPayType(in.getPayType());
            payment.setPayNo(t.getCardNumber());
            payment.setAmount(t.getConsumeAmount());
            payment.setMoney(t.getConsumeAmount());
            payment.setTerminalNo(in.getTerminalNo());
            payment.setTerminalSno(mzkreq.getReceiptNumber());
            payment.setPrcutMode(in.getCutMode());
            payment.setPrecision(in.getPrecision());
            payment.setRate(in.getRate());
            payment.setFlag("1");
            payment.setRowno(cacheModel.getPayments().size());
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS.getIndex(), "\u8d85\u65f6\u5931\u8d25\uff0c\u653e\u5f03\u672c\u8f6e\u51b2\u6b63\uff0c\u89c6\u540c\u4ea4\u6613\u6210\u529f\uff0c\u4eba\u5de5\u68c0\u67e5\u9000\u6b3e\u662f\u5426\u52a0\u56de\u5361\u4e0a\uff0c\u5982\u6709\u95ee\u9898\u4eba\u5de5\u5e72\u9884\u5904\u7406", (Object)resqVo);
    }

    public RespBase saleRepealPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        in = this.loadRequestPara(in, syjMain, mzkPayMode);
        ALiMzkPayIn mzkreq = new ALiMzkPayIn(in);
        ArrayList<Transaction> list = new ArrayList<Transaction>();
        Transaction t1 = new Transaction();
        t1.setCardNumber(in.getCardNo());
        t1.setConsumeAmount(in.getAmount());
        t1.setRelatedPayUserSerial(in.getRefCode());
        list.add(t1);
        mzkreq.setTransactionList(list);
        mzkreq.setReceiptNumber(cacheModel.getOrder().getTerminalSno());
        mzkreq.setStoreName(cacheModel.getOrder().getShopName());
        mzkreq.setOrderNo(cacheModel.getOrder().getOriginFlowNo());
        ServiceResponse resp = this.aLiMzkService.executeBatch(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u64a4\u9500\uff08\u6279\u91cf\uff09", "batchCardConsumeCancel");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkBatchCancerOut res = (ALiMzkBatchCancerOut)resp.getData();
            if (res.isSuccess()) {
                for (int i = 0; i < res.getData().size(); ++i) {
                    JSONObject jsonObject = res.getData().getJSONObject(i);
                    ALiMzkQueryOut reOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)jsonObject, ALiMzkQueryOut.class);
                    Payment payment = new Payment();
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setPayCode(in.getPayCode());
                    payment.setPayName(in.getPayName());
                    payment.setPayType(in.getPayType());
                    payment.setPayNo(in.getCardNo());
                    payment.setCouponBalance(reOut.getBalance());
                    payment.setAmount(in.getAmount());
                    payment.setMoney(in.getAmount());
                    payment.setTerminalNo(in.getTerminalNo());
                    payment.setTerminalSno(mzkreq.getReceiptNumber());
                    payment.setCustmnerName(reOut.getMemberName());
                    payment.setPrcutMode(in.getCutMode());
                    payment.setPrecision(in.getPrecision());
                    payment.setRate(in.getRate());
                    payment.setFlag("1");
                    payment.setRowno(cacheModel.getPayments().size());
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return new RespBase(Code.CODE_50057.getIndex(), "\u6d88\u5355\u5931\u8d25\uff1a" + res.getMessage());
        }
        for (int i = 0; i < 3; ++i) {
            ALiMzkBatchCancerOut res;
            resp = this.aLiMzkService.executeBatch(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u51b2\u6b63(\u6279\u91cf)", "cardConsumeCancelsReversal");
            if ("0".equals(resp.getReturncode()) && (res = (ALiMzkBatchCancerOut)resp.getData()).isSuccess()) {
                return Code.CODE_50072.getRespBase(new Object[]{"\u672c\u6b21\u50a8\u503c\u5361\u4ea4\u6613\u9000\u6b3e\u5931\u8d25"});
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Transaction t : list) {
            Payment payment = new Payment();
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setPayCode(in.getPayCode());
            payment.setPayName(in.getPayName());
            payment.setPayType(in.getPayType());
            payment.setPayNo(t.getCardNumber());
            payment.setAmount(t.getConsumeAmount());
            payment.setMoney(t.getConsumeAmount());
            payment.setTerminalNo(in.getTerminalNo());
            payment.setTerminalSno(mzkreq.getReceiptNumber());
            payment.setPrcutMode(in.getCutMode());
            payment.setPrecision(in.getPrecision());
            payment.setRate(in.getRate());
            payment.setFlag("1");
            payment.setRowno(cacheModel.getPayments().size());
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS.getIndex(), "\u8d85\u65f6\u5931\u8d25\uff0c\u653e\u5f03\u672c\u8f6e\u51b2\u6b63\uff0c\u89c6\u540c\u4ea4\u6613\u6210\u529f\uff0c\u4eba\u5de5\u68c0\u67e5\u9000\u6b3e\u662f\u5426\u52a0\u56de\u5361\u4e0a\uff0c\u5982\u6709\u95ee\u9898\u4eba\u5de5\u5e72\u9884\u5904\u7406", (Object)resqVo);
    }

    public RespBase getRetreatCardByMagTrack(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        ALiMzkQueryIn mzkreq = new ALiMzkQueryIn(in);
        ServiceResponse resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "\u9000\u6b3e\u5361\u4fe1\u606f\u67e5\u8be2", "getRetreatCardByMagTrack");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult out = (ALiMzkResult)resp.getData();
            if (out.isSuccess()) {
                ALiMzkQueryOut aLiMzkQueryOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)out.getData(), ALiMzkQueryOut.class);
                JSONObject json = new JSONObject();
                json.put("money", (Object)aLiMzkQueryOut.getBalance());
                return new RespBase(Code.SUCCESS, (Object)json);
            }
            return Code.CODE_50070.getRespBase(new Object[]{out.getMessage()});
        }
        return Code.CODE_50070.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
    }

    public RespBase cardRetreat(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        JSONObject modeDetailsVo = this.getRedisData(paramsObject);
        JSONObject syjMain = this.getSyjMain(modeDetailsVo);
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        in = this.loadRequestPara(in, syjMain, mzkPayMode);
        ALiMzkPayIn mzkreq = new ALiMzkPayIn(in);
        mzkreq.setReceiptNumber(cacheModel.getOrder().getTerminalSno());
        mzkreq.setStoreName(cacheModel.getOrder().getShopName());
        ServiceResponse resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u9000\u6b3e", "cardRetreat");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult res = (ALiMzkResult)resp.getData();
            if (res.isSuccess()) {
                ALiMzkQueryOut reOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)res.getData(), ALiMzkQueryOut.class);
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(in.getPayCode());
                payment.setPayName(in.getPayName());
                payment.setPayType(in.getPayType());
                payment.setPayNo(in.getCardNo());
                payment.setCouponBalance(reOut.getBalance());
                payment.setAmount(in.getAmount());
                payment.setMoney(in.getAmount());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setTerminalSno(mzkreq.getReceiptNumber());
                payment.setCustmnerName(reOut.getMemberName());
                payment.setPrcutMode(in.getCutMode());
                payment.setPrecision(in.getPrecision());
                payment.setRate(in.getRate());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size());
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo);
            }
            return new RespBase(Code.CODE_50057.getIndex(), "\u6d88\u5355\u5931\u8d25\uff1a" + res.getMessage());
        }
        for (int i = 0; i < 3; ++i) {
            ALiMzkResult res;
            resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "POS\u5361\u6d88\u8d39\u51b2\u6b63", "cardRetreatRepeal");
            if ("0".equals(resp.getReturncode()) && (res = (ALiMzkResult)resp.getData()).isSuccess()) {
                return Code.CODE_50072.getRespBase(new Object[]{"\u672c\u6b21\u50a8\u503c\u5361\u4ea4\u6613\u9000\u6b3e\u5931\u8d25"});
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayCode(in.getPayCode());
        payment.setPayName(in.getPayName());
        payment.setPayType(in.getPayType());
        payment.setPayNo(in.getCardNo());
        payment.setAmount(in.getAmount());
        payment.setMoney(in.getAmount());
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(mzkreq.getReceiptNumber());
        payment.setPrcutMode(in.getCutMode());
        payment.setPrecision(in.getPrecision());
        payment.setRate(in.getRate());
        payment.setFlag("1");
        payment.setRowno(cacheModel.getPayments().size());
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS.getIndex(), "\u8d85\u65f6\u5931\u8d25\uff0c\u653e\u5f03\u672c\u8f6e\u51b2\u6b63\uff0c\u89c6\u540c\u4ea4\u6613\u6210\u529f\uff0c\u4eba\u5de5\u68c0\u67e5\u9000\u6b3e\u662f\u5426\u52a0\u56de\u5361\u4e0a\uff0c\u5982\u6709\u95ee\u9898\u4eba\u5de5\u5e72\u9884\u5904\u7406", (Object)resqVo);
    }

    public JSONObject getRedisData(JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        return JSONObject.parseObject((String)obj);
    }

    public JSONObject getSyjMain(JSONObject modeDetailsVo) {
        JSONObject syjMain = null;
        if (modeDetailsVo.containsKey((Object)"syjmain")) {
            syjMain = modeDetailsVo.getJSONObject("syjmain");
        }
        return syjMain;
    }

    public ALiMzkIn loadRequestPara(ALiMzkIn in, JSONObject syjMain, PaymentMode mzkPayMode) {
        in.setCutMode(mzkPayMode.getSswrfs());
        in.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
        in.setPayName(mzkPayMode.getName());
        in.setPayType(mzkPayMode.getPaytype());
        in.setRate(mzkPayMode.getZlhl().doubleValue());
        if (StringUtils.isNotBlank((String)mzkPayMode.getIszl())) {
            in.setIsAllowCharge(mzkPayMode.getIszl());
        } else {
            in.setIsAllowCharge("N");
        }
        if (StringUtils.isNotBlank((String)mzkPayMode.getIsyy())) {
            in.setIsOverage(mzkPayMode.getIsyy());
        } else {
            in.setIsOverage("N");
        }
        if (syjMain != null && syjMain.containsKey((Object)"erpCode")) {
            in.setErpcode(syjMain.getString("erpCode"));
        }
        return in;
    }

    public RespBase getSellCardByMagTrack(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        ALiMzkIn in = (ALiMzkIn)JSON.toJavaObject((JSON)paramsObject, ALiMzkIn.class);
        ALiMzkQueryIn mzkreq = new ALiMzkQueryIn(in);
        ServiceResponse resp = this.aLiMzkService.execute(session, JSON.toJSONString((Object)mzkreq), "\u552e\u5356\u5361\u4fe1\u606f\u67e5\u8be2", "getSellCardByMagTrack");
        if ("0".equals(resp.getReturncode())) {
            ALiMzkResult out = (ALiMzkResult)resp.getData();
            if (out.isSuccess()) {
                ALiMzkQueryOut aLiMzkQueryOut = (ALiMzkQueryOut)JSON.toJavaObject((JSON)out.getData(), ALiMzkQueryOut.class);
                JSONObject json = new JSONObject();
                json.put("money", (Object)aLiMzkQueryOut.getBalance());
                return new RespBase(Code.SUCCESS, (Object)json);
            }
            return Code.CODE_50070.getRespBase(new Object[]{out.getMessage()});
        }
        return Code.CODE_50070.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
    }
}

