/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.wslf.response.DfOweInfo;
import com.efuture.business.model.df.DfCannelPayReq;
import com.efuture.business.model.df.DfInModel;
import com.efuture.business.model.df.DfOweInfoReq;
import com.efuture.business.model.df.DfPayReq;
import com.efuture.business.service.DFSaleBS;
import com.efuture.business.util.DfPayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class DFSaleBSImpl
implements DFSaleBS {
    private static final Logger log = LoggerFactory.getLogger(DFSaleBSImpl.class);
    private static Logger logger = LoggerFactory.getLogger(DFSaleBSImpl.class);
    RestTemplate restTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    DfPayUtil dfPayUtil;

    public RespBase Payment(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        JSONObject resObject;
        DfPayReq dfPayDef;
        ModeDetailsVo modeDetailsVo;
        CacheModel cacheModel;
        DfInModel dfInModel;
        block6: {
            logger.info("Payment\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)paramsObject));
            dfInModel = (DfInModel)JSON.parseObject((String)paramsObject.toJSONString(), DfInModel.class);
            cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
            }
            String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
            modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            dfPayDef = new DfPayReq();
            dfPayDef.setCHANNEL_TYPE(modeDetailsVo.getSysparainfo().dfChannelType);
            dfPayDef.setORG_NO(modeDetailsVo.getSysparainfo().dfOrgNo);
            dfPayDef.setTERMINAL_NO(modeDetailsVo.getSysparainfo().dfChannelType);
            DFSaleBSImpl dFSaleBSImpl = this;
            dfPayDef.setSYS_OPER_ID("D" + dFSaleBSImpl.dfPayUtil.getSysId());
            dfPayDef.setCONS_NO(dfInModel.getConsNo());
            dfPayDef.setACCT_ORG_NO(modeDetailsVo.getSysparainfo().dfOrgNo);
            dfPayDef.setBANK_SERIAL(String.valueOf(UniqueID.getUniqueID()));
            dfPayDef.setBANK_CODE(modeDetailsVo.getSysparainfo().dfChannelType);
            DFSaleBSImpl dFSaleBSImpl2 = this;
            dfPayDef.setBANK_DATE(dFSaleBSImpl2.dfPayUtil.getDate());
            dfPayDef.setPAY_FLAG(dfInModel.getPayFlag());
            dfPayDef.setRCV_AMT(dfInModel.getRcvAmt());
            JSONArray printInfos = null;
            resObject = null;
            ServiceResponse resp = null;
            try {
                log.info("\u8c03\u7528\u7f34\u8d39\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dfPayDef));
                resp = this.dfPayUtil.payment(this.restTemplate, session, dfPayDef);
                log.info("\u8c03\u7528\u7f34\u8d39\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
                if ("0".equals(resp.getReturncode())) {
                    resObject = (JSONObject)JSONObject.toJSON((Object)resp.getData());
                    if ("0".equals(resObject.getString("RTN_CODE"))) {
                        printInfos = resObject.getJSONObject("result").getJSONArray("PRINT_INFO");
                        if (null != printInfos) {
                            JSONObject print = printInfos.getJSONObject(0);
                            log.info("PRINT_INFO\uff1a{}", (Object)print.toJSONString());
                            cacheModel.getOrder().setCallerremark(print.getString("RCVBL_AMT_ID"));
                            cacheModel.getOrder().setDfPrintInfo(printInfos);
                        }
                        break block6;
                    }
                    return new RespBase(Code.CODE_50053.getIndex(), resObject.getString("RTN_MSG"));
                }
                return new RespBase(Code.CODE_50053.getIndex(), "\u7535\u7f51\u901a\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + JSON.toJSONString((Object)resp));
            }
            catch (Exception e) {
                log.error("\u7f34\u8d39\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            }
        }
        cacheModel.getOrder().setExtendFt3(dfPayDef.getBANK_SERIAL());
        cacheModel.getOrder().setCorporationcode(modeDetailsVo.getSysparainfo().dfOrgNo);
        cacheModel.getOrder().setDfStatus(1);
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, resObject);
        return new RespBase(Code.SUCCESS, (Object)resqVo, dfInModel.getFlowNo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RespBase queryOweInfo(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        logger.info("queryOweInfo\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)paramsObject));
        DfInModel dfInModel = (DfInModel)JSON.parseObject((String)paramsObject.toJSONString(), DfInModel.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        DfOweInfoReq dfOweInfoDef = new DfOweInfoReq();
        dfOweInfoDef.setCHANNEL_TYPE(modeDetailsVo.getSysparainfo().dfChannelType);
        dfOweInfoDef.setORG_NO(modeDetailsVo.getSysparainfo().dfOrgNo);
        dfOweInfoDef.setBANK_CODE(modeDetailsVo.getSysparainfo().dfChannelType);
        dfOweInfoDef.setTERMINAL_NO(modeDetailsVo.getSysparainfo().dfChannelType);
        DFSaleBSImpl dFSaleBSImpl = this;
        dfOweInfoDef.setSYS_OPER_ID("D" + dFSaleBSImpl.dfPayUtil.getSysId());
        dfOweInfoDef.setCONS_NO(dfInModel.getConsNo());
        JSONObject resultObj = null;
        ServiceResponse resp = null;
        JSONObject resData = null;
        try {
            log.info("\u8c03\u7528\u6b20\u8d39\u4fe1\u606f\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dfOweInfoDef));
            resp = this.dfPayUtil.queryOweInfo(this.restTemplate, session, dfOweInfoDef);
            log.info("\u8c03\u7528\u6b20\u8d39\u4fe1\u606f\u67e5\u8be2\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            if (!"0".equals(resp.getReturncode())) return new RespBase(Code.CODE_50053.getIndex(), "\u7535\u7f51\u901a\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + JSON.toJSONString((Object)resp));
            resData = (JSONObject)JSONObject.toJSON((Object)resp.getData());
            if (!"0".equals(resData.getString("RTN_CODE"))) return new RespBase(Code.CODE_50053.getIndex(), resData.getString("RTN_MSG"));
            resultObj = resData.getJSONObject("result");
            JSONArray oweInfolist = resultObj.getJSONArray("RCVBL_DET");
            double RCVBL_AMT = 0.0;
            double RCVED_AMT = 0.0;
            double RCVBL_PENALTY = 0.0;
            int RECORD_COUNT = 0;
            double TOTAL_OWE_AMT = 0.0;
            for (int i = 0; i < oweInfolist.size(); ++i) {
                RCVBL_AMT += oweInfolist.getJSONObject(i).getDouble("RCVBL_AMT").doubleValue();
                RCVED_AMT += oweInfolist.getJSONObject(i).getDouble("RCVED_AMT").doubleValue();
                RCVBL_PENALTY += oweInfolist.getJSONObject(i).getDouble("RCVBL_PENALTY").doubleValue();
                RECORD_COUNT += oweInfolist.getJSONObject(i).getInteger("RECORD_COUNT").intValue();
                TOTAL_OWE_AMT += oweInfolist.getJSONObject(i).getDouble("TOTAL_OWE_AMT").doubleValue();
            }
            DfOweInfo dfOweInfo = (DfOweInfo)JSONObject.parseObject((String)oweInfolist.getJSONObject(0).toJSONString(), DfOweInfo.class);
            dfOweInfo.setRcvblAmt(String.valueOf(ManipulatePrecision.doubleConvert((double)RCVBL_AMT, (int)2, (int)0)));
            dfOweInfo.setRcvedAmt(String.valueOf(ManipulatePrecision.doubleConvert((double)RCVED_AMT, (int)2, (int)0)));
            dfOweInfo.setRcvblPenalty(String.valueOf(ManipulatePrecision.doubleConvert((double)RCVBL_PENALTY, (int)2, (int)0)));
            dfOweInfo.setRecordCount(String.valueOf(RECORD_COUNT));
            dfOweInfo.setTotalOweAmt(String.valueOf(ManipulatePrecision.doubleConvert((double)TOTAL_OWE_AMT, (int)2, (int)0)));
            cacheModel.getOrder().setDfOweInfo(dfOweInfo);
        }
        catch (Exception e) {
            log.error("\u6b20\u8d39\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_50053.getIndex(), "\u6b20\u8d39\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage());
        }
        log.info("\u6b20\u8d39\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)cacheModel, "DFQUERY")));
        return new RespBase(Code.SUCCESS, (Object)cacheModel, "DFQUERY");
    }

    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        logger.info("cancelPay\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)paramsObject));
        DfInModel dfInModel = (DfInModel)JSON.parseObject((String)paramsObject.toJSONString(), DfInModel.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        DfCannelPayReq dfCannelPayReq = new DfCannelPayReq();
        dfCannelPayReq.setCHANNEL_TYPE(modeDetailsVo.getSysparainfo().dfChannelType);
        dfCannelPayReq.setORG_NO(modeDetailsVo.getSysparainfo().dfOrgNo);
        dfCannelPayReq.setTERMINAL_NO(modeDetailsVo.getSysparainfo().dfChannelType);
        DFSaleBSImpl dFSaleBSImpl = this;
        dfCannelPayReq.setSYS_OPER_ID("D" + dFSaleBSImpl.dfPayUtil.getSysId());
        dfCannelPayReq.setFLOW_NO(String.valueOf(UniqueID.getUniqueID()));
        dfCannelPayReq.setCANCEL_FLOW_NO(dfInModel.getCannelFlowNo());
        dfCannelPayReq.setBANK_CODE(modeDetailsVo.getSysparainfo().dfChannelType);
        DFSaleBSImpl dFSaleBSImpl2 = this;
        dfCannelPayReq.setACCT_DATE(dFSaleBSImpl2.dfPayUtil.getDate());
        ServiceResponse resp = null;
        JSONObject resData = null;
        try {
            log.info("\u8c03\u7528\u53d6\u6d88\u7f34\u8d39\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dfCannelPayReq));
            resp = this.dfPayUtil.cancelPay(this.restTemplate, session, dfCannelPayReq);
            log.info("\u8c03\u7528\u53d6\u6d88\u7f34\u8d39\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resp));
            if ("0".equals(resp.getReturncode())) {
                resData = (JSONObject)JSONObject.toJSON((Object)resp.getData());
                if (!"0".equals(resData.getString("RTN_CODE"))) {
                    return new RespBase(Code.CODE_50053.getIndex(), resData.getString("RTN_MSG"));
                }
            } else {
                return new RespBase(Code.CODE_50053.getIndex(), "\u7535\u7f51\u901a\u4fe1\u63a5\u53e3\u5f02\u5e38\uff1a" + JSON.toJSONString((Object)resp));
            }
            cacheModel.getOrder().setDfStatus(2);
            cacheModel.getOrder().setExtendFt3(dfCannelPayReq.getFLOW_NO());
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u7f34\u8d39\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_50053.getIndex(), "\u53d6\u6d88\u7f34\u8d39\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + e.getMessage());
        }
        return new RespBase(Code.SUCCESS, (Object)cacheModel, "DFCANNELPAY");
    }
}

