/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.erajaya.EraJayaCouponSaleReq;
import com.efuture.business.javaPos.struct.erajaya.ErajayaRespVo;
import com.efuture.business.javaPos.struct.request.DeletePaymentIn;
import com.efuture.business.model.erajaya.CouponCancelRes;
import com.efuture.business.model.erajaya.CouponCheckRes;
import com.efuture.business.model.erajaya.CouponInfo;
import com.efuture.business.model.erajaya.CouponPayReq;
import com.efuture.business.model.erajaya.CouponPayRes;
import com.efuture.business.model.erajaya.Error;
import com.efuture.business.model.erajaya.Product;
import com.efuture.business.model.erajaya.Products;
import com.efuture.business.service.EraJayaCouponSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class EraJayaCouponSaleBSImpl
implements EraJayaCouponSaleBS {
    private static final Logger log = LoggerFactory.getLogger(EraJayaCouponSaleBSImpl.class);
    RestTemplate restTemplate;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Value(value="${pay.couponUrl}")
    protected String couponUrl;
    private static String COUPONCHECK = "/v1.1/coupon/isredeemable";
    private static String COUPONSALE = "/v1.1/coupon/redeem";
    private static String COUPONCLEAN = "/v2/coupon/reactivate";

    public RespBase couponCheck(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("voucherCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"voucherCode"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        String consumersId = "";
        if (null == order || null == order.getConsumersData() || !StringUtils.isNotBlank((String)order.getConsumersData().getConsumersId())) {
            return Code.CODE_50147.getRespBase(new Object[0]);
        }
        consumersId = order.getConsumersData().getConsumersId();
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                if (!StringUtils.isNotBlank((String)p.getPayMemo()) || !"ERAJAYACOUPON".equals(p.getPayMemo())) continue;
                return Code.CODE_50149.getRespBase(new Object[0]);
            }
        }
        String shopCode = paramsObject.getString("shopCode");
        String terminalNo = paramsObject.getString("terminalNo");
        String obj = this.redisUtil.get(RedisKey.CACHEID + shopCode + terminalNo);
        PaymentMode payModel = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Basic cHBwLnhsLnN0b3JlMjoxNGIyNTkzYjVlNDRmNzI4MGQ2OTU4NWIwZTViMjE4Yw==");
        String COUPONCHECK1 = COUPONCHECK + "?code=" + paramsObject.getString("voucherCode") + "&format=js&details=extended&external_id=" + consumersId;
        ServiceResponse resp = this.httpUtils.doErajayaGet("", this.couponUrl, COUPONCHECK1, session, null, JSONObject.class, "ERAJAYA", "EARJAVA\u5238\u68c0\u67e5", headMap);
        if ("0".equals(resp.getReturncode())) {
            JSONObject res2 = (JSONObject)resp.getData();
            CouponCheckRes res1 = (CouponCheckRes)JSONObject.toJavaObject((JSON)res2.getJSONObject("response"), CouponCheckRes.class);
            if (null == res1.getCoupons() || null == res1.getCoupons().getRedeemable()) {
                return Code.CODE_50142.getRespBase(new Object[0]);
            }
            String is_redeemable = res1.getCoupons().getRedeemable().getIs_redeemable();
            if (!"true".equals(is_redeemable)) {
                JSONObject item_status = res1.getCoupons().getRedeemable().getItem_status();
                if (null != item_status && StringUtils.isNotBlank((String)item_status.getString("message"))) {
                    return Code.CODE_50143.getRespBase(new Object[]{item_status.getString("message")});
                }
                return Code.CODE_50142.getRespBase(new Object[0]);
            }
            CouponInfo series_info = res1.getCoupons().getRedeemable().getSeries_info();
            if (null == series_info) {
                return Code.CODE_50142.getRespBase(new Object[0]);
            }
            Products products = series_info.getProducts();
            boolean hasProducts = false;
            if (null != products && null != products.getProduct() && products.getProduct().size() > 0) {
                hasProducts = true;
            }
            double disGoodsAmount = 0.0;
            long min_bill_amount = series_info.getMin_bill_amount();
            if (hasProducts) {
                boolean hasGoods = false;
                block1: for (Goods g : cacheModel.getGoodsList()) {
                    for (Product product : products.getProduct()) {
                        if (!g.getBarNo().equals(product.getEan())) continue;
                        if (!hasGoods) {
                            hasGoods = true;
                        }
                        if ("ABS".equals(series_info.getDiscount_type())) {
                            if (!(g.getSalePrice() > (double)min_bill_amount)) continue;
                            disGoodsAmount = g.getSalePrice();
                            continue block1;
                        }
                        disGoodsAmount = ManipulatePrecision.add((double)disGoodsAmount, (double)g.getSaleAmount());
                    }
                }
                if (!hasGoods) {
                    return Code.CODE_50148.getRespBase(new Object[0]);
                }
            } else {
                disGoodsAmount = order.getOughtPay();
            }
            if ((double)min_bill_amount > disGoodsAmount) {
                return Code.CODE_50148.getRespBase(new Object[0]);
            }
            double zkl = ManipulatePrecision.div((double)CastUtil.castDouble((Object)series_info.getDiscount_value()), (double)100.0);
            Object amount = "";
            Object amount1 = "";
            amount = "ABS".equals(series_info.getDiscount_type()) ? series_info.getDiscount_value() : "" + (int)(disGoodsAmount * zkl);
            amount1 = "" + disGoodsAmount;
            CouponPayReq req = new CouponPayReq();
            req.setCode(paramsObject.getString("voucherCode"));
            JSONObject customer = new JSONObject();
            customer.put("external_id", (Object)consumersId);
            req.setCustomer(customer);
            JSONObject transaction = new JSONObject();
            transaction.put("number", (Object)cacheModel.getFlowNo());
            transaction.put("amount", amount1);
            req.setTransaction(transaction);
            ArrayList<CouponPayReq> list = new ArrayList<CouponPayReq>();
            list.add(req);
            JSONObject coupon = new JSONObject();
            coupon.put("coupon", list);
            JSONObject j = new JSONObject();
            j.put("root", (Object)coupon);
            ServiceResponse response = this.httpUtils.doErajayaPost("", this.couponUrl, COUPONSALE, session, j.toJSONString(), JSONObject.class, "ERAJAYA", "EARJAVA\u5238\u6838\u9500", headMap);
            if ("0".equals(response.getReturncode())) {
                JSONObject re = (JSONObject)response.getData();
                log.info("\u5238\u8fd4\u56dere" + re.toJSONString());
                CouponPayRes res = (CouponPayRes)JSONObject.toJavaObject((JSON)re.getJSONObject("response"), CouponPayRes.class);
                if (!"true".equals(res.getStatus().getString("success"))) {
                    return Code.CODE_50143.getRespBase(new Object[]{res.getStatus().getString("message")});
                }
                log.info("\u5238\u8fd4\u56deres" + JSON.toJSONString((Object)res));
                if (null == res.getCoupons() || null == res.getCoupons().getCoupon()) {
                    return Code.CODE_50119.getRespBase(new Object[0]);
                }
                if (!"true".equals(res.getCoupons().getCoupon().getItem_status().getString("success"))) {
                    return Code.CODE_50143.getRespBase(new Object[]{res.getCoupons().getCoupon().getItem_status().getString("message")});
                }
                Payment payment = new Payment();
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setPayCode(paramsObject.getString("payCode"));
                payment.setPayName(payModel.getName());
                payment.setPayType(payModel.getPaytype());
                payment.setPayNo(paramsObject.getString("voucherCode"));
                payment.setRate(payModel.getZlhl().doubleValue());
                payment.setAmount(Double.parseDouble((String)amount));
                payment.setMoney(Double.parseDouble((String)amount));
                payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                payment.setPrecision(String.valueOf(payModel.getSswrjd()));
                payment.setPrcutMode(payModel.getSswrfs());
                payment.setIsAllowCharge(payModel.getIszl());
                payment.setIsOverage(payModel.getIsyy());
                payment.setFlag("1");
                payment.setRefCode(res.getCoupons().getCoupon().getRedemption_id());
                payment.setPayMemo("ERAJAYACOUPON");
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setRownoId(payment.getPuid());
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "EARJAVPOINTPAY", cacheModel.getFlowNo());
            }
            return Code.CODE_40029.getRespBase(new Object[0]);
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    public RespBase couponPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel = null;
        ErajayaRespVo erajayaRespVo = null;
        EraJayaCouponSaleReq earJavCouponSaleReq = (EraJayaCouponSaleReq)JSONObject.parseObject((String)paramsObject.toString(), EraJayaCouponSaleReq.class);
        cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder() == null) {
            return new RespBase(Code.CODE_100025, vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + earJavCouponSaleReq.getShopCode() + earJavCouponSaleReq.getTerminalNo());
        PaymentMode payModel = null;
        if (obj != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)obj);
            payModel = PayModeUtils.getPayMode((String)earJavCouponSaleReq.getPayCode(), (JSONObject)jsonObject);
        }
        log.info("EARJAVA\u5238\u6838\u9500 \u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)earJavCouponSaleReq));
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Basic cHBwLnhsLnN0b3JlMjoxNGIyNTkzYjVlNDRmNzI4MGQ2OTU4NWIwZTViMjE4Yw==");
        ServiceResponse response = this.httpUtils.doErajayaPost("", this.couponUrl, COUPONSALE, session, JSONObject.toJSONString((Object)earJavCouponSaleReq), ErajayaRespVo.class, "ERAJAYA", "EARJAVA\u5238\u6838\u9500", headMap);
        if (!"0".equals(response.getReturncode())) {
            return new RespBase(Integer.parseInt(response.getReturncode()), JSONObject.toJSON((Object)response.getData()).toString(), "");
        }
        erajayaRespVo = (ErajayaRespVo)response.getData();
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayCode(paramsObject.getString("payCode"));
        payment.setPayName(payModel.getName());
        payment.setPayType(payModel.getPaytype());
        payment.setPayNo(erajayaRespVo.getData().getString("voucherCode"));
        payment.setRate(payModel.getHl().doubleValue());
        payment.setAmount(Double.parseDouble(erajayaRespVo.getData().getString("voucherValue")));
        payment.setMoney(Double.parseDouble(erajayaRespVo.getData().getString("voucherValue")));
        payment.setTerminalNo(cacheModel.getOrder().getTerminalNo());
        payment.setPrecision(String.valueOf(payModel.getSswrjd()));
        payment.setPrcutMode(payModel.getSswrfs());
        payment.setIsAllowCharge(payModel.getIszl());
        payment.setIsOverage(payModel.getIsyy());
        payment.setFlag("1");
        payment.setRefCode(erajayaRespVo.getData().getString("redemptionld"));
        payment.setPayMemo("ERAJAYACOUPON");
        payment.setDescription("1");
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setRownoId(payment.getPuid());
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "EARJAVPOINTPAY", cacheModel.getFlowNo());
    }

    public RespBase delCouponPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(in.getPuid())) continue;
            payment = p;
            break;
        }
        if (null == payment) {
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(payment.getRefCode());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("redemptionIds", list);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", "Basic cHBwLnhsLnN0b3JlMjoxNGIyNTkzYjVlNDRmNzI4MGQ2OTU4NWIwZTViMjE4Yw==");
        ServiceResponse resp = this.httpUtils.doErajayaPost("", this.couponUrl, COUPONCLEAN, session, jsonObject.toJSONString(), CouponCancelRes.class, "ERAJAYA", "EARJAVA\u5238\u64a4\u9500", headMap);
        if ("0".equals(resp.getReturncode())) {
            CouponCancelRes res = (CouponCancelRes)resp.getData();
            if (!res.isSuccess()) {
                return Code.CODE_50053.getRespBase(new Object[]{((Error)res.getErrors().get(0)).getMessage()});
            }
            block1: for (Goods g : cacheModel.getGoodsList()) {
                if (null == g.getOutCouponUses() || g.getOutCouponUses().size() <= 0) continue;
                for (int i = 0; i < g.getOutCouponUses().size(); ++i) {
                    CouponUse couponUse = (CouponUse)g.getOutCouponUses().get(i);
                    if (!payment.getPayNo().equals(couponUse.getCouponNo())) continue;
                    g.getOutCouponUses().remove(couponUse);
                    continue block1;
                }
            }
            cacheModel.getPayments().remove(payment);
            PayUtil.sortPayments((List)cacheModel.getPayments());
            cacheModel.setPayments(cacheModel.getPayments());
            cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
            if (cacheModel.getCalcResult() == -1) {
                String errCode = String.valueOf(Code.CODE_500000.getIndex());
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
            }
            vo.setCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "");
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    public RespBase couponConsume(ServiceSession session, JSONObject paramsObject) {
        log.info("EARJAVA\u5238\u51b2\u6b63 \u5165\u53c2 ==>{}", (Object)paramsObject.toJSONString());
        ServiceResponse response = this.httpUtils.doMyshopPost(this.restTemplate, null, COUPONCLEAN, session, paramsObject.toJSONString(), null, "EARJAVA\u5238", "EARJAVA\u5238\u51b2\u6b63", null);
        log.info("EARJAVA\u5238\u51b2\u6b63  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
        if (!"0".equals(response.getReturncode().trim())) {
            return new RespBase(Integer.parseInt(response.getReturncode().trim()), JSONObject.toJSON((Object)response.getData()).toString(), response.getData());
        }
        if (response.getData() == null) {
            return new RespBase(Code.CODE_50128.getIndex(), "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", "");
        }
        return new RespBase(Code.SUCCESS);
    }

    public static void main(String[] args) {
        String s = "{\"response\":{\"coupons\":{\"coupon\":{\"side_effects\":[],\"code\":\"EQ20TVL5\",\"series_code\":\"71445\",\"discount_code\":\"lutfy_Product\",\"redemption_id\":\"14658886\",\"item_status\":{\"code\":700,\"success\":\"true\",\"message\":\"Coupon processing successful\"},\"is_absolute\":\"true\",\"coupon_value\":\"10000\",\"transaction\":{\"number\":\"1063.SI.240424.8001.0000001\",\"amount\":\"10000.00\"},\"customer\":{\"mobile\":\"6285860778469\",\"external_id\":\"783\",\"email\":\"sri.cifo@gmail.com\"},\"series_info\":[]}},\"status\":{\"code\":200,\"success\":\"true\",\"message\":\"Success\"}}}";
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        CouponPayRes res = (CouponPayRes)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("response"), CouponPayRes.class);
        System.out.println(JSON.toJSONString((Object)res));
        if (null == res.getCoupons() || null == res.getCoupons().getCoupon()) {
            System.out.println(false);
        }
    }
}

