/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.erajaya.ErajayaRespVo;
import com.efuture.business.model.mzk.request.GiftCardCancelPayIn;
import com.efuture.business.model.mzk.request.GiftCardPayIn;
import com.efuture.business.model.mzk.response.GiftCardRes;
import com.efuture.business.service.GiftCardSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class GiftCardSaleBSImpl
implements GiftCardSaleBS {
    private static final Logger log = LoggerFactory.getLogger(GiftCardSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    protected RedisUtil redisUtil;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Value(value="${pay.promoUrl}")
    protected String promoUrl;
    private static String CARDSALE = "/v1/giftcard/external/redeem";
    private static String CARDCANCEL = "/v1/giftcard/external/release";

    public RespBase giftCardPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        CacheModel cacheModel;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cardNo"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"amount"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payCode"});
        }
        String type = "0";
        if (StringUtils.isNotBlank((String)paramsObject.getString("type"))) {
            type = paramsObject.getString("type");
        }
        if ((cacheModel = vo.getCacheModel()) == null) {
            return Code.CODE_60.getRespBase(new Object[]{""});
        }
        String shopCode = paramsObject.getString("shopCode");
        String terminalNo = paramsObject.getString("terminalNo");
        String merchantOrderNo = shopCode + terminalNo + System.currentTimeMillis();
        String obj = this.redisUtil.get(RedisKey.CACHEID + shopCode + terminalNo);
        String apikey = "xx0vYR1UuZtdfexzSARskkCzdwVMYiA7X5S9j60RTPbmA3Wy";
        PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        if (remainValue - paramsObject.getDouble("amount") < 0.0) {
            return Code.CODE_50110.getRespBase(new Object[0]);
        }
        GiftCardPayIn giftCardPayIn = new GiftCardPayIn();
        if ("0".equals(type)) {
            giftCardPayIn.setBarcode(paramsObject.getString("cardNo"));
        } else {
            giftCardPayIn.setCard_number(paramsObject.getString("cardNo"));
            giftCardPayIn.setPin(paramsObject.getString("pin"));
        }
        giftCardPayIn.setInvoice_number(merchantOrderNo);
        giftCardPayIn.setGrand_total(paramsObject.getInteger("amount").intValue());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("source", "eraspace");
        headMap.put("x-eraspacegtw-apikey", apikey);
        ServiceResponse response = this.httpUtils.doErajayaPost("", this.promoUrl, CARDSALE, session, JSONObject.toJSONString((Object)giftCardPayIn), ErajayaRespVo.class, "ERAJAYA", "\u793c\u54c1\u5361\u652f\u4ed8", headMap);
        if ("0".equals(response.getReturncode())) {
            ErajayaRespVo res = (ErajayaRespVo)response.getData();
            if (200 != res.getStatus()) {
                return Code.CODE_50015.getRespBase(new Object[]{res.getError_message()});
            }
            GiftCardRes cardPayOut = (GiftCardRes)JSON.toJavaObject((JSON)res.getData(), GiftCardRes.class);
            Payment payment = new Payment();
            payment.setPayCode(paramsObject.getString("payCode"));
            payment.setPayName(payMode.getName());
            payment.setPayType(payMode.getPaytype());
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setRownoId(payment.getPuid());
            payment.setRowno(cacheModel.getPayments().size() + 1);
            if ("0".equals(type)) {
                payment.setPayNo(giftCardPayIn.getBarcode());
            } else {
                payment.setPayNo(giftCardPayIn.getCard_number());
            }
            payment.setMoney(cardPayOut.getTotalAmount());
            payment.setAmount(cardPayOut.getTotalAmount());
            payment.setPrecision(String.valueOf(payMode.getSswrjd()));
            payment.setPrcutMode(payMode.getSswrfs());
            payment.setRate(payMode.getZlhl().doubleValue());
            payment.setFlag("1");
            payment.setTerminalNo(terminalNo);
            payment.setBatchNo(String.valueOf(cardPayOut.getCurrentBatchNumber()));
            payment.setMisTerminalId(cardPayOut.getApprovalCode());
            payment.setPayMemo(String.valueOf(cardPayOut.getTransactionId()));
            payment.setRefCode(merchantOrderNo);
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            vo.setCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    public RespBase giftCardCancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"shopCode"});
        }
        if (!paramsObject.containsKey((Object)"terminalNo") || paramsObject.getString("terminalNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalNo"});
        }
        if (!paramsObject.containsKey((Object)"flowNo") || paramsObject.getString("flowNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"flowNo"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{"", vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_50115.getRespBase(new Object[0]);
        }
        String shopCode = paramsObject.getString("shopCode");
        String terminalNo = paramsObject.getString("terminalNo");
        String merchantOrderNo = shopCode + terminalNo + System.currentTimeMillis();
        String obj = this.redisUtil.get(RedisKey.CACHEID + shopCode + terminalNo);
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(paramsObject.getString("puid"))) continue;
            payment = p;
            break;
        }
        if (null == payment) {
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        JSONObject j = new JSONObject();
        j.put("CardNumber", (Object)payment.getPayNo());
        j.put("OriginalBatchNumber", (Object)CastUtil.castInt((Object)payment.getBatchNo()));
        j.put("OriginalTransactionId", (Object)CastUtil.castInt((Object)payment.getPayMemo()));
        j.put("OriginalApprovalCode", (Object)CastUtil.castInt((Object)payment.getMisTerminalId()));
        j.put("originalInvoiceNumber", (Object)payment.getRefCode());
        j.put("InvoiceNumber", (Object)merchantOrderNo);
        String apikey = "xx0vYR1UuZtdfexzSARskkCzdwVMYiA7X5S9j60RTPbmA3Wy";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Content-Type", "application/json");
        headMap.put("source", "eraspace");
        headMap.put("x-eraspacegtw-apikey", apikey);
        ServiceResponse resp = this.httpUtils.doErajayaPost("", this.promoUrl, CARDCANCEL, session, j.toJSONString(), ErajayaRespVo.class, "ERAJAYA", "\u793c\u54c1\u5361\u64a4\u9500", headMap);
        if ("0".equals(resp.getReturncode())) {
            ErajayaRespVo res = (ErajayaRespVo)resp.getData();
            if (200 != res.getStatus()) {
                return Code.CODE_50053.getRespBase(new Object[]{res.getError_message()});
            }
            if (payment != null) {
                cacheModel.getPayments().remove(payment);
                PayUtil.sortPayments((List)cacheModel.getPayments());
                cacheModel.setPayments(cacheModel.getPayments());
                cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
                if (cacheModel.getCalcResult() == -1) {
                    String errCode = String.valueOf(Code.CODE_500000.getIndex());
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
                }
                vo.setCacheModel(cacheModel);
            }
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "");
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    public RespBase giftCardReturnPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        GiftCardCancelPayIn giftCardCancelPayIn = (GiftCardCancelPayIn)JSONObject.toJavaObject((JSON)paramsObject, GiftCardCancelPayIn.class);
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"shopCode"});
        }
        if (!paramsObject.containsKey((Object)"terminalNo") || paramsObject.getString("terminalNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalNo"});
        }
        if (!paramsObject.containsKey((Object)"flowNo") || paramsObject.getString("flowNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"flowNo"});
        }
        if (!paramsObject.containsKey((Object)"CardNumber") || paramsObject.getString("CardNumber").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"CardNumber"});
        }
        if (!paramsObject.containsKey((Object)"OriginalBatchNumber") || paramsObject.getString("OriginalBatchNumber").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"OriginalBatchNumber"});
        }
        if (!paramsObject.containsKey((Object)"OriginalTransactionId") || paramsObject.getString("OriginalTransactionId").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"OriginalTransactionId"});
        }
        if (!paramsObject.containsKey((Object)"OriginalApprovalCode") || paramsObject.getString("OriginalApprovalCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"OriginalApprovalCode"});
        }
        if (!paramsObject.containsKey((Object)"originalInvoiceNumber") || paramsObject.getString("originalInvoiceNumber").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"originalInvoiceNumber"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"money"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{"", vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_50115.getRespBase(new Object[0]);
        }
        String shopCode = paramsObject.getString("shopCode");
        String terminalNo = paramsObject.getString("terminalNo");
        String merchantOrderNo = shopCode + terminalNo + System.currentTimeMillis();
        String obj = this.redisUtil.get(RedisKey.CACHEID + shopCode + terminalNo);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String clientID = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"YNKEY");
        if (StringUtils.isBlank((String)clientID)) {
            return Code.CODE_50129.getRespBase(new Object[]{"YNKEY"});
        }
        giftCardCancelPayIn.setInvoiceNumber(merchantOrderNo);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Content-Type", "application/json");
        headMap.put("source", "eraspace");
        headMap.put("x-eraspacegtw-apikey", clientID);
        ServiceResponse response = this.httpUtils.doErajayaPost("", this.promoUrl, CARDCANCEL, session, JSONObject.toJSONString((Object)giftCardCancelPayIn), ErajayaRespVo.class, "ERAJAYA", "\u793c\u54c1\u5361\u9000\u6b3e", headMap);
        if ("0".equals(response.getReturncode())) {
            ErajayaRespVo res = (ErajayaRespVo)response.getData();
            if (200 != res.getStatus()) {
                return Code.CODE_50015.getRespBase(new Object[]{res.getError_message()});
            }
            GiftCardRes cardPayOut = (GiftCardRes)JSON.toJavaObject((JSON)res.getData(), GiftCardRes.class);
            Payment payment = new Payment();
            PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
            payment.setPayCode(paramsObject.getString("payCode"));
            payment.setPayName(payMode.getName());
            payment.setPayType(payMode.getPaytype());
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setRownoId(payment.getPuid());
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setPayNo(merchantOrderNo);
            payment.setMoney(cardPayOut.getTotalAmount());
            payment.setAmount(cardPayOut.getTotalAmount());
            payment.setRate(payMode.getHl().doubleValue());
            payment.setPrecision(String.valueOf(payMode.getSswrjd()));
            payment.setPrcutMode(payMode.getSswrfs());
            payment.setFlag("1");
            payment.setTerminalNo(terminalNo);
            payment.setMisTerminalId(String.valueOf(cardPayOut.getApprovalCode()));
            payment.setPayMemo(String.valueOf(cardPayOut.getTransactionId()));
            payment.setRefCode(String.valueOf(cardPayOut.getCurrentBatchNumber()));
            payment.setIsSuccess(true);
            payment.setPopFlag("1");
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            vo.setCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "");
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }
}

