/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.skp.request.DepositIn;
import com.efuture.business.model.skp.request.LockAccountIn;
import com.efuture.business.model.skp.request.NoShowIn;
import com.efuture.business.model.skp.request.UnLockAccountIn;
import com.efuture.business.model.skp.response.LockAccountOut;
import com.efuture.business.service.SkpKdSaleBS;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class SkpKdSaleBSImpl
implements SkpKdSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SkpKdSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    private RedisUtil redisUtil;
    RestTemplate restTemplate;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Value(value="${localcache.enabled}")
    protected Boolean localcache;
    private static String GETBALANCEMONEY = "order.online.account.getBalanceMoney";
    private static String LOCKACCOUNTMONEY = "order.online.account.lockAccountMoney";
    private static String UNLOCKACCOUNTMONEY = "order.online.account.unLockAccountMoney";
    private static String UNLOCKACCOUNTMONEYFORREVERSE = "order.online.account.unLockAccountMoneyForReverse";

    public RespBase deposit(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        if (this.localcache.booleanValue()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u7a7a\u8ba2\u9500\u552e\u5fc5\u987b\u8054\u7f51\u4f7f\u7528\uff01");
        }
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"phone") || paramsObject.getString("phone").isEmpty()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u9884\u5b58\u8ba2\u91d1\u5305\u542b\u53c2\u6570[\u624b\u673a\u53f7]", vo.getCacheModel().getFlowNo());
        }
        DepositIn in = (DepositIn)JSON.parseObject((String)paramsObject.toJSONString(), DepositIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u7a7a\u8ba2\u64cd\u4f5c\u524d\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5546\u54c1\uff0c\u8bf7\u5148\u5220\u9664\u5546\u54c1\uff01"});
        }
        cacheModel.getOrder().setOrderType("KD1");
        cacheModel.getOrder().setGroupBuyNumber(in.getPhone());
        cacheModel.getOrder().setGroupBuyerName(in.getName());
        cacheModel.getOrder().setGroupBuyerCode(in.getIdNumber());
        BaseOutModel res = new BaseOutModel();
        res.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)res)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (this.localcache.booleanValue()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u8131\u673a\u4e0d\u5141\u8bb8\u4f7f\u7528\u5b9a\u91d1\u652f\u4ed8\uff01");
        }
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return new RespBase(Code.CODE_3.getIndex(), "\u53c2\u6570\u9519\u8bef");
        }
        if (!paramsObject.containsKey((Object)"voucherNo") || paramsObject.getString("voucherNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5b9a\u91d1\u4f59\u989d\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u51ed\u8bc1\u53f7]", vo.getCacheModel().getFlowNo());
        }
        NoShowIn in = (NoShowIn)JSONObject.toJavaObject((JSON)paramsObject, NoShowIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        JSONObject jo = new JSONObject();
        jo.put("mkt", (Object)cacheModel.getOrder().getShopCode());
        jo.put("voucherNo", (Object)paramsObject.getString("voucherNo"));
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, GETBALANCEMONEY, session, jo.toJSONString(), BigDecimal.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u67e5\u8be2\u8d26\u6237\u4f59\u989d");
        if ("0".equals(resp.getReturncode())) {
            double money = ((BigDecimal)resp.getData()).doubleValue();
            JSONObject json = new JSONObject();
            json.put("money", (Object)money);
            return new RespBase(Code.SUCCESS, (Object)json);
        }
        return new RespBase(Code.CODE_50058.getIndex(), "\u67e5\u8be2\u5b9a\u91d1\u8d26\u6237\u4f59\u989d\u5931\u8d25\uff1a" + resp.getData());
    }

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (this.localcache.booleanValue()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u8131\u673a\u4e0d\u5141\u8bb8\u4f7f\u7528\u5b9a\u91d1\u652f\u4ed8\uff01");
        }
        log.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"voucherNo") || paramsObject.getString("voucherNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u51ed\u8bc1\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        NoShowIn in = (NoShowIn)JSONObject.toJavaObject((JSON)paramsObject, NoShowIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        log.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + JSON.toJSONString((Object)in));
        if (remainValue - in.getAmount() < 0.0 && "N".equals(mzkPayMode.getIsyy())) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                if (!in.getVoucherNo().equals(p.getPayNo())) continue;
                return Code.CODE_50071.getRespBase(new Object[]{"\u4e00\u7b14\u4ea4\u6613\u4e00\u4e2a\u8d26\u6237\u53ea\u80fd\u5237\u4e00\u6b21"});
            }
        }
        LockAccountIn lockAccountIn = new LockAccountIn();
        lockAccountIn.setMkt(in.getShopCode());
        lockAccountIn.setMoney(in.getAmount());
        lockAccountIn.setVoucherNo(in.getVoucherNo());
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, LOCKACCOUNTMONEY, session, JSON.toJSONString((Object)lockAccountIn), LockAccountOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u9501\u5b9a\u8d26\u6237\u91d1\u989d");
        if ("0".equals(resp.getReturncode())) {
            LockAccountOut out = (LockAccountOut)resp.getData();
            Payment payment = new Payment();
            payment.setPuid(UUIDUtils.buildPuid());
            payment.setRefCode(out.getTempVoucherNo());
            payment.setBatchNo(in.getVoucherNo());
            payment.setCouponGroup(out.getAccountNo());
            payment.setCouponEventScd(out.getTempVoucherNo());
            payment.setPayCode(in.getPayCode());
            payment.setPayName(mzkPayMode.getName());
            payment.setPayType(mzkPayMode.getPaytype());
            payment.setPayNo(out.getAccountNo());
            payment.setAmount(in.getAmount().doubleValue());
            payment.setMoney(in.getAmount().doubleValue());
            payment.setTerminalNo(in.getTerminalNo());
            payment.setTerminalSno(cacheModel.getOrder().getTerminalSno());
            payment.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
            payment.setPrcutMode(mzkPayMode.getSswrfs());
            payment.setRate(mzkPayMode.getZlhl().doubleValue());
            payment.setFlag("1");
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setIsAllowCharge(mzkPayMode.getIszl());
            payment.setIsOverage(mzkPayMode.getIsyy());
            payment.setExtMemo(JSON.toJSONString((Object)out.getPayList()));
            payment.setDescription("DJ");
            log.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            BaseOutModel res = new BaseOutModel();
            res.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)res)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
        }
        return Code.CODE_50025.getRespBase(new Object[]{resp.getData()});
    }

    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        NoShowIn in = (NoShowIn)JSONObject.toJavaObject((JSON)paramsObject, NoShowIn.class);
        String puid = in.getPuid();
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            preDeletePayment = p;
            break;
        }
        UnLockAccountIn unLockAccountIn = new UnLockAccountIn();
        if (preDeletePayment == null) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]");
        }
        unLockAccountIn.setMkt(in.getShopCode());
        unLockAccountIn.setMoney(in.getAmount());
        unLockAccountIn.setAccountNo(preDeletePayment.getPayNo());
        unLockAccountIn.setTempVoucherNo(preDeletePayment.getRefCode());
        unLockAccountIn.setPayList((List)JSON.parseArray((String)preDeletePayment.getExtMemo()));
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, UNLOCKACCOUNTMONEY, session, JSON.toJSONString((Object)unLockAccountIn), LockAccountOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u89e3\u9501\u8d26\u6237\u91d1\u989d");
        BaseOutModel out = new BaseOutModel();
        if ("0".equals(resp.getReturncode())) {
            if (preDeletePayment != null) {
                cacheModel.getPayments().remove(preDeletePayment);
                PayUtil.sortPayments((List)cacheModel.getPayments());
                cacheModel.setPayments(cacheModel.getPayments());
                cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
            }
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
        }
        return Code.CODE_50053.getRespBase(new Object[]{resp.getData()});
    }

    public RespBase saleRepealPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"payNo") || paramsObject.getString("payNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u8d26\u53f7]", vo.getCacheModel().getFlowNo());
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8bf7\u6c42\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        JSONObject jo = new JSONObject();
        jo.put("mkt", (Object)cacheModel.getOrder().getOriginShopCode());
        jo.put("originSheetNo", (Object)cacheModel.getOrder().getOriginIdSheetNo());
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, UNLOCKACCOUNTMONEYFORREVERSE, session, jo.toJSONString(), LockAccountOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6d88\u5355\u65f6\u89e3\u9501\u8d26\u6237\u91d1\u989d");
        if ("0".equals(resp.getReturncode())) {
            for (Payment p : cacheModel.getReturnPayments()) {
                if (!StringUtils.isNotBlank((String)p.getPayNo()) || !p.getPayNo().equals(paramsObject.getString("payNo"))) continue;
                p.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
                p.setPrcutMode(mzkPayMode.getSswrfs());
                p.setIsSuccess(true);
                p.setRowno(cacheModel.getPayments().size() + 1);
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, p);
            }
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        return Code.CODE_50053.getRespBase(new Object[]{resp.getData()});
    }

    public RespBase saleReserve(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"voucherNo") || paramsObject.getString("voucherNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u51ed\u8bc1\u53f7]");
        }
        NoShowIn in = (NoShowIn)JSONObject.toJavaObject((JSON)paramsObject, NoShowIn.class);
        UnLockAccountIn unLockAccountIn = new UnLockAccountIn();
        unLockAccountIn.setMkt(in.getShopCode());
        unLockAccountIn.setTempVoucherNo(paramsObject.getString("voucherNo"));
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, UNLOCKACCOUNTMONEY, session, JSON.toJSONString((Object)unLockAccountIn), LockAccountOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u89e3\u9501\u8d26\u6237\u91d1\u989d");
        if ("0".equals(resp.getReturncode())) {
            return new RespBase(Code.SUCCESS);
        }
        return Code.CODE_50025.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25\uff1a" + resp.getData()});
    }
}

