/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.V3PointSaleDao;
import com.efuture.business.enumcase.MzkEnum;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.model.mzk.request.V3MzkRequestDef;
import com.efuture.business.model.mzk.response.V3MzkResultDef;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.V3PointSaleBS;
import com.efuture.business.service.impl.V3MzkSaleServiceIml;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.MzkSaleUtil;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class V3PointSaleServiceIml
implements V3PointSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(V3MzkSaleServiceIml.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Resource
    private V3PointSaleDao mzkSaleDao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("cardNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u79ef\u5206\u6d88\u8d39\u5361\u53f7]");
        }
        if (null == jsonObject.getDouble("amount")) {
            jsonObject.put("amount", (Object)0);
        }
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        String v3jfcard = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JFCARD");
        String mkt = cacheModel.getOrder().getShopCode();
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)v3jfcard)) {
            String[] rows = v3jfcard.split(",", -1);
            boolean hasfind = false;
            for (int i = 0; i < rows.length && StringUtils.isNotEmpty((String)rows[i]); ++i) {
                if (!jsonObject.getString("cardNo").contains(rows[i])) continue;
                hasfind = true;
                break;
            }
            if (!hasfind) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u8bf7\u4f7f\u7528\u6b63\u786e\u65b9\u5f0f\u4f7f\u7528\u79ef\u5206\u6d88\u8d39"});
            }
        }
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        mzkRequestDef.setFlow_no(cacheModel.getOrder().getFlowNo());
        mzkRequestDef.setType("05");
        mzkRequestDef.setSeqno(0L);
        mzkRequestDef.setTermno(cacheModel.getOrder().getTerminalNo());
        mzkRequestDef.setMktcode(mkt);
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setSyjh(cacheModel.getOrder().getTerminalNo());
        mzkRequestDef.setFphm(Long.parseLong(cacheModel.getOrder().getTerminalSno()));
        mzkRequestDef.setSyyh(cacheModel.getOrder().getTerminalOperator());
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            mzkRequestDef.setInvdjlb("1");
            Object goodsList = "";
            Object oneGoodsInfo = "";
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods goods = (Goods)cacheModel.getGoodsList().get(i);
                oneGoodsInfo = (goods.getGoodsCode() == null ? "" : goods.getGoodsCode()) + "," + (goods.getOrgCode() == null ? "" : goods.getOrgCode()) + "," + (goods.getGoodsUid() == null ? "" : goods.getGoodsUid()) + ",00," + (goods.getCategoryCode() == null ? "" : goods.getCategoryCode()) + "," + (goods.getBrandCode() == null ? "" : goods.getBrandCode());
                goodsList = i != 0 ? (String)goodsList + "|" + (String)oneGoodsInfo : oneGoodsInfo;
            }
            mzkRequestDef.setGoodsList((String)goodsList);
        } else {
            mzkRequestDef.setInvdjlb("4");
            mzkRequestDef.setType("055");
        }
        mzkRequestDef.setPaycode("");
        mzkRequestDef.setJe(0.0);
        mzkRequestDef.setTrack1("");
        mzkRequestDef.setTrack2(jsonObject.getString("cardNo"));
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd("");
        mzkRequestDef.setMemo("");
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        logger.info("\u79ef\u5206\u6d88\u8d39\u67e5\u8be2\u662f\u5426\u542f\u7528\u672c\u5730\u8131\u673a:{}", (Object)this.localcache);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39\u67e5\u8be2", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39\u67e5\u8be2", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                V3MzkResultDef mzkResultDef = (V3MzkResultDef)JSONObject.parseObject((String)object.getString("data"), V3MzkResultDef.class);
                respBase = new RespBase(Code.SUCCESS, (Object)mzkResultDef);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u67e5\u8be2\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        V3MzkResultDef mzkResultDef = (V3MzkResultDef)respBase.getData();
        JSONObject json = new JSONObject();
        for (Payment p : cacheModel.getPayments()) {
            if (!mzkResultDef.getCardno().equals(p.getPayNo())) continue;
            return Code.CODE_50073.getRespBase(new Object[]{"\u5361\u53f7\u91cd\u590d"});
        }
        if (StringUtils.isEmpty((String)mzkResultDef.getMemo())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u5151\u6362\u89c4\u5219\u4e3a\u7a7a"});
        }
        String[] memo = mzkResultDef.getMemo().split(",", -1);
        if (memo.length < 2) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u5151\u6362\u89c4\u5219\u5f02\u5e38" + mzkResultDef.getMemo()});
        }
        String[] goodsRuleType = null;
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            if (StringUtils.isEmpty((String)mzkResultDef.getGoodsruletype())) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u67e5\u8be2[\u5546\u54c1\u53ef\u7528\u79ef\u5206\u8fd4\u56de\u5f02\u5e38],\u89c4\u5219:" + mzkResultDef.getGoodsruletype()});
            }
            goodsRuleType = mzkResultDef.getGoodsruletype().split("\\|", -1);
            if (goodsRuleType.length < cacheModel.getGoodsList().size()) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u67e5\u8be2[\u5546\u54c1\u53ef\u7528\u79ef\u5206\u8fd4\u56de\u5f02\u5e38],\u5546\u54c1\u6570" + cacheModel.getGoodsList() + ",\u89c4\u5219:" + mzkResultDef.getGoodsruletype()});
            }
        }
        json.put("available", (Object)mzkResultDef.getValue1());
        String yfphm = "";
        String ysyjh = "";
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && StringUtils.isNotEmpty((String)cacheModel.getOrder().getOriginTerminalNo()) && StringUtils.isNotEmpty((String)cacheModel.getOrder().getOriginTerminalSno())) {
            yfphm = cacheModel.getOrder().getOriginTerminalSno();
            ysyjh = cacheModel.getOrder().getOriginTerminalNo();
        }
        double custNum4 = 0.0;
        String custStr2 = "";
        if (cacheModel.getOrder() != null && cacheModel.getOrder().getConsumersData() != null) {
            custNum4 = cacheModel.getOrder().getConsumersData().getNum4();
            custStr2 = cacheModel.getOrder().getConsumersData().getStr2() == null ? "" : cacheModel.getOrder().getConsumersData().getStr2();
        }
        json.put("description", (Object)(memo[0] + "," + memo[1] + ",,,," + custNum4 + "," + custStr2 + "," + ysyjh + "," + yfphm));
        double multiple = ManipulatePrecision.mod((double)this.getCalcKfJe(cacheModel, goodsRuleType), (double)Double.parseDouble(memo[1]));
        double allowpayje = multiple = ManipulatePrecision.doubleConvert((double)(this.getCalcKfJe(cacheModel, goodsRuleType) - multiple));
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            allowpayje = Math.min(multiple, mzkResultDef.getYe());
        }
        if (Double.parseDouble(memo[1]) <= 0.0 || Double.parseDouble(memo[0]) <= 0.0) {
            allowpayje = 0.0;
        }
        json.put("maxAvailable", (Object)allowpayje);
        json.put("pointExchange", (Object)memo[0]);
        json.put("pointExchangeMoney", (Object)memo[1]);
        json.put("rate", (Object)1);
        json.put("cardNo", (Object)mzkResultDef.getCardno());
        return new RespBase(Code.SUCCESS, (Object)json);
    }

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (!jsonObject.containsKey((Object)"balance") || jsonObject.getString("balance").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f59\u989d]"}));
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("description"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "[\u4ed8\u6b3e]\u79ef\u5206\u6d88\u8d39\u63cf\u8ff0");
        }
        String[] memo = jsonObject.getString("description").split(",", -1);
        if (memo.length < 9) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u79ef\u5206\u5151\u6362\u89c4\u5219\u4e3a\u7a7a"});
        }
        double jfnum = Double.parseDouble(memo[0].trim());
        double jenum = Double.parseDouble(memo[1].trim());
        if (jfnum <= 0.0 || jenum <= 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u79ef\u5206\u5151\u6362\u89c4\u5219\u5f02\u5e38"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        String mkt = cacheModel.getOrder().getShopCode();
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        String cardCode = mzkIn.getCardNo();
        mzkIn.setCardNo(mzkIn.getCardNo());
        mzkIn.setBalance(jsonObject.getDouble("balance").doubleValue());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        logger.info("\u79ef\u5206\u6d88\u8d39\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        if (remainValue - mzkIn.getAmount() < 0.0 && "N".equals(mzkIn.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        if (ManipulatePrecision.mod((double)mzkIn.getAmount(), (double)jenum) != 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u6d88\u8d39\u7684\u91d1\u989d\u5fc5\u987b\u4e3a" + jenum + "\u7684\u500d\u6570\uff01"});
        }
        int bsnum = ManipulatePrecision.integerDiv((double)mzkIn.getAmount(), (double)jenum);
        if (bsnum < 1) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u5361\u79ef\u5206\u4e0d\u8db3\u4ee5\u6298\u73b0\uff0c\u4e0d\u80fd\u7528\u6b64\u4ed8\u6b3e\u65b9\u5f0f\u4ed8\u6b3e\uff01"});
        }
        double jfAmount = ManipulatePrecision.mul((double)jfnum, (double)bsnum);
        Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setCouponBalance(ManipulatePrecision.sub((double)mzkIn.getBalance(), (double)jfAmount));
        payment.setPayNo(cardCode);
        String description = jsonObject.getString("description");
        payment.setDescription(description);
        payment.setRefCode(mzkIn.getOrderNo());
        payment.setAmountJF(jfAmount);
        if (remainValue - mzkIn.getAmount() > 0.0) {
            payment.setIsOverage("N");
        }
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u6d88\u8d39\u5931\u8d25:" + cacheModel.getErrMsg()});
        }
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        mzkRequestDef.setFlow_no(cacheModel.getOrder().getFlowNo());
        mzkRequestDef.setType("01");
        mzkRequestDef.setSeqno(Long.parseLong(mzkIn.getOrderNo()));
        mzkRequestDef.setTermno(cacheModel.getOrder().getTerminalNo());
        mzkRequestDef.setMktcode(mkt);
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setSyjh(cacheModel.getOrder().getTerminalNo());
        mzkRequestDef.setFphm(Long.parseLong(cacheModel.getOrder().getTerminalSno()));
        mzkRequestDef.setSyyh(cacheModel.getOrder().getTerminalOperator());
        mzkRequestDef.setInvdjlb("1");
        mzkRequestDef.setPaycode(mzkIn.getPayCode());
        mzkRequestDef.setJe(jfAmount);
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.setTrack2(mzkIn.getCardNo());
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd(mzkIn.getPasswd() == null ? "" : mzkIn.getPasswd());
        mzkRequestDef.setMemo(jfAmount + "," + description);
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39\u6d88\u8d39", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39\u6d88\u8d39", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u6d88\u8d39\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u6d88\u8d39\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("puid"))) {
            return Code.CODE_64.getRespBase(new Object[]{"[\u64a4\u9500]\u652f\u4ed8puid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        if (!jsonObject.containsKey((Object)"description") || jsonObject.getString("description").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "[\u64a4\u9500]\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u63cf\u8ff0]");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (p.getPuid() == null || !p.getPuid().equals(jsonObject.getString("puid"))) continue;
            preDeletePayment = p;
            break;
        }
        if (null == preDeletePayment) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!"});
        }
        String orderNo = "";
        String description = "";
        if (null != preDeletePayment) {
            orderNo = preDeletePayment.getRefCode();
            description = preDeletePayment.getDescription();
            jsonObject.put("balance", (Object)preDeletePayment.getCouponBalance());
        } else {
            for (Payment p : cacheModel.getReturnPayments()) {
                if (p.getPuid() == null || !p.getPuid().equals(jsonObject.getString("puid"))) continue;
                orderNo = p.getRefCode();
                jsonObject.put("balance", (Object)p.getCouponBalance());
                description = p.getDescription();
                break;
            }
        }
        String[] memo = description.split(",", -1);
        if (memo.length < 9) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u64a4\u9500]\u79ef\u5206\u5151\u6362\u89c4\u5219\u4e3a\u7a7a"});
        }
        double jfnum = Double.parseDouble(memo[0].trim());
        double jenum = Double.parseDouble(memo[1].trim());
        if (jfnum <= 0.0 || jenum <= 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u64a4\u9500]\u79ef\u5206\u5151\u6362\u89c4\u5219\u5f02\u5e38"});
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        mzkIn.setOrderNo(orderNo);
        if (ManipulatePrecision.mod((double)mzkIn.getAmount(), (double)jenum) != 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u64a4\u9500]\u6d88\u8d39\u7684\u91d1\u989d\u5fc5\u987b\u4e3a" + jenum + "\u7684\u500d\u6570\uff01"});
        }
        int bsnum = ManipulatePrecision.integerDiv((double)mzkIn.getAmount(), (double)jenum);
        if (bsnum < 1) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u64a4\u9500]\u5361\u79ef\u5206\u4e0d\u8db3\u4ee5\u6298\u73b0\uff0c\u4e0d\u80fd\u7528\u6b64\u4ed8\u6b3e\u65b9\u5f0f\u4ed8\u6b3e\uff01"});
        }
        double jfAmount = ManipulatePrecision.mul((double)jfnum, (double)bsnum);
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        String transType = jsonObject.getString("transType");
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            if (StringUtils.isEmpty((String)transType)) {
                transType = "02";
            }
            mzkRequestDef.setInvdjlb("1");
        } else if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) || SellType.ISHCSALE((String)cacheModel.getOrder().getOrderType())) {
            if (StringUtils.isEmpty((String)transType)) {
                transType = "04";
            }
            mzkRequestDef.setInvdjlb("4");
        }
        mzkRequestDef.setFlow_no(cacheModel.getOrder().getFlowNo());
        mzkRequestDef.setType(transType);
        mzkRequestDef.setSeqno(Long.parseLong(mzkIn.getOrderNo()));
        mzkRequestDef.setTermno(mzkIn.getMzkTerminalNo());
        mzkRequestDef.setMktcode(mzkIn.getShopCode());
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setSyjh(mzkIn.getMzkTerminalNo());
        mzkRequestDef.setFphm(Long.parseLong(preDeletePayment.getTerminalSno()));
        mzkRequestDef.setSyyh(cacheModel.getOrder().getTerminalOperator());
        mzkRequestDef.setPaycode(mzkIn.getPayCode());
        mzkRequestDef.setJe(jfAmount);
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.setTrack2(mzkIn.getCardNo());
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd(mzkIn.getPasswd() == null ? "" : mzkIn.getPasswd());
        mzkRequestDef.setMemo(jfAmount + "," + description);
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39/\u5238\u64a4\u9500", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39/\u5238\u64a4\u9500", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39/\u5238\u64a4\u9500!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39/\u5238\u64a4\u9500\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        cacheModel.getPayments().remove(preDeletePayment);
        PayUtil.sortPayments((List)cacheModel.getPayments());
        cacheModel.setPayments(cacheModel.getPayments());
        cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase executeCzk(ServiceSession session, JSONObject jsonObject) {
        V3MzkRequestDef mzkreq = (V3MzkRequestDef)JSON.parseObject((String)jsonObject.toJSONString(), V3MzkRequestDef.class);
        V3MzkResultDef mzkResultDef = new V3MzkResultDef();
        String[] type = mzkreq.getType();
        if (StringUtils.isEmpty((String)type)) {
            return Code.CODE_64.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u7c7b\u578b]!"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getTrack2())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u79ef\u5206\u6d88\u8d39\u5361\u53f7]"});
        }
        if (!MzkEnum.SALEQUERY.compareCode(mzkreq.getType()) && !"055".equals(mzkreq.getType())) {
            if (!this.checkPayType((String)type)) {
                return Code.CODE_64.getRespBase(new Object[]{"\u4ea4\u6613\u7c7b\u578b\u4e0d\u5339\u914d:" + (String)type});
            }
            if (StringUtils.isEmpty((String)mzkreq.getTermno())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u673a\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getSyyh())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u5458\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getTrack2())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u79ef\u5206\u6d88\u8d39\u5361\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getPaycode())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u65b9\u5f0f]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getMktcode())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u95e8\u5e97\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getJygs())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getInvdjlb())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5355\u636e\u7c7b\u578b]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getMemo())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u63cf\u8ff0]"});
            }
            String[] memo = mzkreq.getMemo().split(",", -1);
            if (memo.length < 9) {
                return Code.CODE_50025.getRespBase(new Object[]{"[\u652f\u4ed8]\u79ef\u5206\u5151\u6362\u89c4\u5219\u4e3a\u7a7a"});
            }
            double jfnum = Double.parseDouble(memo[0].trim());
            double jenum = Double.parseDouble(memo[1].trim());
            if (jfnum <= 0.0 || jenum <= 0.0) {
                return Code.CODE_50025.getRespBase(new Object[]{"[\u652f\u4ed8]\u79ef\u5206\u5151\u6362\u89c4\u5219\u5f02\u5e38"});
            }
            mzkResultDef = this.mzkSaleDao.sendmzk(mzkreq);
        } else if ("055".equals(mzkreq.getType())) {
            mzkreq.setType("05");
            mzkResultDef = this.mzkSaleDao.sendmzk(mzkreq);
        } else {
            mzkResultDef = this.mzkSaleDao.sendmzkgoods(mzkreq);
        }
        if (null == mzkResultDef) {
            return new RespBase(Code.CODE_50058);
        }
        if (0 != mzkResultDef.recode) {
            switch (type) {
                case "01": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39[\u6d88\u8d39]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "02": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39[\u6d88\u8d39\u51b2\u6b63]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "03": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39[\u9000\u6b3e]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "04": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39[\u9000\u6b3e\u51b2\u6b63]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "05": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39[\u67e5\u8be2]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
            }
            return Code.CODE_55563.getRespBase(new Object[0]);
        }
        String func = "";
        if (mzkResultDef.getFunc() != null && mzkResultDef.getFunc().length() >= 3) {
            func = mzkResultDef.getFunc().substring(1, 3);
        }
        String syyh = mzkreq.getSyyh() == null ? "" : mzkreq.getSyyh();
        String djlb = mzkreq.getInvdjlb() == null ? "" : mzkreq.getInvdjlb();
        mzkResultDef.setRetcode("00");
        return new RespBase(Code.SUCCESS, (Object)mzkResultDef);
    }

    private boolean checkPayType(String payType) {
        switch (payType) {
            case "01": {
                return true;
            }
            case "02": {
                return true;
            }
            case "03": {
                return true;
            }
            case "04": {
                return true;
            }
            case "05": {
                return true;
            }
        }
        return false;
    }

    public RespBase saleReserve(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (!"02".equals(jsonObject.getString("transType")) && !"04".equals(jsonObject.getString("transType"))) {
            return new RespBase(Code.CODE_64.getIndex(), "\u51b2\u6b63\u53c2\u6570\u4ea4\u6613\u7c7b\u578b[transType]\u4e0d\u5339\u914d");
        }
        if (!jsonObject.containsKey((Object)"cardNo") || jsonObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u79ef\u5206\u6d88\u8d39\u5361\u53f7]");
        }
        if (!jsonObject.containsKey((Object)"amount") || jsonObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]");
        }
        if (!jsonObject.containsKey((Object)"terminalSno") || jsonObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]");
        }
        if (!jsonObject.containsKey((Object)"description") || jsonObject.getString("description").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u63cf\u8ff0]");
        }
        if (!jsonObject.containsKey((Object)"transType") || jsonObject.getString("transType").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[transType]");
        }
        String[] memo = jsonObject.getString("description").split(",", -1);
        if (memo.length < 9) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u79ef\u5206\u5151\u6362\u89c4\u5219\u4e3a\u7a7a"});
        }
        double jfnum = Double.parseDouble(memo[0].trim());
        double jenum = Double.parseDouble(memo[1].trim());
        if (jfnum <= 0.0 || jenum <= 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u79ef\u5206\u5151\u6362\u89c4\u5219\u5f02\u5e38"});
        }
        if (!StringUtils.isEmpty((String)jsonObject.getString("flowNo"))) {
            Payment delpayment = null;
            if (vo != null && vo.getCacheModel() != null) {
                CacheModel cacheModel = vo.getCacheModel();
                for (Payment p : cacheModel.getPayments()) {
                    if (p.getRefCode() == null || !p.getRefCode().equals(jsonObject.getString("orderNo"))) continue;
                    jsonObject.put("puid", (Object)p.getPuid());
                    delpayment = p;
                    break;
                }
            }
            if (delpayment != null) {
                return this.cancelPay(session, vo, jsonObject);
            }
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        JSONObject modeDetailsVo = MzkSaleUtil.getRedisData((JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        ModeDetailsVo modeDetailsVo2 = (ModeDetailsVo)JSONObject.parseObject((String)modeDetailsVo.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo2.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        JSONObject syjMain = modeDetailsVo.getJSONObject("syjmain");
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)jsonObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn mzkIn = MzkSaleUtil.loadRequestPara((JSONObject)jsonObject, (JSONObject)syjMain, (PaymentMode)mzkPayMode);
        String transType = jsonObject.getString("transType");
        String indjlb = "1";
        if ("04".equals(transType)) {
            indjlb = "4";
        }
        if (ManipulatePrecision.mod((double)mzkIn.getAmount(), (double)jenum) != 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u6d88\u8d39\u7684\u91d1\u989d\u5fc5\u987b\u4e3a" + jenum + "\u7684\u500d\u6570\uff01"});
        }
        int bsnum = ManipulatePrecision.integerDiv((double)mzkIn.getAmount(), (double)jenum);
        if (bsnum < 1) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u5361\u79ef\u5206\u4e0d\u8db3\u4ee5\u6298\u73b0\uff0c\u4e0d\u80fd\u7528\u6b64\u4ed8\u6b3e\u65b9\u5f0f\u4ed8\u6b3e\uff01"});
        }
        double jfAmount = ManipulatePrecision.mul((double)jfnum, (double)bsnum);
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        mzkRequestDef.setFlow_no("");
        mzkRequestDef.setType(transType);
        mzkRequestDef.setSeqno(Long.parseLong(mzkIn.getOrderNo()));
        mzkRequestDef.setTermno(mzkIn.getMzkTerminalNo());
        mzkRequestDef.setMktcode(mzkIn.getShopCode());
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setSyjh(mzkIn.getMzkTerminalNo());
        mzkRequestDef.setFphm(Long.parseLong(jsonObject.getString("terminalSno")));
        mzkRequestDef.setSyyh(mzkIn.getTerminalOperator());
        mzkRequestDef.setInvdjlb(indjlb);
        mzkRequestDef.setPaycode(mzkIn.getPayCode());
        mzkRequestDef.setJe(jfAmount);
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.setTrack2(mzkIn.getCardNo());
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd("");
        mzkRequestDef.setMemo(jfAmount + "," + jsonObject.getString("description"));
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39\u5f00\u673a\u51b2\u6b63", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39\u5f00\u673a\u51b2\u6b63", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u5f00\u673a\u51b2\u6b63!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39\u5f00\u673a\u51b2\u6b63\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!jsonObject.containsKey((Object)"description") || jsonObject.getString("description").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u8d27\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u63cf\u8ff0]");
        }
        String[] memo = jsonObject.getString("description").split(",", -1);
        if (memo.length < 9) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u79ef\u5206\u5151\u6362\u89c4\u5219\u4e3a\u7a7a"});
        }
        double jfnum = Double.parseDouble(memo[0].trim());
        double jenum = Double.parseDouble(memo[1].trim());
        if (jfnum <= 0.0 || jenum <= 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u79ef\u5206\u5151\u6362\u89c4\u5219\u5f02\u5e38"});
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        mzkIn.setAmount(mzkIn.getAmount());
        if (ManipulatePrecision.mod((double)mzkIn.getAmount(), (double)jenum) != 0.0) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u6d88\u8d39\u7684\u91d1\u989d\u5fc5\u987b\u4e3a" + jenum + "\u7684\u500d\u6570\uff01"});
        }
        int bsnum = ManipulatePrecision.integerDiv((double)mzkIn.getAmount(), (double)jenum);
        if (bsnum < 1) {
            return Code.CODE_50025.getRespBase(new Object[]{"[\u4ed8\u6b3e]\u5361\u79ef\u5206\u4e0d\u8db3\u4ee5\u6298\u73b0\uff0c\u4e0d\u80fd\u7528\u6b64\u4ed8\u6b3e\u65b9\u5f0f\u4ed8\u6b3e\uff01"});
        }
        double jfAmount = ManipulatePrecision.mul((double)jfnum, (double)bsnum);
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        mzkRequestDef.setFlow_no(cacheModel.getOrder().getFlowNo());
        mzkRequestDef.setType("03");
        mzkRequestDef.setSeqno(Long.parseLong(mzkIn.getOrderNo()));
        mzkRequestDef.setTermno(cacheModel.getOrder().getTerminalNo());
        mzkRequestDef.setMktcode(cacheModel.getOrder().getShopCode());
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setSyjh(cacheModel.getOrder().getTerminalNo());
        mzkRequestDef.setFphm(Long.parseLong(cacheModel.getOrder().getTerminalSno()));
        mzkRequestDef.setSyyh(cacheModel.getOrder().getTerminalOperator());
        mzkRequestDef.setInvdjlb("4");
        mzkRequestDef.setPaycode(mzkIn.getPayCode());
        mzkRequestDef.setJe(jfAmount);
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.setTrack2(mzkIn.getCardNo());
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd(mzkIn.getPasswd() == null ? "" : mzkIn.getPasswd());
        mzkRequestDef.setMemo(jfAmount + "," + jsonObject.getString("description"));
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        RespBase respBase = null;
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39/\u5238\u9000\u8d27", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u79ef\u5206\u6d88\u8d39/\u5238\u9000\u8d27", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39/\u5238\u9000\u8d27!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u79ef\u5206\u6d88\u8d39/\u5238\u9000\u8d27:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setDescription(jsonObject.getString("description"));
        payment.setCouponBalance(ManipulatePrecision.add((double)mzkIn.getBalance(), (double)jfAmount));
        payment.setAmountJF(jfAmount);
        payment.setRefCode(mzkIn.getOrderNo());
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public double getCalcKfJe(CacheModel cacheModel, String[] goodsRuleType) {
        if (cacheModel == null || cacheModel.getGoodsList().size() == 0) {
            return 0.0;
        }
        double kfje = 0.0;
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods goods = (Goods)cacheModel.getGoodsList().get(i);
            if (goodsRuleType != null && "N".equals(goodsRuleType[i])) continue;
            double je = goods.getSaleAmount();
            kfje += je;
        }
        return ManipulatePrecision.doubleConvert((double)kfje);
    }
}

