/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulateDateTime;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.wsykt.EcardPacket;
import com.efuture.business.model.wsykt.PacketInfo;
import com.efuture.business.model.wsykt.request.YktReqDef;
import com.efuture.business.model.wsykt.response.YktRespDef;
import com.efuture.business.service.GoodsRemoteService;
import com.efuture.business.service.YktSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.ECardClient;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.TVicClient;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class YktSaleBSImpl
implements YktSaleBS {
    private static final Logger log = LoggerFactory.getLogger(YktSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    private RedisUtil redisUtil;
    @SoaAnnotation(value="/apiGoodsRemoteService.do")
    private GoodsRemoteService goodsRemoteService;

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"password") || paramsObject.getString("password").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5bc6\u7801]");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt") || paramsObject.getString("tradeAmt").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u91d1\u989d]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        log.info("\u6570\u5b57\u4e00\u5361\u901a-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007, (Object)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - in.getTradeAmt() < 0.0) {
            return new RespBase(Code.CODE_50050, (Object)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        JSONObject jo = this.getRedisData(paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)jo.toJSONString(), ModeDetailsVo.class);
        String jzhx = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JZHX");
        boolean isSuccess = false;
        if (StringUtils.isNotBlank((String)jzhx) && "Y".equals(jzhx)) {
            if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                for (Payment p : cacheModel.getPayments()) {
                    if (!StringUtils.isNotBlank((String)p.getPayNo()) || !p.getPayNo().equals(in.getPassword())) continue;
                    return new RespBase(Code.CODE_50002.getIndex(), "\u652f\u4ed8\u5931\u8d25:\u4e00\u7b14\u8ba2\u5355\u8be5\u5361\u53ea\u5141\u8bb8\u652f\u4ed8\u4e00\u6b21");
                }
            }
        } else {
            YktRespDef yktRespDef = new YktRespDef();
            log.info("\u83b7\u53d6\u96c6\u56e2\u50a8\u503c\u5361ip");
            String jtczip = "";
            jtczip = this.getSysCode(in, "JTCZ");
            log.info("jtczip{}", (Object)jtczip);
            if ("".equals(jtczip)) {
                return new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4e00\u5361\u901aIP\u7aef\u53e3\u53c2\u6570", vo.getCacheModel().getFlowNo());
            }
            GlobalInfo.ytkIp = jtczip.split(":")[0];
            GlobalInfo.ytkPort = Integer.valueOf(jtczip.split(":")[1]);
            log.info("\u8c03\u7528\u96c6\u56e2\u6838\u9500\u63a5\u53e3");
            if (!this.sendMzkSale(in, yktRespDef)) {
                return new RespBase(Code.CODE_50002.getIndex(), "\u652f\u4ed8\u5931\u8d25:" + yktRespDef.getMsg(), vo.getCacheModel().getFlowNo());
            }
            isSuccess = true;
        }
        PaymentMode szyktPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)jo);
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayNo(in.getPassword());
        payment.setRefCode(in.getOrderNo());
        payment.setPayCode(in.getPayCode());
        payment.setPayName(szyktPayMode.getName());
        payment.setPayType(szyktPayMode.getPaytype());
        payment.setPasswd(in.getPassword());
        payment.setTrackData(in.getCodeValue());
        payment.setAmount(in.getTradeAmt());
        payment.setMoney(in.getTradeAmt());
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(in.getTerminalSno());
        payment.setCustmnerName(in.getAccountNo());
        payment.setMisMerchantId(this.getSysCode(in, "JGDM"));
        payment.setPrecision(String.valueOf(szyktPayMode.getSswrjd()));
        payment.setPrcutMode(szyktPayMode.getSswrfs());
        payment.setRate(szyktPayMode.getZlhl().doubleValue());
        payment.setFlag("1");
        payment.setPayMemo(in.getWstranNo());
        payment.setMemo(in.getTradeDate());
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setIsSuccess(isSuccess);
        if ("1".equals(in.getScene())) {
            payment.setPopFlag("1");
        }
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "YKTSALEPAY")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTSALEPAY");
    }

    public RespBase refund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"password") || paramsObject.getString("password").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5bc6\u7801]");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt") || paramsObject.getString("tradeAmt").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u91d1\u989d]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"saleType") || paramsObject.getString("saleType").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7c7b\u578b]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        log.info("\u4e00\u5361\u901a\u9000\u6b3e\u5165\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007, (Object)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - in.getTradeAmt() < 0.0) {
            return new RespBase(Code.CODE_50050, (Object)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        JSONObject jo = this.getRedisData(paramsObject);
        PaymentMode szyktPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)jo);
        YktRespDef yktRespDef = new YktRespDef();
        log.info("\u83b7\u53d6\u96c6\u56e2\u50a8\u503c\u5361ip");
        String jtczip = "";
        jtczip = this.getSysCode(in, "JTCZ");
        log.info("jtczip{}", (Object)jtczip);
        if ("".equals(jtczip)) {
            return new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4e00\u5361\u901aIP\u7aef\u53e3\u53c2\u6570", vo.getCacheModel().getFlowNo());
        }
        GlobalInfo.ytkIp = jtczip.split(":")[0];
        GlobalInfo.ytkPort = Integer.valueOf(jtczip.split(":")[1]);
        log.info("\u8c03\u7528\u6838\u9500\u63a5\u53e3");
        if (!this.sendMzkSale(in, yktRespDef)) {
            return new RespBase(Code.CODE_50002.getIndex(), "\u9000\u6b3e\u5931\u8d25:" + yktRespDef.getMsg(), vo.getCacheModel().getFlowNo());
        }
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayNo(in.getPassword());
        payment.setRefCode(in.getOrderNo());
        payment.setPayCode(in.getPayCode());
        payment.setPayName(szyktPayMode.getName());
        payment.setPayType(szyktPayMode.getPaytype());
        payment.setPasswd(in.getPassword());
        payment.setTrackData(in.getCodeValue());
        payment.setAmount(in.getTradeAmt());
        payment.setMoney(in.getTradeAmt());
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(in.getTerminalSno());
        payment.setCustmnerName(in.getAccountNo());
        payment.setMisMerchantId(this.getSysCode(in, "JGDM"));
        payment.setPrecision(String.valueOf(szyktPayMode.getSswrjd()));
        payment.setPrcutMode(szyktPayMode.getSswrfs());
        payment.setRate(szyktPayMode.getZlhl().doubleValue());
        payment.setFlag("1");
        payment.setPayMemo(in.getWstranNo());
        payment.setMemo(in.getTradeDate());
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setIsSuccess(true);
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u4e00\u5361\u901a\u9000\u8d27\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "YKTREFUND")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTREFUND");
    }

    public RespBase outPay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"password") || paramsObject.getString("password").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5bc6\u7801]");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt") || paramsObject.getString("tradeAmt").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u91d1\u989d]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"saleType") || paramsObject.getString("saleType").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7c7b\u578b]");
        }
        if (!paramsObject.containsKey((Object)"jtczIp") || paramsObject.getString("jtczIp").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u96c6\u56e2ip\u7aef\u53e3]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        log.info("\u4e00\u5361\u901a\u5916\u90e8\u652f\u4ed8\u53c2 ==>{}", (Object)JSONObject.toJSONString((Object)in));
        YktRespDef yktRespDef = new YktRespDef();
        log.info("\u83b7\u53d6\u96c6\u56e2\u50a8\u503c\u5361ip");
        log.info("jtczip{}", (Object)in.getJtczIp());
        GlobalInfo.ytkIp = in.getJtczIp().split(":")[0];
        GlobalInfo.ytkPort = Integer.valueOf(in.getJtczIp().split(":")[1]);
        log.info("\u8c03\u7528\u6838\u9500\u63a5\u53e3");
        if (!this.sendMzkSale(in, yktRespDef)) {
            return new RespBase(Code.CODE_50002.getIndex(), "\u6838\u9500\u5931\u8d25:" + yktRespDef.getMsg(), "");
        }
        return new RespBase(Code.SUCCESS, (Object)yktRespDef, "YKTOUTPAY");
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        String puid = paramsObject.getString("puid");
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            if (p.getIsSuccess()) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u8be5\u5361\u5df2\u6263\u6b3e,\u4e0d\u5141\u8bb8\u5220\u9664\uff01"});
            }
            PreDeletePayment = p;
            break;
        }
        BaseOutModel out = new BaseOutModel();
        if (PreDeletePayment != null) {
            cacheModel.getPayments().remove(PreDeletePayment);
            PayUtil.sortPayments((List)cacheModel.getPayments());
            cacheModel.setPayments(cacheModel.getPayments());
            cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
        }
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTSALEREFUND");
    }

    public RespBase queryCard(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        log.info("\u4e00\u5361\u901a-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        YktRespDef yktRespDef = new YktRespDef();
        log.info("\u83b7\u53d6\u96c6\u56e2\u50a8\u503c\u5361ip");
        String jtczip = "";
        jtczip = StringUtils.isNotBlank((String)in.getJtczIp()) ? in.getJtczIp() : this.getSysCode(in, "JTCZ");
        log.info("jtczip{}", (Object)jtczip);
        if ("".equals(jtczip)) {
            return new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4e00\u5361\u901aIP\u7aef\u53e3\u53c2\u6570", paramsObject.getString("flowNo"));
        }
        GlobalInfo.ytkIp = jtczip.split(":")[0];
        GlobalInfo.ytkPort = Integer.valueOf(jtczip.split(":")[1]);
        if (!this.sendMzkQuery(in, yktRespDef)) {
            return new RespBase(Code.CODE_50058.getIndex(), yktRespDef.getMsg());
        }
        log.info("\u4e00\u5361\u901a\u67e5\u8be2\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)yktRespDef, "YKTSALEQUERY")));
        return new RespBase(Code.SUCCESS, (Object)yktRespDef, "YKTSALEQUERY");
    }

    public RespBase vicCheck(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"guid") || paramsObject.getString("guid").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[guid]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        boolean flag = false;
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        BaseOutModel out = new BaseOutModel();
        log.info("\u4e00\u5361\u901a\u6821\u9a8c-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        Goods goods = (Goods)cacheModel.getGoodsList().get(0);
        in.setTradeAmt(goods.getSaleAmount());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        YktRespDef yktRespDef = new YktRespDef();
        if (!"".equals(in.getCodeValue())) {
            if (cacheModel.isYktFlag()) {
                log.info("\u793c\u54c1\u5361\u5df2\u88ab\u6fc0\u6d3b-\u901a\u8fc7{}", (Object)cacheModel.isYktFlag());
                flag = true;
            } else {
                log.info("\u8c03\u7528\u96c6\u56e2\u793c\u54c1\u5361\u6821\u9a8c\u63a5\u53e3", (Object)cacheModel.isYktFlag());
                flag = this.vicCheck(in, yktRespDef);
            }
        }
        if (!flag) {
            log.info("\u6821\u9a8c\u5931\u8d25\uff0c\u5220\u9664\u5546\u54c1{}", (Object)in.getGuid());
            JSONObject ob = new JSONObject();
            ob.put("guid", (Object)goods.getGuid());
            ob.put("barNo", (Object)goods.getBarNo());
            ob.put("shopCode", (Object)paramsObject.getString("shopCode"));
            ob.put("terminalNo", (Object)paramsObject.getString("terminalNo"));
            ob.put("terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            ob.put("flowNo", (Object)paramsObject.getString("flowNo"));
            log.info("\u5220\u9664\u5546\u54c1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)ob));
            ResqVo buildReqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)ob);
            return this.goodsRemoteService.delCartGoods(session, buildReqVo);
        }
        ((Goods)cacheModel.getGoodsList().get(0)).setRemark(in.getCodeValue());
        cacheModel.setCodeValue(in.getCodeValue());
        cacheModel.setCodeAmount(in.getTradeAmt());
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "YKTCHECK")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTCHECK");
    }

    public RespBase sendVicRecharge(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt") || paramsObject.getString("tradeAmt").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u91d1\u989d]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        log.info("\u4e00\u5361\u901a\u5145\u503c-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        YktRespDef yktRespDef = new YktRespDef();
        in.setWstranNo(this.vicGetTranId(in));
        log.info("\u4e00\u5361\u901a\u5145\u503c", (Object)JSONObject.toJSONString((Object)in));
        if (!this.sendVicRecharge(in, yktRespDef)) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u5145\u503c\u5931\u8d25:" + yktRespDef.getMsg(), vo.getCacheModel().getFlowNo());
        }
        cacheModel.setYktFlag(true);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "YKTRECHARGE")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTRECHARGE");
    }

    public RespBase sendVicCancel(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt") || paramsObject.getString("tradeAmt").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5145\u503c\u91d1\u989d]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4e00\u5361\u901a\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        YktReqDef in = (YktReqDef)JSONObject.toJavaObject((JSON)paramsObject, YktReqDef.class);
        log.info("\u4e00\u5361\u901a\u5145\u503c-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        YktRespDef yktRespDef = new YktRespDef();
        if (!this.vicCancel(in, yktRespDef)) {
            return new RespBase(Code.CODE_50058.getIndex(), yktRespDef.getMsg(), vo.getCacheModel().getFlowNo());
        }
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)yktRespDef)));
        log.info("\u4e00\u5361\u901a\u67e5\u8be2\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "YKTCANCEL")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTCANCEL");
    }

    private JSONObject getRedisData(JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        return JSONObject.parseObject((String)obj);
    }

    public boolean sendMzkQuery(YktReqDef req, YktRespDef ret) {
        try {
            ECardClient client = new ECardClient();
            client.storeCode = StringUtils.isNotBlank((String)req.getJtczIp()) ? req.getStoreCode() : this.getSysCode(req, "JGDM");
            PacketInfo cardIdPacket = EcardPacket.getCardIdPacket();
            cardIdPacket.setFieldString("CardNo", req.getPassword());
            cardIdPacket.setFieldString("CardReadNo", req.getCodeValue());
            byte[] cardIdData = cardIdPacket.getPacketBytes();
            PacketInfo vicPacket = EcardPacket.getVicPacket();
            byte[] vicData = client.vicQuery(cardIdData);
            ret.setCodeType(vicPacket.getFieldString(vicData, 0, "CardType"));
            ret.setAccountNo(vicPacket.getFieldString(vicData, 0, "CardNo"));
            ret.setBalance(Double.parseDouble(vicPacket.getFieldString(vicData, 0, "RemainAmount")));
            ret.setExpireDate(vicPacket.getFieldString(vicData, 0, "ExpireDate"));
            log.info("\u4e00\u5361\u901a\u50a8\u503c\u5361\u4fe1\u606f\nCardType:" + vicPacket.getFieldString(vicData, 0, "CardType") + "\nCardNo:" + vicPacket.getFieldString(vicData, 0, "CardNo") + "\nCardReadNo:" + vicPacket.getFieldString(vicData, 0, "CardReadNo") + "\nRemainAmount:" + vicPacket.getFieldString(vicData, 0, "RemainAmount") + "\nKeepAmount:" + vicPacket.getFieldString(vicData, 0, "KeepAmount"));
            return true;
        }
        catch (Exception ex) {
            log.info("\u4e00\u5361\u901a\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:" + ex.getMessage());
            ret.setMsg("\u4e00\u5361\u901a\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff1a" + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public boolean sendMzkSale(YktReqDef req, YktRespDef ret) {
        ECardClient client = null;
        try {
            client = new ECardClient();
            client.storeCode = StringUtils.isNotBlank((String)req.getFlowNo()) ? this.getSysCode(req, "JGDM") : req.getStoreCode();
            Vector<byte[]> packets = new Vector<byte[]>();
            PacketInfo cardWithdrawPacket = EcardPacket.getCardWithdrawPacket();
            cardWithdrawPacket.setFieldString("CardType", "0");
            String WithdrawType = "0";
            Object WithdrawAmount = String.valueOf(req.getTradeAmt());
            if (StringUtils.isNotBlank((String)req.getSaleType()) && "1".equals(req.getSaleType())) {
                WithdrawType = "3";
                WithdrawAmount = "-" + (String)WithdrawAmount;
            }
            cardWithdrawPacket.setFieldString("WithdrawType", WithdrawType);
            cardWithdrawPacket.setFieldString("CardReadNo", req.getCodeValue());
            cardWithdrawPacket.setFieldString("StoreCode", "");
            cardWithdrawPacket.setFieldString("PosNo", req.getTerminalNo());
            cardWithdrawPacket.setFieldString("GatherNo", req.getTerminalSno());
            cardWithdrawPacket.setFieldString("Operator", req.getTerminalOperator());
            String rqsj = ManipulateDateTime.getWSDateTimeAll();
            String rq = rqsj.substring(0, 10);
            String sj = rqsj.substring(11, 19);
            req.setTradeDate(rqsj);
            cardWithdrawPacket.setFieldString("Date", rq);
            cardWithdrawPacket.setFieldString("Time", sj);
            cardWithdrawPacket.setFieldString("WritePassword", req.getPassword());
            cardWithdrawPacket.setFieldString("WithdrawAmount", (String)WithdrawAmount);
            String info = cardWithdrawPacket.getPacketString();
            packets.add(cardWithdrawPacket.getPacketBytes());
            int packetCount = packets.size();
            int packetSize = cardWithdrawPacket.getPacketSize();
            int bufferSize = packetCount * cardWithdrawPacket.getPacketSize();
            byte[] buffer = new byte[bufferSize];
            for (int i = 0; i < packetCount; ++i) {
                byte[] tmp = (byte[])packets.get(i);
                System.arraycopy(tmp, 0, buffer, i * packetSize + 0, packetSize);
            }
            byte[] cardWithdrawData = cardWithdrawPacket.getPacketBytes();
            client.cardWithdraw(packetCount, cardWithdrawData);
            ret.setWstranNo(client.getTranId());
            log.info("[" + rqsj + "]transID == " + req.getWstranNo());
            String remainAmount = (String)client.getAmtMap().get(req.getCodeValue());
            ret.setBalance(Double.valueOf(remainAmount).doubleValue());
            String accountNo = (String)client.getCardNoMap().get(req.getCodeValue());
            log.info("accountNo:{}", (Object)accountNo);
            ret.setAccountNo(accountNo);
            ret.setAmount(req.getTradeAmt());
            ret.setBillDate(req.getTradeDate());
            return true;
        }
        catch (Exception ex) {
            ret.setMsg(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public String vicGetTranId(YktReqDef req) {
        log.info("\u83b7\u53d6\u793c\u54c1\u5361\u4ea4\u6613id", (Object)JSONObject.toJSONString((Object)req));
        try {
            TVicClient client = new TVicClient();
            client.storeCode = this.getSysCode(req, "JGDM");
            PacketInfo tVicValidationPacket = EcardPacket.getTVicTranIdPacket();
            tVicValidationPacket.setFieldString("StoreCode", req.getShopCode().substring(0, 4));
            tVicValidationPacket.setFieldString("PosNo", req.getTerminalNo());
            tVicValidationPacket.setFieldString("GatherNo", req.getTerminalSno());
            tVicValidationPacket.setFieldString("Operator", req.getTerminalOperator());
            byte[] cardIdData = tVicValidationPacket.getPacketBytes();
            String tranId = client.tvicQuery(cardIdData);
            log.info("tranId==>{}", (Object)tranId);
            return tranId.trim();
        }
        catch (Exception ex) {
            log.info("\u552e\u5361\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38:" + ex);
            ex.printStackTrace();
            return "";
        }
    }

    public boolean vicCheck(YktReqDef req, YktRespDef ret) {
        try {
            if ("".equals(req.getCodeValue()) || null == req.getCodeValue()) {
                return false;
            }
            boolean flag = false;
            TVicClient client = new TVicClient();
            client.storeCode = this.getSysCode(req, "JGDM");
            PacketInfo tVicValidationPacket = EcardPacket.getTVicValidationPacket();
            tVicValidationPacket.setFieldString("CardNo", req.getCodeValue());
            tVicValidationPacket.setFieldString("ReChargeAmount", String.valueOf(req.getTradeAmt()));
            tVicValidationPacket.setFieldString("StoreCode", req.getShopCode().substring(0, 4));
            tVicValidationPacket.setFieldString("PosNo", req.getTerminalNo());
            tVicValidationPacket.setFieldString("GatherNo", req.getTerminalSno());
            tVicValidationPacket.setFieldString("Operator", req.getTerminalOperator());
            byte[] cardIdData = tVicValidationPacket.getPacketBytes();
            PacketInfo vicPacket = EcardPacket.getTVicPacket();
            flag = client.tvicValidation(cardIdData);
            ret.setCodeType("3");
            ret.setAccountNo(req.getCodeValue());
            ret.setBalance(Double.parseDouble(String.valueOf(req.getTradeAmt())));
            return flag;
        }
        catch (Exception ex) {
            ret.setMsg(ex.getMessage());
            log.info("\u552e\u5361\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38:" + ex);
            ex.printStackTrace();
            return false;
        }
    }

    public boolean sendVicRecharge(YktReqDef req, YktRespDef ret) {
        TVicClient client = null;
        try {
            client = new TVicClient();
            client.storeCode = this.getSysCode(req, "JGDM");
            Vector<byte[]> packets = new Vector<byte[]>();
            PacketInfo tVicRechargePacket = EcardPacket.getTVicRechargePacket();
            tVicRechargePacket.setFieldString("StoreCode", req.getShopCode().substring(0, 4));
            tVicRechargePacket.setFieldString("PosNo", req.getTerminalNo());
            tVicRechargePacket.setFieldString("GatherNo", req.getTerminalSno());
            tVicRechargePacket.setFieldString("Operator", req.getTerminalOperator());
            tVicRechargePacket.setFieldString("VicType", req.getCodeType());
            tVicRechargePacket.setFieldString("CardNo", req.getCodeValue());
            String rqsj = YktSaleBSImpl.getDateTimeAll();
            String rq = rqsj.substring(0, 10);
            String sj = rqsj.substring(11, 19);
            req.setTradeDate(rqsj);
            tVicRechargePacket.setFieldString("Date", rq);
            tVicRechargePacket.setFieldString("Time", sj);
            double chargeAmount = new BigDecimal(req.getTradeAmt()).setScale(6, 4).doubleValue();
            log.info("chargeAmount:{}", (Object)chargeAmount);
            tVicRechargePacket.setFieldString("ReChargeAmount", String.valueOf(chargeAmount));
            tVicRechargePacket.setFieldString("ChargeId", req.getWstranNo());
            String info = tVicRechargePacket.getPacketString();
            log.info("\u6263\u6b3e\u8bf7\u6c42CardWithdrawPacket == " + info);
            packets.add(tVicRechargePacket.getPacketBytes());
            int packetCount = packets.size();
            int packetSize = tVicRechargePacket.getPacketSize();
            int bufferSize = packetCount * tVicRechargePacket.getPacketSize();
            byte[] buffer = new byte[bufferSize];
            for (int i = 0; i < packetCount; ++i) {
                byte[] tmp = (byte[])packets.get(i);
                System.arraycopy(tmp, 0, buffer, i * packetSize + 0, packetSize);
            }
            byte[] vicRechargeData = tVicRechargePacket.getPacketBytes();
            boolean flag = false;
            log.info("\u8c03\u5145\u503c\u63a5\u53e3--");
            flag = client.vicRecharge(packetCount, vicRechargeData);
            ret.setWstranNo(client.getTranId());
            log.info("[" + rqsj + "]transID == " + req.getWstranNo());
            return flag;
        }
        catch (Exception ex) {
            ret.setMsg(ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    public boolean vicCancel(YktReqDef req, YktRespDef ret) {
        try {
            TVicClient client = new TVicClient();
            client.storeCode = this.getSysCode(req, "JGDM");
            PacketInfo tVicValidationPacket = EcardPacket.getTVicCancelPacket();
            tVicValidationPacket.setFieldString("CardNo", req.getCodeValue());
            tVicValidationPacket.setFieldString("ReChargeType", "0");
            tVicValidationPacket.setFieldString("StoreCode", "");
            tVicValidationPacket.setFieldString("PosNo", req.getTerminalNo());
            tVicValidationPacket.setFieldString("GatherNo", req.getTerminalSno());
            tVicValidationPacket.setFieldString("Operator", req.getTerminalOperator());
            String rqsj = YktSaleBSImpl.getDateTimeAll();
            String rq = rqsj.substring(0, 10);
            String sj = rqsj.substring(11, 19);
            req.setTradeDate(rqsj);
            tVicValidationPacket.setFieldString("Date", rq);
            tVicValidationPacket.setFieldString("Time", sj);
            tVicValidationPacket.setFieldString("tranid", req.getWstranNo());
            byte[] cardIdData = tVicValidationPacket.getPacketBytes();
            PacketInfo vicPacket = EcardPacket.getTVicCancelPacket();
            client.vicCancel(cardIdData);
            return true;
        }
        catch (Exception ex) {
            ret.setMsg(ex.getMessage());
            log.info("\u552e\u5361\u5145\u6b63\u51fa\u73b0\u5f02\u5e38:" + ex);
            ex.printStackTrace();
            return false;
        }
    }

    private String getSysCode(YktReqDef yktReqDef, String type) {
        JSONObject object3;
        log.info("\u83b7\u53d6\u914d\u7f6e{}", (Object)type);
        String obj = this.redisUtil.get(RedisKey.CACHEID + yktReqDef.getShopCode() + yktReqDef.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals(type)) continue;
                array.add((Object)sys);
                break;
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        log.info("\u83b7\u53d6\u914d\u7f6e\u7ed3\u679c{}", (Object)paravalue);
        return paravalue;
    }

    public static String getDateTimeAll() {
        Date myDate = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdf.format(myDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase cardWriteOff(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        Order order = cacheModel.getOrder();
        YktReqDef req = new YktReqDef();
        req.setShopCode(order.getShopCode());
        req.setTerminalNo(order.getTerminalNo());
        ECardClient client = null;
        String errmsg = "";
        String jtczip = "";
        try {
            Payment p2;
            jtczip = this.getSysCode(req, "JTCZ");
            log.info("jtczip{}", (Object)jtczip);
            if ("".equals(jtczip)) {
                RespBase respBase = new RespBase(Code.CODE_60.getIndex(), "\u672a\u914d\u7f6e\u96c6\u56e2\u4e00\u5361\u901aIP\u7aef\u53e3\u53c2\u6570", vo.getCacheModel().getFlowNo());
                return respBase;
            }
            GlobalInfo.ytkIp = jtczip.split(":")[0];
            GlobalInfo.ytkPort = Integer.valueOf(jtczip.split(":")[1]);
            client = new ECardClient();
            Vector<byte[]> packets = new Vector<byte[]>();
            boolean isFirst = true;
            int packetSize = 0;
            client.storeCode = this.getSysCode(req, "JGDM");
            int count = 0;
            if (!cacheModel.getOrder().getSendSuccess()) {
                for (Payment p2 : cacheModel.getPayments()) {
                    if (p2.getIsSuccess()) continue;
                    ++count;
                    PacketInfo cardWithdrawPacket = this.getPacketInfo(p2, order, "0");
                    log.info("\u96c6\u4e2d\u6838\u6d88\u6570\u636e\u5305cardWithdrawPacket=={}", (Object)JSONObject.toJSONString((Object)cardWithdrawPacket));
                    packets.add(cardWithdrawPacket.getPacketBytes());
                    if (!isFirst) continue;
                    packetSize = cardWithdrawPacket.getPacketSize();
                    isFirst = false;
                }
            }
            int packetCount = packets.size();
            log.info("count :" + count);
            if (packetCount == 0) {
                log.info("\u6c92\u6709\u9700\u8981\u6838\u92b7\u7684\u4e00\u5361\u901a\u76f4\u63a5\u8fd4\u56de\uff1aflowno" + cacheModel.getFlowNo());
                p2 = new RespBase(Code.SUCCESS, (Object)cacheModel);
                return p2;
            }
            if (count != packetCount) {
                p2 = new RespBase(Code.CODE_50025.getIndex(), "\u4e00\u5361\u901a\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a\u9700\u8981\u6838\u9500\u4e00\u5361\u901a\u4fe1\u606f\u4e0d\u4e00\u81f4");
                return p2;
            }
            int bufferSize = packetCount * packetSize;
            byte[] buffer = new byte[bufferSize];
            for (int i = 0; i < packetCount; ++i) {
                byte[] tmp = (byte[])packets.get(i);
                System.arraycopy(tmp, 0, buffer, i * packetSize + 0, packetSize);
            }
            log.info("\u96c6\u4e2d\u6838\u9500\u5165\u53c2\uff1a" + cacheModel.getFlowNo() + new String(buffer));
            client.cardWithdraw(packetCount, buffer);
            ArrayList<Payment> listPayment = new ArrayList<Payment>();
            for (Payment p3 : cacheModel.getPayments()) {
                if (p3.getIsSuccess()) continue;
                String accountNo = (String)client.getCardNoMap().get(p3.getTrackData());
                String remainAmount = (String)client.getAmtMap().get(p3.getTrackData());
                log.info("accountNo:{}", (Object)accountNo);
                if (!StringUtils.isNotBlank((String)accountNo)) continue;
                p3.setCouponBalance(CastUtil.castDouble((Object)remainAmount));
                p3.setRefCode((String)client.getCardChargeMap().get(p3.getTrackData()));
                p3.setIsSuccess(true);
                if (!"0".equals(remainAmount)) continue;
                log.info("\u8bb0\u5f55\u4f59\u989d\u4e3a0\u652f\u4ed8\u884c");
                listPayment.add(p3);
            }
            if (listPayment.size() > 0) {
                log.info("\u5361\u56de\u6536\u5f00\u59cb");
                this.cardWriteFix(listPayment, client.storeCode, cacheModel);
            }
            cacheModel.setCalcResult(666);
            RespBase respBase = new RespBase(Code.SUCCESS, (Object)cacheModel);
            return respBase;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errmsg = ex.getMessage();
            RespBase respBase = new RespBase(Code.CODE_50025.getIndex(), "\u4e00\u5361\u901a\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a" + ex.getMessage());
            return respBase;
        }
        finally {
            if (!cacheModel.getOrder().getSendSuccess()) {
                for (Payment p : cacheModel.getPayments()) {
                    if (p.getIsSuccess()) continue;
                    return new RespBase(Code.CODE_50025.getIndex(), "\u4e00\u5361\u901a\u96c6\u4e2d\u6838\u9500\u5931\u8d25,\u6709\u672a\u6838\u9500\u7684\u652f\u4ed8\u884c:" + errmsg);
                }
            }
        }
    }

    public RespBase checkVicStatus(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"flowNo") || paramsObject.getString("flowNo").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u793c\u54c1\u5361\u8865\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u793c\u54c1\u5361\u8865\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        log.info("\u4e00\u5361\u901a\u5145\u503c\u8865\u5f55==>{}", (Object)paramsObject.toJSONString());
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043.getIndex(), "\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        if ("U".equals(cacheModel.getOrder().getOrderType())) {
            if (!("Y".equals(cacheModel.getCurTempGrant().getIsgrant()) || "Y".equals(cacheModel.getCurGrant().getIsgrant()) || "Y".equals(cacheModel.getCurYyyInfo().getIsgrant()))) {
                return new RespBase(Code.CODE_60.getIndex(), "\u8be5\u5458\u5de5\u6ca1\u6709\u6388\u6743\u6743\u9650", vo.getCacheModel().getFlowNo());
            }
        } else {
            return new RespBase(Code.CODE_60.getIndex(), "\u8ba2\u5355\u7c7b\u578b\u4e0d\u662f\u5361\u9500\u552e", vo.getCacheModel().getFlowNo());
        }
        cacheModel.setYktFlag(true);
        log.info("\u8bbe\u7f6e\u793c\u54c1\u5361\u8865\u5f55\u5b57\u6bb5");
        cacheModel.getOrder().setExtendFt2("1");
        log.info(cacheModel.getOrder().getExtendFt2());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "YKTCHECKSTATUS")));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "YKTCHECKSTATUS");
    }

    public RespBase cardWriteFix(List<Payment> payments, String storeCode, CacheModel cacheModel) {
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", cacheModel.getFlowNo());
        }
        Order order = cacheModel.getOrder();
        ECardClient client = null;
        try {
            client = new ECardClient();
            Vector<byte[]> packets = new Vector<byte[]>();
            boolean isFirst = true;
            int packetSize = 0;
            client.storeCode = storeCode;
            for (Payment p : payments) {
                PacketInfo cardWithdrawPacket = this.getPacketInfo(p, order, "2");
                log.info("\u50a8\u503c\u5361\u6570\u636e\u5305{}", (Object)JSONObject.toJSONString((Object)cardWithdrawPacket));
                packets.add(cardWithdrawPacket.getPacketBytes());
                if (!isFirst) continue;
                packetSize = cardWithdrawPacket.getPacketSize();
                isFirst = false;
            }
            int packetCount = packets.size();
            if (packetCount == 0) {
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            int bufferSize = packetCount * packetSize;
            byte[] buffer = new byte[bufferSize];
            for (int i = 0; i < packetCount; ++i) {
                byte[] tmp = (byte[])packets.get(i);
                System.arraycopy(tmp, 0, buffer, i * packetSize + 0, packetSize);
            }
            log.info("\u8c03\u7528\u5361\u56de\u6536\u63a5\u53e3");
            client.cardWithdraw(packetCount, buffer);
            log.info("\u8c03\u7528\u5361\u56de\u6536\u63a5\u53e3\u7ed3\u675f");
            return new RespBase(Code.SUCCESS, (Object)cacheModel);
        }
        catch (Exception ex) {
            log.info("\u4e00\u5361\u901a\u96c6\u4e2d\u5361\u56de\u6536\u5931\u6557" + ex.getMessage());
            ex.printStackTrace();
            return new RespBase(Code.CODE_50025.getIndex(), "\u4e00\u5361\u901a\u96c6\u4e2d\u5361\u56de\u6536\u5931\u6557");
        }
    }

    public PacketInfo getPacketInfo(Payment p, Order o, String type) {
        PacketInfo cardWithdrawPacket = EcardPacket.getCardWithdrawPacket();
        cardWithdrawPacket.setFieldString("CardType", type);
        cardWithdrawPacket.setFieldString("WithdrawType", "0");
        cardWithdrawPacket.setFieldString("CardReadNo", p.getTrackData());
        cardWithdrawPacket.setFieldString("StoreCode", "");
        cardWithdrawPacket.setFieldString("PosNo", o.getTerminalNo());
        cardWithdrawPacket.setFieldString("GatherNo", o.getTerminalSno());
        cardWithdrawPacket.setFieldString("Operator", o.getTerminalOperator());
        String rqsj = ManipulateDateTime.getWSDateTimeAll();
        String rq = rqsj.substring(0, 10);
        String sj = rqsj.substring(11, 19);
        cardWithdrawPacket.setFieldString("Date", rq);
        cardWithdrawPacket.setFieldString("Time", sj);
        cardWithdrawPacket.setFieldString("WritePassword", p.getPasswd());
        if ("2".equals(type)) {
            cardWithdrawPacket.setFieldString("WithdrawAmount", "0");
        } else {
            cardWithdrawPacket.setFieldString("WithdrawAmount", String.valueOf(p.getAmount()));
        }
        return cardWithdrawPacket;
    }
}

