/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.model.allVpay.BaseRequest;
import com.efuture.business.model.allVpay.BaseResponse;
import com.efuture.business.model.allVpay.request.PayRequest;
import com.efuture.business.model.allVpay.request.RefundRequest;
import com.efuture.business.model.allVpay.request.SaleQueryRequest;
import com.efuture.business.model.allVpay.request.SubmitRequest;
import com.efuture.business.model.allVpay.request.VoidRequest;
import com.efuture.business.model.allVpay.request.ZhongbaiPayRefundIn;
import com.efuture.business.model.allVpay.request.ZhongbaiSaleQueryIn;
import com.efuture.business.model.allVpay.request.ZhongbaiSaleReserveIn;
import com.efuture.business.model.allVpay.request.ZhongbaiSaleVoidIn;
import com.efuture.business.model.allVpay.response.ZhongbaiData;
import com.efuture.business.model.allVpay.response.ZhongbaiPaymentIn;
import com.efuture.business.service.CommonService;
import com.efuture.business.service.ZhongBaio2oService;
import com.efuture.business.service.ZhongbaiService;
import com.efuture.business.service.impl.ZBPayServiceImpl;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.RSAConfig;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.SocketClientUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ZBPayServiceImpl
extends CommonService
implements ZhongbaiService {
    private static final Logger log = LoggerFactory.getLogger(ZBPayServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ZBPayServiceImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    ZhongBaio2oService ZhongBaiOdsiService;
    @Autowired
    PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    private RestTemplate restTemplate = null;
    public RSAConfig rsaConfig = new RSAConfig();
    @Autowired
    private RedisUtil redisUtil;
    public final String zbIsUpdata = "ZBUP";
    public final String zhongbaiInterface = "ZBHY";
    public static final String ZBMCID = "ZBMCID";

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ZhongbaiPaymentIn in = (ZhongbaiPaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), ZhongbaiPaymentIn.class);
        LOGGER.info("\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)in));
        String emptypara = paramsValidateUtils.getNullField((Object)in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return Code.CODE_500001.getRespBase(new Object[]{emptypara});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        JSONObject jsonObject = JSONObject.parseObject((String)obj);
        if (obj != null) {
            for (int i = 0; i < jsonObject.getJSONArray("paymode").size(); ++i) {
                JSONObject model = jsonObject.getJSONArray("paymode").getJSONObject(i);
                if (!in.getPayCode().equals(model.getString("code"))) continue;
                in.setScene("0");
                in.setRate(model.getDouble("pyhl").doubleValue());
                in.setAuthCode(model.getString("authCode"));
                in.setChargeRate(model.getDouble("zlhl").doubleValue());
                in.setFlag(model.getString("flag"));
                in.setIsAllowCharge(model.getString("iszl"));
                in.setIsOverage(model.getString("isyy"));
                in.setMinVal(model.getBigDecimal("minval").doubleValue());
                in.setMaxVal(model.getBigDecimal("maxval").doubleValue());
                in.setCutMode(model.getString("sswrfs"));
                in.setPrecision(model.getString("sswrjd"));
            }
        }
        if (in.getAmount() < in.getMinVal() || in.getAmount() > in.getMaxVal()) {
            return Code.CODE_50045.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && !"2".equals(cacheModel.getOrder().getOrderType()) && in.getAmount() > cacheModel.getOrder().getRemainValue()) {
            return Code.CODE_500003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        LOGGER.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (remainValue - in.getMoney() < 0.0) {
            return Code.CODE_500003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        ServiceResponse response = this.initRSAConfigByCache(session, cacheModel);
        if (!"0".equals(response.getReturncode())) {
            return Code.FAIL.getRespBase(new Object[]{response.getReturncode(), response.getData()});
        }
        PayRequest payReq = new PayRequest(in, cacheModel, this.rsaConfig);
        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)payReq), null, serviceUrl);
        return this.callSalePayServiceHandle(response, payReq, session, cacheModel, in, 0, "101", vo);
    }

    private RespBase callSalePayServiceHandle(ServiceResponse response, PayRequest payReq, ServiceSession session, CacheModel cacheModel, ZhongbaiPaymentIn in, int queryTimes, String serviceType, ResqVo vo) {
        LOGGER.info("callSalePayServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes, (Object)serviceType);
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        JSONObject jsonObject = JSONObject.parseObject((String)obj);
        if ("0".equals(response.getReturncode())) {
            BaseResponse zhongbaiPayResp = (BaseResponse)response.getData();
            if (BaseResponse.ZBResultCode.SUCCESS.code().equals(zhongbaiPayResp.getResultCode())) {
                if (BaseRequest.ZBServiceType.sale.code().equals(serviceType) || BaseRequest.ZBServiceType.query.code().equals(serviceType)) {
                    if ("0".equals(zhongbaiPayResp.getData().getFactAmt())) {
                        return new RespBase(-1, "\u652f\u4ed8\u5931\u8d25\uff0c\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989dfactAmt =" + zhongbaiPayResp.getData().getFactAmt(), vo.getCacheModel().getFlowNo());
                    }
                    Payment pay = ZhongbaiPaymentIn.creatPrePayment((ZhongbaiPaymentIn)in, (CacheModel)cacheModel);
                    List realPayList = ZhongbaiPaymentIn.creatPayment((Payment)pay, (ZhongbaiData)zhongbaiPayResp.getData());
                    for (int i = 0; i < realPayList.size(); ++i) {
                        boolean havaPayment = false;
                        Payment payment = (Payment)realPayList.get(i);
                        if (obj != null) {
                            for (int k = 0; k < jsonObject.getJSONArray("paymentmethodposref").size(); ++k) {
                                JSONObject paymentmethodposref = jsonObject.getJSONArray("paymentmethodposref").getJSONObject(k);
                                if (!payment.getPayCode().equalsIgnoreCase(paymentmethodposref.getString("posAbleCode"))) continue;
                                String parentPayCode = paymentmethodposref.getString("payCode");
                                for (int j = 0; j < jsonObject.getJSONArray("paymode").size(); ++j) {
                                    JSONObject model = jsonObject.getJSONArray("paymode").getJSONObject(j);
                                    if (!parentPayCode.equals(model.getString("code"))) continue;
                                    log.info("\u7236\u7c7b\u652f\u4ed8\u65b9\u5f0f{}\u6b63\u5e38", (Object)parentPayCode);
                                    havaPayment = true;
                                }
                            }
                            for (int j = 0; j < jsonObject.getJSONArray("paymode").size(); ++j) {
                                JSONObject model = jsonObject.getJSONArray("paymode").getJSONObject(j);
                                if (!payment.getPayCode().equals(model.getString("code"))) continue;
                                log.info("\u751f\u6210\u652f\u4ed8\u65b9\u5f0f{}\u6b63\u5e38", (Object)payment.getPayCode());
                                havaPayment = true;
                            }
                        }
                        if (!havaPayment) {
                            log.info("{}\u652f\u4ed8\u65b9\u5f0f\u4ee3\u7801\u6216\u8005\u7236\u7c7b\u4ee3\u7801\u627e\u4e0d\u5230\u627e\u4e0d\u5230", (Object)payment.getPayCode());
                            VoidRequest voidIn = new VoidRequest(payReq, this.rsaConfig);
                            String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                            response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)voidIn), BaseRequest.ZBServiceType.voidsale.desc(), serviceUrl);
                            return this.callSalePayServiceHandle(response, payReq, session, cacheModel, in, ++queryTimes, BaseRequest.ZBServiceType.voidsale.code(), vo);
                        }
                        LOGGER.info("\u6839\u636e\u5238\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u751f\u6210Payment[{}]", (Object)JSON.toJSONString(realPayList.get(i)));
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, (Payment)realPayList.get(i));
                    }
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    LOGGER.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "ZHONGBAIPAY")));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "ZHONGBAIPAY");
                }
                if (BaseRequest.ZBServiceType.voidsale.code().equals(serviceType)) {
                    LOGGER.info("\u4ed8\u6b3e\u4ea4\u6613\u5931\u8d25\uff0c\u5df2\u51b2\u6b63\u6210\u529f!");
                    return new RespBase(-1, "\u652f\u4ed8\u5931\u8d25\uff0c\u5df2\u51b2\u6b63!", vo.getCacheModel().getFlowNo());
                }
                return new RespBase(-1, "\u652f\u4ed8\u5931\u8d25\uff0c[\u6682\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u7c7b\u578b{0}]", JSON.toJSONString((Object)zhongbaiPayResp));
            }
            if (BaseResponse.ZBResultCode.WAITING.code().equals(zhongbaiPayResp.getResultCode())) {
                RespBase respBase = this.waitingForQuery(queryTimes, session, response);
                if (!"0".equals("" + respBase.getRetflag())) {
                    return Code.FAIL.getRespBase(new Object[]{respBase.getRetflag(), respBase.getData()});
                }
                SaleQueryRequest queryIn = new SaleQueryRequest(payReq, this.rsaConfig);
                String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryIn), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
                return this.callSalePayServiceHandle(response, payReq, session, cacheModel, in, ++queryTimes, BaseRequest.ZBServiceType.query.code(), vo);
            }
            if (BaseResponse.ZBResultCode.FAIL.code().equals(zhongbaiPayResp.getResultCode()) || BaseResponse.ZBResultCode.UNKNOWN.code().equals(zhongbaiPayResp.getResultCode())) {
                if (BaseRequest.ZBServiceType.sale.code().equals(serviceType) || BaseRequest.ZBServiceType.query.code().equals(serviceType)) {
                    VoidRequest voidIn = new VoidRequest(payReq, this.rsaConfig);
                    String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                    response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)voidIn), BaseRequest.ZBServiceType.voidsale.desc(), serviceUrl);
                    return this.callSalePayServiceHandle(response, payReq, session, cacheModel, in, ++queryTimes, BaseRequest.ZBServiceType.voidsale.code(), vo);
                }
                if (BaseRequest.ZBServiceType.voidsale.code().equals(serviceType)) {
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    return Code.FAIL.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25"});
                }
            }
            LOGGER.info("\u5238\u5e73\u53f0\u4ea4\u6613\u5931\u8d25 ServiceResponse=[{}]", (Object)JSON.toJSONString((Object)zhongbaiPayResp));
            return new RespBase(-1, "\u652f\u4ed8\u5931\u8d25", JSON.toJSONString((Object)zhongbaiPayResp));
        }
        return new RespBase(Integer.parseInt(response.getReturncode()), response.getData().toString(), JSON.toJSONString((Object)response));
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ServiceResponse response;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ZhongbaiPayRefundIn in = (ZhongbaiPayRefundIn)JSON.parseObject((String)paramsObject.toJSONString(), ZhongbaiPayRefundIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        JSONObject jsonObject = JSONObject.parseObject((String)obj);
        if (obj != null) {
            for (int i = 0; i < jsonObject.getJSONArray("paymode").size(); ++i) {
                JSONObject model = jsonObject.getJSONArray("paymode").getJSONObject(i);
                if (!in.getPayCode().equals(model.getString("code"))) continue;
                in.setRate(model.getDouble("pyhl").doubleValue());
                in.setCutMode(model.getString("sswrfs"));
                in.setPrecision(model.getString("sswrjd"));
            }
        }
        if (!"0".equals((response = this.initRSAConfigByCache(session, cacheModel = this.posLogicCompoment.calcBalance(cacheModel))).getReturncode())) {
            return Code.FAIL.getRespBase(new Object[]{response.getReturncode(), response.getData()});
        }
        RefundRequest refundReq = new RefundRequest(in, cacheModel, this.rsaConfig);
        Order order = cacheModel.getOrder();
        LOGGER.info("saleRefund \u8ba1\u7b97\u540e\u8ba2\u5355[{}]", (Object)JSON.toJSONString((Object)order));
        if (ManipulatePrecision.doubleCompare((double)in.getMoney(), (double)(order.getRemainValue() * 100.0), (int)1) == 1) {
            return new RespBase(-1, "\u8bf7\u6c42\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u5269\u4f59\u4ed8\u6b3e", vo.getCacheModel().getFlowNo());
        }
        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)refundReq), BaseRequest.ZBServiceType.refund.desc(), serviceUrl);
        return this.callRefundServiceHandle(response, refundReq, session, cacheModel, in, 0, BaseRequest.ZBServiceType.refund.code(), vo);
    }

    private RespBase callRefundServiceHandle(ServiceResponse response, RefundRequest refundReq, ServiceSession session, CacheModel cacheModel, ZhongbaiPayRefundIn in, int queryTimes, String serviceType, ResqVo vo) {
        LOGGER.info("callRefundServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes, (Object)serviceType);
        if ("0".equals(response.getReturncode())) {
            BaseResponse zhongbaiPayResp = (BaseResponse)response.getData();
            if (BaseResponse.ZBResultCode.SUCCESS.code().equals(zhongbaiPayResp.getResultCode())) {
                if (BaseRequest.ZBServiceType.refund.code().equals(serviceType) || BaseRequest.ZBServiceType.query.code().equals(serviceType)) {
                    Payment payment = ZhongbaiPayRefundIn.creatPreRefungPayment((ZhongbaiPayRefundIn)in, (CacheModel)cacheModel);
                    List realRefundPayList = ZhongbaiPayRefundIn.creatRefundPayment((Payment)payment, (ZhongbaiData)zhongbaiPayResp.getData());
                    for (int i = 0; i < realRefundPayList.size(); ++i) {
                        LOGGER.info("\u6839\u636e\u5238\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u751f\u6210Payment[{}]", (Object)JSON.toJSONString(realRefundPayList.get(i)));
                        this.posLogicCompoment.calcPayAmout(cacheModel, (Payment)realRefundPayList.get(i));
                    }
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "ZHONGBAIPREFUND");
                }
                if (BaseRequest.ZBServiceType.voidsale.code().equals(serviceType)) {
                    LOGGER.info("\u9000\u8d27\u4ea4\u6613\u5931\u8d25\uff0c\u5df2\u51b2\u6b63\u6210\u529f!");
                    return new RespBase(Code.CODE_50052, (Object)"\u9000\u6b3e\u5931\u8d25\uff0c\u5df2\u51b2\u6b63!", JSON.toJSONString((Object)response));
                }
                return new RespBase(Code.CODE_50052, (Object)("\u9000\u6b3e\u5931\u8d25\uff0c[\u6682\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u7c7b\u578b]:" + serviceType), JSON.toJSONString((Object)response));
            }
            if (BaseResponse.ZBResultCode.WAITING.code().equals(zhongbaiPayResp.getResultCode())) {
                RespBase respBase = this.waitingForQuery(queryTimes, session, response);
                if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                    return respBase;
                }
                SaleQueryRequest queryIn = new SaleQueryRequest(refundReq, this.rsaConfig);
                String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryIn), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
                return this.callRefundServiceHandle(response, refundReq, session, cacheModel, in, ++queryTimes, BaseRequest.ZBServiceType.query.code(), vo);
            }
            if (BaseResponse.ZBResultCode.FAIL.code().equals(zhongbaiPayResp.getResultCode()) || BaseResponse.ZBResultCode.UNKNOWN.code().equals(zhongbaiPayResp.getResultCode())) {
                return new RespBase(-1, zhongbaiPayResp.getResultCode(), JSON.toJSONString((Object)zhongbaiPayResp));
            }
            return new RespBase(-1, zhongbaiPayResp.getResultCode(), JSON.toJSONString((Object)response));
        }
        return new RespBase(-1, "\u9000\u6b3e\u901a\u4fe1\u5931\u8d25", JSON.toJSONString((Object)response));
    }

    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ServiceResponse response;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ZhongbaiSaleQueryIn in = (ZhongbaiSaleQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), ZhongbaiSaleQueryIn.class);
        String emptypara = paramsValidateUtils.getNullField((Object)in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return new RespBase(-1, "\u5220\u9664\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570:", emptypara);
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        JSONObject jsonObject = JSONObject.parseObject((String)obj);
        if (obj != null) {
            for (int i = 0; i < jsonObject.getJSONArray("paymode").size(); ++i) {
                JSONObject model = jsonObject.getJSONArray("paymode").getJSONObject(i);
                if (!in.getPayCode().equals(model.getString("code"))) continue;
                in.setRate(model.getDouble("pyhl").doubleValue());
                in.setCutMode(model.getString("sswrfs"));
                in.setPrecision(model.getString("sswrjd"));
            }
        }
        if (!"0".equals((response = this.initRSAConfigByCache(session, cacheModel)).getReturncode())) {
            return Code.FAIL.getRespBase(new Object[]{response.getReturncode(), response.getData()});
        }
        SaleQueryRequest queryRequest = new SaleQueryRequest(in, this.rsaConfig, cacheModel);
        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryRequest), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
        return this.callTransQueryServiceHandle(response, queryRequest, session, cacheModel, in, 0, BaseRequest.ZBServiceType.query.code(), vo);
    }

    private RespBase callTransQueryServiceHandle(ServiceResponse response, SaleQueryRequest queryReq, ServiceSession session, CacheModel cacheModel, ZhongbaiSaleQueryIn in, int queryTimes, String serviceType, ResqVo vo) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes, (Object)serviceType);
        if ("0".equals(response.getReturncode())) {
            BaseResponse zhongbaiResp = (BaseResponse)response.getData();
            if (BaseResponse.ZBResultCode.SUCCESS.code().equals(zhongbaiResp.getResultCode())) {
                Boolean hasPayment = false;
                List cacheList = cacheModel.getPayments();
                for (Payment payment : cacheList) {
                    if (!payment.getBatchNo().equals(in.getOrderNo()) && !payment.getBatchNo().equals(in.getRefundNo())) continue;
                    cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
                    hasPayment = true;
                    break;
                }
                if (!hasPayment.booleanValue()) {
                    Payment payment = ZhongbaiSaleQueryIn.creatPrePayment((ZhongbaiSaleQueryIn)in, (CacheModel)cacheModel);
                    List PayList = ZhongbaiSaleQueryIn.creatPayment((Payment)payment, (ZhongbaiData)zhongbaiResp.getData(), (String)in.getQueryType());
                    for (int i = 0; i < PayList.size(); ++i) {
                        LOGGER.info("\u6839\u636e\u5238\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u751f\u6210Payment[{}]", (Object)JSON.toJSONString(PayList.get(i)));
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, (Payment)PayList.get(i));
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ZHONGBAIQUERY");
            }
            if (BaseResponse.ZBResultCode.WAITING.code().equals(zhongbaiResp.getResultCode())) {
                RespBase respBase = this.waitingForQuery(queryTimes, session, response);
                if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                    return respBase;
                }
                String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryReq), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
                return this.callTransQueryServiceHandle(response, queryReq, session, cacheModel, in, ++queryTimes, serviceType, vo);
            }
            return new RespBase(-1, zhongbaiResp.getResultCode(), JSON.toJSONString((Object)zhongbaiResp));
        }
        return new RespBase(-1, response.getReturncode(), JSON.toJSONString((Object)response));
    }

    public RespBase saleRepealPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        ZhongbaiSaleVoidIn in = (ZhongbaiSaleVoidIn)JSON.parseObject((String)paramsObject.toJSONString(), ZhongbaiSaleVoidIn.class);
        String emptypara = paramsValidateUtils.getNullField((Object)in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return new RespBase(-1, "\u5220\u9664\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570:", emptypara);
        }
        if ("0".equals(in.getVoidType()) && StringUtils.isEmpty((String)in.getPuid())) {
            return new RespBase(-1, "\u5220\u9664\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570:", "\u4ed8\u6b3e\u884c\u552f\u4e00\u6807\u8bc6");
        }
        if (StringUtils.isEmpty((String)in.getOrderNo()) && StringUtils.isEmpty((String)in.getRefundNo())) {
            return new RespBase(-1, "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570:", "\u8ba2\u5355\u53f7\u6216\u8005\u9000\u6b3e\u8ba2\u5355\u53f7");
        }
        LOGGER.info("saleRepealPay,\u5165\u53c2\u2014\u2014\u2014\u2014>[{}]", (Object)JSON.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(-1, "\u8ba2\u5355\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f:", in.getFlowNo());
        }
        ServiceResponse response = this.initRSAConfigByCache(session, cacheModel);
        if (!"0".equals(response.getReturncode())) {
            return Code.FAIL.getRespBase(new Object[]{response.getReturncode(), response.getData()});
        }
        VoidRequest request = new VoidRequest(in, this.rsaConfig, cacheModel);
        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)request), BaseRequest.ZBServiceType.voidsale.desc(), serviceUrl);
        return this.callVoidSaleServiceHandle(response, request, session, cacheModel, in, 0, BaseRequest.ZBServiceType.voidsale.code(), vo);
    }

    private RespBase callVoidSaleServiceHandle(ServiceResponse response, VoidRequest voidReq, ServiceSession session, CacheModel cacheModel, ZhongbaiSaleVoidIn in, int queryTimes, String serviceType, ResqVo vo) {
        LOGGER.info("callVoidSaleServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes, (Object)serviceType);
        if ("0".equals(response.getReturncode())) {
            BaseResponse zhongbaiResp = (BaseResponse)response.getData();
            if (BaseResponse.ZBResultCode.SUCCESS.code().equals(zhongbaiResp.getResultCode())) {
                if ("0".equals(in.getVoidType())) {
                    String refCode = "";
                    String puid = in.getPuid();
                    List oldPay = cacheModel.getPayments();
                    LOGGER.info("CacheModel payments==>{}", (Object)JSONObject.toJSONString((Object)oldPay));
                    for (Payment p : oldPay) {
                        if (!p.getPuid().equals(puid)) continue;
                        refCode = p.getBatchNo();
                        break;
                    }
                    if (!StringUtils.isEmpty((String)refCode)) {
                        Iterator it = oldPay.iterator();
                        while (it.hasNext()) {
                            Payment itPay = (Payment)it.next();
                            if (!refCode.equals(itPay.getBatchNo())) continue;
                            LOGGER.info("\u64a4\u9500\u4ed8\u6b3e\u884cpuid=[{}]", (Object)itPay.getPuid());
                            it.remove();
                        }
                        if ((cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel)).getCalcResult() == -1) {
                            String errCode = "100000";
                            if (cacheModel.getErrCode().length() > 0) {
                                errCode = cacheModel.getErrCode();
                            }
                            return new RespBase(-1, errCode, cacheModel.getErrMsg());
                        }
                    }
                } else {
                    List voidPayList = cacheModel.getReturnPayments();
                    LOGGER.info("[" + in.getFlowNo() + "]saleRepealPay returnPayments-->[{}]", (Object)JSON.toJSONString((Object)voidPayList));
                    if (cacheModel.getPayments().size() > 0) {
                        LOGGER.info("[" + in.getFlowNo() + "]saleRepealPay Payments-->[{}]", (Object)JSON.toJSONString((Object)cacheModel.getPayments()));
                    }
                    List voidPay = ZhongbaiSaleVoidIn.creatVoidPayment((ZhongbaiSaleVoidIn)in, (List)voidPayList, (CacheModel)cacheModel);
                    for (int i = 0; i < voidPay.size(); ++i) {
                        LOGGER.info("\u6839\u636e\u5238\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u751f\u6210Payment==>{}", (Object)JSON.toJSONString(voidPay.get(i)));
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, (Payment)voidPay.get(i));
                    }
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "ZHONGBAIREVOKE");
            }
            if (BaseResponse.ZBResultCode.WAITING.code().equals(zhongbaiResp.getResultCode())) {
                RespBase respBase = this.waitingForQuery(queryTimes, session, response);
                if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                    return respBase;
                }
                SaleQueryRequest queryIn = new SaleQueryRequest(voidReq, this.rsaConfig);
                String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryIn), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
                return this.callVoidSaleServiceHandle(response, voidReq, session, cacheModel, in, ++queryTimes, BaseRequest.ZBServiceType.query.code(), vo);
            }
            return new RespBase(-1, zhongbaiResp.getResultCode(), JSON.toJSONString((Object)response));
        }
        return new RespBase(-1, "\u51b2\u6b63\u901a\u4fe1\u5931\u8d25", JSON.toJSONString((Object)response.getData()));
    }

    public void saleSubmit(CacheModel cacheModel, ResqVo vo, ServiceSession session) {
        try {
            String obj = this.redisUtil.get(RedisKey.CACHEID + vo.getCacheModel().getOrder().getShopCode() + vo.getCacheModel().getOrder().getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            List syspara = modeDetailsVo.getSyspara();
            LOGGER.info("\u5f00\u59cbsaleSubmit!");
            String isNeedUpdataPara = cacheModel.getOrder().getSysPara().isSendCust;
            String hyPara = cacheModel.getOrder().getSysPara().custUrl;
            String custMode = cacheModel.getOrder().getSysPara().custMode;
            ServiceResponse response = this.initRSAConfigByCache(session, cacheModel);
            if (!"0".equals(response.getReturncode())) {
                return;
            }
            SubmitRequest subReq = new SubmitRequest(cacheModel, this.rsaConfig);
            LOGGER.info("saleSubmit syspara[ZBUP]=[{}]", (Object)isNeedUpdataPara);
            if (StringUtils.isBlank((String)hyPara)) {
                LOGGER.info("[\u5238\u5e73\u53f0\u8fdc\u7a0b\u63a5\u53e3\u914d\u7f6e\u4e0d\u5bf9]\uff0c\u5238\u5e73\u53f0\u4e0a\u9001\u5931\u8d25 \uff0c\u7ee7\u7eed\u63d0\u4ea4\u8ba2\u5355 !");
                return;
            }
            String methodRouter = custMode;
            if (!"1".equals(custMode) && !"2".equals(custMode)) {
                LOGGER.info("[\u5238\u5e73\u53f0\u63a5\u53e3\u8def\u7531\u914d\u7f6e\u9519\u8bef] ,\u4e0a\u4f20\u5238\u5e73\u53f0\u5931\u8d25 ,\u7ee7\u7eed\u63d0\u4ea4\u8ba2\u5355 !");
                return;
            }
            if (!"1".equals(custMode) && hyPara.indexOf(":") < 0) {
                LOGGER.info("[\u5238\u5e73\u53f0\u8fdc\u7a0b\u63a5\u53e3socket\u5730\u5740\u914d\u7f6e\u4e0d\u5bf9]\uff0c\u5238\u5e73\u53f0\u4e0a\u9001\u5931\u8d25 \uff0c\u7ee7\u7eed\u63d0\u4ea4\u8ba2\u5355 !");
                return;
            }
            String hyAddress = hyPara;
            if (!UploadType.noneUpload.code().equals(isNeedUpdataPara)) {
                if (UploadType.allUpload.code().equals(isNeedUpdataPara)) {
                    if ("2".equals(methodRouter)) {
                        String[] result;
                        String responses = this.saleSubmitSocket(cacheModel, session, hyAddress);
                        if (StringUtils.isNotBlank((String)responses) && (result = responses.split("|")).length > 0) {
                            cacheModel.getOrder().setPointNum(Double.parseDouble(result[3]));
                        }
                    } else {
                        String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)subReq), BaseRequest.ZBServiceType.submit.desc(), serviceUrl);
                        this.callSubmitServiceHandle(response, subReq, session, cacheModel, 0, BaseRequest.ZBServiceType.submit.code(), vo);
                    }
                } else if (cacheModel.getOrder().getConsumersData() != null && !StringUtils.isEmpty((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                    LOGGER.info("\u4f1a\u5458\u5df2\u767b\u5f55\uff0c\u5f00\u59cb\u4e0a\u4f20\u8ba2\u5355\u5238\u5e73\u53f0 !");
                    if ("2".equals(methodRouter)) {
                        String[] result;
                        String responses = this.saleSubmitSocket(cacheModel, session, hyAddress);
                        if (StringUtils.isNotBlank((String)responses) && (result = responses.split("|")).length > 0) {
                            cacheModel.getOrder().setPointNum(Double.parseDouble(result[3]));
                        }
                    } else {
                        Objects.requireNonNull(this.ZhongBaiOdsiService);
                        String serviceUrl = ModeDetailsVo.getSysParaValue((List)syspara, (String)"HYPU");
                        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)subReq), BaseRequest.ZBServiceType.submit.desc(), serviceUrl);
                        this.callSubmitServiceHandle(response, subReq, session, cacheModel, 0, BaseRequest.ZBServiceType.submit.code(), vo);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[" + cacheModel.getFlowNo() + "]\u5238\u5e73\u53f0\u4ea4\u6613\u4e0a\u9001\u5931\u8d25{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    private RespBase callSubmitServiceHandle(ServiceResponse response, SubmitRequest subReq, ServiceSession session, CacheModel cacheModel, int queryTimes, String serviceType, ResqVo vo) {
        LOGGER.info("[" + cacheModel.getFlowNo() + "]callSubmitServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes, (Object)serviceType);
        if ("0".equals(response.getReturncode())) {
            BaseResponse zhongbaiResp = (BaseResponse)response.getData();
            if (BaseResponse.ZBResultCode.SUCCESS.code().equals(zhongbaiResp.getResultCode())) {
                return Code.SUCCESS.getRespBase(new Object[0]);
            }
            if (BaseResponse.ZBResultCode.WAITING.code().equals(zhongbaiResp.getResultCode())) {
                RespBase respBase = this.waitingForQuery(queryTimes, session, response);
                if (!"0".equals("" + respBase.getRetflag())) {
                    response.setReturncode("" + respBase.getRetflag());
                    response.setData(respBase.getData());
                    return Code.SUCCESS.getRespBase(new Object[0]);
                }
                SaleQueryRequest queryIn = new SaleQueryRequest(subReq, this.rsaConfig);
                String serviceUrl = cacheModel.getOrder().getSysPara().payUrl;
                response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryIn), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
                return this.callSubmitServiceHandle(response, subReq, session, cacheModel, ++queryTimes, BaseRequest.ZBServiceType.query.code(), vo);
            }
            LOGGER.info("\u4e2d\u767e\u5238\u5e73\u53f0\u4e0a\u9001\u5931\u8d25!");
            return Code.FAIL.getRespBase(new Object[0]);
        }
        LOGGER.info("\u4ea4\u6613\u4e0a\u9001\u901a\u4fe1\u5931\u8d25\u539f\u56e0[{}]", response.getData());
        return Code.FAIL.getRespBase(new Object[0]);
    }

    public ServiceResponse saleReserve(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validateWithOutFlowNo()) {
            return paramsValidateUtils.getServiceResponse();
        }
        ZhongbaiSaleReserveIn in = (ZhongbaiSaleReserveIn)JSON.parseObject((String)paramsObject.toJSONString(), ZhongbaiSaleReserveIn.class);
        String emptypara = paramsValidateUtils.getNullField((Object)in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        ServiceResponse response = this.initRSAConfigByPara(session, in.getShopCode(), in.getErpCode());
        if (!"0".equals(response.getReturncode())) {
            return response;
        }
        VoidRequest request = new VoidRequest(in, this.rsaConfig);
        String serviceUrl = "";
        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)request), BaseRequest.ZBServiceType.voidsale.desc(), serviceUrl);
        return this.callReserveSaleServiceHandle(response, request, session, in, 0, BaseRequest.ZBServiceType.voidsale.code(), serviceUrl);
    }

    private ServiceResponse callReserveSaleServiceHandle(ServiceResponse response, VoidRequest voidReq, ServiceSession session, ZhongbaiSaleReserveIn in, int queryTimes, String serviceType, String serviceUrl) {
        LOGGER.info("callVoidSaleServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes, (Object)serviceType);
        if ("0".equals(response.getReturncode())) {
            BaseResponse zhongbaiResp = (BaseResponse)response.getData();
            if (BaseResponse.ZBResultCode.SUCCESS.code().equals(zhongbaiResp.getResultCode())) {
                return ServiceResponse.buildSuccess((Object)zhongbaiResp.getData());
            }
            if (BaseResponse.ZBResultCode.WAITING.code().equals(zhongbaiResp.getResultCode())) {
                RespBase respBase = this.waitingForQuery(queryTimes, session, response);
                if (!"0".equals("" + respBase.getRetflag())) {
                    return response;
                }
                SaleQueryRequest queryIn = new SaleQueryRequest(voidReq, this.rsaConfig);
                response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)queryIn), BaseRequest.ZBServiceType.query.desc(), serviceUrl);
                return this.callReserveSaleServiceHandle(response, voidReq, session, in, ++queryTimes, BaseRequest.ZBServiceType.query.code(), serviceUrl);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)zhongbaiResp.getResultCode(), (String)JSON.toJSONString((Object)response));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u51b2\u6b63\u901a\u4fe1\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{response.getData()});
    }

    public String saleSubmitSocket(CacheModel cacheModel, ServiceSession session, String Address) throws IOException {
        String[] ippara = Address.split(":");
        String ip = ippara[0];
        int port = Integer.valueOf(ippara[1]);
        String tranID = this.ZhongBaiOdsiService.getTrainID(cacheModel, ip, port);
        LOGGER.info("[" + cacheModel.getFlowNo() + "]\u83b7\u53d6TranID =[{}]", (Object)tranID);
        if (StringUtils.isEmpty((String)tranID)) {
            LOGGER.info("[" + cacheModel.getFlowNo() + "]\u83b7\u53d6TranID\u5931\u8d25\uff0csocket\u4e0a\u4f20\u5238\u5e73\u53f0\u5931\u8d25 \uff0c\u7ee7\u7eed\u4e0a\u4f20\u8ba2\u5355! ");
            return null;
        }
        String req = this.ZhongBaiOdsiService.packageSubmitReq(cacheModel, this.rsaConfig, tranID);
        LOGGER.info("[" + cacheModel.getFlowNo() + "][\u4e2d\u767e\u5238\u5e73\u53f0] -->[\u4f1a\u5458\u9500\u552e\u6570\u636e] ip[{}] ,port[{}] \u8bf7\u6c42\u62a5\u6587 [{}]", new Object[]{ip, port, req});
        String returnMsg = SocketClientUtil.sendCIPMessage((String)req, (String)ip, (Integer)port, (Integer)0, (int)this.rsaConfig.getSocketTimeout());
        LOGGER.info("[" + cacheModel.getFlowNo() + "][\u4e2d\u767e\u5238\u5e73\u53f0] -->[\u4f1a\u5458\u9500\u552e\u6570\u636e]\u8fd4\u56de\u62a5\u6587 [{}]", (Object)returnMsg);
        return returnMsg;
    }

    private static boolean validateReturnMsg(String returnMsg) {
        String lengStr = returnMsg.substring(0, 6);
        int leng = Integer.valueOf(lengStr);
        String msgStr = returnMsg.substring(6);
        try {
            byte[] bt = msgStr.getBytes("GB2312");
            if (leng != bt.length) {
                LOGGER.info("\u8fd4\u56de\u62a5\u6587\u957f\u5ea6\u4e0d\u5408\u6cd5!");
                return false;
            }
            String[] returnMsgArr = returnMsg.split("\\|");
            if (!"0".equals(returnMsgArr[1])) {
                LOGGER.info("\u4e0a\u9001\u5931\u8d25,errcode[{}] errmsg", (Object)returnMsgArr[1], (Object)returnMsgArr[2]);
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info("\u4ea4\u6613\u5931\u8d25\uff0c[{}]", (Object)e.toString());
            e.printStackTrace();
        }
        return true;
    }

    public RespBase waitingForQuery(int queryTimes, ServiceSession session, ServiceResponse response) {
        BaseResponse zhongbaiResp = (BaseResponse)response.getData();
        if (queryTimes >= 5) {
            return Code.CODE_50015.getRespBase(new Object[]{"\u652f\u4ed8\u8d85\u65f6!"});
        }
        long nti = zhongbaiResp.getData().getNti();
        try {
            if (0L == nti) {
                Thread.sleep(12000L);
            } else {
                Thread.sleep(zhongbaiResp.getData().getNti());
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("\u5904\u7406\u5f02\u5e38:{}", (Throwable)e);
            e.printStackTrace();
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public ServiceResponse initRSAConfigByCache(ServiceSession session, CacheModel cacheModel) {
        String mcId = cacheModel.getOrder().getSysPara().outErpCode;
        if (StringUtils.isEmpty((String)mcId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7f13\u5b58\u83b7\u53d6\u5546\u6237\u7ecf\u8425\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.rsaConfig.setMcId(mcId);
        return ServiceResponse.buildSuccess(null);
    }

    public ServiceResponse initRSAConfigByPara(ServiceSession session, String shopCode, String erpCode) {
        String mcId = this.getMCIDfromSysPara(session, shopCode, erpCode);
        if (StringUtils.isEmpty((String)mcId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u5546\u6237\u7ecf\u8425\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.rsaConfig.setMcId(mcId);
        return ServiceResponse.buildSuccess(null);
    }

    public String getMCIDfromSysPara(ServiceSession session, String shopCode, String erpCode) {
        String mcid = "";
        return mcid;
    }

    public static void main(String[] args) {
        String returnMsg = "000150MS||92C95908941176CEE0530D0217AC9E7D|1|1|2150998|0002|190926012362|20190926015823|||093605|||0|2362#959600|1.0|3.0|3.0|093605|1|0|%||0375|#01|3.0||1|1";
        returnMsg = "000010MS|1||2362";
        ZBPayServiceImpl.validateReturnMsg((String)returnMsg);
    }
}

