/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.request.PaymentIn;
import com.efuture.business.service.localize.PaySaleBSImpl_WSLF;
import com.efuture.business.util.ParamsValidateUtils;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaySaleBSImpl_TZCS
extends PaySaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(PaySaleBSImpl_TZCS.class);

    public RespBase Payment(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        JSONObject object3;
        log.info("\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[0]);
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"amount"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payCode"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payName"});
        }
        if (!paramsObject.containsKey((Object)"flag") || paramsObject.getString("flag").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"flag"});
        }
        if (!paramsObject.containsKey((Object)"scene") || paramsObject.getString("scene").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"scene"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getString("rate").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"rate"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"precision"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"cutMode"});
        }
        if (!paramsObject.containsKey((Object)"maxVal") || paramsObject.getDouble("maxVal").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"maxVal"});
        }
        if (!paramsObject.containsKey((Object)"isAllowCharge") || paramsObject.getString("isAllowCharge").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"isAllowCharge"});
        }
        if (!paramsObject.containsKey((Object)"isOverage") || paramsObject.getString("isOverage").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"isOverage"});
        }
        if (!paramsObject.containsKey((Object)"minVal") || paramsObject.getDouble("minVal").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"minVal"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        PaymentIn in = (PaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), PaymentIn.class);
        log.info("PaymentIn\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        double tmpRAmt = cacheModel.getOrder().getNewRateRemainValue();
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        String paravalue = "1";
        String[] hlms = null;
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (sys.get((Object)"code").equals("OZ")) {
                    array.add((Object)sys);
                }
                if (!sys.get((Object)"code").equals("HLMS")) continue;
                hlms = sys.getString("paravalue").split("\\|");
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        double rate = 0.0;
        String rateMode = "";
        String isOpenRateMode = "";
        String code = "";
        String jdms = "";
        if (null != hlms && hlms.length >= 3) {
            rate = Double.parseDouble((String)hlms[0]);
            rateMode = hlms[1];
            isOpenRateMode = hlms[2];
            code = hlms[4];
            jdms = hlms[5];
        }
        String[] temp = paravalue.split(",");
        int maxSalePayCount = Integer.valueOf(temp[1]);
        if (cacheModel.getPayments().size() >= maxSalePayCount) {
            return Code.CODE_50044.getRespBase(new Object[0]);
        }
        if (in.getAmount() < in.getMinVal() || in.getAmount() > in.getMaxVal()) {
            return new RespBase(Code.CODE_50045, vo.getCacheModel().getFlowNo());
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && !"2".equals(cacheModel.getOrder().getOrderType()) && in.getAmount() > ManipulatePrecision.getMoneyByPrecision((double)cacheModel.getOrder().getRemainValue(), (String)in.getCutMode(), (String)in.getPrecision()) && !"Y".equals(in.getIsOverage())) {
            return Code.CODE_500003.getRespBase(new Object[0]);
        }
        log.info("\u8ba1\u7b97\u5269\u4f59\u4ed8\u6b3e");
        Payment pay = PaymentIn.creatPayment((PaymentIn)in, (CacheModel)cacheModel);
        if ("1".equals(in.getScene())) {
            pay.setIsAutoDelOnly(true);
            pay.setIsDirectDel(false);
        }
        if (null != hlms && "Y".equals(in.getIsCalcForRate()) && 0.0 != in.getNewRateAmt()) {
            if (cacheModel.getOrder().getNewRateRemainValue() == in.getNewRateAmt()) {
                pay.setMoney(cacheModel.getOrder().getRemainValue());
                pay.setAmount(cacheModel.getOrder().getRemainValue());
            } else {
                pay.setMoney(ManipulatePrecision.doubleConvert((double)ManipulatePrecision.div((double)in.getNewRateAmt(), (double)rate), (int)2, (int)1));
                pay.setAmount(ManipulatePrecision.doubleConvert((double)ManipulatePrecision.div((double)in.getNewRateAmt(), (double)rate), (int)2, (int)1));
            }
            pay.setAdditionalData(new BigDecimal(String.valueOf(in.getNewRateAmt())).toPlainString());
            pay.setDeliveryMemoNumber(hlms[0]);
        }
        if ((cacheModel = this.posLogicService.CalcOrderAmountByPayReturn(cacheModel, pay)).getCalcResult() == -1) {
            String errCode = String.valueOf(Code.CODE_500000.getIndex());
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            Code.FAIL.setMsg(cacheModel.getErrMsg());
            return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
        }
        if (null != hlms) {
            for (Payment payment : cacheModel.getPayments()) {
                if (!"2".equals(payment.getFlag())) continue;
                log.info("payment.getPayCode()=====\u300b" + payment.getPayCode());
                log.info("code=====\u300b" + code);
                if (in.getPayCode().equals(code)) {
                    log.info("in.getNewRateAmt()=====\u300b" + in.getNewRateAmt());
                    log.info("cacheModel.getOrder().getNewRateRemainValue()=====\u300b" + tmpRAmt);
                    payment.setAdditionalData(String.valueOf(ManipulatePrecision.getDetailOverFlow((double)(in.getNewRateAmt() - tmpRAmt), (String)jdms)));
                } else {
                    payment.setAdditionalData(String.valueOf(this.posLogicCompoment.getNewRateAmt(payment.getAmount(), sysParaList)));
                }
                payment.setDeliveryMemoNumber(hlms[0]);
                break;
            }
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "PAYCERTIFY");
    }
}

