/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MzkSaleUtil {
    public static MzkIn getMzkIn(ServiceSession session, JSONObject paramsObject, RedisUtil redisUtil) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            throw new EfutureException(Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"}));
        }
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]"}));
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]"}));
        }
        if (!paramsObject.containsKey((Object)"orderNo") || paramsObject.getString("orderNo").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5916\u90e8\u6d41\u6c34]"}));
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]"}));
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u4ee3\u7801]"}));
        }
        JSONObject modeDetailsVo = MzkSaleUtil.getRedisData((JSONObject)paramsObject, (RedisUtil)redisUtil);
        if (!modeDetailsVo.containsKey((Object)"syjmain")) {
            throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u652f\u4ed8\u83b7\u53d6\u6536\u94f6\u673a\u6478\u7248\u4e3a\u7a7a!"}));
        }
        JSONObject syjMain = modeDetailsVo.getJSONObject("syjmain");
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)modeDetailsVo);
        if (null == mzkPayMode) {
            throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u652f\u4ed8\u83b7\u53d6\u4ed8\u6b3e\u65b9\u5f0f\u4e3a\u7a7a!"}));
        }
        MzkIn mzkIn = MzkSaleUtil.loadRequestPara((JSONObject)paramsObject, (JSONObject)syjMain, (PaymentMode)mzkPayMode);
        return mzkIn;
    }

    public static JSONObject getRedisData(JSONObject paramsObject, RedisUtil redisUtil) {
        String obj = redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        return JSONObject.parseObject((String)obj);
    }

    public static MzkIn loadRequestPara(JSONObject paramsObject, JSONObject syjMain, PaymentMode mzkPayMode) {
        MzkIn in = MzkSaleUtil.loadRequestPara((JSONObject)paramsObject);
        in.setMemo(paramsObject.getString("memo"));
        if (paramsObject.containsKey((Object)"balance")) {
            in.setBalance(paramsObject.getDouble("balance").doubleValue());
        } else {
            in.setBalance(0.0);
        }
        in.setCutMode(mzkPayMode.getSswrfs());
        in.setPrecision(String.valueOf(mzkPayMode.getSswrjd()));
        in.setPayName(mzkPayMode.getName());
        in.setPayType(mzkPayMode.getPaytype());
        in.setRate(mzkPayMode.getZlhl().doubleValue());
        if (StringUtils.isNotBlank((String)mzkPayMode.getIszl())) {
            in.setIsAllowCharge(mzkPayMode.getIszl());
        } else {
            in.setIsAllowCharge("N");
        }
        if (StringUtils.isNotBlank((String)mzkPayMode.getIsyy())) {
            in.setIsOverage(mzkPayMode.getIsyy());
        } else {
            in.setIsOverage("N");
        }
        if (syjMain != null && syjMain.containsKey((Object)"erpCode")) {
            in.setErpcode(syjMain.getString("erpCode"));
        }
        return in;
    }

    public static Payment buildPayment(MzkIn mzkIn) {
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setRefCode(mzkIn.getOrderNo());
        payment.setPayCode(mzkIn.getPayCode());
        payment.setPayName(mzkIn.getPayName());
        payment.setPayType(mzkIn.getPayType());
        payment.setPayNo(mzkIn.getCardNo());
        payment.setPasswd(mzkIn.getPasswd());
        payment.setTrackData(mzkIn.getCardNo());
        payment.setAmount(mzkIn.getAmount());
        payment.setMoney(mzkIn.getAmount());
        payment.setTerminalNo(mzkIn.getTerminalNo());
        payment.setTerminalSno(mzkIn.getInvno());
        payment.setPrecision(mzkIn.getPrecision());
        payment.setPrcutMode(mzkIn.getCutMode());
        payment.setRate(mzkIn.getRate());
        payment.setFlag("1");
        payment.setIsAllowCharge(mzkIn.getIsAllowCharge());
        payment.setIsOverage(mzkIn.getIsOverage());
        return payment;
    }

    public static MzkIn loadRequestPara(JSONObject paramsObject) {
        MzkIn in = new MzkIn();
        in.setShopCode(paramsObject.getString("shopCode"));
        in.setCardNo(paramsObject.getString("cardNo"));
        in.setPasswd(paramsObject.getString("passwd"));
        in.setAmount(paramsObject.getDouble("amount").doubleValue());
        in.setInvno(paramsObject.getString("terminalSno"));
        in.setPayCode(paramsObject.getString("payCode"));
        in.setOrderNo(paramsObject.getString("orderNo"));
        if (StringUtils.isNotBlank((String)paramsObject.getString("mzkTerminalNo"))) {
            in.setMzkTerminalNo(paramsObject.getString("mzkTerminalNo"));
        } else {
            in.setMzkTerminalNo(paramsObject.getString("terminalNo"));
        }
        in.setTerminalOperator(paramsObject.getString("terminalOperator"));
        in.setPuid(UUIDUtils.buildPuid());
        return in;
    }
}

