/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureUtil {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtil.class);
    private static final String charcterCode = "UTF-8";

    public static String sign(Signature signature, String data, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        log.info("PrivateKey====>{}", (Object)privateKey);
        signature.initSign(privateKey);
        signature.update(data.getBytes(charcterCode));
        byte[] signBytes = signature.sign();
        return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])signBytes));
    }

    public static boolean verify(Signature signature, String data, String sign, PublicKey publicKey) throws UnsupportedEncodingException {
        if (data == null || sign == null || publicKey == null) {
            return false;
        }
        byte[] signBytes = org.bouncycastle.util.encoders.Base64.decode((byte[])sign.getBytes(charcterCode));
        try {
            signature.initVerify(publicKey);
            signature.update(data.getBytes(charcterCode));
            return signature.verify(signBytes);
        }
        catch (Exception e) {
            log.error("SignatureUtil verify error: {}", (Throwable)e);
            return false;
        }
    }

    public static String encodeBase64(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static byte[] decodeBase64(byte[] bytes) {
        byte[] result = null;
        try {
            result = Base64.decodeBase64((byte[])bytes);
        }
        catch (Exception e) {
            log.error("SignatureUtil decodeBase64 error: {}", (Throwable)e);
            return null;
        }
        return result;
    }

    static String assembelSignaturingData(Map data) {
        StringBuilder sb = new StringBuilder();
        TreeMap treeMap = new TreeMap(data);
        for (Map.Entry ent : treeMap.entrySet()) {
            String name = (String)ent.getKey();
            if ("sign".equals(name)) continue;
            sb.append(name).append('=').append(ent.getValue()).append('&');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

