/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.response.DeletePaymentOut;
import com.efuture.business.model.GetPayInfoIn;
import com.efuture.business.model.GetPayQueryInfoIn;
import com.efuture.business.model.GetPayReFundInfoIn;
import com.efuture.business.model.GetRepealPayInfoIn;
import com.efuture.business.model.allVpay.request.ActviateRequest;
import com.efuture.business.model.allVpay.request.CheckPayCodeIn;
import com.efuture.business.model.allVpay.request.FaceScanningRequest;
import com.efuture.business.model.allVpay.request.PayQueryRequest;
import com.efuture.business.model.allVpay.request.PayRequest2;
import com.efuture.business.model.allVpay.request.RefundPayQueryRequest;
import com.efuture.business.model.allVpay.request.RefundPayRequest;
import com.efuture.business.model.allVpay.request.RepealPayRequest;
import com.efuture.business.model.allVpay.response.ActivateResponse;
import com.efuture.business.model.allVpay.response.CheckPayCodeOut;
import com.efuture.business.model.allVpay.response.FaceScanningResponse;
import com.efuture.business.model.allVpay.response.PayQueryResponse;
import com.efuture.business.model.allVpay.response.PayResponse;
import com.efuture.business.model.allVpay.response.RefundPayQueryResponse;
import com.efuture.business.model.allVpay.response.RefundPayResponse;
import com.efuture.business.model.allVpay.response.RepealPayResponse;
import com.efuture.business.service.AllVpaySaleBS;
import com.efuture.business.service.OrderRemoteService;
import com.efuture.business.service.ZhongbaiService;
import com.efuture.business.util.AllVPayTools;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.Encrypt3des;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RSAUtils2;
import com.efuture.business.util.RandomNum;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.SocketShuttleDes;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.TypeUtils;
import jakarta.annotation.Resource;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class AllVpaySaleBSImpl
implements AllVpaySaleBS {
    private static final Logger log = LoggerFactory.getLogger(AllVpaySaleBSImpl.class);
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Autowired
    protected AllVPayTools allVPayTools;
    @Resource
    private ZhongbaiService zhongbaiService;
    protected RestTemplate restTemplate;
    protected static final String SUCCESS = "SUCCESS";
    protected static final String INPROCESS = "INPROCESS";
    protected static final String FAIL = "FAIL";
    protected String CHECKPAYCODE = "order.online.check.payCode";
    protected String cloudServerIp = "47.114.171.51";
    protected String desKey = "feb31e0af2ca1ebd";
    @Autowired
    public OrderTransfer orderTransfer;
    @SoaAnnotation(value="/apiOrderRemoteService.do")
    protected OrderRemoteService orderRemoteService;
    @Value(value="${localcache.enabled}")
    protected Boolean localcache;
    @Value(value="${allvpay.RSAPrivateKey}")
    protected String RSAPrivateKey;
    @Value(value="${allvpay.url}")
    protected String url;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    protected PosLogicCompoment posLogicCompoment;

    public RespBase salePayZB(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return this.zhongbaiService.salePay(session, vo, paramsObject);
    }

    public RespBase saleRefundZB(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return this.zhongbaiService.saleRefund(session, vo, paramsObject);
    }

    public RespBase saleRepealPayZB(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return this.zhongbaiService.saleRepealPay(session, vo, paramsObject);
    }

    public RespBase salePayQueryZB(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        return this.zhongbaiService.saleQuery(session, vo, paramsObject);
    }

    public void saleSubmit(CacheModel cacheModel, ResqVo vo, ServiceSession session) {
        this.zhongbaiService.saleSubmit(cacheModel, vo, session);
    }

    public RespBase posActivate(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"shopCode"});
        }
        if (!paramsObject.containsKey((Object)"terminalOperator") || paramsObject.getString("terminalOperator").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalOperator"});
        }
        if (!paramsObject.containsKey((Object)"terminalNo") || paramsObject.getString("terminalNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalNo"});
        }
        ActviateRequest actviateRequest = new ActviateRequest(paramsObject);
        ActivateResponse activateResponse = null;
        String obj = this.redisUtil.get(RedisKey.CACHEID + actviateRequest.getShopCode() + actviateRequest.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String SJPAY = ModeDetailsVo.getSysParaValue((List)syspara, (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
            actviateRequest.setAllvpayIp(AllvpayIp);
            actviateRequest.setAllvpayport(Allvpayport);
        }
        try {
            log.info("pos\u901a\u6fc0\u6d3b\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)actviateRequest));
            activateResponse = this.allVPayTools.posActivate(actviateRequest);
            log.info("\u6fc0\u6d3b\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)activateResponse));
            if (FAIL.equals(activateResponse.getBusinessResult())) {
                return Code.CODE_500001.getRespBase(new Object[]{activateResponse.getReturnResult(), ""});
            }
        }
        catch (Exception e) {
            log.info("\u7ec8\u7aef\u6fc0\u6d3b\u5931\u8d25:\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50101.getRespBase(new Object[]{e.getMessage()});
        }
        return new RespBase(Code.SUCCESS, (Object)activateResponse, "");
    }

    public RespBase abcSalePay(ServiceSession session, ResqVo vo, JSONObject bodyJson) {
        return this.salePay(session, vo, bodyJson);
    }

    public RespBase abcSalePayQuery(ServiceSession session, ResqVo resqVo, JSONObject bodyJson) {
        return this.salePayQuery(session, resqVo, bodyJson);
    }

    public RespBase abcSaleRefund(ServiceSession session, ResqVo resqVo, JSONObject bodyJson) {
        return this.saleRefund(session, resqVo, bodyJson);
    }

    public RespBase abcSaleRefundPay(ServiceSession session, ResqVo resqVo, JSONObject bodyJson) {
        return this.saleRepealPay(session, resqVo, bodyJson);
    }

    public RespBase abcSaleRefundQuery(ServiceSession session, ResqVo resqVo, JSONObject bodyJson) {
        return this.saleRefundQuery(session, resqVo, bodyJson);
    }

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        JSONObject syjmain;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payCode"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payName"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalSno"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"money"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"rate"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"precision"});
        }
        GetPayInfoIn getPayInfoIn = (GetPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayInfoIn.class);
        ArrayList<PayRequest2.GoodsPackage> goodsPackages = new ArrayList<PayRequest2.GoodsPackage>();
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayInfoIn.getShopCode() + getPayInfoIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        int maxSalePayCount = this.getMaxPayCount(obj);
        if (cacheModel.getPayments().size() >= maxSalePayCount) {
            return new RespBase(Code.CODE_50044, (Object)"\u8ba2\u5355\u8d85\u8fc7\u6700\u5927\u4ed8\u6b3e\u884c\u6570\u8bbe\u7f6e!", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - CastUtil.castDouble((Object)getPayInfoIn.getMoney()) < 0.0) {
            return new RespBase(Code.CODE_500003.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        log.info("post\u7cfb\u7edf\u53c2\u6570==>{}", (Object)this.getPayShopCode(obj));
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                log.info("\u6536\u94f6\u673a\u67dc\u7ec4==>{}", (Object)cacheModel.getSyjmain().getSyjgz());
                if (StringUtils.isBlank((String)cacheModel.getSyjmain().getSyjgz())) {
                    return Code.CODE_50015.getRespBase(new Object[]{"\u6536\u94f6\u673a\u67dc\u7ec4\u672a\u914d\u7f6e!"});
                }
                paramsObject.put("payShopCode", (Object)cacheModel.getSyjmain().getSyjgz());
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            log.info("\u5f02\u5e38", (Throwable)e);
            return Code.CODE_500001.getRespBase(new Object[]{"[payShopCode] or [payTerminalNo]"});
        }
        if (!paramsObject.containsKey((Object)"payTerminalNo") || StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payTerminalNo"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty() || "".equals(paramsObject.getString("payShopCode"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payShopCode"});
        }
        getPayInfoIn = (GetPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayInfoIn.class);
        String merchantOrderNo = getPayInfoIn.getShopCode() + getPayInfoIn.getTerminalNo() + System.currentTimeMillis();
        getPayInfoIn.setIdSheetNo(merchantOrderNo);
        paramsObject.put("idSheetNoforPay", (Object)merchantOrderNo);
        List goodsList = vo.getCacheModel().getGoodsList();
        for (Goods goods : goodsList) {
            PayRequest2.GoodsPackage goodsPackage = new PayRequest2.GoodsPackage();
            goodsPackage.setBarcode(goods.getBarNo() == null ? "" : goods.getBarNo());
            goodsPackage.setBrandName(goods.getBrandCode() == null ? "" : goods.getBrandCode());
            goodsPackage.setCategory(goods.getTempCategory() == null ? "" : goods.getTempCategory());
            goodsPackage.setCategoryName(goods.getTempCategory() == null ? "" : goods.getTempCategory());
            goodsPackage.setGoodsMemo(goods.getRemark() == null ? "" : goods.getRemark());
            goodsPackage.setGoodsName(goods.getGoodsName() == null ? "" : goods.getGoodsName());
            goodsPackage.setGoodsNo(goods.getGoodsNo() == null ? "" : goods.getGoodsNo());
            goodsPackage.setQty(String.valueOf((int)goods.getQty() * 1000));
            goodsPackage.setSaleAmount(String.valueOf((int)(ManipulatePrecision.doubleConvert((double)(goods.getSaleAmount() / goods.getQty()), (int)2, (int)1) * 100.0)));
            goodsPackage.setSaleUnit(goods.getSaleUnit() == null ? "" : goods.getSaleUnit());
            goodsPackages.add(goodsPackage);
        }
        boolean isSuccess = false;
        log.info("getPayInfoIn" + JSONObject.toJSONString((Object)getPayInfoIn));
        PayRequest2 payRequest = new PayRequest2(getPayInfoIn, goodsPackages);
        payRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        if ("B9".equals(getPayInfoIn.getPayType()) && (syjmain = JSONObject.parseObject((String)obj).getJSONObject("syjmain")).containsKey((Object)"ZFIP")) {
            payRequest.setSyjip(syjmain.getString("ZFIP"));
        }
        String objAL = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
            payRequest.setAllvpayIp(AllvpayIp);
            payRequest.setAllvpayport(Allvpayport);
        }
        PayResponse payResponse = null;
        try {
            if ("0".equals(getPayInfoIn.getFaceScanning())) {
                payRequest.setPayShopCode(getPayInfoIn.getPayShopCode() + getPayInfoIn.getShopCode());
                String request = payRequest.toString();
                log.info("\u5237\u8138\u652f\u4ed8\u5165\u53c2\uff1a" + request);
                String response = SocketShuttleDes.sendSocketByDes((String)GlobalInfo.getAllvpayIp(), (int)GlobalInfo.getAllvpayPort(), (Long)40L, (String)request, (String)this.desKey);
                log.info("\u5237\u8138\u652f\u4ed8\u8fd4\u56de==>{}", (Object)response);
                payResponse = new PayResponse(response);
            } else {
                log.info("\u626b\u7801\u652f\u4ed8\u5165\u53c2\uff1a" + payRequest.toString());
                if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                    payRequest.setPayShopCode(getPayInfoIn.getPayShopCode() + getPayInfoIn.getShopCode());
                    String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)40L, (String)payRequest.toString(), (String)this.desKey);
                    log.info("\u626b\u7801\u652f\u4ed8\u8fd4\u56de==>{}", (Object)response);
                    payResponse = new PayResponse(response);
                } else {
                    payResponse = this.allVPayTools.salePay(payRequest);
                }
            }
            cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
            Order order = cacheModel.getOrder();
            if (payResponse.getReturnCode().equals(SUCCESS)) {
                if (payResponse.getBusinessResult().equals(SUCCESS)) {
                    Payment payment = new Payment();
                    if ("98".equals(getPayInfoIn.getPayType()) || "D4".equals(getPayInfoIn.getPayType())) {
                        payment.setPayCode(getPayInfoIn.getPayCode());
                        payment.setPayName(getPayInfoIn.getPayName());
                        payment.setAppType(this.getAppType(getPayInfoIn.getPayType()));
                    } else {
                        log.info("\u5fae\u652f\u4ed8\u53cd\u5199\u652f\u4ed8\u540d\u79f0");
                        String channelFlag = "";
                        channelFlag = "99".equals(getPayInfoIn.getPayType()) ? Convert.newSubString((String)payResponse.getQrcodeUrl(), (int)0, (int)2).trim() : (payResponse.getQrcodeUrl().length() > 24 ? Convert.newSubString((String)payResponse.getQrcodeUrl(), (int)0, (int)24).trim() : ("D1".equals(getPayInfoIn.getPayType()) ? payResponse.getQrcodeUrl().trim() : payResponse.getQrcodeUrl()));
                        log.info("channelFlag==>{}", (Object)channelFlag);
                        boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                        if (!flag) {
                            log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f-\u51b2\u6b63");
                            log.info("saleRefund===" + JSONObject.toJSONString((Object)paramsObject));
                            getPayInfoIn.setOriginalIdSheetNo(merchantOrderNo);
                            getPayInfoIn.setOriginalCreateTime(payResponse.getCreateTime());
                            RepealPayRequest repealPayRequest = new RepealPayRequest(getPayInfoIn);
                            if (StringUtils.isBlank((String)repealPayRequest.getOriginalCreateTime())) {
                                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                                DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                                LocalDateTime dateTime = LocalDateTime.parse(cacheModel.getOrder().getSaleDate(), df);
                                repealPayRequest.setOriginalCreateTime(dateTime.format(df2));
                            }
                            repealPayRequest.setAllvpayIp(AllvpayIp);
                            repealPayRequest.setAllvpayport(Allvpayport);
                            log.info("repealPayRequest===" + JSONObject.toJSONString((Object)repealPayRequest));
                            try {
                                RepealPayResponse rayResponse = null;
                                if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                                    repealPayRequest.setPayShopCode(getPayInfoIn.getPayShopCode() + getPayInfoIn.getShopCode());
                                    String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)40L, (String)repealPayRequest.toString(), (String)this.desKey);
                                    log.info("\u626b\u7801\u652f\u4ed8\u8fd4\u56de==>{}", (Object)response);
                                    rayResponse = new RepealPayResponse(response);
                                } else {
                                    rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                                }
                                log.info("rayResponse===" + JSONObject.toJSONString((Object)rayResponse));
                                if (!rayResponse.getReturnCode().equals(SUCCESS)) {
                                    return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
                                }
                            }
                            catch (Exception e) {
                                log.info("\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25:\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                                return Code.CODE_50053.getRespBase(new Object[]{e.getMessage()});
                            }
                            return Code.CODE_50102.getRespBase(new Object[]{getPayInfoIn.getPayCode()});
                        }
                    }
                    PaymentMode payMode = PayModeUtils.getPayMode((String)getPayInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                    payment.setPayType(payMode.getPaytype());
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setRownoId(payment.getPuid());
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    payment.setPayNo(payRequest.getIdSheetNo());
                    if (null != paramsObject.getBoolean("invoiceFlag")) {
                        payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                    }
                    if (null != paramsObject.getBoolean("creditsFlag")) {
                        payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                    }
                    double money = 0.0;
                    money = CastUtil.castDouble((Object)payResponse.getDiscounts()) + CastUtil.castDouble((Object)payResponse.getActualCharge()) + CastUtil.castDouble((Object)payResponse.getOtherDiscounts());
                    payment.setMoney(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setAmount(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setRate(getPayInfoIn.getRate());
                    payment.setPrecision(String.valueOf(getPayInfoIn.getPrecision()));
                    payment.setPrcutMode(getPayInfoIn.getCutMode());
                    payment.setFlag("1");
                    payment.setTerminalNo(payRequest.getTerminalNo());
                    if ("67".equals(paramsObject.getString("payType"))) {
                        payment.setMisTerminalId(payRequest.getTerminalNo());
                    }
                    payment.setTerminalSno(payRequest.getTerminalSno());
                    payment.setDiscountValue((CastUtil.castDouble((Object)payResponse.getDiscounts()) + CastUtil.castDouble((Object)payResponse.getOtherDiscounts())) * 0.01);
                    payment.setMerchantDiscountValue(CastUtil.castDouble((Object)payResponse.getDiscounts()) * 0.01);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)payResponse.getOtherDiscounts()) * 0.01);
                    payment.setPayMemo(payResponse.getCreateTime());
                    payment.setRefCode(payResponse.getPayOrderId());
                    payment.setIsSuccess(true);
                    if ("67".equals(getPayInfoIn.getPayType()) || "46".equals(getPayInfoIn.getPayType()) || "D1".equals(getPayInfoIn.getPayType()) || "C5".equals(getPayInfoIn.getPayType())) {
                        payment.setPayNo(payResponse.getPayOrderId());
                        payment.setRefCode(payResponse.getIdSheetNo());
                    }
                    if ("1".equals(getPayInfoIn.getScene())) {
                        payment.setPopFlag("1");
                    }
                    this.convertRespse(payment, payResponse, paramsObject);
                    log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    vo.setCacheModel(cacheModel);
                    payResponse.setRemainValue(order.getRemainValue());
                    payResponse.setOughtPay(order.getOughtPay());
                    payResponse.setOverageValue(order.getOverageValue());
                    payResponse.setExistPay(order.getExistPay());
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                }
                if (payResponse.getBusinessResult().equals(INPROCESS)) {
                    return new RespBase(Code.CODE_55555.getIndex(), merchantOrderNo, payResponse.getReturnResult());
                }
            }
            return Code.CODE_50015.getRespBase(new Object[]{payResponse.getReturnResult()});
        }
        catch (Exception e) {
            log.info("\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25\u539f\u56e0:\u652f\u4ed8\u670d\u52a1\u5f02\u5e38", "");
        }
    }

    public void convertRespse(Payment payment, PayResponse payResponse, JSONObject paramsObject) {
    }

    public RespBase salePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        log.info("salePayQuery ==" + JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        GetPayQueryInfoIn getPayQueryInfoIn = (GetPayQueryInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayQueryInfoIn.class);
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getPayType())) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getTerminalSno())) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalSno"});
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getIdSheetNo())) {
            return Code.CODE_500001.getRespBase(new Object[]{"idSheetNo"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        Boolean hasPayment = false;
        List cacheList = cacheModel.getPayments();
        log.info("cacheList==>" + JSONObject.toJSONString((Object)cacheList));
        log.info("idSheetNo==>" + paramsObject.getString("idSheetNo"));
        for (Payment payment : cacheList) {
            if (!StringUtils.isNotBlank((String)payment.getPayNo()) || !payment.getPayNo().equals(getPayQueryInfoIn.getIdSheetNo())) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        boolean b = this.checkPayCode(session, paramsObject, cacheModel.getOrder().getErpCode());
        if (!b) {
            return Code.CODE_50103.getRespBase(new Object[0]);
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayQueryInfoIn.getShopCode() + getPayQueryInfoIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        try {
            if ("67".equals(getPayQueryInfoIn.getPayType())) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(getPayQueryInfoIn.getPayType())) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            log.info("\u5f02\u5e38", (Throwable)e);
            return Code.CODE_500001.getRespBase(new Object[]{"[payShopCode]/[payTerminalNo]"});
        }
        if (!paramsObject.containsKey((Object)"payTerminalNo") || paramsObject.getString("payTerminalNo").isEmpty() || "".equals(paramsObject.getString("payTerminalNo"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payTerminalNo"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty() || "".equals(paramsObject.getString("payShopCode"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payShopCode"});
        }
        getPayQueryInfoIn = (GetPayQueryInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayQueryInfoIn.class);
        if (!(getPayQueryInfoIn.getIdSheetNo().startsWith(cacheModel.getOrder().getShopCode()) || "67".equals(getPayQueryInfoIn.getPayType()) || "46".equals(getPayQueryInfoIn.getPayType()) || "D1".equals(getPayQueryInfoIn.getPayType()) || "C5".equals(getPayQueryInfoIn.getPayType()))) {
            return Code.CODE_50015.getRespBase(new Object[0]);
        }
        PayQueryRequest payQueryRequest = new PayQueryRequest(getPayQueryInfoIn);
        if ("98".equals(payQueryRequest.getPayType()) || "D1".equals(payQueryRequest.getPayType()) || "C5".equals(payQueryRequest.getPayType())) {
            payQueryRequest.setExchangeCode("02");
        }
        payQueryRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        log.info("\u67e5\u8be2\u652f\u4ed8\u5165\u53c2 ==>{}" + payQueryRequest.toString());
        String objAL = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
            payQueryRequest.setAllvpayIp(AllvpayIp);
            payQueryRequest.setAllvpayport(Allvpayport);
        }
        PayQueryResponse rayResponse = null;
        try {
            if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                payQueryRequest.setPayShopCode(getPayQueryInfoIn.getPayShopCode() + getPayQueryInfoIn.getShopCode());
                String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)40L, (String)payQueryRequest.toString(), (String)this.desKey);
                log.info("\u5fae\u652f\u4ed8\u652f\u4ed8\u67e5\u8be2\u8fd4\u53c2==>{}", (Object)response);
                rayResponse = new PayQueryResponse(response);
            } else {
                rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
            }
            log.info("rayResponse ==" + JSONObject.toJSONString((Object)rayResponse));
            if (rayResponse.getReturnCode().equals(SUCCESS)) {
                if (INPROCESS.equals(rayResponse.getBusinessResult())) {
                    for (int i = 0; i < 11; ++i) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                            String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)40L, (String)payQueryRequest.toString(), (String)this.desKey);
                            log.info("\u5fae\u652f\u4ed8\u652f\u4ed8\u67e5\u8be2\u8fd4\u53c2==>{}", (Object)response);
                            rayResponse = new PayQueryResponse(response);
                        } else {
                            rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
                        }
                        if (!INPROCESS.equals(rayResponse.getBusinessResult())) break;
                    }
                    if (!SUCCESS.equals(rayResponse.getBusinessResult())) {
                        return Code.CODE_50105.getRespBase(new Object[]{rayResponse.getReturnResult()});
                    }
                }
                if (FAIL.equals(rayResponse.getBusinessResult())) {
                    return Code.CODE_50106.getRespBase(new Object[]{rayResponse.getReturnResult()});
                }
                try {
                    String channelTransationTime = rayResponse.getCreateTime();
                    int cmft = cacheModel.getOrder().getSysPara().getCmft();
                    if (cmft > 0) {
                        LocalDateTime dateTime = LocalDateTime.now();
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                        LocalDateTime orderDateTime = LocalDateTime.parse(channelTransationTime, df);
                        Duration duration = Duration.between(orderDateTime, dateTime);
                        if (duration.toMinutes() - (long)cmft > 0L) {
                            return new RespBase(Code.CODE_50049.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8d85\u8fc7\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u67e5\u8be2\u652f\u4ed8", vo.getCacheModel().getFlowNo());
                        }
                    }
                }
                catch (Exception e) {
                    log.info("\u6821\u9a8c\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    return Code.CODE_50107.getRespBase(new Object[]{e.getMessage()});
                }
                if (!hasPayment.booleanValue()) {
                    Payment payment = new Payment();
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setRownoId(payment.getPuid());
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    if ("98".equals(getPayQueryInfoIn.getPayType()) || "D4".equals(getPayQueryInfoIn.getPayType())) {
                        payment.setPayCode(getPayQueryInfoIn.getPayCode());
                        payment.setPayName(getPayQueryInfoIn.getPayName());
                        payment.setAppType(this.getAppType(getPayQueryInfoIn.getPayType()));
                    } else {
                        String channelFlag = "";
                        channelFlag = "02".equals(getPayQueryInfoIn.getPayType()) ? "07" : ("03".equals(getPayQueryInfoIn.getPayType()) ? "06" : ("99".equals(getPayQueryInfoIn.getPayType()) ? Convert.newSubString((String)rayResponse.getQrcodeUrl(), (int)0, (int)2).trim() : (rayResponse.getQrcodeUrl().length() > 24 ? rayResponse.getQrcodeUrl().substring(0, 24).trim() : ("D1".equals(getPayQueryInfoIn.getPayType()) ? rayResponse.getQrcodeUrl().trim() : rayResponse.getQrcodeUrl()))));
                        boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                        if (!flag) {
                            log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f");
                            return Code.CODE_50102.getRespBase(new Object[]{getPayQueryInfoIn.getPayCode()});
                        }
                    }
                    payment.setPayNo(rayResponse.getIdSheetNo());
                    double money = 0.0;
                    money = CastUtil.castDouble((Object)rayResponse.getDiscounts()) + CastUtil.castDouble((Object)rayResponse.getActualCharge()) + CastUtil.castDouble((Object)rayResponse.getOtherDiscounts());
                    if (cacheModel.getOrder().getRemainValue() < ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1)) {
                        return Code.CODE_50108.getRespBase(new Object[0]);
                    }
                    payment.setMoney(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setAmount(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setRate(1.0);
                    payment.setPrecision(String.valueOf(getPayQueryInfoIn.getPrecision()));
                    payment.setPrcutMode(getPayQueryInfoIn.getCutMode());
                    payment.setFlag("1");
                    payment.setTerminalNo(getPayQueryInfoIn.getTerminalNo());
                    if ("67".equals(getPayQueryInfoIn.getPayType())) {
                        payment.setMisTerminalId(getPayQueryInfoIn.getPayTerminalNo());
                    }
                    payment.setTerminalSno(getPayQueryInfoIn.getTerminalSno());
                    payment.setDiscountValue((CastUtil.castDouble((Object)rayResponse.getDiscounts()) + CastUtil.castDouble((Object)rayResponse.getOtherDiscounts())) * 0.01);
                    payment.setMerchantDiscountValue(CastUtil.castDouble((Object)rayResponse.getDiscounts()) * 0.01);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)rayResponse.getOtherDiscounts()) * 0.01);
                    payment.setPayMemo(rayResponse.getCreateTime());
                    payment.setRefCode(rayResponse.getPayOrderId());
                    if ("67".equals(getPayQueryInfoIn.getPayType()) || "46".equals(getPayQueryInfoIn.getPayType()) || "D1".equals(getPayQueryInfoIn.getPayType()) || "C5".equals(payQueryRequest.getPayType())) {
                        payment.setPayNo(payment.getRefCode());
                        payment.setRefCode(rayResponse.getIdSheetNo());
                    }
                    if ("1".equals(getPayQueryInfoIn)) {
                        payment.setPopFlag("1");
                    }
                    this.convertRespse(payment, (PayResponse)rayResponse, paramsObject);
                    PaymentMode payMode = PayModeUtils.getPayMode((String)getPayQueryInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                    payment.setPayType(payMode.getPaytype());
                    log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    vo.setCacheModel(cacheModel);
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                }
                return new RespBase(Code.FAIL, (Object)rayResponse, "");
            }
            return Code.CODE_50015.getRespBase(new Object[]{rayResponse.getReturnResult()});
        }
        catch (Exception e) {
            return Code.CODE_50109.getRespBase(new Object[0]);
        }
    }

    public RespBase saleRepealPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payCode"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payName"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalSno"});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"originalIdSheetNo"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"money"});
        }
        if (!paramsObject.containsKey((Object)"refundMoney") || paramsObject.getString("refundMoney").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"refundMoney"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"rate"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"precision"});
        }
        GetRepealPayInfoIn getRepealPayInfoIn = (GetRepealPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetRepealPayInfoIn.class);
        String obj = this.redisUtil.get(RedisKey.CACHEID + getRepealPayInfoIn.getShopCode() + getRepealPayInfoIn.getTerminalNo());
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        Order order = cacheModel.getOrder();
        String merchantOrderNo = getRepealPayInfoIn.getShopCode() + getRepealPayInfoIn.getTerminalNo() + System.currentTimeMillis();
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            return Code.CODE_500001.getRespBase(new Object[]{"[payShopCode]/[payTerminalNo]"});
        }
        getRepealPayInfoIn = (GetRepealPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetRepealPayInfoIn.class);
        log.info("getRepealPayInfoIn=>" + JSONObject.toJSONString((Object)getRepealPayInfoIn));
        getRepealPayInfoIn.setIdSheetNo(merchantOrderNo);
        RefundPayRequest refundRequest = new RefundPayRequest(getRepealPayInfoIn);
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        String objAL = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
        }
        refundRequest.setAllvpayIp(AllvpayIp);
        refundRequest.setAllvpayport(Allvpayport);
        if (CastUtil.castDouble((Object)refundRequest.getMoney()) > ManipulatePrecision.doubleConvert((double)(order.getRemainValue() * 100.0))) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u539f\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u5269\u4f59\u4ed8\u6b3e", vo.getCacheModel().getFlowNo());
        }
        if (CastUtil.castDouble((Object)refundRequest.getMoney()) < CastUtil.castDouble((Object)refundRequest.getRefundMoney())) {
            return new RespBase(Code.CODE_50051.getIndex(), "\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u539f\u5355\u652f\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        double money = ManipulatePrecision.doubleConvert((double)CastUtil.castDouble((Object)getRepealPayInfoIn.getMoney()), (int)2, (int)1);
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - money < 0.0) {
            return new RespBase(Code.CODE_50110.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        double originalAmount = 0.0;
        boolean isNeedQuery = true;
        String is0ffline = "";
        String orgTime = "";
        if (null != cacheModel.getReturnPayments() && cacheModel.getReturnPayments().size() > 0) {
            block10: for (Payment p : cacheModel.getReturnPayments()) {
                if ("D4".equals(getRepealPayInfoIn.getPayType()) && refundRequest.getOriginalIdSheetNo().equals(p.getRefCode())) {
                    originalAmount = p.getAmount();
                    isNeedQuery = false;
                    break;
                }
                if (refundRequest.getOriginalIdSheetNo().equals(p.getPayNo())) {
                    orgTime = p.getPayMemo();
                    originalAmount = p.getAmount();
                    if ("02".equals(getRepealPayInfoIn.getPayType())) {
                        refundRequest.setOriginalIdSheetNo(p.getRefCode());
                    }
                    log.info("payNoIndex\uff1a" + "07".equals(p.getPayNo().substring(0, 2)));
                    if ("offline".equals(p.getCouponType()) && "07".equals(p.getPayNo().substring(0, 2))) {
                        log.info("\u79bb\u7ebf\u652f\u4ed8\uff1a" + getRepealPayInfoIn.getOriginalIdSheetNo());
                        is0ffline = p.getCouponType();
                        refundRequest.setOriginalIdSheetNo(getRepealPayInfoIn.getOriginalIdSheetNo());
                    }
                    isNeedQuery = false;
                    break;
                }
                if (!"DJ".equals(p.getDescription())) continue;
                List payModels = JSON.parseArray((String)p.getExtMemo(), OrdersPayModel.class);
                for (OrdersPayModel op : payModels) {
                    if (!refundRequest.getOriginalIdSheetNo().equals(op.getPayNo())) continue;
                    orgTime = p.getPayMemo();
                    originalAmount = op.getAmount().doubleValue();
                    if ("02".equals(getRepealPayInfoIn.getPayType())) {
                        refundRequest.setOriginalIdSheetNo(op.getRefCode());
                    }
                    log.info("payNoIndex\uff1a" + "07".equals(op.getPayNo().substring(0, 2)));
                    if ("offline".equals(op.getCopType()) && "07".equals(op.getPayNo().substring(0, 2))) {
                        log.info("\u79bb\u7ebf\u652f\u4ed8\uff1a" + getRepealPayInfoIn.getOriginalIdSheetNo());
                        is0ffline = op.getCopType();
                        refundRequest.setOriginalIdSheetNo(getRepealPayInfoIn.getOriginalIdSheetNo());
                    }
                    isNeedQuery = false;
                    continue block10;
                }
            }
        } else if (this.supportNoSourceReturn(paramsObject)) {
            isNeedQuery = false;
            originalAmount = money;
        }
        log.info("offline:" + is0ffline);
        if (isNeedQuery || "offline".equals(is0ffline)) {
            PayQueryRequest payQueryRequest = new PayQueryRequest(getRepealPayInfoIn);
            payQueryRequest.setExchangeCode("02");
            payQueryRequest.setIdSheetNo(refundRequest.getOriginalIdSheetNo());
            payQueryRequest.setAllvpayIp(AllvpayIp);
            payQueryRequest.setAllvpayport(Allvpayport);
            log.info("payQueryRequest ====>{}", (Object)payQueryRequest.toString());
            try {
                PayQueryResponse rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
                if (!SUCCESS.equals(rayResponse.getReturnCode())) {
                    return new RespBase(Code.CODE_50111.getIndex(), "\u5fae\u652f\u4ed8\u539f\u5355\u4fe1\u606f\u672a\u627e\u5230", vo.getCacheModel().getFlowNo());
                }
                originalAmount = ManipulatePrecision.doubleConvert((double)((CastUtil.castDouble((Object)rayResponse.getDiscounts()) + CastUtil.castDouble((Object)rayResponse.getActualCharge()) + CastUtil.castDouble((Object)rayResponse.getOtherDiscounts())) * 0.01), (int)2, (int)1);
                refundRequest.setOriginalCreateTime(rayResponse.getCreateTime());
            }
            catch (Exception e) {
                log.info("\u5fae\u652f\u4ed8\u67e5\u8be2\u539f\u5355\u652f\u4ed8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                return new RespBase(Code.CODE_50112.getIndex(), "\u5fae\u652f\u4ed8\u67e5\u8be2\u539f\u5355\u652f\u4ed8\u4fe1\u606f\u5931\u8d25", vo.getCacheModel().getFlowNo());
            }
        }
        if (money > originalAmount) {
            return new RespBase(Code.CODE_50051.getIndex(), "\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u539f\u5355\u652f\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        refundRequest.setMoney(String.valueOf((int)ManipulatePrecision.doubleConvert((double)(originalAmount * 100.0))));
        try {
            RefundPayResponse refundPayResponse;
            String request = "";
            if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                refundRequest.setPayShopCode(getRepealPayInfoIn.getPayShopCode() + paramsObject.getString("shopCode"));
                request = refundRequest.toString();
                String response = SocketShuttleDes.sendSocketByDes((String)GlobalInfo.getAllvpayIp(), (int)GlobalInfo.getAllvpayPort(), (Long)40L, (String)request, (String)this.desKey);
                log.info("\u652f\u4ed8\u9000\u6b3e\u8fd4\u56de==>{}", (Object)response);
                refundPayResponse = new RefundPayResponse(response);
            } else {
                log.info("\u5fae\u652f\u4ed8\u9000\u6b3e\u5165\u53c2\uff1a" + refundRequest.toString());
                refundPayResponse = this.allVPayTools.saleRefundPay(refundRequest);
            }
            if (refundPayResponse.getReturnCode().equals(SUCCESS)) {
                if (refundPayResponse.getBusinessResult().equals(SUCCESS)) {
                    Payment payment = new Payment();
                    if ("98".equals(getRepealPayInfoIn.getPayType()) || "D4".equals(getRepealPayInfoIn.getPayType())) {
                        payment.setPayCode(getRepealPayInfoIn.getPayCode());
                        payment.setPayName(getRepealPayInfoIn.getPayName());
                        payment.setAppType(this.getAppType(getRepealPayInfoIn.getPayType()));
                    } else {
                        String channelFlag = "";
                        channelFlag = "02".equals(getRepealPayInfoIn.getPayType()) ? "07" : ("03".equals(getRepealPayInfoIn.getPayType()) ? "06" : ("99".equals(getRepealPayInfoIn.getPayType()) ? refundPayResponse.getRefundPayMemo().substring(0, 2).trim() : (refundPayResponse.getRefundPayMemo().length() > 24 ? refundPayResponse.getRefundPayMemo().substring(0, 24).trim() : ("D1".equals(getRepealPayInfoIn.getPayType()) ? refundPayResponse.getRefundPayMemo().trim() : refundPayResponse.getRefundPayMemo()))));
                        boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                        if (!flag) {
                            log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f-\u51b2\u6b63");
                            log.info("saleRefund===" + JSONObject.toJSONString((Object)paramsObject));
                            getRepealPayInfoIn.setOriginalIdSheetNo(merchantOrderNo);
                            getRepealPayInfoIn.setOriginalCreateTime(refundRequest.getCreateTime());
                            RepealPayRequest repealPayRequest = new RepealPayRequest(getRepealPayInfoIn);
                            repealPayRequest.setAllvpayIp(AllvpayIp);
                            repealPayRequest.setAllvpayport(Allvpayport);
                            if (StringUtils.isBlank((String)orgTime)) {
                                orgTime = AllVPayTools.getTime();
                            }
                            repealPayRequest.setOriginalCreateTime(orgTime);
                            log.info("repealPayRequest===" + JSONObject.toJSONString((Object)repealPayRequest));
                            try {
                                RepealPayResponse rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                                if (!rayResponse.getReturnCode().equals(SUCCESS)) {
                                    return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
                                }
                            }
                            catch (Exception e) {
                                log.info("\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25", (Throwable)e);
                                return Code.CODE_50053.getRespBase(new Object[]{e.getMessage()});
                            }
                            return Code.CODE_50102.getRespBase(new Object[0]);
                        }
                    }
                    this.convertReturnResponse(refundPayResponse);
                    PaymentMode payMode = PayModeUtils.getPayMode((String)getRepealPayInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                    log.info("\u8fd4\u56de\u53c2\u6570\u683c\u5f0f\u5316==>{}", (Object)JSONObject.toJSONString((Object)refundPayResponse));
                    payment.setPayType(payMode.getPaytype());
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setRownoId(payment.getPuid());
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    payment.setPayNo(refundRequest.getIdSheetNo());
                    if ("D1".equals(refundRequest.getPayType())) {
                        payment.setPayNo(refundPayResponse.getOriginalIdSheetNo());
                    }
                    payment.setAmount(CastUtil.castDouble((Object)refundRequest.getRefundMoney()) * 0.01);
                    payment.setMoney(CastUtil.castDouble((Object)refundRequest.getRefundMoney()) * 0.01);
                    payment.setFlag("1");
                    payment.setTerminalNo(refundRequest.getTerminalNo());
                    if ("67".equals(paramsObject.getString("payType"))) {
                        payment.setMisTerminalId(refundRequest.getTerminalNo());
                    }
                    payment.setTerminalSno(refundRequest.getTerminalSno());
                    payment.setRate(getRepealPayInfoIn.getRate());
                    payment.setPrecision(String.valueOf(getRepealPayInfoIn.getPrecision()));
                    payment.setPrcutMode(getRepealPayInfoIn.getCutMode());
                    payment.setDiscountValue((CastUtil.castDouble((Object)refundPayResponse.getDiscounts()) + CastUtil.castDouble((Object)refundPayResponse.getOtherDiscounts())) * 0.01);
                    payment.setMerchantDiscountValue(CastUtil.castDouble((Object)refundPayResponse.getDiscounts()) * 0.01);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)refundPayResponse.getOtherDiscounts()) * 0.01);
                    payment.setPayMemo(refundRequest.getCreateTime());
                    payment.setRefCode(refundPayResponse.getOriginalIdSheetNo());
                    if (null != paramsObject.getBoolean("invoiceFlag")) {
                        payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                    }
                    if (null != paramsObject.getBoolean("creditsFlag")) {
                        payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                    }
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    vo.setCacheModel(cacheModel);
                    log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                    refundPayResponse.setRemainValue(order.getRemainValue());
                    refundPayResponse.setOughtPay(order.getOughtPay());
                    refundPayResponse.setOverageValue(order.getOverageValue());
                    refundPayResponse.setExistPay(order.getExistPay());
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                }
                if (refundPayResponse.getBusinessResult().equals(INPROCESS)) {
                    return new RespBase(Code.CODE_55555.getIndex(), merchantOrderNo, refundPayResponse.getReturnResult());
                }
            }
            return Code.CODE_50052.getRespBase(new Object[]{refundPayResponse.getReturnResult()});
        }
        catch (Exception e) {
            e.printStackTrace();
            getRepealPayInfoIn.setOriginalIdSheetNo(merchantOrderNo);
            getRepealPayInfoIn.setOriginalCreateTime(refundRequest.getCreateTime());
            RepealPayRequest repealPayRequest = new RepealPayRequest(getRepealPayInfoIn);
            repealPayRequest.setAllvpayIp(AllvpayIp);
            repealPayRequest.setAllvpayport(Allvpayport);
            log.info("repealPayRequest===" + JSONObject.toJSONString((Object)repealPayRequest));
            try {
                RepealPayResponse rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                log.info("rayResponse===" + JSONObject.toJSONString((Object)rayResponse));
                if (!rayResponse.getReturnCode().equals(SUCCESS)) {
                    return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
                }
            }
            catch (Exception es) {
                log.info("\u5f02\u5e38", (Throwable)e);
                return Code.CODE_50053.getRespBase(new Object[]{es.getMessage()});
            }
            return Code.CODE_50109.getRespBase(new Object[0]);
        }
    }

    public void convertReturnResponse(RefundPayResponse refundPayResponse) {
    }

    public boolean supportNoSourceReturn(JSONObject paramsObject) {
        return false;
    }

    public RespBase saleRefundQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalSno"});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"originalIdSheetNo"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            return Code.CODE_500001.getRespBase(new Object[]{"[payShopCode]/[payTerminalNo]"});
        }
        if (!paramsObject.containsKey((Object)"payTerminalNo") || paramsObject.getString("payTerminalNo").isEmpty() || "".equals(paramsObject.getString("payTerminalNo"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payTerminalNo"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty() || "".equals(paramsObject.getString("payShopCode"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payShopCode"});
        }
        String objAL = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
        }
        RefundPayQueryRequest refundQueryRequest = new RefundPayQueryRequest(paramsObject);
        refundQueryRequest.setAllvpayIp(AllvpayIp);
        refundQueryRequest.setAllvpayport(Allvpayport);
        try {
            RefundPayQueryResponse refundPayQueryResponse;
            if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                refundQueryRequest.setPayShopCode(refundQueryRequest.getPayShopCode() + paramsObject.getString("shopCode"));
                String response = SocketShuttleDes.sendSocketByDes((String)GlobalInfo.getAllvpayIp(), (int)GlobalInfo.getAllvpayPort(), (Long)40L, (String)refundQueryRequest.toString(), (String)this.desKey);
                log.info("\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de==>{}", (Object)response);
                refundPayQueryResponse = new RefundPayQueryResponse(response);
            } else {
                refundPayQueryResponse = this.allVPayTools.saleRefundPayQuery(refundQueryRequest);
            }
            if (refundPayQueryResponse.getReturnCode().equals(SUCCESS) && refundPayQueryResponse.getBusinessResult().equals(SUCCESS)) {
                Payment payment = new Payment();
                if ("98".equals(paramsObject.getString("payType")) || "D4".equals(paramsObject.getString("payType"))) {
                    payment.setPayCode(paramsObject.getString("payCode"));
                    payment.setPayName(paramsObject.getString("payName"));
                    payment.setAppType(this.getAppType(paramsObject.getString("payType")));
                } else {
                    String channelFlag = "";
                    channelFlag = "02".equals(paramsObject.getString("payType")) ? "07" : ("03".equals(paramsObject.getString("payType")) ? "06" : ("99".equals(paramsObject.getString("payType")) ? refundPayQueryResponse.getRefundPayMemo().substring(0, 2).trim() : (refundPayQueryResponse.getRefundPayMemo().length() > 24 ? refundPayQueryResponse.getRefundPayMemo().substring(0, 24).trim() : ("D1".equals(paramsObject.getString("payType")) ? refundPayQueryResponse.getRefundPayMemo().trim() : refundPayQueryResponse.getRefundPayMemo()))));
                    boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                    if (!flag) {
                        log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f-\u51b2\u6b63");
                        log.info("saleRefund===" + JSONObject.toJSONString((Object)paramsObject));
                        paramsObject.put("originalIdSheetNo", (Object)refundQueryRequest.getIdSheetNo());
                        paramsObject.put("originalCreateTime", (Object)refundQueryRequest.getCreateTime());
                        RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
                        repealPayRequest.setAllvpayIp(AllvpayIp);
                        repealPayRequest.setAllvpayport(Allvpayport);
                        log.info("repealPayRequest===" + JSONObject.toJSONString((Object)repealPayRequest));
                        try {
                            RepealPayResponse rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                            if (!rayResponse.getReturnCode().equals(SUCCESS)) {
                                return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
                            }
                        }
                        catch (Exception e) {
                            return Code.CODE_50113.getRespBase(new Object[]{e.getMessage()});
                        }
                        return Code.CODE_50102.getRespBase(new Object[]{paramsObject.getString("payCode")});
                    }
                }
                this.convertReturnResponse((RefundPayResponse)refundPayQueryResponse);
                PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
                payment.setPayType(payMode.getPaytype());
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setRownoId(payment.getPuid());
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setPayNo(refundQueryRequest.getIdSheetNo());
                payment.setAmount(CastUtil.castDouble((Object)refundPayQueryResponse.getRefundMoney()) * 0.01);
                payment.setMoney(CastUtil.castDouble((Object)refundPayQueryResponse.getRefundMoney()) * 0.01);
                payment.setFlag("1");
                payment.setTerminalNo(refundQueryRequest.getTerminalNo());
                if ("67".equals(paramsObject.getString("payType"))) {
                    payment.setMisTerminalId(refundQueryRequest.getTerminalNo());
                }
                payment.setTerminalSno(refundQueryRequest.getTerminalSno());
                payment.setRate(paramsObject.getDouble("rate").doubleValue());
                payment.setPrecision(paramsObject.getString("precision"));
                payment.setPrcutMode(paramsObject.getString("cutMode"));
                payment.setDiscountValue((CastUtil.castDouble((Object)refundPayQueryResponse.getDiscounts()) + CastUtil.castDouble((Object)refundPayQueryResponse.getOtherDiscounts())) * 0.01);
                payment.setMerchantDiscountValue(CastUtil.castDouble((Object)refundPayQueryResponse.getDiscounts()) * 0.01);
                payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)refundPayQueryResponse.getOtherDiscounts()) * 0.01);
                payment.setPayMemo(refundQueryRequest.getCreateTime());
                payment.setRefCode(refundPayQueryResponse.getOriginalIdSheetNo());
                if (null != paramsObject.getBoolean("invoiceFlag")) {
                    payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                }
                if (null != paramsObject.getBoolean("creditsFlag")) {
                    payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                }
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                refundPayQueryResponse.setRemainValue(order.getRemainValue());
                refundPayQueryResponse.setOughtPay(order.getOughtPay());
                refundPayQueryResponse.setOverageValue(order.getOverageValue());
                refundPayQueryResponse.setExistPay(order.getExistPay());
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            return Code.CODE_50052.getRespBase(new Object[]{refundPayQueryResponse.getReturnResult()});
        }
        catch (Exception e) {
            log.info("\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\u539f\u56e0\uff1a\u652f\u4ed8\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return Code.CODE_50114.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        GetPayReFundInfoIn getPayReFundInfoIn = (GetPayReFundInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayReFundInfoIn.class);
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalSno"});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"originalIdSheetNo"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"money"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"puid"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayReFundInfoIn.getShopCode() + getPayReFundInfoIn.getTerminalNo());
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_50115.getRespBase(new Object[0]);
        }
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u672a\u8bbe\u7f6e[payShopCode]\u6216[payTerminalNo]", ""});
        }
        getPayReFundInfoIn = (GetPayReFundInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayReFundInfoIn.class);
        String puid = getPayReFundInfoIn.getPuid();
        RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
        String objAL = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
        }
        repealPayRequest.setAllvpayIp(AllvpayIp);
        repealPayRequest.setAllvpayport(Allvpayport);
        if (StringUtils.isBlank((String)repealPayRequest.getOriginalCreateTime())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            LocalDateTime dateTime = LocalDateTime.parse(cacheModel.getOrder().getSaleDate(), df);
            repealPayRequest.setOriginalCreateTime(dateTime.format(df2));
        }
        DeletePaymentOut deletePaymentOut = new DeletePaymentOut();
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            payment = p;
            break;
        }
        if (("67".equals(getPayReFundInfoIn.getPayType()) || "46".equals(getPayReFundInfoIn.getPayType()) || "C5".equals(getPayReFundInfoIn.getPayType())) && null != payment) {
            repealPayRequest.setOriginalIdSheetNo(payment.getRefCode());
        }
        repealPayRequest.setOriginalCreateTime(payment.getPayMemo());
        repealPayRequest = this.convertRequest(repealPayRequest, payment, paramsObject);
        log.info("\u5fae\u652f\u4ed8\u64a4\u9500\u5165\u53c2===" + repealPayRequest.toString());
        try {
            RepealPayResponse rayResponse;
            if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                repealPayRequest.setPayShopCode(getPayReFundInfoIn.getPayShopCode() + getPayReFundInfoIn.getShopCode());
                String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)40L, (String)repealPayRequest.toString(), (String)this.desKey);
                log.info("\u652f\u4ed8\u64a4\u9500\u8fd4\u56de==>{}", (Object)response);
                rayResponse = new RepealPayResponse(response);
            } else {
                rayResponse = this.allVPayTools.repealPay(repealPayRequest);
            }
            if (rayResponse.getReturnCode().equals(SUCCESS)) {
                if (rayResponse.getBusinessResult().equals(SUCCESS)) {
                    if (payment != null) {
                        cacheModel.getPayments().remove(payment);
                        PayUtil.sortPayments((List)cacheModel.getPayments());
                        cacheModel.setPayments(cacheModel.getPayments());
                        cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
                        if (cacheModel.getCalcResult() == -1) {
                            String errCode = String.valueOf(Code.CODE_500000.getIndex());
                            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                                errCode = cacheModel.getErrCode();
                            }
                            return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
                        }
                        vo.setCacheModel(cacheModel);
                        deletePaymentOut.setExistPay(order.getExistPay());
                        deletePaymentOut.setFlowNo(order.getFlowNo());
                        deletePaymentOut.setOughtPay(order.getOughtPay());
                        deletePaymentOut.setOverageValue(order.getOverageValue());
                        deletePaymentOut.setTotalDiscountValue(order.getTotalDiscountValue());
                        deletePaymentOut.setRemainValue(order.getRemainValue());
                        deletePaymentOut.setSalePayments(cacheModel.getPayments());
                        BaseOutModel out = new BaseOutModel();
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                    }
                    return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!", "");
                }
                return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25:" + rayResponse.getReturnResult(), "");
            }
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0:" + rayResponse.getReturnResult(), "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.FAIL.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0\uff1a\u652f\u4ed8\u670d\u52a1\u5f02\u5e38!", "");
        }
    }

    public RepealPayRequest convertRequest(RepealPayRequest repealPayRequest, Payment payment, JSONObject getPayReFundInfoIn) {
        return repealPayRequest;
    }

    public RespBase saleRefundVoid(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", ""});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", ""});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u53f7]", ""});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u91d1\u989d]", ""});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u672a\u8bbe\u7f6e[payShopCode]\u6216[payTerminalNo]", ""});
        }
        Order order = cacheModel.getOrder();
        String originalPayNo = paramsObject.getString("originalIdSheetNo");
        Payment pay = null;
        int rowNo = -1;
        for (int i = 0; i < cacheModel.getReturnPayments().size(); ++i) {
            Payment p = (Payment)cacheModel.getReturnPayments().get(i);
            if (!originalPayNo.equals(p.getPayNo())) continue;
            pay = (Payment)p.clone();
            rowNo = i;
            break;
        }
        if (null == pay) {
            return new RespBase(Code.CODE_50030, (Object)"\u6d88\u5355\u4f20\u5165\u5355\u53f7\u6709\u8bef", vo.getCacheModel().getFlowNo());
        }
        paramsObject.put("originalCreateTime", (Object)pay.getPayMemo());
        String post = ModeDetailsVo.getSysParaValue((List)syspara, (String)"POST");
        String objAL = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (!pay.getIsSuccess()) {
            String[] ips;
            RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
            repealPayRequest.setOriginalCreateTime(pay.getPayMemo());
            log.info("post\u7cfb\u7edf\u53c2\u6570==>{}", (Object)post);
            if ("67".equals(paramsObject.getString("payType")) || "46".equals(paramsObject.getString("payType")) || "C5".equals(paramsObject.getString("payType"))) {
                repealPayRequest.setOriginalIdSheetNo(pay.getRefCode());
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                if (null != post) {
                    repealPayRequest.setPayShopCode(post);
                } else {
                    repealPayRequest.setPayShopCode("AAAA");
                }
            }
            if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
                AllvpayIp = ips[0];
                Allvpayport = Integer.parseInt(ips[1]);
                repealPayRequest.setAllvpayIp(AllvpayIp);
                repealPayRequest.setAllvpayport(Allvpayport);
            }
            repealPayRequest = this.convertRequest(repealPayRequest, pay, paramsObject);
            log.info("\u5fae\u652f\u4ed8\u64a4\u9500\u5165\u53c2===" + repealPayRequest.toString());
            try {
                RepealPayResponse rayResponse = null;
                if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                    repealPayRequest.setPayShopCode(repealPayRequest.getPayShopCode() + paramsObject.getString("shopCode"));
                    String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)40L, (String)repealPayRequest.toString(), (String)this.desKey);
                    log.info("\u652f\u4ed8\u64a4\u9500\u8fd4\u56de==>{}", (Object)response);
                    rayResponse = new RepealPayResponse(response);
                } else {
                    rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                }
                if (rayResponse.getReturnCode().equals(SUCCESS)) {
                    if (rayResponse.getBusinessResult().equals(SUCCESS)) {
                        PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
                        pay.setPayType(payMode.getPaytype());
                        pay.setPuid(String.valueOf(UniqueID.getUniqueID()));
                        pay.setRownoId(pay.getPuid());
                        pay.setPayNo(originalPayNo);
                        pay.setAmount(CastUtil.castDouble((Object)repealPayRequest.getMoney()) * 0.01);
                        pay.setMoney(CastUtil.castDouble((Object)repealPayRequest.getMoney()) * 0.01);
                        pay.setFlag("1");
                        pay.setTerminalNo(repealPayRequest.getTerminalNo());
                        pay.setTerminalSno(repealPayRequest.getTerminalSno());
                        pay.setRefCode(originalPayNo);
                        pay.setRate(payMode.getZlhl().doubleValue());
                        pay.setPrecision(String.valueOf(payMode.getSswrjd()));
                        pay.setPrcutMode(payMode.getSswrfs());
                        pay.setIsSuccess(true);
                        pay.setRowno(cacheModel.getPayments().size() + 1);
                        ((Payment)cacheModel.getReturnPayments().get(rowNo)).setIsSuccess(true);
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, pay);
                        vo.setCacheModel(cacheModel);
                        BaseOutModel out = new BaseOutModel();
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                    }
                    return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
                }
                return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
            }
            catch (Exception e) {
                return Code.CODE_50053.getRespBase(new Object[]{e.getMessage()});
            }
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
    }

    public boolean checkPayName(String redisObj, JSONObject paramsObject, Payment payment, String pmCode) {
        String postr = "";
        if (redisObj != null) {
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)redisObj.toString(), ModeDetailsVo.class);
            List syspara = modeDetailsVo.getSyspara();
            postr = ModeDetailsVo.getSysParaValue((List)syspara, (String)"POSTR");
        }
        log.info("\u7cfb\u7edf\u53c2\u6570postr=" + postr);
        if ("N".equals(postr)) {
            GetPayInfoIn getPayInfoIn = (GetPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayInfoIn.class);
            payment.setPayCode(getPayInfoIn.getPayCode());
            payment.setPayName(getPayInfoIn.getPayName());
            payment.setAppType(this.getAppType(getPayInfoIn.getPayType()));
            return true;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)redisObj);
        for (int k = 0; k < jsonObject.getJSONArray("paymentmethodposref").size(); ++k) {
            JSONObject paymentmethodposref = jsonObject.getJSONArray("paymentmethodposref").getJSONObject(k);
            if (paramsObject.getString("payCode").equalsIgnoreCase(paymentmethodposref.getString("payCode")) && pmCode.equals(paymentmethodposref.getString("pmCode"))) {
                payment.setPayCode(paymentmethodposref.getString("posAbleCode"));
                payment.setPayName(paymentmethodposref.getString("posAbleName"));
                payment.setAppType(this.getAppType(pmCode));
                return true;
            }
            payment.setPayCode(paramsObject.getString("payCode"));
            payment.setPayName(paramsObject.getString("payName"));
            payment.setAppType(this.getAppType(pmCode));
        }
        return true;
    }

    protected int getMaxPayCount(String obj) {
        JSONObject object3;
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "1";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("OZ")) continue;
                array.add((Object)sys);
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        String[] temp = paravalue.split(",");
        int maxSalePayCount = Integer.valueOf(temp[1]);
        return maxSalePayCount;
    }

    public void setPayShopCode(JSONObject object, String obj) {
        log.info("pos\u901a\u83b7\u53d6\u53c2\u6570");
        object.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
        object.put("payShopCode", (Object)this.getPayShopCode(obj));
    }

    public String getPayTerminalNo(String obj) {
        JSONObject syjmainVo = JSONObject.parseObject((String)obj).getJSONObject("syjmain");
        String terminalNo = syjmainVo.getString("POSTTerminalnno");
        return terminalNo;
    }

    public String getPayShopCode(String obj) {
        JSONObject object3;
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("POST")) continue;
                array.add((Object)sys);
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        return paravalue;
    }

    public boolean checkPayCode(ServiceSession session, JSONObject json, String erpCode) {
        try {
            CheckPayCodeOut out;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            CheckPayCodeIn in = new CheckPayCodeIn();
            in.setBusiTakeMarketCode(json.getString("shopCode"));
            in.setErpCode(erpCode);
            in.setPayNo(json.getString("idSheetNo"));
            try {
                String searchDate = dateFormat.format(new Date());
                String data = DateHelpUtil.getYestoryDate((String)searchDate);
                Date whenDate = TypeUtils.castToDate((Object)data);
                in.setStartDateTime(whenDate);
                String afterHour = DateHelpUtil.getAfterHourByHour((int)9);
                Date afterDate = TypeUtils.castToDate((Object)afterHour);
                in.setEndDateTime(afterDate);
            }
            catch (Exception searchDate) {
                // empty catch block
            }
            HashMap<String, CheckPayCodeIn> map = new HashMap<String, CheckPayCodeIn>();
            map.put("data", in);
            ServiceResponse response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, this.CHECKPAYCODE, session, JSON.toJSONString(map), CheckPayCodeOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6821\u9a8c\u5546\u6237\u8ba2\u5355\u53f7");
            if ("0".equals(response.getReturncode()) && !(out = (CheckPayCodeOut)response.getData()).getExist().booleanValue()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getAppType(String type) {
        String appType = "";
        switch (type) {
            case "06": {
                appType = "3";
                break;
            }
            case "07": {
                appType = "99";
                break;
            }
            case "13": {
                appType = "4";
                break;
            }
            case "67": {
                appType = "67";
                break;
            }
            case "38": {
                appType = "5";
                break;
            }
            default: {
                appType = "0";
            }
        }
        log.info("appType:{}", (Object)appType);
        return appType;
    }

    public RespBase getFaceScanning(ServiceSession session, JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        String payShopCode = this.getPayShopCode(obj);
        String payTerminalNo = this.getPayTerminalNo(obj);
        if (StringUtils.isBlank((String)payShopCode)) {
            paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
        } else {
            paramsObject.put("payShopCode", (Object)payShopCode);
        }
        if (StringUtils.isBlank((String)payTerminalNo)) {
            paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
        } else {
            paramsObject.put("payTerminalNo", (Object)payTerminalNo);
        }
        FaceScanningRequest request = (FaceScanningRequest)JSONObject.parseObject((String)paramsObject.toJSONString(), FaceScanningRequest.class);
        String response = null;
        try {
            log.info("\u83b7\u53d6\u5237\u8138\u652f\u4ed8\u53c2\u6570==>{}", (Object)request.toString());
            String desKey = "feb31e0af2ca1ebd";
            response = SocketShuttleDes.sendSocketByDes((String)GlobalInfo.getAllvpayIp(), (int)GlobalInfo.getAllvpayPort(), (Long)40L, (String)request.toString(), (String)desKey);
            log.info("\u83b7\u53d6\u5237\u8138\u652f\u4ed8\u53c2\u6570\u8fd4\u56de==>{}", (Object)response);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5237\u8138\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        String privateKey = "802c1dfe3729e65c931971cf";
        FaceScanningResponse faceScanningResponse = new FaceScanningResponse(response);
        if (faceScanningResponse.getReturnCode().equals(SUCCESS) && SUCCESS.equals(faceScanningResponse.getBusinessResult())) {
            String result = faceScanningResponse.getRepealPayMemo();
            String jsonResponse = null;
            try {
                jsonResponse = Encrypt3des.decryptFromBase64((String)result, (String)privateKey);
            }
            catch (Exception e) {
                log.info("\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            }
            return new RespBase(Code.SUCCESS, (Object)JSONObject.parseObject((String)jsonResponse), paramsObject.getString("flow_no"));
        }
        return Code.FAIL.getRespBase(new Object[0]);
    }

    public RespBase getQrCode(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            log.info("\u79bb\u7ebf\u652f\u4ed8\u5165\u53c2" + jsonObject.toJSONString());
            String apsp = "";
            String obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            apsp = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"APSP");
            log.info("apsp:" + apsp);
            if (!StringUtils.isNotEmpty((String)apsp)) {
                return new RespBase(Code.FAIL.getIndex(), "\u672a\u627e\u5230\u5fae\u652f\u4ed8\u95e8\u5e97\u914d\u7f6e\u4fe1\u606f", vo.getCacheModel().getFlowNo());
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            if (StringUtils.isNotEmpty((String)vo.getCacheModel().getRn())) {
                treeMap.put("rn", vo.getCacheModel().getRn().substring(0, 4));
            } else {
                treeMap.put("rn", RandomNum.generateString((int)4));
            }
            treeMap.put("shop", apsp);
            treeMap.put("amt", String.valueOf((long)ManipulatePrecision.doubleConvert((double)(jsonObject.getDouble("amt") * 100.0), (int)2, (int)1)));
            JSONObject treeMapObject = new JSONObject(treeMap);
            log.info("\u6392\u5e8f\u540e\u7684\u5165\u53c2\uff1a" + treeMapObject.toJSONString());
            log.info("key\uff1a" + this.RSAPrivateKey);
            String sign = RSAUtils2.signForSHA((String)treeMapObject.toJSONString(), (PrivateKey)RSAUtils2.getPrivateKey((String)this.RSAPrivateKey));
            log.info("\u7b7e\u540dRSA\u52a0\u5bc6\uff1a" + sign);
            String qrCode = this.url + "?shop=" + treeMap.get("shop") + "&amt=" + treeMap.get("amt") + "&rn=" + treeMap.get("rn") + "&sign=" + URLEncoder.encode(sign, "UTF-8");
            JSONObject resp = new JSONObject();
            resp.put("qrCode", (Object)qrCode);
            if (StringUtils.isEmpty((String)vo.getCacheModel().getRn())) {
                vo.getCacheModel().setRn((String)treeMap.get("rn") + String.valueOf((long)ManipulatePrecision.doubleConvert((double)(jsonObject.getDouble("amt") * 100.0), (int)2, (int)1)));
            }
            vo.setJsonObject(resp);
            return new RespBase(Code.SUCCESS, (Object)vo, vo.getCacheModel().getFlowNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(Code.FAIL, "\u83b7\u53d6\u4e8c\u7ef4\u7801\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public RespBase qrCodePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("qrCodePayQuery ==" + JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        GetPayQueryInfoIn getPayQueryInfoIn = (GetPayQueryInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayQueryInfoIn.class);
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getPayType())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getTerminalSno())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getIdSheetNo())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", "\u652f\u4ed8\u5355\u53f7");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String amt = String.valueOf((long)ManipulatePrecision.doubleConvert((double)(getPayQueryInfoIn.getAmount() * 100.0), (int)2, (int)1));
        if (!(getPayQueryInfoIn.getPayNo() + amt).contains(cacheModel.getRn())) {
            log.info("getPayQueryInfoIn.getPayNo()+amt==>" + getPayQueryInfoIn.getPayNo() + amt);
            log.info("cacheModel.getRn()==>" + cacheModel.getRn());
            return new RespBase(Code.CODE_50144.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u4e0d\u5c5e\u4e8e\u672c\u7b14\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        Boolean hasPayment = false;
        List cacheList = cacheModel.getPayments();
        log.info("cacheList==>" + JSONObject.toJSONString((Object)cacheList));
        log.info("idSheetNo==>" + paramsObject.getString("idSheetNo"));
        for (Payment payment : cacheList) {
            if (!StringUtils.isNotBlank((String)payment.getPayNo()) || !payment.getPayNo().equals(getPayQueryInfoIn.getIdSheetNo())) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        if (this.localcache.booleanValue()) {
            log.info("\u8131\u673a\u67e5\u8be2\u5165\u53c2\uff1a" + paramsObject.toJSONString());
            RespBase respBase = this.orderRemoteService.checkPayCode(session, paramsObject);
            log.info("\u8131\u673a\u67e5\u8be2\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)respBase));
            if (0 != respBase.getRetflag()) {
                return new RespBase(Code.CODE_50015.getIndex(), "\u5546\u6236\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
            }
        } else {
            boolean b = this.checkPayCode(session, paramsObject, cacheModel.getOrder().getErpCode());
            if (!b) {
                return new RespBase(Code.CODE_50015.getIndex(), "\u5546\u6236\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
            }
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayQueryInfoIn.getShopCode() + getPayQueryInfoIn.getTerminalNo());
        log.info("payType:" + getPayQueryInfoIn.getPayType());
        getPayQueryInfoIn.setPayShopCode(paramsObject.getString("shopCode"));
        getPayQueryInfoIn.setPayTerminalNo(paramsObject.getString("terminalNo"));
        PayQueryRequest payQueryRequest = new PayQueryRequest(getPayQueryInfoIn);
        if ("98".equals(payQueryRequest.getPayType())) {
            payQueryRequest.setExchangeCode("02");
        }
        log.info("payQueryRequest ==" + JSONObject.toJSONString((Object)payQueryRequest));
        try {
            if (!hasPayment.booleanValue()) {
                Payment payment = new Payment();
                payment.setPuid(UUIDUtils.buildPuid());
                payment.setRownoId(payment.getPuid());
                payment.setRowno(cacheModel.getPayments().size() + 1);
                if ("67".equals(getPayQueryInfoIn.getPayType()) || "98".equals(getPayQueryInfoIn.getPayType()) || "D6".equals(getPayQueryInfoIn.getPayType()) || "31".equals(getPayQueryInfoIn.getPayType())) {
                    payment.setPayCode(getPayQueryInfoIn.getPayCode());
                    payment.setPayName(getPayQueryInfoIn.getPayName());
                    payment.setAppType(this.getAppType(getPayQueryInfoIn.getPayType()));
                } else {
                    String channelFlag = "";
                    channelFlag = "02".equals(getPayQueryInfoIn.getPayType()) ? "07" : ("03".equals(getPayQueryInfoIn.getPayType()) ? "06" : getPayQueryInfoIn.getPayNo().substring(0, 2));
                    boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                    payment.setAppType(this.getAppType(channelFlag));
                    if (!flag) {
                        log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f");
                        return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25-\u672a\u627e\u5230\u652f\u4ed8\u65b9\u5f0f:" + getPayQueryInfoIn.getPayCode(), null, "");
                    }
                }
                payment.setPayNo(getPayQueryInfoIn.getIdSheetNo());
                double money = 0.0;
                money = CastUtil.castDouble((Object)getPayQueryInfoIn.getAmount());
                payment.setMoney(ManipulatePrecision.doubleConvert((double)money, (int)2, (int)1));
                payment.setAmount(ManipulatePrecision.doubleConvert((double)money, (int)2, (int)1));
                payment.setRate(1.0);
                payment.setPrecision(String.valueOf(getPayQueryInfoIn.getPrecision()));
                payment.setPrcutMode(getPayQueryInfoIn.getCutMode());
                payment.setFlag("1");
                payment.setTerminalNo(getPayQueryInfoIn.getTerminalNo());
                payment.setTerminalSno(getPayQueryInfoIn.getTerminalSno());
                payment.setCouponType("offline");
                if ("1".equals(getPayQueryInfoIn)) {
                    payment.setPopFlag("1");
                }
                PaymentMode payMode = PayModeUtils.getPayMode((String)getPayQueryInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                payment.setPayType(payMode.getPaytype());
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            return new RespBase(Code.FAIL, (Object)"\u751f\u6210\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25", cacheModel.getFlowNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25\u539f\u56e0:\u652f\u4ed8\u670d\u52a1\u5f02\u5e38", cacheModel.getFlowNo());
        }
    }
}

