/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.CrmFlCouponSaleDao;
import com.efuture.business.enumcase.MzkEnum;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.model.mzk.request.V3MzkRequestDef;
import com.efuture.business.model.mzk.response.V3MzkResultDef;
import com.efuture.business.model.xhd.RangeMzkRequestDef;
import com.efuture.business.service.CrmFlCouponSaleBS;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.MzkSaleUtil;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class CrmFlCouponSaleServiceIml
implements CrmFlCouponSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(CrmFlCouponSaleServiceIml.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Resource
    private CrmFlCouponSaleDao crmFlCouponSaleDao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("cardNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f1a\u5458\u5361\u53f7]");
        }
        if (null == jsonObject.getDouble("amount")) {
            jsonObject.put("amount", (Object)0);
        }
        CacheModel cacheModel = vo.getCacheModel();
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        String obj = this.redisUtil.get(RedisKey.CACHEID + mzkIn.getShopCode() + mzkIn.getMzkTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        jsonObject.put("amount", (Object)"0");
        V3MzkRequestDef mzkRequestDef = V3MzkRequestDef.convertReq((CacheModel)cacheModel, (MzkIn)mzkIn);
        mzkRequestDef.setType("05");
        mzkRequestDef.setJygs(v3jygs);
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            mzkRequestDef.setInvdjlb("4");
        } else {
            mzkRequestDef.setInvdjlb("1");
        }
        mzkRequestDef.str1 = "02";
        if (mzkIn.getCardNo().startsWith("#")) {
            mzkRequestDef.setTrack2(mzkIn.getCardNo().replaceAll("#", ""));
        } else {
            mzkRequestDef.setTrack1("");
        }
        Object salegoodsstr = "";
        for (Goods g : cacheModel.getGoodsList()) {
            salegoodsstr = (String)salegoodsstr + "|" + g.getGoodsCode() + "," + ("7".equals(g.getFlag()) ? "N" : "Y");
        }
        if (((String)salegoodsstr).indexOf("|") == 0) {
            salegoodsstr = ((String)salegoodsstr).substring(1, ((String)salegoodsstr).length());
        }
        mzkRequestDef.setGoodsList((String)salegoodsstr);
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        logger.info("\u8fd4\u5229\u5238\u67e5\u8be2\u662f\u5426\u542f\u7528\u672c\u5730\u8131\u673a:{}", (Object)this.localcache);
        RespBase respBase = this.executeCzk(session, param);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        V3MzkResultDef mzkResultDef = (V3MzkResultDef)respBase.getData();
        JSONObject json = new JSONObject();
        for (Payment p : cacheModel.getPayments()) {
            if (!mzkResultDef.getCardno().equals(p.getPayNo())) continue;
            return Code.CODE_50073.getRespBase(new Object[]{"\u5361\u53f7\u91cd\u590d"});
        }
        double ye = mzkResultDef.getYe();
        if (ye == 0.0 && SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u5f53\u524d\u4f1a\u5458\u5361\u6ca1\u6709\u53ef\u7528\u5238"});
        }
        if (StringUtils.isNotEmpty((String)mzkResultDef.getStr2())) {
            double allowpayje = 0.0;
            for (int i = 0; i < mzkResultDef.getStr2().length(); ++i) {
                Goods goods = (Goods)cacheModel.getGoodsList().get(i);
                char r = mzkResultDef.getStr2().charAt(i);
                goods.setFlMemo("");
                if (r != 'Y') continue;
                goods.setFlMemo("Y");
                allowpayje += ManipulatePrecision.getDetailOverFlow((double)goods.getSaleAmount(), (String)goods.getPrcutMode());
            }
            allowpayje = Math.min(allowpayje, ye);
            ye = Math.min(allowpayje, cacheModel.getOrder().getRemainValue());
        }
        json.put("money", (Object)ye);
        json.put("balance", (Object)mzkResultDef.getYe());
        json.put("cardNo", (Object)mzkResultDef.getCardno());
        json.put("description", (Object)mzkResultDef.getDescription());
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)json);
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"balance") || jsonObject.getString("balance").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f59\u989d]"}));
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("description"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8fd4\u5229\u5238\u63cf\u8ff0");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        String cardCode = mzkIn.getCardNo();
        mzkIn.setCardNo(mzkIn.getCardNo());
        mzkIn.setBalance(jsonObject.getDouble("balance").doubleValue());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        logger.info("\u8fd4\u5229\u5238\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        if (remainValue - mzkIn.getAmount() < 0.0 && "N".equals(mzkIn.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setCouponBalance(ManipulatePrecision.sub((double)mzkIn.getBalance(), (double)mzkIn.getAmount()));
        payment.setPayNo(cardCode);
        payment.setPayMemo("FLQ");
        String description = jsonObject.getString("description");
        payment.setDescription(description);
        payment.setBatchNo(description.split(",")[2]);
        payment.setCopType(description.split(",")[0]);
        if (remainValue - mzkIn.getAmount() > 0.0) {
            payment.setIsOverage("N");
        }
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238\u6d88\u8d39\u5931\u8d25:" + cacheModel.getErrMsg()});
        }
        V3MzkRequestDef mzkRequestDef = V3MzkRequestDef.convertReq((CacheModel)cacheModel, (MzkIn)mzkIn);
        mzkRequestDef.setType("01");
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setInvdjlb("1");
        mzkRequestDef.str1 = "02";
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        RespBase respBase = this.executeCzk(session, param);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        int maxIndex = 0;
        Double ftmoneySum = 0.0;
        HashedMap ftmap = new HashedMap();
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods g = (Goods)cacheModel.getGoodsList().get(i);
            if (StringUtils.isNotEmpty((String)g.getFlMemo()) && "Y".equals(g.getFlMemo())) {
                double ftmoney = ManipulatePrecision.doubleConvert((double)(payment.getMoney() * (g.getSaleAmount() / cacheModel.getOrder().getOughtPay())));
                ftmoneySum = ftmoneySum + ftmoney;
                ftmap.put(i, ftmoney);
            }
            if (!(g.getSaleAmount() > ((Goods)cacheModel.getGoodsList().get(maxIndex)).getSaleAmount())) continue;
            maxIndex = i;
        }
        if (ManipulatePrecision.sub((double)payment.getMoney(), (double)ftmoneySum) != 0.0) {
            ftmap.put(maxIndex, ManipulatePrecision.doubleConvert((double)((Double)ftmap.get(maxIndex) + (payment.getMoney() - ftmoneySum))));
        }
        this.appendCouponuse(cacheModel, (Map)ftmap, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public void appendCouponuse(CacheModel cacheModel, Map<Integer, Double> ftmap, Payment payment) {
        if (ftmap.size() > 0) {
            for (Map.Entry<Integer, Double> next : ftmap.entrySet()) {
                CouponUse couponUse = new CouponUse();
                couponUse.setAmount(next.getValue().doubleValue());
                couponUse.setOriAmount(next.getValue().doubleValue());
                couponUse.setCouponType("FL");
                couponUse.setCouponGroup("A");
                couponUse.setPayRowNo(payment.getRowno());
                couponUse.setPayCode(payment.getPayCode());
                couponUse.setRownoId(payment.getPuid());
                couponUse.setGoodsRowNo(((Goods)cacheModel.getGoodsList().get(next.getKey())).getFlowId());
                ((Goods)cacheModel.getGoodsList().get(next.getKey())).getOutCouponUses().add(couponUse);
            }
        }
    }

    public void removeCouponuse(CacheModel cacheModel, Payment payment) {
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods g = (Goods)cacheModel.getGoodsList().get(i);
            if (g.getCouponUses() == null || g.getOutCouponUses().size() <= 0) continue;
            Iterator iterator = g.getOutCouponUses().iterator();
            while (iterator.hasNext()) {
                CouponUse couponUse = (CouponUse)iterator.next();
                if (!"FL".equals(couponUse.getCouponType()) || !payment.getPuid().equals(couponUse.getRownoId())) continue;
                iterator.remove();
            }
        }
    }

    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("puid"))) {
            return Code.CODE_64.getRespBase(new Object[]{"\u64a4\u9500\u652f\u4ed8puid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(jsonObject.getString("puid"))) continue;
            preDeletePayment = p;
            break;
        }
        if (null == preDeletePayment) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!"});
        }
        String orderNo = "";
        String description = "";
        if (null != preDeletePayment) {
            orderNo = preDeletePayment.getRefCode();
            jsonObject.put("balance", (Object)preDeletePayment.getCouponBalance());
        } else {
            for (Payment p : cacheModel.getReturnPayments()) {
                if (!p.getPuid().equals(jsonObject.getString("puid"))) continue;
                orderNo = p.getRefCode();
                jsonObject.put("balance", (Object)p.getCouponBalance());
                description = p.getDescription();
                break;
            }
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        mzkIn.setOrderNo(orderNo);
        V3MzkRequestDef mzkRequestDef = V3MzkRequestDef.convertReq((CacheModel)cacheModel, (MzkIn)mzkIn);
        String transType = jsonObject.getString("transType");
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            if (StringUtils.isEmpty((String)transType)) {
                transType = "02";
            }
            mzkRequestDef.setInvdjlb("1");
        } else if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) || SellType.ISHCSALE((String)cacheModel.getOrder().getOrderType())) {
            if (StringUtils.isEmpty((String)transType)) {
                transType = "04";
            }
            mzkRequestDef.setInvdjlb("4");
        }
        mzkRequestDef.setType(transType);
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setFphm(Long.parseLong(preDeletePayment.getTerminalSno()));
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.str1 = "02";
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        RespBase respBase = this.executeCzk(session, param);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        if (preDeletePayment != null) {
            this.removeCouponuse(cacheModel, preDeletePayment);
        }
        cacheModel.getPayments().remove(preDeletePayment);
        PayUtil.sortPayments((List)cacheModel.getPayments());
        cacheModel.setPayments(cacheModel.getPayments());
        cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase executeCzk(ServiceSession session, JSONObject jsonObject) {
        String djlb;
        V3MzkRequestDef mzkreq = (V3MzkRequestDef)JSON.parseObject((String)jsonObject.toJSONString(), V3MzkRequestDef.class);
        V3MzkResultDef mzkResultDef = new V3MzkResultDef();
        String type = mzkreq.getType();
        if (StringUtils.isEmpty((String)type)) {
            return Code.CODE_64.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u7c7b\u578b]!"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getTrack2())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u8fd4\u5229\u5238\u5361\u53f7]"});
        }
        if (!MzkEnum.SALEQUERY.compareCode(mzkreq.getType())) {
            if (!this.checkPayType(type)) {
                return Code.CODE_64.getRespBase(new Object[]{"\u4ea4\u6613\u7c7b\u578b\u4e0d\u5339\u914d:" + type});
            }
            if (StringUtils.isEmpty((String)mzkreq.getTermno())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u673a\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getSyyh())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u5458\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getTrack2())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u8fd4\u5229\u5238\u5361\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getPaycode())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u65b9\u5f0f]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getMktcode())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u95e8\u5e97\u53f7]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getJygs())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]"});
            }
            if (StringUtils.isEmpty((String)mzkreq.getInvdjlb())) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5355\u636e\u7c7b\u578b]"});
            }
        }
        if (null == (mzkResultDef = this.crmFlCouponSaleDao.sendmzk(mzkreq))) {
            return new RespBase(Code.CODE_50058);
        }
        if (0 != mzkResultDef.recode) {
            switch (type) {
                case "01": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238[\u6d88\u8d39]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "02": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238[\u6d88\u8d39\u51b2\u6b63]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "03": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238[\u9000\u6b3e]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "04": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238[\u9000\u6b3e\u51b2\u6b63]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
                case "05": {
                    return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238[\u67e5\u8be2]\u5931\u8d25:" + mzkResultDef.getRemsg()});
                }
            }
            return Code.CODE_55563.getRespBase(new Object[0]);
        }
        String func = "";
        if (mzkResultDef.getFunc() != null && mzkResultDef.getFunc().length() >= 3) {
            func = mzkResultDef.getFunc().substring(1, 3);
        }
        String syyh = mzkreq.getSyyh() == null ? "" : mzkreq.getSyyh();
        String string = djlb = mzkreq.getInvdjlb() == null ? "" : mzkreq.getInvdjlb();
        if (type.equals("05") && SellType.ISSALE((String)mzkreq.invdjlb) && StringUtils.isNotEmpty((String)mzkreq.getGoodsList())) {
            RangeMzkRequestDef mzkreqRange = new RangeMzkRequestDef();
            mzkreqRange.setType("2");
            mzkreqRange.setJygs(mzkreq.jygs);
            mzkreqRange.setFlow(mzkreq.flow_no);
            mzkreqRange.setCardno(mzkResultDef.cardno);
            mzkreqRange.setMktcode(mzkreq.mktcode);
            mzkreqRange.setStr1(mzkreq.getGoodsList());
            V3MzkResultDef mzkRangeResultDef = this.crmFlCouponSaleDao.sendmzkRange(mzkreqRange);
            if (0 == mzkRangeResultDef.recode) {
                mzkResultDef.str2 = mzkRangeResultDef.str1;
            }
        }
        String description = func + "," + mzkResultDef.getYe() + "," + mzkResultDef.getValue2() + "," + syyh + "," + djlb;
        mzkResultDef.setDescription(description);
        mzkResultDef.setIsmz("Y");
        mzkResultDef.setRetcode("00");
        return new RespBase(Code.SUCCESS, (Object)mzkResultDef);
    }

    public RespBase saleReserve(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        if (!"02".equals(jsonObject.getString("transType")) && !"04".equals(jsonObject.getString("transType"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u53c2\u6570\u4ea4\u6613\u7c7b\u578b[transType]\u5f02\u5e38");
        }
        if (!jsonObject.containsKey((Object)"cardNo") || jsonObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]");
        }
        if (!jsonObject.containsKey((Object)"amount") || jsonObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]");
        }
        if (!jsonObject.containsKey((Object)"terminalSno") || jsonObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]");
        }
        if (!StringUtils.isEmpty((String)jsonObject.getString("flowNo"))) {
            Payment delpayment = null;
            if (vo != null && vo.getCacheModel() != null) {
                CacheModel cacheModel = vo.getCacheModel();
                for (Payment p : cacheModel.getPayments()) {
                    if (!p.getRefCode().equals(jsonObject.getString("orderNo"))) continue;
                    jsonObject.put("puid", (Object)p.getPuid());
                    delpayment = p;
                    break;
                }
            }
            if (delpayment != null) {
                return this.cancelPay(session, vo, jsonObject);
            }
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        JSONObject modeDetailsVo = MzkSaleUtil.getRedisData((JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        ModeDetailsVo modeDetailsVo2 = (ModeDetailsVo)JSONObject.parseObject((String)modeDetailsVo.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo2.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        JSONObject syjMain = modeDetailsVo.getJSONObject("syjmain");
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)jsonObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn mzkIn = MzkSaleUtil.loadRequestPara((JSONObject)jsonObject, (JSONObject)syjMain, (PaymentMode)mzkPayMode);
        String transType = jsonObject.getString("transType");
        String indjlb = "1";
        if ("04".equals(transType)) {
            indjlb = "4";
        }
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        mzkRequestDef.setFlow_no("");
        mzkRequestDef.setType(transType);
        mzkRequestDef.setSeqno(Long.parseLong(mzkIn.getOrderNo()));
        mzkRequestDef.setTermno(mzkIn.getMzkTerminalNo());
        mzkRequestDef.setMktcode(mzkIn.getShopCode());
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setSyjh(mzkIn.getMzkTerminalNo());
        mzkRequestDef.setFphm(Long.parseLong(jsonObject.getString("terminalSno")));
        mzkRequestDef.setSyyh(mzkIn.getTerminalOperator());
        mzkRequestDef.setInvdjlb(indjlb);
        mzkRequestDef.setPaycode(mzkIn.getPayCode());
        mzkRequestDef.setJe(mzkIn.getAmount());
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.setTrack2(mzkIn.getCardNo());
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd("");
        mzkRequestDef.setMemo("");
        mzkRequestDef.str1 = "02";
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        RespBase respBase = this.executeCzk(session, param);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (!jsonObject.containsKey((Object)"balance") || jsonObject.getString("balance").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u9000\u8d27\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f59\u989d]"}));
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("description"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u8fd4\u5229\u5238\u63cf\u8ff0");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        String cardCode = mzkIn.getCardNo();
        mzkIn.setCardNo(mzkIn.getCardNo());
        mzkIn.setBalance(jsonObject.getDouble("balance").doubleValue());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        logger.info("\u8fd4\u5229\u5238\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        V3MzkRequestDef mzkRequestDef = V3MzkRequestDef.convertReq((CacheModel)cacheModel, (MzkIn)mzkIn);
        mzkRequestDef.setType("03");
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setInvdjlb("4");
        mzkRequestDef.str1 = "02";
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"CRMFLCOUPONEXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u8fd4\u5229\u5238\u9000\u8d27 ", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u8fd4\u5229\u5238\u9000\u8d27", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238\u9000\u8d27\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("retflag"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u8fd4\u5229\u5238\u9000\u8d27\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    private boolean checkPayType(String payType) {
        switch (payType) {
            case "01": {
                return true;
            }
            case "02": {
                return true;
            }
            case "03": {
                return true;
            }
            case "04": {
                return true;
            }
            case "05": {
                return true;
            }
        }
        return false;
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    public RespBase saleQueryNoFlow(ServiceSession session, JSONObject jsonObject) {
        if (StringUtils.isEmpty((String)jsonObject.getString("cardNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f1a\u5458\u5361\u53f7]");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        obj = this.reCacheMode(obj, jsonObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String v3jygs = ModeDetailsVo.getSysParaValue((List)syspara, (String)"V3JYGS");
        if (StringUtils.isEmpty((String)v3jygs)) {
            return Code.CODE_30127.getRespBase(new Object[0]);
        }
        V3MzkRequestDef mzkRequestDef = new V3MzkRequestDef();
        mzkRequestDef.setType("05");
        mzkRequestDef.setJygs(v3jygs);
        mzkRequestDef.setInvdjlb("1");
        mzkRequestDef.setTermno(jsonObject.getString("terminalNo"));
        mzkRequestDef.setMktcode(jsonObject.getString("shopCode"));
        mzkRequestDef.setSyjh(jsonObject.getString("terminalNo"));
        mzkRequestDef.setJe(0.0);
        mzkRequestDef.setTrack1("CARDNO");
        mzkRequestDef.setTrack2(jsonObject.getString("cardNo"));
        mzkRequestDef.setTrack3("");
        mzkRequestDef.setPasswd("");
        mzkRequestDef.setMemo("");
        mzkRequestDef.str1 = "02";
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        RespBase respBase = this.executeCzk(session, param);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        V3MzkResultDef mzkResultDef = (V3MzkResultDef)respBase.getData();
        JSONObject json = new JSONObject();
        json.put("flmoney", (Object)mzkResultDef.getYe());
        json.put("cardNo", (Object)mzkResultDef.getCardno());
        return new RespBase(Code.SUCCESS, (Object)json);
    }
}

