/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.erajaya.ErajayaRespVo;
import com.efuture.business.model.mzk.request.GetOtpIn;
import com.efuture.business.service.ErajayaSaleBS;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.SHA256Util;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ErajayaSaleBSImpl
implements ErajayaSaleBS {
    @Autowired
    protected RedisUtil redisUtil;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Value(value="${pay.vipUrl}")
    protected String vipUrl;

    public RespBase getOtp(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("type"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"type"});
        }
        GetOtpIn getOtpIn = (GetOtpIn)JSONObject.toJavaObject((JSON)paramsObject, GetOtpIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60.getRespBase(new Object[]{getOtpIn.getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        String provider = "";
        if (null != order && null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getConsumersId())) {
            if (StringUtils.isNotBlank((String)order.getConsumersData().getEmail()) && !order.getConsumersData().getEmail().contains("*")) {
                provider = "email";
                getOtpIn.setIdentifier(order.getConsumersData().getEmail());
            } else {
                provider = "whatsapp";
                getOtpIn.setIdentifier(order.getConsumersData().getMobile());
            }
        } else {
            return Code.CODE_50147.getRespBase(new Object[0]);
        }
        String otp_Client = "eraspace";
        String deviceId = getOtpIn.getShopCode() + getOtpIn.getTerminalNo();
        String sign = SHA256Util.getSHA256String((String)(otp_Client + deviceId + getOtpIn.getIdentifier()));
        HashMap<String, Object> headMap = new HashMap<String, Object>();
        headMap.put("Source", "grandlucky");
        headMap.put("Otp-Client", otp_Client);
        headMap.put("Otp-provider", provider);
        headMap.put("Device-ID", deviceId);
        headMap.put("Authorization", "Basic Y3VzdGJhc2ljOk9MV2llWlVvQlA=");
        headMap.put("Signature", sign);
        ServiceResponse resp = this.httpUtils.doErajayaPost("", GlobalInfo.mburl, "/e-customers/v2.1/otp/request", session, JSONObject.toJSONString((Object)getOtpIn), ErajayaRespVo.class, "ERAJAYA", "\u83b7\u53d6OTP", headMap);
        if ("0".equals(resp.getReturncode())) {
            ErajayaRespVo res1 = (ErajayaRespVo)resp.getData();
            if (null != res1.getData() && StringUtils.isBlank((String)res1.getErrorCode())) {
                return new RespBase(Code.SUCCESS, "\u6210\u529f");
            }
            return Code.CODE_50140.getRespBase(new Object[]{res1.getMessage()});
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    public RespBase getToken(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("terminalNo"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"\u7ec8\u7aef\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"\u95e8\u5e97\u53f7"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"YNKEY");
        if (StringUtils.isBlank((String)mbkey) || mbkey.split(",").length < 2) {
            return Code.CODE_50129.getRespBase(new Object[]{"YNKEY"});
        }
        String[] split = mbkey.split(",");
        JSONObject j = new JSONObject();
        j.put("client_id", (Object)split[0]);
        j.put("client_secret", (Object)split[1]);
        ServiceResponse resp = this.httpUtils.doErajayaPost("", GlobalInfo.mburl, "/e-memberpoints-stg/v1/auth/oauth/access-token?grant_type=client_credentials", session, j.toJSONString(), ErajayaRespVo.class, "ERAJAYA", "\u83b7\u53d6token", null);
        if ("0".equals(resp.getReturncode())) {
            ErajayaRespVo res1 = (ErajayaRespVo)resp.getData();
            if (null != res1.getData() && StringUtils.isBlank((String)res1.getErrorCode())) {
                String token = res1.getData().getString("access_token");
                return new RespBase(Code.SUCCESS, (Object)token, "");
            }
            return Code.CODE_50140.getRespBase(new Object[]{res1.getMessage()});
        }
        return Code.CODE_40029.getRespBase(new Object[0]);
    }

    public static void main(String[] args) {
        String sms_Client = "eraspace";
        String deviceId = "82b98e4a-0ce4-41c0-a007-78e7bdaa1818";
        String s = "sri.cifo@gmail.com";
        String sign = SHA256Util.getSHA256String((String)(sms_Client + deviceId + s));
        System.out.println(sign);
    }
}

