/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.MzCouponSaleDaoGzyy;
import com.efuture.business.enumcase.MzkEnum;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.model.mzk.request.MzCouponInDto;
import com.efuture.business.model.mzk.request.MzkRequestGzyyDef;
import com.efuture.business.model.mzk.response.MzkResultGzyyDef;
import com.efuture.business.service.MzCouponSaleBS;
import com.efuture.business.service.MzkSaleBS;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.MzkSaleUtil;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceSession;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MzCouponSaleBSImpl
implements MzCouponSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(MzCouponSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private MzkSaleBS mzkSaleBS;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MzCouponSaleDaoGzyy mzCouponSaleDao;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public RespBase couponQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1001.getRespBase(new Object[0]);
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("flowNo"))) {
            return new RespBase(Code.CODE_64.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7f13\u5b58\u53f7]");
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("cardNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5238\u53f7]");
        }
        if (null == jsonObject.getDouble("amount")) {
            jsonObject.put("amount", (Object)0);
        }
        MzkIn in = MzkSaleUtil.loadRequestPara((JSONObject)jsonObject);
        MzkRequestGzyyDef mzkRequestDef = new MzkRequestGzyyDef(in);
        mzkRequestDef.setVtype(MzkEnum.SALEQUERY.getCode());
        CacheModel cacheModel = vo.getCacheModel();
        mzkRequestDef.setOrderType(cacheModel.getOrder().getOrderType());
        mzkRequestDef.setVsyyh(cacheModel.getOrder().getTerminalOperator());
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"COUPONEXECUTE");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5238\u67e5\u8be2", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5238\u67e5\u8be2", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                MzkResultGzyyDef mzkResultGzyyDef = (MzkResultGzyyDef)JSONObject.parseObject((String)object.getString("data"), MzkResultGzyyDef.class);
                respBase = new RespBase(Code.SUCCESS, (Object)mzkResultGzyyDef);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u67e5\u8be2\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        MzkResultGzyyDef mzkResultDef = (MzkResultGzyyDef)respBase.getData();
        JSONObject json = new JSONObject();
        json.put("money", (Object)mzkResultDef.getRamount());
        json.put("cardNo", (Object)mzkResultDef.getRcardno());
        json.put("minimumAmount", (Object)mzkResultDef.getMinimumAmount());
        json.put("consumersId", (Object)mzkResultDef.getConsumersId());
        json.put("isPassword", (Object)mzkResultDef.getIsPassword());
        json.put("description", (Object)mzkResultDef.getDescription());
        String flowNo = jsonObject.getString("flowNo");
        this.redisUtil.set(RedisKey.CARDNO + flowNo + mzkResultDef.getRcardno(), (Object)JSONObject.toJSONString((Object)mzkResultDef), (long)(GlobalInfo.redistimeout * 10));
        return new RespBase(Code.SUCCESS, (Object)json);
    }

    public RespBase couponPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        Order order;
        if (StringUtils.isEmpty((String)jsonObject.getString("description"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u5238\u63cf\u8ff0");
        }
        jsonObject.put("balance", (Object)0);
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String flowNo = jsonObject.getString("flowNo");
        String mzkResult = this.redisUtil.get(RedisKey.CARDNO + flowNo + mzkIn.getCardNo());
        if (StringUtils.isEmpty((String)mzkResult)) {
            return new RespBase(Code.CODE_64.getIndex(), "\u5238\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        MzkResultGzyyDef mzkResultGzyyDef = (MzkResultGzyyDef)JSONObject.parseObject((String)mzkResult, MzkResultGzyyDef.class);
        if ("Y".equals(mzkResultGzyyDef.getIsPassword())) {
            if (StringUtils.isEmpty((String)jsonObject.getString("password"))) {
                return Code.CODE_500001.getRespBase(new Object[]{"\u5238\u5bc6\u7801"});
            }
            if (!jsonObject.getString("password").equals(mzkResultGzyyDef.getPassword())) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u5238\u652f\u4ed8\u5bc6\u7801\u9519\u8bef"});
            }
        }
        if (null == (order = cacheModel.getOrder())) {
            return new RespBase(Code.CODE_64.getIndex(), "\u5238\u652f\u4ed8\u65e0\u6cd5\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f");
        }
        if (mzkResultGzyyDef.getMinimumAmount() > 0.0 && order.getOughtPay() < mzkResultGzyyDef.getMinimumAmount()) {
            return new RespBase(Code.CODE_64.getIndex(), "\u5238\u652f\u4ed8\u5931\u8d25:\u6700\u4f4e\u7528\u5238\u95e8\u69db[" + mzkResultGzyyDef.getMinimumAmount() + "]\u5143,\u5f53\u524d\u8ba2\u5355\u5e94\u6536\u91d1\u989d[" + order.getOughtPay() + "]\u5143");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        List goodsList = cacheModel.getGoodsList();
        Object orgCode = "";
        for (int i = 0; i < goodsList.size(); ++i) {
            String re = 0 == i ? "" : ",";
            orgCode = (String)orgCode + re + ((Goods)goodsList.get(i)).getOrgCode();
        }
        String retVale = this.checkCoupon(mzkIn.getShopCode(), (String)orgCode, mzkIn.getCardNo());
        String[] recodes = retVale.split(",");
        double payAmount = 0.0;
        for (int i = 0; i < goodsList.size(); ++i) {
            if (!"Y".equals(recodes[i])) continue;
            payAmount += ((Goods)goodsList.get(i)).getSaleValue();
        }
        if (payAmount <= 0.0) {
            return Code.CODE_55566.getRespBase(new Object[0]);
        }
        if (payAmount - mzkIn.getAmount() < 0.0 && "N".equals(mzkIn.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        double overage = 0.0;
        if (mzkIn.getAmount() > payAmount) {
            overage = mzkIn.getAmount() - payAmount;
            mzkIn.setIsOverage("Y");
        } else {
            mzkIn.setIsOverage("N");
        }
        Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setAmount(mzkIn.getAmount());
        payment.setOverage(overage);
        payment.setPayMemo("MZK");
        String description = jsonObject.getString("description");
        payment.setDescription(description);
        payment.setBatchNo(description.split(",")[2]);
        payment.setCopType(description.split(",")[0]);
        double faceValue = Double.parseDouble(description.split(",")[1]);
        payment.setMonthlyInstallment(faceValue);
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u6838\u9500\u5931\u8d25:" + cacheModel.getErrMsg()});
        }
        logger.info("\u5238\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        MzkRequestGzyyDef mzkreq = new MzkRequestGzyyDef(mzkIn);
        mzkreq.setVtype(MzkEnum.SALEPAY.getCode());
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkreq);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"COUPONEXECUTE");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5238\u6838\u9500", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5238\u6838\u9500", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u6838\u9500\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u6838\u9500\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    private String checkCoupon(String shopCode, String orgCode, String cardNo) {
        MzCouponInDto mzCouponInDto = new MzCouponInDto();
        mzCouponInDto.setVmkt(shopCode);
        mzCouponInDto.setVgz(orgCode);
        mzCouponInDto.setVcode(cardNo);
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzCouponInDto);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"COUPONEXECUTE");
                param.put("codeType", (Object)MzkEnum.CHECKCOUPON.getCode());
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{param.getString("flowNo"), "\u9762\u503c\u5238\u9a8c\u8bc1", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{param.getString("flowNo"), "\u9762\u503c\u5238\u9a8c\u8bc1", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u9a8c\u8bc1\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                return object.getString("data");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new EfutureException(Code.FAIL.getRespBase(new Object[]{"\u9762\u503c\u5238\u9a8c\u8bc1\u9519\u8bef:" + e.getMessage()}));
            }
        }
        return this.mzCouponSaleDao.checklq(mzCouponInDto);
    }

    public RespBase couponCancelPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        jsonObject.put("codeType", (Object)MzkEnum.COUPON.getCode());
        jsonObject.put("balance", (Object)0);
        return this.mzkSaleBS.cancelPay(session, vo, jsonObject);
    }

    public RespBase executeCzk(ServiceSession session, JSONObject jsonObject) {
        if (MzkEnum.CHECKCOUPON.getCode().equals(jsonObject.getString("codeType"))) {
            String mkt = jsonObject.getString("vmkt");
            String gz = jsonObject.getString("vgz");
            String code = jsonObject.getString("vcode");
            String retVale = this.checkCoupon(mkt, gz, code);
            return new RespBase(Code.SUCCESS, (Object)retVale, jsonObject.getString("command_id"));
        }
        jsonObject.put("codeType", (Object)MzkEnum.COUPON.getCode());
        return this.mzkSaleBS.executeCzk(session, jsonObject);
    }

    public RespBase saleReserve(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        if (!StringUtils.isEmpty((String)jsonObject.getString("flowNo"))) {
            if (null == vo) {
                return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
            }
            return this.couponCancelPay(session, vo, jsonObject);
        }
        if (!jsonObject.containsKey((Object)"cardNo") || jsonObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        if (!jsonObject.containsKey((Object)"amount") || jsonObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]");
        }
        JSONObject modeDetailsVo = MzkSaleUtil.getRedisData((JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        JSONObject syjMain = modeDetailsVo.getJSONObject("syjmain");
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)jsonObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn mzkIn = MzkSaleUtil.loadRequestPara((JSONObject)modeDetailsVo, (JSONObject)syjMain, (PaymentMode)mzkPayMode);
        MzkRequestGzyyDef mzkreq = new MzkRequestGzyyDef(mzkIn);
        mzkreq.setVtype(MzkEnum.CANCELPAY.getCode());
        mzkreq.setCodeType(MzkEnum.MZK.getCode());
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkreq);
        RespBase respBase = null;
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"COUPONEXECUTE");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5238\u5f00\u673a\u51b2\u6b63", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5238\u5f00\u673a\u51b2\u6b63", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u5f00\u673a\u51b2\u6b63\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5238\u5f00\u673a\u51b2\u6b63\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase couponRefund(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        jsonObject.put("codeType", (Object)MzkEnum.COUPON.getCode());
        return this.mzkSaleBS.saleRefund(session, vo, jsonObject);
    }
}

