/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.wslf.request.SzyktReqDef;
import com.efuture.business.javaPos.struct.wslf.response.SzyktRespDef;
import com.efuture.business.javaPos.struct.wslf.response.SzyktRespDetailsDef;
import com.efuture.business.service.SzyktSaleBS;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PhoneUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/*
 * Exception performing whole class analysis ignored.
 */
public class SzyktSaleBSImpl
implements SzyktSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SzyktSaleBSImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private PosLogicService posLogicService;
    @Autowired
    private PosLogicCompoment posLogicCompoment;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${wslfip}")
    private String ip;
    @Value(value="${wslfport}")
    Integer port;

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u7801/\u624b\u673a\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"codeType") || paramsObject.getString("codeType").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u7c7b\u522b]");
        }
        if ("5".equals(paramsObject.getString("codeType")) && !PhoneUtils.isChinaPhoneLegal((String)paramsObject.getString("codeValue"))) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u4ed8\u6b3e\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7!");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt")) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u91d1\u989d]");
        }
        SzyktReqDef in = (SzyktReqDef)JSONObject.toJavaObject((JSON)paramsObject, SzyktReqDef.class);
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007, (Object)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - in.getTradeAmt() < 0.0) {
            return new RespBase(Code.CODE_50050, (Object)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01", vo.getCacheModel().getFlowNo());
        }
        String reqLine = this.getRequestLine("MP", in);
        String returnData = null;
        try {
            returnData = this.socketPost(reqLine, this.ip, String.valueOf(this.port));
        }
        catch (Exception e) {
            log.info("\u6570\u5b57\u4e00\u5361\u901a-\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38 ==>{}", (Object)e.toString());
            e.printStackTrace();
        }
        log.info("[\u6570\u5b57\u4e00\u5361\u901a] -->[\u4ed8\u6b3e\u8bf7\u6c42] \u8fd4\u56de\u62a5\u6587 [{}]", (Object)returnData);
        if (!StringUtils.isNotBlank((String)returnData) || returnData.indexOf("|") == -1) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef!");
        }
        SzyktRespDef response = this.parseReturnData("MP", returnData);
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
        PaymentMode szyktPayMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)this.getRedisData(paramsObject));
        if ("4000".equals(response.getCode())) {
            Payment payment = new Payment();
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setPayNo(in.getCodeValue());
            payment.setCouponBalance(response.getBalance());
            payment.setRefCode(in.getOrderNo());
            payment.setPayCode(in.getPayCode());
            payment.setPayName(szyktPayMode.getName());
            payment.setPayType(szyktPayMode.getPaytype());
            payment.setPasswd(in.getPassword());
            payment.setTrackData(in.getCodeValue());
            payment.setAmount(in.getTradeAmt());
            payment.setTerminalNo(in.getTerminalNo());
            payment.setTerminalSno(in.getTerminalSno());
            payment.setCustmnerName(in.getAccountNo());
            payment.setPrecision(String.valueOf(szyktPayMode.getSswrjd()));
            payment.setPrcutMode(szyktPayMode.getSswrfs());
            payment.setRate(szyktPayMode.getZlhl().doubleValue());
            payment.setFlag("1");
            payment.setPayMemo(response.getWstranNo());
            payment.setMemo(response.getBillDate());
            payment.setRowno(cacheModel.getPayments().size() + 1);
            if ("1".equals(in.getScene())) {
                payment.setPopFlag("1");
            }
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            log.info("\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSALEPAY")));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSALEPAY");
        }
        return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a" + response.getMsg());
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[puid]");
        }
        if (!paramsObject.containsKey((Object)"tradeDate") || paramsObject.getString("tradeDate").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u4ea4\u6613\u65e5\u671f]");
        }
        if (!paramsObject.containsKey((Object)"wstranNo") || paramsObject.getString("wstranNo").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u4ed8\u6b3e\u7f51\u5173\u4e8b\u52a1\u5355\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"tradeAmt")) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u91d1\u989d]");
        }
        SzyktReqDef in = (SzyktReqDef)JSONObject.toJavaObject((JSON)paramsObject, SzyktReqDef.class);
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String puid = in.getPuid();
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            break;
        }
        String reqLine = this.getRequestLine("MR", in);
        String returnData = null;
        try {
            returnData = this.socketPost(reqLine, this.ip, String.valueOf(this.port));
        }
        catch (Exception e) {
            log.info("\u6570\u5b57\u4e00\u5361\u901a-\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38 ==>{}", (Object)e.toString());
            e.printStackTrace();
        }
        log.info("[\u6570\u5b57\u4e00\u5361\u901a] -->[\u9000\u6b3e\u8bf7\u6c42] \u8fd4\u56de\u62a5\u6587 [{}]", (Object)returnData);
        if (!StringUtils.isNotBlank((String)returnData) || returnData.indexOf("|") == -1) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef!");
        }
        SzyktRespDef response = this.parseReturnData("MR", returnData);
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
        BaseOutModel out = new BaseOutModel();
        try {
            if ("4000".equals(response.getCode())) {
                if (PreDeletePayment != null) {
                    cacheModel.getPayments().remove(PreDeletePayment);
                    cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        String errCode = "100000";
                        if (cacheModel.getErrCode().length() > 0) {
                            errCode = cacheModel.getErrCode();
                        }
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSALEREFUND");
                    }
                }
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                log.info("\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSALEREFUND")));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSALEREFUND");
            }
            return new RespBase(Code.CODE_50052.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u5931\u8d25\u539f\u56e0:" + response.getMsg(), JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.CODE_50052.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u9000\u6b3e\u53d1\u751f\u5f02\u5e38[{0}]!", e.getMessage());
        }
    }

    public RespBase sendVerificationCode(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"codeValue") || paramsObject.getString("codeValue").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u77ed\u4fe1\u9a8c\u8bc1\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u624b\u673a\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u95e8\u5e97\u53f7]");
        }
        SzyktReqDef in = (SzyktReqDef)JSONObject.toJavaObject((JSON)paramsObject, SzyktReqDef.class);
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801-in ==>{}", (Object)JSONObject.toJSONString((Object)in));
        String reqLine = this.getRequestLine("MS", in);
        String returnData = null;
        try {
            returnData = this.socketPost(reqLine, this.ip, String.valueOf(this.port));
        }
        catch (Exception e) {
            log.info("\u6570\u5b57\u4e00\u5361\u901a-\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38 ==>{}", (Object)e.toString());
            e.printStackTrace();
        }
        log.info("[\u6570\u5b57\u4e00\u5361\u901a] -->[\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8bf7\u6c42] \u8fd4\u56de\u62a5\u6587 [{}]", (Object)returnData);
        if (!StringUtils.isNotBlank((String)returnData) || returnData.indexOf("|") == -1) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9519\u8bef!");
        }
        SzyktRespDef response = this.parseReturnData("MS", returnData);
        log.info("\u6570\u5b57\u4e00\u5361\u901a\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)response));
        if ("4000".equals(response.getCode())) {
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)vo.getCacheModel(), (JSONObject)((JSONObject)JSONObject.toJSON((Object)response)));
            log.info("\u6570\u5b57\u4e00\u5361\u901a\u53d1\u9001\u9a8c\u8bc1\u7801\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSENDVERIFICATIONCODE")));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "SZYKTSENDVERIFICATIONCODE");
        }
        return new RespBase(Code.CODE_50025.getIndex(), "\u6570\u5b57\u4e00\u5361\u901a\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\uff1a" + response.getMsg());
    }

    private String getRequestLine(String type, SzyktReqDef in) {
        String reqLine = null;
        switch (type) {
            case "MP": {
                reqLine = "MP|" + in.getCodeType() + "|" + in.getCodeValue() + "|" + in.getPassword() + "|" + in.getFlowNo() + "|" + String.valueOf(in.getTradeAmt()) + "|" + in.getShopCode() + "|" + in.getErpCode() + "||" + in.getTerminalNo() + "|||" + in.getTerminalOperator() + "|";
                break;
            }
            case "MR": {
                String wstransno = in.getWstranNo().contains("#") ? in.getWstranNo().split("#")[0] : in.getWstranNo();
                reqLine = "MR|" + in.getTradeDate().substring(2, 10) + "||" + in.getTradeAmt() + "||||||||" + wstransno;
                break;
            }
            case "MS": {
                reqLine = "MS|" + in.getCodeValue() + "|" + in.getShopCode() + "|";
            }
        }
        reqLine = this.getLenthByGB2312EnCoding(reqLine) + reqLine;
        log.info("\u6570\u5b57\u4e00\u5361\u901a -->[\u63a5\u53e3\u8bf7\u6c42] ip ==>{}", (Object)this.ip);
        log.info("\u6570\u5b57\u4e00\u5361\u901a -->[\u63a5\u53e3\u8bf7\u6c42] port ==>{}", (Object)this.port);
        log.info("\u6570\u5b57\u4e00\u5361\u901a -->[\u63a5\u53e3\u8bf7\u6c42] reqLine ==>{}", (Object)reqLine);
        return reqLine;
    }

    private SzyktRespDef parseReturnData(String type, String data) {
        SzyktRespDef szyktRespDef = new SzyktRespDef();
        try {
            String[] sp = data.split("\\|");
            if (sp.length == 3) {
                szyktRespDef.setRequestType(sp[0]);
                szyktRespDef.setCode(sp[1]);
                szyktRespDef.setMsg(sp[2]);
            } else if ("MP".equals(type) || "MR".equals(type)) {
                szyktRespDef.setRequestType(sp[0]);
                szyktRespDef.setCode(sp[1]);
                szyktRespDef.setMsg(sp[2]);
                szyktRespDef.setFlowNo(sp[3]);
                szyktRespDef.setShopCode(sp[4]);
                szyktRespDef.setErpCode(sp[5]);
                szyktRespDef.setBillDate(sp[6]);
                szyktRespDef.setAccountNo(sp[7]);
                szyktRespDef.setAmount(Double.valueOf(sp[8]).doubleValue());
                szyktRespDef.setBalance(Double.valueOf(sp[9]).doubleValue());
                szyktRespDef.setWstranNo(sp[10]);
                ArrayList<SzyktRespDetailsDef> details = new ArrayList<SzyktRespDetailsDef>();
                for (int i = 11; i < sp.length; ++i) {
                    if (!StringUtils.isNotBlank((String)sp[i])) continue;
                    SzyktRespDetailsDef detail = new SzyktRespDetailsDef();
                    if (sp[i].indexOf(";") != -1) {
                        String[] split = sp[i].split(";");
                        detail.setAmt(Double.valueOf(split[0]).doubleValue());
                        detail.setCardNo(split[1]);
                    } else {
                        detail.setAmt(Double.valueOf(sp[i]).doubleValue());
                    }
                    details.add(detail);
                }
                szyktRespDef.setDetails(details);
            } else if ("MS".equals(type)) {
                szyktRespDef.setRequestType(sp[0]);
                szyktRespDef.setCode(sp[1]);
                szyktRespDef.setMsg(sp[2]);
                szyktRespDef.setAccountNo(sp[3]);
                szyktRespDef.setShopCode(sp[4]);
                szyktRespDef.setSmsCode(sp[5]);
            }
        }
        catch (NumberFormatException e) {
            log.info("\u6570\u5b57\u4e00\u5361\u901a\u8fd4\u56de\u62a5\u6587\u5c01\u88c5\u5f02\u5e38\uff1a" + e.toString());
            e.printStackTrace();
        }
        return szyktRespDef;
    }

    private JSONObject getRedisData(JSONObject paramsObject) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        return JSONObject.parseObject((String)obj);
    }

    private String getLenthByGB2312EnCoding(String msg) {
        StringBuffer sbuffBuffer = null;
        try {
            byte[] msgBty = msg.getBytes("GB2312");
            sbuffBuffer = new StringBuffer();
            int msgLen = msgBty.length;
            String lenStr = String.valueOf(msgLen);
            for (int i = lenStr.length(); i < 6; ++i) {
                sbuffBuffer.append("0");
            }
            sbuffBuffer.append(lenStr);
        }
        catch (UnsupportedEncodingException e) {
            log.info("\u6570\u5b57\u4e00\u5361\u901a\u7f16\u7801\u5f02\u5e38 ==>{}", (Object)e.toString());
            e.printStackTrace();
        }
        return sbuffBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String socketPost(String msg, String clientIp, String clientPort) {
        String rs = "";
        if (clientIp == null || "".equals(clientIp) || clientPort == null || "".equals(clientPort)) {
            log.error("Ip\u6216\u7aef\u53e3\u4e0d\u5b58\u5728...");
            return null;
        }
        int clientPortInt = Integer.parseInt(clientPort);
        Socket s = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            s = new Socket(clientIp, clientPortInt);
            s.setSendBufferSize(4096);
            s.setTcpNoDelay(true);
            s.setSoTimeout(60000);
            s.setKeepAlive(true);
            out = s.getOutputStream();
            in = s.getInputStream();
            log.info("\u51c6\u5907\u53d1\u9001\u62a5\u6587\uff1a" + msg);
            out.write(msg.getBytes("GBK"));
            out.flush();
            byte[] rsByte = SzyktSaleBSImpl.readStream((InputStream)in);
            if (rsByte != null) {
                rs = new String(rsByte, "GBK");
            }
        }
        catch (Exception e) {
            log.error("tcpPost\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            log.info("tcpPost(rs)\uff1a" + rs);
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (in != null) {
                    in.close();
                    in = null;
                }
                if (s != null) {
                    s.close();
                    s = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream in) {
        if (in == null) {
            return null;
        }
        byte[] b = null;
        ByteArrayOutputStream outSteam = null;
        try {
            byte[] buffer = new byte[1024];
            outSteam = new ByteArrayOutputStream();
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                outSteam.write(buffer, 0, len);
            }
            b = outSteam.toByteArray();
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6d41\u4fe1\u606f\u5f02\u5e38" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (outSteam != null) {
                    outSteam.close();
                    outSteam = null;
                }
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return b;
    }
}

