/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.SysPara;
import com.efuture.business.javaPos.struct.request.DeletePaymentIn;
import com.efuture.business.javaPos.struct.request.PaymentIn;
import com.efuture.business.model.allVpay.request.RefundPayRequest;
import com.efuture.business.model.zex.ZexCouponOut;
import com.efuture.business.model.zex.ZexPayIn;
import com.efuture.business.model.zex.ZexUseCouponOut;
import com.efuture.business.service.ZexSaleBS;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpZexUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.SubmitUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.DigestUtils;

public class ZexSaleBSImpl
implements ZexSaleBS {
    private static final Logger log = LoggerFactory.getLogger(ZexSaleBSImpl.class);
    @Value(value="${globalinfo.signKey:000}")
    private String signKey;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    private PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    private RedisUtil redisUtil;

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        double remainValue;
        ZexPayIn inVO = (ZexPayIn)JSON.parseObject((String)paramsObject.toJSONString(), ZexPayIn.class);
        log.info("\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)inVO));
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        PaymentIn in = new PaymentIn();
        String obj = this.redisUtil.get(RedisKey.CACHEID + inVO.getShopCode() + inVO.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String zexIp = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ZEXIP");
        if (StringUtils.isBlank((String)zexIp)) {
            return Code.CODE_55557.getRespBase(new Object[]{"ZEXIP\u53c2\u6570\u672a\u83b7\u53d6\u5230,\u8bf7\u68c0\u67e5\u540e\u53f0"});
        }
        JSONObject jsonObject = JSONObject.parseObject((String)obj);
        if (obj != null) {
            for (int i = 0; i < jsonObject.getJSONArray("paymode").size(); ++i) {
                JSONObject model = jsonObject.getJSONArray("paymode").getJSONObject(i);
                if (!inVO.getPayCode().equals(model.getString("code"))) continue;
                in.setScene("0");
                in.setRate(model.getDouble("pyhl").doubleValue());
                in.setAuthCode(model.getString("authCode"));
                in.setChargeRate(model.getDouble("zlhl").doubleValue());
                in.setFlag(model.getString("flag"));
                in.setIsAllowCharge(model.getString("iszl"));
                in.setIsOverage(model.getString("isyy"));
                in.setMinVal(model.getBigDecimal("minval").doubleValue());
                in.setMaxVal(model.getBigDecimal("maxval").doubleValue());
                in.setCutMode(model.getString("sswrfs"));
                in.setPrecision(model.getString("sswrjd"));
                in.setPayCode(inVO.getPayCode());
                in.setPayName(model.getString("name"));
                in.setPayType(model.getString("paytype"));
                in.setAmount(Double.parseDouble(inVO.getMoney()));
                in.setMoney(Double.parseDouble(inVO.getMoney()));
            }
        }
        if ((remainValue = (cacheModel = this.posLogicCompoment.calcBalance(cacheModel)).getOrder().getRemainValue()) <= 0.0) {
            return new RespBase(Code.CODE_50007, (Object)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - in.getMoney() < 0.0) {
            return new RespBase(Code.CODE_500003, (Object)"\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        log.info("\u8bf7\u6c42\u77e5\u800c\u884c\u5730\u5740===>{}", (Object)zexIp);
        String url = zexIp + "/zex/ws/useCoupons";
        JSONObject jsonRequest = this.getRequest(cacheModel, inVO);
        log.info("json request ==>{}", (Object)JSONObject.toJSONString((Object)jsonRequest));
        Map sParaTemp = SubmitUtil.paraFilter((Map)jsonRequest);
        Object prestr = SubmitUtil.createLinkString((Map)sParaTemp);
        prestr = (String)prestr + "&" + this.signKey;
        log.info("\u6392\u5e8f=>{}", prestr);
        String sign = DigestUtils.md5DigestAsHex((byte[])((String)prestr).getBytes());
        jsonRequest.put("sign", (Object)sign);
        log.info("\u77e5\u800c\u884c\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)jsonRequest));
        String response = HttpZexUtils.post((String)url, (String)JSONObject.toJSONString((Object)jsonRequest));
        log.info("\u77e5\u800c\u884c\u63a5\u53e3\u8fd4\u56de==>{}", (Object)response);
        BigDecimal couponAmount = BigDecimal.ZERO;
        if (StringUtils.isBlank((String)response)) {
            return Code.CODE_55557.getRespBase(new Object[]{response});
        }
        ZexUseCouponOut zexUseCouponOut = (ZexUseCouponOut)JSONObject.parseObject((String)response, ZexUseCouponOut.class);
        if (!"SUCCESS".equalsIgnoreCase(zexUseCouponOut.getCode())) {
            if (ArrayUtils.isNotEmpty((List)zexUseCouponOut.getCouponList())) {
                return Code.CODE_55557.getRespBase(new Object[]{((ZexCouponOut)zexUseCouponOut.getCouponList().get(0)).getResultMessage()});
            }
            return Code.CODE_55557.getRespBase(new Object[]{zexUseCouponOut.getMessage()});
        }
        List zexCouponOutList = zexUseCouponOut.getCouponList();
        for (ZexCouponOut zexCouponOut : zexCouponOutList) {
            if (!"SUCCESS".equalsIgnoreCase(zexCouponOut.getResultCode())) {
                return Code.CODE_55557.getRespBase(new Object[]{zexCouponOut.getResultMessage()});
            }
            couponAmount = zexCouponOut.getCouponAmount();
        }
        cacheModel.getOrder().setUseZex(Boolean.valueOf(true));
        Payment payment = new Payment();
        payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
        payment.setPayNo(inVO.getCouponNo());
        payment.setPayCode(in.getPayCode());
        payment.setPayName(in.getPayName());
        payment.setPayType(in.getPayType());
        payment.setAmount(couponAmount.doubleValue());
        payment.setMoney(couponAmount.doubleValue());
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(inVO.getTerminalSno());
        payment.setPrecision(in.getCutMode());
        payment.setPrcutMode(in.getCutMode());
        payment.setRate(in.getChargeRate());
        payment.setFlag("1");
        payment.setMemo(inVO.getTradeDate());
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setIsOverage("Y");
        payment.setPayMemo("ZEXPAY");
        if ("1".equals(in.getScene())) {
            payment.setPopFlag("1");
        }
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "ZEXSALEPAY");
    }

    private JSONObject getRequest(CacheModel cacheModel, ZexPayIn in) {
        JSONObject request = new JSONObject();
        request.put("shopId", (Object)cacheModel.getSyjmain().getMkt().substring(0, 4));
        request.put("listNo", (Object)cacheModel.getOrder().getTerminalSno());
        request.put("posNo", (Object)cacheModel.getSyjmain().getSyjh());
        List goodsList = cacheModel.getGoodsList();
        JSONArray zexGoodsList = new JSONArray();
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = (Goods)goodsList.get(i);
            JSONObject zexGoods = new JSONObject();
            zexGoods.put("lineNo", (Object)(i + 1));
            zexGoods.put("barcodeId", (Object)goods.getGoodsNo());
            zexGoods.put("price", (Object)BigDecimal.valueOf(goods.getSalePrice()));
            zexGoods.put("amount", (Object)BigDecimal.valueOf(goods.getSaleAmount()));
            zexGoods.put("num", (Object)BigDecimal.valueOf(goods.getQty()));
            zexGoods.put("goodsType", (Object)"ZY");
            zexGoods.put("moneyType", (Object)"RMB");
            zexGoods.put("goodsId", (Object)goods.getGoodsCode());
            zexGoods.put("deptId", (Object)goods.getCategoryCode());
            zexGoodsList.add((Object)zexGoods);
        }
        request.put("goodsList", (Object)zexGoodsList);
        JSONArray zexPayList = new JSONArray();
        List paymentList = cacheModel.getPayments();
        if (ArrayUtils.isNotEmpty((List)paymentList)) {
            for (int i = 0; i < paymentList.size(); ++i) {
                Payment payment = (Payment)paymentList.get(i);
                JSONObject zexPay = new JSONObject();
                if ("ZEXPAY".equals(payment.getPayMemo())) {
                    zexPay.put("payType", (Object)17);
                    zexPay.put("cardNo", (Object)payment.getPayNo());
                    zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                    zexPayList.add((Object)zexPay);
                    continue;
                }
                if ("1".equals(payment.getPayType())) {
                    zexPay.put("payType", (Object)16);
                    zexPay.put("cardNo", (Object)payment.getPayNo());
                    zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                    zexPayList.add((Object)zexPay);
                    continue;
                }
                if ("4".equals(payment.getPayType())) {
                    zexPay.put("payType", (Object)13);
                    zexPay.put("cardNo", (Object)payment.getPayNo());
                    zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                    zexPayList.add((Object)zexPay);
                    continue;
                }
                if ("3".equals(payment.getPayType())) {
                    zexPay.put("payType", (Object)12);
                    zexPay.put("cardNo", (Object)payment.getPayNo());
                    zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                    zexPayList.add((Object)zexPay);
                    continue;
                }
                if ("2".equals(payment.getPayType())) {
                    zexPay.put("payType", (Object)15);
                    zexPay.put("cardNo", (Object)cacheModel.getOrder().getConsumersData().getConsumersCard());
                    zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                    zexPayList.add((Object)zexPay);
                    continue;
                }
                zexPay.put("payType", (Object)11);
                zexPay.put("cardNo", (Object)cacheModel.getOrder().getTerminalSno());
                zexPay.put("amount", (Object)BigDecimal.valueOf(payment.getAmount()));
                zexPayList.add((Object)zexPay);
            }
        } else {
            JSONObject zexPay = new JSONObject();
            zexPay.put("payType", (Object)18);
            zexPay.put("cardNo", (Object)"1");
            zexPay.put("amount", (Object)1);
            zexPayList.add((Object)zexPay);
            if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                request.put("memberCard", (Object)cacheModel.getOrder().getConsumersData().getConsumersCard());
                JSONObject zexPayMemberCard = new JSONObject();
                zexPayMemberCard.put("payType", (Object)14);
                zexPayMemberCard.put("cardNo", (Object)cacheModel.getOrder().getConsumersData().getConsumersCard());
                zexPayMemberCard.put("amount", (Object)1);
                zexPayList.add((Object)zexPayMemberCard);
            }
        }
        request.put("payList", (Object)zexPayList);
        JSONObject zexCoupon = new JSONObject();
        zexCoupon.put("sortId", (Object)1);
        zexCoupon.put("couponNo", (Object)in.getCouponNo());
        JSONArray zexCouponList = new JSONArray();
        zexCouponList.add((Object)zexCoupon);
        request.put("couponList", (Object)zexCouponList);
        return request;
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801]", "");
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u652f\u4ed8\u91d1\u989d]", "");
        }
        if (!paramsObject.containsKey((Object)"refundMoney") || paramsObject.getString("refundMoney").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u9000\u6b3e\u91d1\u989d]", "");
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6c47\u7387]", "");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        paramsObject.put("payShopCode", (Object)paramsObject.getString("shopCode"));
        RefundPayRequest refundRequest = new RefundPayRequest(paramsObject);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        Order order = cacheModel.getOrder();
        if (Double.valueOf(refundRequest.getMoney()) > ManipulatePrecision.doubleConvert((double)(order.getRemainValue() * 100.0))) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u539f\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u5269\u4f59\u4ed8\u6b3e", vo.getCacheModel().getFlowNo());
        }
        if (Double.valueOf(refundRequest.getMoney()) < Double.valueOf(refundRequest.getRefundMoney())) {
            return new RespBase(Code.CODE_50051.getIndex(), "\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u539f\u5355\u652f\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_500000.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - Double.valueOf(paramsObject.getString("money")) < 0.0) {
            return new RespBase(Code.CODE_500000.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
        HashMap<Integer, String> couponList = new HashMap<Integer, String>();
        boolean isNeedRequest = false;
        for (Payment pay : cacheModel.getReturnPayments()) {
            if (!payMode.getCode().equals(pay.getPayCode()) || paramsObject.getString("payNo").equals(pay.getPayNo()) && pay.getIsSuccess()) continue;
            isNeedRequest = true;
            couponList.put(pay.getRowno(), pay.getPayNo());
        }
        List zexCouponOutList = new ArrayList();
        JSONArray zexCouponList = new JSONArray();
        if (isNeedRequest && cacheModel.getOrder().getIsAllReturn()) {
            JSONObject request = new JSONObject();
            request.put("shopId", (Object)cacheModel.getSyjmain().getMkt().substring(0, 4));
            request.put("listNo", (Object)cacheModel.getOrder().getTerminalSno());
            request.put("posNo", (Object)cacheModel.getSyjmain().getSyjh());
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
            request.put("oldOrderTag", (Object)(date + cacheModel.getSyjmain().getSyjh() + cacheModel.getOrder().getOriginTerminalSno()));
            zexCouponList = new JSONArray();
            int i = 1;
            for (Integer key : couponList.keySet()) {
                JSONObject zexCoupon = new JSONObject();
                zexCoupon.put("sortId", (Object)i);
                zexCoupon.put("couponNo", couponList.get(key));
                zexCouponList.add((Object)zexCoupon);
                ++i;
            }
            request.put("couponList", (Object)zexCouponList);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String zexIp = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ZEXIP");
            String url = zexIp + "/zex/ws/salesReturn";
            Map sParaTemp = SubmitUtil.paraFilter((Map)request);
            Object prestr = SubmitUtil.createLinkString((Map)sParaTemp);
            prestr = (String)prestr + "&" + this.signKey;
            log.info("\u6392\u5e8f=>{}", prestr);
            String sign = DigestUtils.md5DigestAsHex((byte[])((String)prestr).getBytes());
            request.put("sign", (Object)sign);
            log.info("\u77e5\u800c\u884c\u9000\u8d27\u63a5\u53e3\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)request));
            String response = HttpZexUtils.post((String)url, (String)JSONObject.toJSONString((Object)request));
            log.info("\u77e5\u800c\u884c\u9000\u8d27\u63a5\u53e3\u8fd4\u56de==>{}", (Object)response);
            if (StringUtils.isBlank((String)response)) {
                return Code.CODE_55557.getRespBase(new Object[]{response});
            }
            ZexUseCouponOut zexUseCouponOut = (ZexUseCouponOut)JSONObject.parseObject((String)response, ZexUseCouponOut.class);
            if (!"SUCCESS".equalsIgnoreCase(zexUseCouponOut.getCode())) {
                if (ArrayUtils.isNotEmpty((List)zexUseCouponOut.getCouponList())) {
                    return Code.CODE_55557.getRespBase(new Object[]{((ZexCouponOut)zexUseCouponOut.getCouponList().get(0)).getResultMessage()});
                }
                return Code.CODE_55557.getRespBase(new Object[]{zexUseCouponOut.getMessage()});
            }
            zexCouponOutList = zexUseCouponOut.getCouponList();
            for (ZexCouponOut zexCouponOut : zexCouponOutList) {
                if ("SUCCESS".equalsIgnoreCase(zexCouponOut.getResultCode())) continue;
                return Code.CODE_55557.getRespBase(new Object[]{zexCouponOut.getResultMessage()});
            }
            for (Integer key : couponList.keySet()) {
                ((Payment)cacheModel.getReturnPayments().get(key - 1)).setIsSuccess(true);
            }
            for (int j = 0; j < zexCouponOutList.size(); ++j) {
                if (!"SUCCESS".equalsIgnoreCase(((ZexCouponOut)zexCouponOutList.get(j)).getResultCode())) continue;
                Payment payment = new Payment();
                payment.setPayType(payMode.getPaytype());
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setRownoId(payment.getPuid());
                payment.setPayCode(payMode.getCode());
                payment.setPayName(payMode.getName());
                payment.setIsDirectDel(true);
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setPayNo(zexCouponList.getJSONObject(j).getString("couponNo"));
                payment.setAmount(((ZexCouponOut)zexCouponOutList.get(j)).getCouponAmount().setScale(2, RoundingMode.HALF_UP).doubleValue());
                payment.setMoney(((ZexCouponOut)zexCouponOutList.get(j)).getCouponAmount().setScale(2, RoundingMode.HALF_UP).doubleValue());
                payment.setFlag("1");
                payment.setTerminalNo(refundRequest.getTerminalNo());
                payment.setTerminalSno(refundRequest.getTerminalSno());
                payment.setRate(paramsObject.getDouble("rate").doubleValue());
                payment.setPrecision(String.valueOf(payMode.getSswrjd()));
                payment.setPrcutMode(payMode.getSswrfs());
                payment.setMemo(refundRequest.getCreateTime());
                payment.setRefCode(cacheModel.getOrder().getOriginTerminalSno());
                payment.setPayMemo("ZEXPAY");
                if (null != paramsObject.getBoolean("invoiceFlag")) {
                    payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                }
                if (null != paramsObject.getBoolean("creditsFlag")) {
                    payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                }
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
            }
        } else {
            Payment payment = new Payment();
            payment.setPayType(payMode.getPaytype());
            payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
            payment.setRownoId(payment.getPuid());
            payment.setPayCode(payMode.getCode());
            payment.setPayName(payMode.getName());
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setAmount(Double.valueOf(refundRequest.getMoney()) * 0.01);
            payment.setMoney(Double.valueOf(refundRequest.getMoney()) * 0.01);
            payment.setFlag("1");
            payment.setTerminalNo(refundRequest.getTerminalNo());
            payment.setTerminalSno(refundRequest.getTerminalSno());
            payment.setRate(paramsObject.getDouble("rate").doubleValue());
            payment.setPrecision(String.valueOf(payMode.getSswrjd()));
            payment.setPrcutMode(payMode.getSswrfs());
            payment.setMemo(refundRequest.getCreateTime());
            payment.setRefCode(cacheModel.getOrder().getOriginTerminalSno());
            payment.setPayMemo("ZEXPAY");
            if (null != paramsObject.getBoolean("invoiceFlag")) {
                payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
            }
            if (null != paramsObject.getBoolean("creditsFlag")) {
                payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
            }
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase query(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        return null;
    }

    public RespBase cancle(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return new RespBase(-1, "\u5220\u9664\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", "\u4ed8\u6b3e\u884c\u552f\u4e00\u6807\u8bc6");
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return new RespBase(Code.CODE_50043, (Object)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f!", vo.getCacheModel().getFlowNo());
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(in.getPuid())) continue;
            payment = p;
            break;
        }
        if (payment != null) {
            JSONObject request = new JSONObject();
            request.put("shopId", (Object)cacheModel.getSyjmain().getMkt().substring(0, 4));
            request.put("listNo", (Object)cacheModel.getOrder().getTerminalSno());
            request.put("posNo", (Object)cacheModel.getSyjmain().getSyjh());
            JSONObject zexCoupon = new JSONObject();
            zexCoupon.put("sortId", (Object)1);
            zexCoupon.put("couponNo", (Object)payment.getPayNo());
            JSONArray zexCouponList = new JSONArray();
            zexCouponList.add((Object)zexCoupon);
            request.put("couponList", (Object)zexCouponList);
            String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String zexIp = SysPara.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ZEXIP");
            String url = zexIp + "/zex/ws/cancelCoupons";
            Map sParaTemp = SubmitUtil.paraFilter((Map)request);
            Object prestr = SubmitUtil.createLinkString((Map)sParaTemp);
            prestr = (String)prestr + "&" + this.signKey;
            log.info("\u6392\u5e8f=>{}", prestr);
            String sign = DigestUtils.md5DigestAsHex((byte[])((String)prestr).getBytes());
            request.put("sign", (Object)sign);
            log.info("\u77e5\u800c\u884c\u53d6\u6d88\u63a5\u53e3\u5165\u53c2==>{}", (Object)JSONObject.toJSONString((Object)request));
            String response = HttpZexUtils.post((String)url, (String)JSONObject.toJSONString((Object)request));
            log.info("\u77e5\u800c\u884c\u53d6\u6d88\u63a5\u53e3\u8fd4\u56de==>{}", (Object)response);
            if (StringUtils.isBlank((String)response)) {
                return Code.CODE_55557.getRespBase(new Object[]{response});
            }
            ZexUseCouponOut zexUseCouponOut = (ZexUseCouponOut)JSONObject.parseObject((String)response, ZexUseCouponOut.class);
            if (!"SUCCESS".equalsIgnoreCase(zexUseCouponOut.getCode())) {
                if (ArrayUtils.isNotEmpty((List)zexUseCouponOut.getCouponList())) {
                    return Code.CODE_55557.getRespBase(new Object[]{((ZexCouponOut)zexUseCouponOut.getCouponList().get(0)).getResultMessage()});
                }
                return Code.CODE_55557.getRespBase(new Object[]{zexUseCouponOut.getMessage()});
            }
            List zexCouponOutList = zexUseCouponOut.getCouponList();
            for (ZexCouponOut zexCouponOut : zexCouponOutList) {
                if ("SUCCESS".equalsIgnoreCase(zexCouponOut.getResultCode())) continue;
                return Code.CODE_55557.getRespBase(new Object[]{zexCouponOut.getResultMessage()});
            }
            cacheModel.getPayments().remove(payment);
            PayUtil.sortPayments((List)cacheModel.getPayments());
            cacheModel.setPayments(cacheModel.getPayments());
            cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
            if (cacheModel.getCalcResult() == -1) {
                String errCode = String.valueOf(Code.CODE_500000.getIndex());
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
            }
            vo.setCacheModel(cacheModel);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "DELPAYCERTIFY");
    }

    public RespBase returnCoupon(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        return null;
    }
}

