/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.gzyy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.dao.MzkSaleDaoGzyy;
import com.efuture.business.enumcase.MzkEnum;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.request.MzkIn;
import com.efuture.business.model.mzk.request.FindFaceValueCardInDto;
import com.efuture.business.model.mzk.request.MzkRequestGzyyDef;
import com.efuture.business.model.mzk.request.SendFaceValueCardInDto;
import com.efuture.business.model.mzk.response.FindFaceValueCardOutDto;
import com.efuture.business.model.mzk.response.FindFaceValueCardStatusOutDto;
import com.efuture.business.model.mzk.response.MzkResultGzyyDef;
import com.efuture.business.service.MzkSaleBS;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.MzkSaleUtil;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.vo.FaceValueCardStatusVO;
import com.product.model.ServiceSession;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MzkSaleServiceImlGzyy
implements MzkSaleBS {
    protected static Logger logger = LoggerFactory.getLogger(MzkSaleServiceImlGzyy.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Resource
    private MzkSaleDaoGzyy mzkSaleDaoGzyy;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    protected PosLogicService posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public RespBase saleQuery(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (null == vo && null == vo.getCacheModel()) {
            return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("cardNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        if (null == jsonObject.getDouble("amount")) {
            jsonObject.put("amount", (Object)0);
        }
        MzkIn in = MzkSaleUtil.loadRequestPara((JSONObject)jsonObject);
        in.setCardNo(in.getCardNo());
        MzkRequestGzyyDef mzkRequestDef = new MzkRequestGzyyDef(in);
        mzkRequestDef.setVtype(MzkEnum.SALEQUERY.getCode());
        mzkRequestDef.setCodeType(MzkEnum.MZK.getCode());
        CacheModel cacheModel = vo.getCacheModel();
        mzkRequestDef.setOrderType(cacheModel.getOrder().getOrderType());
        mzkRequestDef.setVsyyh(cacheModel.getOrder().getTerminalOperator());
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkRequestDef);
        logger.info("\u9762\u503c\u5361\u67e5\u8be2\u662f\u5426\u542f\u7528\u672c\u5730\u8131\u673a:{}", (Object)this.localcache);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361\u67e5\u8be2", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361\u67e5\u8be2", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                MzkResultGzyyDef mzkResultGzyyDef = (MzkResultGzyyDef)JSONObject.parseObject((String)object.getString("data"), MzkResultGzyyDef.class);
                respBase = new RespBase(Code.SUCCESS, (Object)mzkResultGzyyDef);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u67e5\u8be2\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        MzkResultGzyyDef mzkResultDef = (MzkResultGzyyDef)respBase.getData();
        JSONObject json = new JSONObject();
        for (Payment p : cacheModel.getPayments()) {
            if (!mzkResultDef.getRcardno().equals(p.getPayNo())) continue;
            return Code.CODE_50073.getRespBase(new Object[]{"\u5361\u53f7\u91cd\u590d"});
        }
        json.put("money", (Object)mzkResultDef.getRamount());
        json.put("cardNo", (Object)mzkResultDef.getRcardno());
        json.put("ismz", (Object)mzkResultDef.getIsmz());
        json.put("description", (Object)mzkResultDef.getDescription());
        return new RespBase(Code.SUCCESS, (Object)json);
    }

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (!jsonObject.containsKey((Object)"balance") || jsonObject.getString("balance").isEmpty()) {
            throw new EfutureException(Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4f59\u989d]"}));
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("description"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9762\u503c\u5361\u63cf\u8ff0");
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        String cardCode = mzkIn.getCardNo();
        mzkIn.setCardNo("#" + mzkIn.getCardNo());
        mzkIn.setBalance(jsonObject.getDouble("balance").doubleValue());
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return Code.CODE_50007.getRespBase(new Object[0]);
        }
        logger.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mzkIn));
        if (remainValue - mzkIn.getAmount() < 0.0 && "N".equals(mzkIn.getIsOverage())) {
            return Code.CODE_50050.getRespBase(new Object[0]);
        }
        Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        payment.setCouponBalance(ManipulatePrecision.sub((double)mzkIn.getBalance(), (double)mzkIn.getAmount()));
        payment.setPayNo(cardCode);
        payment.setPayMemo("MZK");
        String description = jsonObject.getString("description");
        payment.setDescription(description);
        payment.setBatchNo(description.split(",")[2]);
        payment.setCopType(description.split(",")[0]);
        double faceValue = Double.parseDouble(description.split(",")[1]);
        payment.setMonthlyInstallment(faceValue);
        if (remainValue - mzkIn.getAmount() > 0.0) {
            payment.setIsOverage("N");
        }
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u6d88\u8d39\u5931\u8d25:" + cacheModel.getErrMsg()});
        }
        MzkRequestGzyyDef mzkreq = new MzkRequestGzyyDef(mzkIn);
        mzkreq.setVtype(MzkEnum.SALEPAY.getCode());
        mzkreq.setCodeType(MzkEnum.MZK.getCode());
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkreq);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361\u6d88\u8d39", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361\u6d88\u8d39", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u6d88\u8d39\u6570\u636e\u4e3a\u7a7a!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u6d88\u8d39\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase cancelPay(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        String codeType = jsonObject.getString("codeType");
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) && StringUtils.isEmpty((String)jsonObject.getString("puid"))) {
            return Code.CODE_64.getRespBase(new Object[]{"\u64a4\u9500\u652f\u4ed8puid\u4e0d\u80fd\u4e3a\u7a7a!"});
        }
        Payment preDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(jsonObject.getString("puid"))) continue;
            preDeletePayment = p;
            break;
        }
        if (null == preDeletePayment && SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_50053.getRespBase(new Object[]{"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!"});
        }
        String orderNo = "";
        String description = "";
        if (null != preDeletePayment) {
            orderNo = preDeletePayment.getRefCode();
            jsonObject.put("balance", (Object)preDeletePayment.getCouponBalance());
        } else {
            for (Payment p : cacheModel.getReturnPayments()) {
                if (!p.getPuid().equals(jsonObject.getString("puid"))) continue;
                orderNo = p.getRefCode();
                jsonObject.put("balance", (Object)p.getCouponBalance());
                description = p.getDescription();
                break;
            }
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        mzkIn.setOrderNo(orderNo);
        if (!MzkEnum.COUPON.compareCode(codeType)) {
            mzkIn.setCardNo("#" + mzkIn.getCardNo());
        }
        MzkRequestGzyyDef mzkreq = new MzkRequestGzyyDef(mzkIn);
        mzkreq.setVtype(MzkEnum.CANCELPAY.getCode());
        mzkreq.setCodeType(StringUtils.isEmpty((String)codeType) ? MzkEnum.MZK.getCode() : codeType);
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkreq);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361/\u5238\u64a4\u9500", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361/\u5238\u64a4\u9500", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361/\u5238\u64a4\u9500!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361/\u5238\u64a4\u9500\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            cacheModel.getPayments().remove(preDeletePayment);
        } else {
            Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setCouponBalance(ManipulatePrecision.add((double)mzkIn.getBalance(), (double)mzkIn.getAmount()));
            payment.setPayNo(orderNo);
            payment.setPayMemo("MZK");
            payment.setDescription(description);
            payment.setBatchNo(description.split(",")[2]);
            payment.setCopType(description.split(",")[0]);
            double faceValue = Double.parseDouble(description.split(",")[1]);
            payment.setMonthlyInstallment(faceValue);
            if (cacheModel.getOrder().getRemainValue() - mzkIn.getAmount() > 0.0) {
                payment.setIsOverage("N");
            }
            logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
            cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        }
        PayUtil.sortPayments((List)cacheModel.getPayments());
        cacheModel.setPayments(cacheModel.getPayments());
        cacheModel = this.posLogicService.CalcOrderAmountByDeletePayReturn(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase executeCzk(ServiceSession session, JSONObject jsonObject) {
        int sendmzk;
        MzkRequestGzyyDef mzkreq = (MzkRequestGzyyDef)JSON.parseObject((String)jsonObject.toJSONString(), MzkRequestGzyyDef.class);
        MzkResultGzyyDef mzkResultDef = new MzkResultGzyyDef();
        String type = mzkreq.getVtype();
        if (StringUtils.isEmpty((String)type)) {
            return Code.CODE_64.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u7c7b\u578b]!"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVtrack2())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]"});
        }
        if (MzkEnum.SALEQUERY.compareCode(mzkreq.getVtype())) {
            FindFaceValueCardInDto param = new FindFaceValueCardInDto();
            if (MzkEnum.MZK.compareCode(mzkreq.getCodeType())) {
                param.setTrack1("#");
            }
            param.setTrack2(mzkreq.getVtrack2());
            FindFaceValueCardOutDto faceValueCardOutDto = this.mzkSaleDaoGzyy.findmzk(param);
            if (null == faceValueCardOutDto) {
                return new RespBase(Code.CODE_50058);
            }
            if (StringUtils.isEmpty((String)faceValueCardOutDto.getRfunc()) || faceValueCardOutDto.getRfunc().length() < 3) {
                return Code.CODE_64.getRespBase(new Object[]{"\u83b7\u53d6\u5361/\u5238\u7c7b\u578b\u5931\u8d25"});
            }
            String description = faceValueCardOutDto.getRfunc().substring(1, 3) + "," + faceValueCardOutDto.getRvalue1() + "," + faceValueCardOutDto.getRvalue2() + "," + mzkreq.getVsyyh() + "," + mzkreq.getOrderType();
            mzkResultDef.setDescription(description);
            if (MzkEnum.MZK.compareCode(mzkreq.getCodeType())) {
                mzkResultDef.setRetcode("00");
                mzkResultDef.setRcardno(faceValueCardOutDto.getRcode());
                mzkResultDef.setRamount("" + faceValueCardOutDto.getRye());
                mzkResultDef.setIsmz(faceValueCardOutDto.getRismz());
                return new RespBase(Code.SUCCESS, (Object)mzkResultDef);
            }
            if (MzkEnum.COUPON.compareCode(mzkreq.getCodeType())) {
                if (!"Y".equals(faceValueCardOutDto.getRislq())) {
                    return Code.CODE_64.getRespBase(new Object[]{"\u5f53\u524d\u5361\u53f7\u53ea\u80fd\u7528\u5238\u652f\u4ed8"});
                }
                mzkResultDef.setRetcode("00");
                mzkResultDef.setRcardno(faceValueCardOutDto.getRcode());
                mzkResultDef.setRamount("" + faceValueCardOutDto.getRye());
                mzkResultDef.setMinimumAmount(faceValueCardOutDto.getRvalue3());
                mzkResultDef.setConsumersId(faceValueCardOutDto.getRvip());
                mzkResultDef.setPassword(faceValueCardOutDto.getRpasswd());
                mzkResultDef.setPassword(faceValueCardOutDto.getRpasswd());
                mzkResultDef.setIsPassword(faceValueCardOutDto.getRispw());
                return new RespBase(Code.SUCCESS, (Object)mzkResultDef);
            }
            return Code.CODE_64.getRespBase(new Object[]{"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5339\u914d"});
        }
        if (!this.checkPayType(type)) {
            return Code.CODE_64.getRespBase(new Object[]{"\u4ea4\u6613\u7c7b\u578b\u4e0d\u5339\u914d:" + type});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVseqno())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u6d41\u6c34]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVtermno())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u673a\u53f7]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVsyyh())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u5458\u53f7]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVinvno())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVamount())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getVtrack2())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getPayCode())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u65b9\u5f0f]"});
        }
        if (StringUtils.isEmpty((String)mzkreq.getShopCode())) {
            return Code.CODE_500001.getRespBase(new Object[]{"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u95e8\u5e97\u53f7]"});
        }
        SendFaceValueCardInDto sendFaceValueCardInDto = new SendFaceValueCardInDto(mzkreq);
        if (MzkEnum.SALEPAY.compareCode(type)) {
            sendFaceValueCardInDto.setVtype("A");
        }
        if (MzkEnum.CANCELPAY.getCode().equals(type)) {
            sendFaceValueCardInDto.setVtype("B");
        }
        if (MzkEnum.SALEREFUND.compareCode(type)) {
            sendFaceValueCardInDto.setVje(sendFaceValueCardInDto.getVje() * -1.0);
            sendFaceValueCardInDto.setVtype("A");
        }
        if (1 != (sendmzk = this.mzkSaleDaoGzyy.sendmzk(sendFaceValueCardInDto))) {
            switch (type) {
                case "01": {
                    return Code.CODE_55561.getRespBase(new Object[0]);
                }
                case "02": {
                    return Code.CODE_55562.getRespBase(new Object[0]);
                }
            }
            return Code.CODE_55563.getRespBase(new Object[0]);
        }
        mzkResultDef.setRetcode("00");
        mzkResultDef.setRcardno(sendFaceValueCardInDto.getVpayno());
        mzkResultDef.setRamount("" + sendFaceValueCardInDto.getVkye());
        return new RespBase(Code.SUCCESS, (Object)mzkResultDef);
    }

    private boolean checkPayType(String payType) {
        switch (payType) {
            case "01": {
                return true;
            }
            case "02": {
                return true;
            }
            case "03": {
                return true;
            }
        }
        return false;
    }

    public RespBase saleReserve(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        RespBase respBase;
        if (!StringUtils.isEmpty((String)jsonObject.getString("flowNo"))) {
            if (null == vo) {
                return Code.CODE_1003.getRespBase(new Object[]{jsonObject.getString("flowNo")});
            }
            return this.cancelPay(session, vo, jsonObject);
        }
        if (!jsonObject.containsKey((Object)"cardNo") || jsonObject.getString("cardNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u50a8\u503c\u5361\u5361\u53f7]");
        }
        if (!jsonObject.containsKey((Object)"amount") || jsonObject.getString("amount").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ea4\u6613\u91d1\u989d]");
        }
        String codeType = jsonObject.getString("codeType");
        JSONObject modeDetailsVo = MzkSaleUtil.getRedisData((JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        JSONObject syjMain = modeDetailsVo.getJSONObject("syjmain");
        PaymentMode mzkPayMode = PayModeUtils.getPayMode((String)jsonObject.getString("payCode"), (JSONObject)modeDetailsVo);
        MzkIn mzkIn = MzkSaleUtil.loadRequestPara((JSONObject)jsonObject, (JSONObject)syjMain, (PaymentMode)mzkPayMode);
        if (!MzkEnum.COUPON.compareCode(codeType)) {
            mzkIn.setCardNo("#" + mzkIn.getCardNo());
        }
        MzkRequestGzyyDef mzkreq = new MzkRequestGzyyDef(mzkIn);
        mzkreq.setVtype(MzkEnum.CANCELPAY.getCode());
        mzkreq.setCodeType(MzkEnum.MZK.getCode());
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkreq);
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361\u5f00\u673a\u51b2\u6b63", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361\u5f00\u673a\u51b2\u6b63", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u5f00\u673a\u51b2\u6b63!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361\u5f00\u673a\u51b2\u6b63\u5f02\u5e38:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        String codeType = jsonObject.getString("codeType");
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_55560.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        MzkIn mzkIn = MzkSaleUtil.getMzkIn((ServiceSession)session, (JSONObject)jsonObject, (RedisUtil)this.redisUtil);
        mzkIn.setAmount(mzkIn.getAmount());
        if (MzkEnum.COUPON.compareCode(codeType)) {
            mzkIn.setCardNo(mzkIn.getCardNo());
        } else {
            mzkIn.setCardNo("#" + mzkIn.getCardNo());
        }
        MzkRequestGzyyDef mzkreq = new MzkRequestGzyyDef(mzkIn);
        mzkreq.setVtype(MzkEnum.SALEREFUND.getCode());
        mzkreq.setCodeType(StringUtils.isEmpty((String)codeType) ? MzkEnum.MZK.getCode() : codeType);
        JSONObject param = (JSONObject)JSON.toJSON((Object)mzkreq);
        RespBase respBase = null;
        if (this.localcache.booleanValue()) {
            try {
                param.put("command_id", (Object)"EXECUTECZK");
                logger.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361/\u5238\u9000\u8d27", param.toJSONString()});
                String resp = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toJSONString());
                logger.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u9762\u503c\u5361/\u5238\u9000\u8d27", resp});
                if (StringUtils.isEmpty((String)resp)) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361/\u5238\u9000\u8d27!"}));
                }
                JSONObject object = (JSONObject)JSONObject.parse((String)resp);
                if (!"0".equals(object.getString("returncode"))) {
                    throw new EfutureException(Code.CODE_50025.getRespBase(new Object[]{object.getString("data")}));
                }
                respBase = Code.SUCCESS.getRespBase(new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return Code.CODE_50025.getRespBase(new Object[]{"\u9762\u503c\u5361/\u5238\u9000\u8d27:" + e.getMessage()});
            }
        } else {
            respBase = this.executeCzk(session, param);
        }
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        Payment payment = MzkSaleUtil.buildPayment((MzkIn)mzkIn);
        payment.setRowno(cacheModel.getPayments().size() + 1);
        logger.info("\u652f\u4ed8\u884c\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)payment));
        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo);
    }

    public RespBase queryStatus(ServiceSession session, JSONObject jsonObject) {
        if (this.localcache.booleanValue()) {
            return Code.CODE_64.getRespBase(new Object[]{"\u67e5\u8be2\u50a8\u503c\u5361\u72b6\u6001\u5fc5\u987b[\u8054\u7f51]"});
        }
        if (StringUtils.isEmpty((String)jsonObject.getString("cardNo"))) {
            return Code.CODE_64.getRespBase(new Object[]{"\u67e5\u8be2\u50a8\u503c\u5361\u72b6\u6001\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5361\u53f7]"});
        }
        FindFaceValueCardInDto param = new FindFaceValueCardInDto();
        param.setTrack1("#");
        param.setTrack2(jsonObject.getString("cardNo"));
        FindFaceValueCardStatusOutDto findFaceValueCardStatusOutDto = this.mzkSaleDaoGzyy.findmzkinfo(param);
        FaceValueCardStatusVO faceValueCardStatusVO = new FaceValueCardStatusVO();
        String cardNo = findFaceValueCardStatusOutDto.getRcode();
        if (!StringUtils.isEmpty((String)cardNo) && cardNo.length() > 5) {
            cardNo = cardNo.substring(0, cardNo.length() - 5);
        }
        faceValueCardStatusVO.setCardNo(cardNo);
        faceValueCardStatusVO.setBalance(findFaceValueCardStatusOutDto.getRye());
        faceValueCardStatusVO.setFaceValue(findFaceValueCardStatusOutDto.getRmoney());
        faceValueCardStatusVO.setRlastdate(findFaceValueCardStatusOutDto.getRlastdate());
        faceValueCardStatusVO.setStatus(findFaceValueCardStatusOutDto.getRmemo());
        return new RespBase(Code.SUCCESS, (Object)faceValueCardStatusVO);
    }

    public RespBase cardActivation(ServiceSession session, JSONObject body) {
        return null;
    }

    public RespBase unActivation(ServiceSession session, JSONObject body) {
        return null;
    }

    public RespBase unifyConsume(ServiceSession session, ResqVo buildReqVo, JSONObject body) {
        return null;
    }

    public RespBase queryCardInfo(ServiceSession session, JSONObject body) {
        return null;
    }

    public RespBase reverseUnifyConsume(ServiceSession session, ResqVo buildReqVo, JSONObject body) {
        return null;
    }

    public RespBase refundUnifyConsume(ServiceSession session, ResqVo buildReqVo, JSONObject body) {
        return null;
    }
}

