/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.sjgw;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.GetPayInfoIn;
import com.efuture.business.model.GetPayQueryInfoIn;
import com.efuture.business.model.allVpay.request.PayQueryRequest;
import com.efuture.business.model.allVpay.request.PayRequest2;
import com.efuture.business.model.allVpay.request.RepealPayRequest;
import com.efuture.business.model.allVpay.response.PayResponse;
import com.efuture.business.model.allVpay.response.RepealPayResponse;
import com.efuture.business.service.impl.AllVpaySaleBSImpl;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.RSAUtils2;
import com.efuture.business.util.RandomNum;
import com.efuture.business.util.SocketShuttleDes;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllVpaySaleBSImpl_SJGW
extends AllVpaySaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(AllVpaySaleBSImpl_SJGW.class);

    public void convertRespse(Payment payment, PayResponse payResponse, JSONObject paramsObject) {
        JSONObject j = new JSONObject();
        j.put("ptflowno", (Object)paramsObject.getString("payBarCode"));
        if (StringUtils.isNotBlank((String)payResponse.getAccountId())) {
            j.put("ptpayaccount", (Object)payResponse.getAccountId());
        }
        payment.setExtMemo(j.toJSONString());
    }

    public RespBase salePay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        String[] ips;
        JSONObject syjmain;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payCode"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payName"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"payType"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"terminalSno"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"money"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return Code.CODE_500001.getRespBase(new Object[]{"rate"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return Code.CODE_500001.getRespBase(new Object[]{"precision"});
        }
        GetPayInfoIn getPayInfoIn = (GetPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayInfoIn.class);
        ArrayList<PayRequest2.GoodsPackage> goodsPackages = new ArrayList<PayRequest2.GoodsPackage>();
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayInfoIn.getShopCode() + getPayInfoIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        int maxSalePayCount = this.getMaxPayCount(obj);
        if (cacheModel.getPayments().size() >= maxSalePayCount) {
            return new RespBase(Code.CODE_50044, (Object)"\u8ba2\u5355\u8d85\u8fc7\u6700\u5927\u4ed8\u6b3e\u884c\u6570\u8bbe\u7f6e!", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_50007.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - CastUtil.castDouble((Object)getPayInfoIn.getMoney()) < 0.0) {
            return new RespBase(Code.CODE_500003.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        log.info("post\u7cfb\u7edf\u53c2\u6570==>{}", (Object)this.getPayShopCode(obj));
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                log.info("\u6536\u94f6\u673a\u67dc\u7ec4==>{}", (Object)cacheModel.getSyjmain().getSyjgz());
                if (StringUtils.isBlank((String)cacheModel.getSyjmain().getSyjgz())) {
                    return Code.CODE_50015.getRespBase(new Object[]{"\u6536\u94f6\u673a\u67dc\u7ec4\u672a\u914d\u7f6e!"});
                }
                paramsObject.put("payShopCode", (Object)cacheModel.getSyjmain().getSyjgz());
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                String payShopCode = this.getPayShopCode(obj);
                String payTerminalNo = this.getPayTerminalNo(obj);
                if (StringUtils.isBlank((String)payShopCode)) {
                    paramsObject.put("payShopCode", (Object)paramsObject.getString("payShopCode"));
                } else {
                    paramsObject.put("payShopCode", (Object)payShopCode);
                }
                if (StringUtils.isBlank((String)payTerminalNo)) {
                    paramsObject.put("payTerminalNo", (Object)paramsObject.getString("payTerminalNo"));
                } else {
                    paramsObject.put("payTerminalNo", (Object)payTerminalNo);
                }
            }
        }
        catch (Exception e) {
            log.info("\u5f02\u5e38", (Throwable)e);
            return Code.CODE_500001.getRespBase(new Object[]{"[payShopCode] or [payTerminalNo]"});
        }
        if (!paramsObject.containsKey((Object)"payTerminalNo") || StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payTerminalNo"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty() || "".equals(paramsObject.getString("payShopCode"))) {
            return Code.CODE_500001.getRespBase(new Object[]{"payShopCode"});
        }
        getPayInfoIn = (GetPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayInfoIn.class);
        String merchantOrderNo = getPayInfoIn.getShopCode() + getPayInfoIn.getTerminalNo() + System.currentTimeMillis();
        getPayInfoIn.setIdSheetNo(merchantOrderNo);
        List goodsList = vo.getCacheModel().getGoodsList();
        for (Goods goods : goodsList) {
            PayRequest2.GoodsPackage goodsPackage = new PayRequest2.GoodsPackage();
            goodsPackage.setBarcode(goods.getBarNo() == null ? "" : goods.getBarNo());
            goodsPackage.setBrandName(goods.getBrandCode() == null ? "" : goods.getBrandCode());
            goodsPackage.setCategory(goods.getTempCategory() == null ? "" : goods.getTempCategory());
            goodsPackage.setCategoryName(goods.getTempCategory() == null ? "" : goods.getTempCategory());
            goodsPackage.setGoodsMemo(goods.getRemark() == null ? "" : goods.getRemark());
            goodsPackage.setGoodsName(goods.getGoodsName() == null ? "" : goods.getGoodsName());
            goodsPackage.setGoodsNo(goods.getGoodsNo() == null ? "" : goods.getGoodsNo());
            goodsPackage.setQty(String.valueOf((int)goods.getQty() * 1000));
            goodsPackage.setSaleAmount(String.valueOf((int)(ManipulatePrecision.doubleConvert((double)(goods.getSaleAmount() / goods.getQty()), (int)2, (int)1) * 100.0)));
            goodsPackage.setSaleUnit(goods.getSaleUnit() == null ? "" : goods.getSaleUnit());
            goodsPackages.add(goodsPackage);
        }
        boolean isSuccess = false;
        log.info("getPayInfoIn" + JSONObject.toJSONString((Object)getPayInfoIn));
        PayRequest2 payRequest = new PayRequest2(getPayInfoIn, goodsPackages);
        payRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        if ("B9".equals(getPayInfoIn.getPayType()) && (syjmain = JSONObject.parseObject((String)obj).getJSONObject("syjmain")).containsKey((Object)"ZFIP")) {
            payRequest.setSyjip(syjmain.getString("ZFIP"));
        }
        ModeDetailsVo modeDetailsVoAL = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String SJPAY = ModeDetailsVo.getSysParaValue((List)modeDetailsVoAL.getSyspara(), (String)"SJPAY");
        String AllvpayIp = GlobalInfo.getAllvpayIp();
        int Allvpayport = GlobalInfo.getAllvpayPort();
        if (StringUtils.isNotEmpty((String)SJPAY) && (ips = SJPAY.split(":")).length > 1) {
            AllvpayIp = ips[0];
            Allvpayport = Integer.parseInt(ips[1]);
            payRequest.setAllvpayIp(AllvpayIp);
            payRequest.setAllvpayport(Allvpayport);
        }
        PayResponse payResponse = null;
        try {
            if ("0".equals(getPayInfoIn.getFaceScanning())) {
                payRequest.setPayShopCode(getPayInfoIn.getPayShopCode() + getPayInfoIn.getShopCode());
                String request = payRequest.toString();
                log.info("\u5237\u8138\u652f\u4ed8\u5165\u53c2\uff1a" + request);
                String response = SocketShuttleDes.sendSocketByDes((String)GlobalInfo.getAllvpayIp(), (int)GlobalInfo.getAllvpayPort(), (Long)95L, (String)request, (String)this.desKey);
                log.info("\u5237\u8138\u652f\u4ed8\u8fd4\u56de==>{}", (Object)response);
                payResponse = new PayResponse(response);
            } else {
                log.info("\u626b\u7801\u652f\u4ed8\u5165\u53c2\uff1a" + payRequest.toString());
                if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                    payRequest.setPayShopCode(getPayInfoIn.getPayShopCode() + getPayInfoIn.getShopCode());
                    String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)95L, (String)payRequest.toString(), (String)this.desKey);
                    log.info("\u626b\u7801\u652f\u4ed8\u8fd4\u56de==>{}", (Object)response);
                    payResponse = new PayResponse(response);
                } else {
                    payResponse = this.allVPayTools.salePay(payRequest);
                }
            }
            cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
            Order order = cacheModel.getOrder();
            if (payResponse.getReturnCode().equals("SUCCESS")) {
                if (payResponse.getBusinessResult().equals("SUCCESS")) {
                    Payment payment = new Payment();
                    if ("98".equals(getPayInfoIn.getPayType()) || "D4".equals(getPayInfoIn.getPayType())) {
                        payment.setPayCode(getPayInfoIn.getPayCode());
                        payment.setPayName(getPayInfoIn.getPayName());
                        payment.setAppType(this.getAppType(getPayInfoIn.getPayType()));
                    } else {
                        log.info("\u5fae\u652f\u4ed8\u53cd\u5199\u652f\u4ed8\u540d\u79f0");
                        String channelFlag = "";
                        channelFlag = "99".equals(getPayInfoIn.getPayType()) ? Convert.newSubString((String)payResponse.getQrcodeUrl(), (int)0, (int)2).trim() : (payResponse.getQrcodeUrl().length() > 24 ? Convert.newSubString((String)payResponse.getQrcodeUrl(), (int)0, (int)24).trim() : ("D1".equals(getPayInfoIn.getPayType()) ? payResponse.getQrcodeUrl().trim() : payResponse.getQrcodeUrl()));
                        log.info("channelFlag==>{}", (Object)channelFlag);
                        boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                        if (!flag) {
                            log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f-\u51b2\u6b63");
                            log.info("saleRefund===" + JSONObject.toJSONString((Object)paramsObject));
                            getPayInfoIn.setOriginalIdSheetNo(merchantOrderNo);
                            getPayInfoIn.setOriginalCreateTime(payResponse.getCreateTime());
                            RepealPayRequest repealPayRequest = new RepealPayRequest(getPayInfoIn);
                            if (StringUtils.isBlank((String)repealPayRequest.getOriginalCreateTime())) {
                                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                                DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                                LocalDateTime dateTime = LocalDateTime.parse(cacheModel.getOrder().getSaleDate(), df);
                                repealPayRequest.setOriginalCreateTime(dateTime.format(df2));
                            }
                            repealPayRequest.setAllvpayIp(AllvpayIp);
                            repealPayRequest.setAllvpayport(Allvpayport);
                            log.info("repealPayRequest===" + JSONObject.toJSONString((Object)repealPayRequest));
                            try {
                                RepealPayResponse rayResponse = null;
                                if (this.cloudServerIp.equals(GlobalInfo.getAllvpayIp())) {
                                    repealPayRequest.setPayShopCode(getPayInfoIn.getPayShopCode() + getPayInfoIn.getShopCode());
                                    String response = SocketShuttleDes.sendSocketByDes((String)AllvpayIp, (int)Allvpayport, (Long)95L, (String)repealPayRequest.toString(), (String)this.desKey);
                                    log.info("\u626b\u7801\u652f\u4ed8\u8fd4\u56de==>{}", (Object)response);
                                    rayResponse = new RepealPayResponse(response);
                                } else {
                                    rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                                }
                                log.info("rayResponse===" + JSONObject.toJSONString((Object)rayResponse));
                                if (!rayResponse.getReturnCode().equals("SUCCESS")) {
                                    return Code.CODE_50053.getRespBase(new Object[]{rayResponse.getReturnResult()});
                                }
                            }
                            catch (Exception e) {
                                log.info("\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25:\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                                return Code.CODE_50053.getRespBase(new Object[]{e.getMessage()});
                            }
                            return Code.CODE_50102.getRespBase(new Object[]{getPayInfoIn.getPayCode()});
                        }
                    }
                    PaymentMode payMode = PayModeUtils.getPayMode((String)getPayInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                    payment.setPayType(payMode.getPaytype());
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setRownoId(payment.getPuid());
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    payment.setPayNo(payRequest.getIdSheetNo());
                    if (null != paramsObject.getBoolean("invoiceFlag")) {
                        payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                    }
                    if (null != paramsObject.getBoolean("creditsFlag")) {
                        payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                    }
                    double money = 0.0;
                    money = CastUtil.castDouble((Object)payResponse.getDiscounts()) + CastUtil.castDouble((Object)payResponse.getActualCharge()) + CastUtil.castDouble((Object)payResponse.getOtherDiscounts());
                    payment.setMoney(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setAmount(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setRate(getPayInfoIn.getRate());
                    payment.setPrecision(String.valueOf(getPayInfoIn.getPrecision()));
                    payment.setPrcutMode(getPayInfoIn.getCutMode());
                    payment.setFlag("1");
                    payment.setTerminalNo(payRequest.getTerminalNo());
                    if ("67".equals(paramsObject.getString("payType"))) {
                        payment.setMisTerminalId(payRequest.getTerminalNo());
                    }
                    payment.setTerminalSno(payRequest.getTerminalSno());
                    payment.setDiscountValue((CastUtil.castDouble((Object)payResponse.getDiscounts()) + CastUtil.castDouble((Object)payResponse.getOtherDiscounts())) * 0.01);
                    payment.setMerchantDiscountValue(CastUtil.castDouble((Object)payResponse.getDiscounts()) * 0.01);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)payResponse.getOtherDiscounts()) * 0.01);
                    payment.setPayMemo(payResponse.getCreateTime());
                    payment.setRefCode(payResponse.getPayOrderId());
                    payment.setIsSuccess(true);
                    if ("67".equals(getPayInfoIn.getPayType()) || "46".equals(getPayInfoIn.getPayType()) || "D1".equals(getPayInfoIn.getPayType()) || "C5".equals(getPayInfoIn.getPayType())) {
                        payment.setPayNo(payResponse.getPayOrderId());
                        payment.setRefCode(payResponse.getIdSheetNo());
                    }
                    if ("1".equals(getPayInfoIn.getScene())) {
                        payment.setPopFlag("1");
                    }
                    this.convertRespse(payment, payResponse, paramsObject);
                    log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    vo.setCacheModel(cacheModel);
                    payResponse.setRemainValue(order.getRemainValue());
                    payResponse.setOughtPay(order.getOughtPay());
                    payResponse.setOverageValue(order.getOverageValue());
                    payResponse.setExistPay(order.getExistPay());
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                }
                if (payResponse.getBusinessResult().equals("INPROCESS")) {
                    RespBase res = new RespBase();
                    res.setRetflag(Code.CODE_55555.getIndex());
                    res.setRetmsg(merchantOrderNo);
                    return res;
                }
            }
            return Code.CODE_50015.getRespBase(new Object[]{payResponse.getReturnResult()});
        }
        catch (Exception e) {
            log.info("\u5f02\u5e38", (Throwable)e);
            RespBase res = new RespBase();
            res.setRetflag(Code.CODE_55555.getIndex());
            res.setRetmsg(merchantOrderNo);
            return res;
        }
    }

    public RespBase getQrCode(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            log.info("\u79bb\u7ebf\u652f\u4ed8\u5165\u53c2" + jsonObject.toJSONString());
            String apsp = "";
            String obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            apsp = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"APSP");
            log.info("apsp:" + apsp);
            if (!StringUtils.isNotEmpty((String)apsp)) {
                return new RespBase(Code.FAIL.getIndex(), "\u672a\u627e\u5230\u5fae\u652f\u4ed8\u95e8\u5e97\u914d\u7f6e\u4fe1\u606f", vo.getCacheModel().getFlowNo());
            }
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            if (StringUtils.isNotEmpty((String)vo.getCacheModel().getRn())) {
                treeMap.put("rn", vo.getCacheModel().getRn().substring(0, 4) + vo.getCacheModel().getOrder().getTerminalNo().substring(vo.getCacheModel().getOrder().getTerminalNo().length() - 2, vo.getCacheModel().getOrder().getTerminalNo().length()));
            } else {
                treeMap.put("rn", RandomNum.generateString((int)4) + vo.getCacheModel().getOrder().getTerminalNo().substring(vo.getCacheModel().getOrder().getTerminalNo().length() - 2, vo.getCacheModel().getOrder().getTerminalNo().length()));
            }
            treeMap.put("shop", apsp);
            treeMap.put("amt", String.valueOf((long)ManipulatePrecision.doubleConvert((double)(jsonObject.getDouble("amt") * 100.0), (int)2, (int)1)));
            JSONObject treeMapObject = new JSONObject(treeMap);
            log.info("\u6392\u5e8f\u540e\u7684\u5165\u53c2\uff1a" + treeMapObject.toJSONString());
            log.info("key\uff1a" + this.RSAPrivateKey);
            String sign = RSAUtils2.signForSHA((String)treeMapObject.toJSONString(), (PrivateKey)RSAUtils2.getPrivateKey((String)this.RSAPrivateKey));
            log.info("\u7b7e\u540dRSA\u52a0\u5bc6\uff1a" + sign);
            String qrCode = this.url + "?shop=" + treeMap.get("shop") + "&amt=" + treeMap.get("amt") + "&rn=" + treeMap.get("rn") + "&sign=" + URLEncoder.encode(sign, "UTF-8");
            JSONObject resp = new JSONObject();
            resp.put("qrCode", (Object)qrCode);
            if (StringUtils.isEmpty((String)vo.getCacheModel().getRn())) {
                vo.getCacheModel().setRn((String)treeMap.get("rn") + String.valueOf((long)ManipulatePrecision.doubleConvert((double)(jsonObject.getDouble("amt") * 100.0), (int)2, (int)1)));
            }
            vo.setJsonObject(resp);
            return new RespBase(Code.SUCCESS, (Object)vo, vo.getCacheModel().getFlowNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(Code.FAIL, "\u83b7\u53d6\u4e8c\u7ef4\u7801\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public RespBase qrCodePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("qrCodePayQuery ==" + JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        GetPayQueryInfoIn getPayQueryInfoIn = (GetPayQueryInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayQueryInfoIn.class);
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getPayType())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getTerminalSno())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getIdSheetNo())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", "\u652f\u4ed8\u5355\u53f7");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String amt = String.valueOf((long)ManipulatePrecision.doubleConvert((double)(getPayQueryInfoIn.getAmount() * 100.0), (int)2, (int)1));
        if (!(getPayQueryInfoIn.getPayNo() + amt).contains(cacheModel.getRn())) {
            log.info("getPayQueryInfoIn.getPayNo()+amt==>" + getPayQueryInfoIn.getPayNo() + amt);
            log.info("cacheModel.getRn()==>" + cacheModel.getRn());
            return new RespBase(Code.CODE_50144.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u4e0d\u5c5e\u4e8e\u672c\u7b14\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        Boolean hasPayment = false;
        List cacheList = cacheModel.getPayments();
        log.info("cacheList==>" + JSONObject.toJSONString((Object)cacheList));
        log.info("idSheetNo==>" + paramsObject.getString("idSheetNo"));
        for (Payment payment : cacheList) {
            if (!StringUtils.isNotBlank((String)payment.getPayNo()) || !payment.getPayNo().equals(getPayQueryInfoIn.getIdSheetNo())) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        if (this.localcache.booleanValue()) {
            log.info("\u8131\u673a\u67e5\u8be2\u5165\u53c2\uff1a" + paramsObject.toJSONString());
            RespBase respBase = this.orderRemoteService.checkPayCode(session, paramsObject);
            log.info("\u8131\u673a\u67e5\u8be2\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)respBase));
            if (0 != respBase.getRetflag()) {
                return new RespBase(Code.CODE_50015.getIndex(), "\u5546\u6236\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
            }
        } else {
            boolean b = this.checkPayCode(session, paramsObject, cacheModel.getOrder().getErpCode());
            if (!b) {
                return new RespBase(Code.CODE_50015.getIndex(), "\u5546\u6236\u8ba2\u5355\u53f7\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
            }
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayQueryInfoIn.getShopCode() + getPayQueryInfoIn.getTerminalNo());
        log.info("payType:" + getPayQueryInfoIn.getPayType());
        getPayQueryInfoIn.setPayShopCode(paramsObject.getString("shopCode"));
        getPayQueryInfoIn.setPayTerminalNo(paramsObject.getString("terminalNo"));
        PayQueryRequest payQueryRequest = new PayQueryRequest(getPayQueryInfoIn);
        if ("98".equals(payQueryRequest.getPayType())) {
            payQueryRequest.setExchangeCode("02");
        }
        log.info("payQueryRequest ==" + JSONObject.toJSONString((Object)payQueryRequest));
        try {
            if (!hasPayment.booleanValue()) {
                Payment payment = new Payment();
                payment.setPuid(UUIDUtils.buildPuid());
                payment.setRownoId(payment.getPuid());
                payment.setRowno(cacheModel.getPayments().size() + 1);
                if ("67".equals(getPayQueryInfoIn.getPayType()) || "98".equals(getPayQueryInfoIn.getPayType()) || "D6".equals(getPayQueryInfoIn.getPayType()) || "31".equals(getPayQueryInfoIn.getPayType())) {
                    payment.setPayCode(getPayQueryInfoIn.getPayCode());
                    payment.setPayName(getPayQueryInfoIn.getPayName());
                    payment.setAppType(this.getAppType(getPayQueryInfoIn.getPayType()));
                } else {
                    String channelFlag = "";
                    channelFlag = "02".equals(getPayQueryInfoIn.getPayType()) ? "07" : ("03".equals(getPayQueryInfoIn.getPayType()) ? "06" : getPayQueryInfoIn.getPayNo().substring(0, 2));
                    boolean flag = this.checkPayName(obj, paramsObject, payment, channelFlag);
                    payment.setAppType(this.getAppType(channelFlag));
                    if (!flag) {
                        log.info("\u672a\u5339\u914d\u5230\u652f\u4ed8\u65b9\u5f0f");
                        return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25-\u672a\u627e\u5230\u652f\u4ed8\u65b9\u5f0f:" + getPayQueryInfoIn.getPayCode(), null, "");
                    }
                }
                payment.setPayNo(getPayQueryInfoIn.getIdSheetNo());
                double money = 0.0;
                money = CastUtil.castDouble((Object)getPayQueryInfoIn.getAmount());
                payment.setMoney(ManipulatePrecision.doubleConvert((double)money, (int)2, (int)1));
                payment.setAmount(ManipulatePrecision.doubleConvert((double)money, (int)2, (int)1));
                payment.setRate(1.0);
                payment.setPrecision(String.valueOf(getPayQueryInfoIn.getPrecision()));
                payment.setPrcutMode(getPayQueryInfoIn.getCutMode());
                payment.setFlag("1");
                payment.setTerminalNo(getPayQueryInfoIn.getTerminalNo());
                payment.setTerminalSno(getPayQueryInfoIn.getTerminalSno());
                payment.setCouponType("offline");
                if ("1".equals(getPayQueryInfoIn)) {
                    payment.setPopFlag("1");
                }
                PaymentMode payMode = PayModeUtils.getPayMode((String)getPayQueryInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                payment.setPayType(payMode.getPaytype());
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            return new RespBase(Code.FAIL, (Object)"\u751f\u6210\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25", cacheModel.getFlowNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25\u539f\u56e0:\u652f\u4ed8\u670d\u52a1\u5f02\u5e38", cacheModel.getFlowNo());
        }
    }
}

