/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.xhd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.model.GetPayInfoIn;
import com.efuture.business.model.allVpay.request.RepealPayRequest;
import com.efuture.business.model.allVpay.response.PayResponse;
import com.efuture.business.model.allVpay.response.RefundPayResponse;
import com.efuture.business.service.impl.AllVpaySaleBSImpl;
import com.efuture.business.util.AllVPayTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllVpaySaleBSImpl_XHD
extends AllVpaySaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(AllVpaySaleBSImpl_XHD.class);

    public boolean checkPayName(String redisObj, JSONObject paramsObject, Payment payment, String pmCode) {
        String postr = "";
        if (redisObj != null) {
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)redisObj.toString(), ModeDetailsVo.class);
            List syspara = modeDetailsVo.getSyspara();
            postr = ModeDetailsVo.getSysParaValue((List)syspara, (String)"POSTR");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)redisObj);
        log.info("\u7cfb\u7edf\u53c2\u6570postr=" + postr);
        if (postr.startsWith("A")) {
            GetPayInfoIn getPayInfoIn = (GetPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayInfoIn.class);
            String[] pars = postr.split("\\|");
            List<String> paycodes = Arrays.asList(pars[1].split(","));
            if (paycodes.contains(getPayInfoIn.getPayCode())) {
                for (int k = 0; k < jsonObject.getJSONArray("paymentmethodposref").size(); ++k) {
                    JSONObject paymentmethodposref = jsonObject.getJSONArray("paymentmethodposref").getJSONObject(k);
                    if (paramsObject.getString("payCode").equalsIgnoreCase(paymentmethodposref.getString("payCode")) && pmCode.equals(paymentmethodposref.getString("pmCode"))) {
                        payment.setPayCode(paymentmethodposref.getString("posAbleCode"));
                        payment.setPayName(paymentmethodposref.getString("posAbleName"));
                        payment.setAppType(this.getAppType(pmCode));
                        return true;
                    }
                    payment.setPayCode(paramsObject.getString("payCode"));
                    payment.setPayName(paramsObject.getString("payName"));
                    payment.setAppType(this.getAppType(pmCode));
                }
            } else {
                payment.setPayCode(getPayInfoIn.getPayCode());
                payment.setPayName(getPayInfoIn.getPayName());
                payment.setAppType(this.getAppType(getPayInfoIn.getPayType()));
            }
            return true;
        }
        return super.checkPayName(redisObj, paramsObject, payment, pmCode);
    }

    public RepealPayRequest convertRequest(RepealPayRequest repealPayRequest, Payment payment, JSONObject paramsObject) {
        if ("67".equals(paramsObject.getString("payType")) && StringUtils.isNotEmpty((String)payment.getExtMemo()) && payment.getExtMemo().startsWith("\u6570\u5b57\u4eba\u6c11\u5e01") || "C5".equals(paramsObject.getString("payType"))) {
            String merchantOrderNo = paramsObject.getString("shopCode") + paramsObject.getString("terminalNo") + System.currentTimeMillis();
            repealPayRequest.setIdSheetNo(merchantOrderNo);
            repealPayRequest.setMessageLen("000244");
            repealPayRequest.setExchangeCode("03");
            repealPayRequest.setOriginalIdSheetNo(payment.getPayNo());
            repealPayRequest.setOriginalCreateTime(payment.getPayMemo());
            repealPayRequest.setCreateTime(AllVPayTools.getTime());
            repealPayRequest.setRefundMoney(String.valueOf((int)ManipulatePrecision.doubleConvert((double)(payment.getMoney() * 100.0))));
            repealPayRequest.setMoney(String.valueOf((int)ManipulatePrecision.doubleConvert((double)(payment.getMoney() * 100.0))));
        }
        return repealPayRequest;
    }

    public void convertRespse(Payment payment, PayResponse payResponse, JSONObject paramsObject) {
        payment.setExtMemo(payResponse.getQrcodeUrl());
        try {
            JSONObject jsonObject;
            int i;
            double merchantDis;
            double otherDis;
            if ("99".equals(paramsObject.getString("payType"))) {
                otherDis = 0.0;
                merchantDis = 0.0;
                if (payResponse.getQrcodeUrl().startsWith("06") && StringUtils.isNotEmpty((String)payResponse.getExtMsg1())) {
                    JSONArray promotion_detail = JSONObject.parseObject((String)payResponse.getExtMsg1()).getJSONArray("promotion_detail");
                    for (i = 0; i < promotion_detail.size(); ++i) {
                        jsonObject = promotion_detail.getJSONObject(i);
                        double wxpay_contribute = jsonObject.getDouble("wxpay_contribute") / 100.0;
                        double merchant_contribute = jsonObject.getDouble("merchant_contribute") / 100.0;
                        double other_contribute = jsonObject.getDouble("other_contribute") / 100.0;
                        otherDis += ManipulatePrecision.getDetailOverFlow((double)(wxpay_contribute + other_contribute), (String)payment.getPrecision());
                        merchantDis += ManipulatePrecision.getDetailOverFlow((double)merchant_contribute, (String)payment.getPrecision());
                    }
                }
                if (payResponse.getQrcodeUrl().startsWith("07") && payResponse.getDiscountDetails() != null && payResponse.getDiscountDetails().size() > 0) {
                    for (int i2 = 0; i2 < payResponse.getDiscountDetails().size(); ++i2) {
                        PayResponse.DiscountDetail detail = (PayResponse.DiscountDetail)payResponse.getDiscountDetails().get(i2);
                        if ("MERCHANT".equals(detail.getDiscountInvestorType())) {
                            merchantDis += ManipulatePrecision.getDetailOverFlow((double)(Double.parseDouble(detail.getDiscountInvestmentAmount()) / 100.0), (String)payment.getPrecision());
                            continue;
                        }
                        otherDis += ManipulatePrecision.getDetailOverFlow((double)(Double.parseDouble(detail.getDiscountInvestmentAmount()) / 100.0), (String)payment.getPrecision());
                    }
                }
                if (payResponse.getQrcodeUrl().startsWith("13") && StringUtils.isNotEmpty((String)payResponse.getMechineDiscount()) && StringUtils.isNotEmpty((String)payResponse.getChannelDiscount())) {
                    merchantDis = Double.parseDouble(payResponse.getMechineDiscount()) / 100.0;
                    otherDis = Double.parseDouble(payResponse.getChannelDiscount()) / 100.0;
                }
                payment.setMerchantDiscountValue(merchantDis);
                payment.setPayChannelDiscountValue(otherDis);
                payment.setDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(merchantDis + otherDis), (String)payment.getPrecision()));
            }
            if ("67".equals(paramsObject.getString("payType"))) {
                otherDis = 0.0;
                merchantDis = 0.0;
                if (StringUtils.isNotEmpty((String)payResponse.getExtMsg1())) {
                    JSONArray pop = JSONArray.parseArray((String)payResponse.getExtMsg1());
                    for (i = 0; i < pop.size(); ++i) {
                        jsonObject = pop.getJSONObject(i);
                        double merchantDiscountAmount = jsonObject.getDouble("merchantDiscountAmount") / 100.0;
                        double thirdPartyDiscountAmount = jsonObject.getDouble("thirdPartyDiscountAmount") / 100.0;
                        double platformDiscountAmount = jsonObject.getDouble("platformDiscountAmount") / 100.0;
                        otherDis += ManipulatePrecision.getDetailOverFlow((double)(thirdPartyDiscountAmount + platformDiscountAmount), (String)payment.getPrecision());
                        merchantDis += ManipulatePrecision.getDetailOverFlow((double)merchantDiscountAmount, (String)payment.getPrecision());
                    }
                    payment.setMerchantDiscountValue(merchantDis);
                    payment.setPayChannelDiscountValue(otherDis);
                    payment.setDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(merchantDis + otherDis), (String)payment.getPrecision()));
                }
            }
        }
        catch (Exception e) {
            log.info("\u4f18\u60e0\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }

    public boolean supportNoSourceReturn(JSONObject paramsObject) {
        return "67".equals(paramsObject.getString("payType"));
    }

    public void convertReturnResponse(RefundPayResponse refund) {
        String result = refund.getResult();
        if (!StringUtils.isEmpty((String)result) && result.length() > 616) {
            refund.setPayDetailsDefine(Convert.newSubString((String)result, (int)614, (int)620).trim());
            int size = Integer.valueOf(refund.getPayDetailsDefine().substring(3));
            int payDetailsEndLen = 620 + 70 * size;
            String payDetailsStr = Convert.newSubString((String)result, (int)620, (int)payDetailsEndLen);
            ArrayList<PayResponse.PayDetail> pdList = new ArrayList<PayResponse.PayDetail>();
            for (int i = 0; i < size; ++i) {
                String payDetailStr = Convert.newSubString((String)payDetailsStr, (int)(70 * i), (int)(70 * i + 70));
                PayResponse.PayDetail payDetail = new PayResponse.PayDetail();
                payDetail.setPayDetailCode(Convert.newSubString((String)payDetailStr, (int)0, (int)16).trim());
                payDetail.setPayDetailName(Convert.newSubString((String)payDetailStr, (int)16, (int)46).trim());
                payDetail.setPayDetailAmount(payDetailStr);
                payDetail.setPayDetailMemo(Convert.newSubString((String)payDetailStr, (int)58, (int)70).trim());
                pdList.add(payDetail);
            }
            refund.setPayDetails(pdList);
            if (result.length() > payDetailsEndLen) {
                int discountDetailsDefineEnd = payDetailsEndLen + 6;
                refund.setDiscountDetailsDefine(Convert.newSubString((String)result, (int)payDetailsEndLen, (int)discountDetailsDefineEnd).trim());
                int discountSize = Integer.valueOf(refund.getDiscountDetailsDefine().substring(3));
                int discountsEndLen = discountDetailsDefineEnd + 230 * discountSize;
                String discountDetailsStr = Convert.newSubString((String)result, (int)discountDetailsDefineEnd, (int)discountsEndLen);
                ArrayList<PayResponse.DiscountDetail> disDetailList = new ArrayList<PayResponse.DiscountDetail>();
                for (int i = 0; i < discountSize; ++i) {
                    String discountDetailStr = Convert.newSubString((String)discountDetailsStr, (int)(230 * i), (int)(230 * i + 230));
                    PayResponse.DiscountDetail discountDetail = new PayResponse.DiscountDetail();
                    discountDetail.setDiscountType(Convert.newSubString((String)discountDetailStr, (int)0, (int)30).trim());
                    discountDetail.setDiscountName(Convert.newSubString((String)discountDetailStr, (int)30, (int)50).trim());
                    discountDetail.setDiscountGoodsId(Convert.newSubString((String)discountDetailStr, (int)50, (int)70).trim());
                    discountDetail.setDiscountGoodsName(Convert.newSubString((String)discountDetailStr, (int)70, (int)110).trim());
                    discountDetail.setDiscountGoodsQty(Convert.newSubString((String)discountDetailStr, (int)110, (int)120).trim());
                    discountDetail.setDiscountCouponId(Convert.newSubString((String)discountDetailStr, (int)120, (int)152).trim());
                    discountDetail.setDiscountCouponAmount(Convert.newSubString((String)discountDetailStr, (int)152, (int)164).trim());
                    discountDetail.setDiscountInvestorType(Convert.newSubString((String)discountDetailStr, (int)164, (int)176).trim());
                    discountDetail.setDiscountInvestorName(Convert.newSubString((String)discountDetailStr, (int)176, (int)188).trim());
                    discountDetail.setDiscountInvestmentAmount(Convert.newSubString((String)discountDetailStr, (int)188, (int)200).trim());
                    discountDetail.setDiscountMemo(Convert.newSubString((String)discountDetailStr, (int)200, (int)230).trim());
                    disDetailList.add(discountDetail);
                }
                refund.setDiscountDetails(disDetailList);
                if (result.length() > (discountsEndLen += 24)) {
                    refund.setDiscounts(Convert.newSubString((String)result, (int)discountsEndLen, (int)(discountsEndLen + 12)).trim());
                }
                if (result.length() > discountsEndLen + 12) {
                    refund.setOtherDiscounts(Convert.newSubString((String)result, (int)(discountsEndLen + 12), (int)(discountsEndLen + 24)).trim());
                }
            }
        }
    }
}

