/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.response.DeletePaymentOut;
import com.efuture.business.model.GetPayQueryInfoIn;
import com.efuture.business.model.GetRepealPayInfoIn;
import com.efuture.business.model.allVpay.request.PayQueryRequest;
import com.efuture.business.model.allVpay.request.RefundPayQueryRequest;
import com.efuture.business.model.allVpay.request.RefundPayRequest;
import com.efuture.business.model.allVpay.request.RepealPayRequest;
import com.efuture.business.model.allVpay.response.PayQueryResponse;
import com.efuture.business.model.allVpay.response.RefundPayQueryResponse;
import com.efuture.business.model.allVpay.response.RefundPayResponse;
import com.efuture.business.model.allVpay.response.RepealPayResponse;
import com.efuture.business.service.impl.AllVpaySaleBSImpl;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.PayUtil;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllVpaySaleBSImpl_WHSC
extends AllVpaySaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(AllVpaySaleBSImpl_WHSC.class);
    private static final String SUCCESS = "SUCCESS";
    private static final String INPROCESS = "INPROCESS";
    private static final String FAIL = "FAIL";
    private String CHECKPAYCODE = "order.online.check.payCode";

    public RespBase salePayQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        log.info("salePayQuery ==" + JSONObject.toJSONString((Object)paramsObject));
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        GetPayQueryInfoIn getPayQueryInfoIn = (GetPayQueryInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayQueryInfoIn.class);
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getPayType())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getTerminalSno())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (StringUtils.isBlank((String)getPayQueryInfoIn.getIdSheetNo())) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", "\u652f\u4ed8\u5355\u53f7");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60, (Object)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        Boolean hasPayment = false;
        List cacheList = cacheModel.getPayments();
        log.info("cacheList==>" + JSONObject.toJSONString((Object)cacheList));
        log.info("idSheetNo==>" + paramsObject.getString("idSheetNo"));
        for (Payment payment : cacheList) {
            if (!StringUtils.isNotBlank((String)payment.getRefCode()) || !payment.getRefCode().equals(getPayQueryInfoIn.getIdSheetNo())) continue;
            return new RespBase(Code.CODE_50048.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayQueryInfoIn.getShopCode() + getPayQueryInfoIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        try {
            if ("67".equals(getPayQueryInfoIn.getPayType())) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(getPayQueryInfoIn.getPayType())) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                if (StringUtils.isBlank((String)paramsObject.getString("payShopCode"))) {
                    paramsObject.put("payShopCode", (Object)cacheModel.getOrder().getShopCode());
                }
                if (StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
                    paramsObject.put("payTerminalNo", (Object)cacheModel.getOrder().getTerminalNo());
                }
            }
        }
        catch (Exception e) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u672a\u8bbe\u7f6e[payShopCode]\u6216[payTerminalNo]", "");
        }
        if (!paramsObject.containsKey((Object)"payTerminalNo") || paramsObject.getString("payTerminalNo").isEmpty() || "".equals(paramsObject.getString("payTerminalNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "[\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u7ec8\u7aef\u53f7]\u672a\u914d\u7f6e", "\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u7ec8\u7aef\u53f7");
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty() || "".equals(paramsObject.getString("payShopCode"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "[\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7]\u672a\u914d\u7f6e", "\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7");
        }
        getPayQueryInfoIn = (GetPayQueryInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetPayQueryInfoIn.class);
        PayQueryRequest payQueryRequest = new PayQueryRequest(getPayQueryInfoIn);
        payQueryRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        payQueryRequest.setExchangeCode("02");
        log.info("\u652f\u4ed8\u67e5\u8be2\u5165\u53c2 ==>{}" + payQueryRequest.toString());
        try {
            PayQueryResponse rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
            log.info("rayResponse ==" + JSONObject.toJSONString((Object)rayResponse));
            if (rayResponse.getReturnCode().equals(SUCCESS)) {
                if (INPROCESS.equals(rayResponse.getBusinessResult())) {
                    for (int i = 0; i < 11; ++i) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
                        if (!INPROCESS.equals(rayResponse.getBusinessResult())) break;
                    }
                    if (!SUCCESS.equals(rayResponse.getBusinessResult())) {
                        return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25", vo.getCacheModel().getFlowNo());
                    }
                }
                if (FAIL.equals(rayResponse.getBusinessResult())) {
                    return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u67e5\u8be2\u5931\u8d25\uff1a" + rayResponse.getReturnResult(), vo.getCacheModel().getFlowNo());
                }
                try {
                    String channelTransationTime = rayResponse.getCreateTime();
                    int cmft = cacheModel.getOrder().getSysPara().getCmft();
                    if (cmft > 0) {
                        LocalDateTime dateTime = LocalDateTime.now();
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                        LocalDateTime orderDateTime = LocalDateTime.parse(channelTransationTime, df);
                        Duration duration = Duration.between(orderDateTime, dateTime);
                        if (duration.toMinutes() - (long)cmft > 0L) {
                            return new RespBase(Code.CODE_50049.getIndex(), "\u652f\u4ed8\u5931\u8d25\uff1a\u8d85\u8fc7\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u67e5\u8be2\u652f\u4ed8", vo.getCacheModel().getFlowNo());
                        }
                    }
                }
                catch (Exception e) {
                    return new RespBase(Code.CODE_50015.getIndex(), "\u6821\u9a8c\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38", vo.getCacheModel().getFlowNo());
                }
                if (!rayResponse.getIdSheetNo().startsWith(cacheModel.getOrder().getShopCode())) {
                    return new RespBase(Code.CODE_50015.getIndex(), "\u5fae\u652f\u4ed8\u8ba2\u5355\u67e5\u7801\u4ed8 \u4e0d\u5141\u8bb8\u8de8\u95e8\u5e97\u8fdb\u884c", vo.getCacheModel().getFlowNo());
                }
                paramsObject.put("idSheetNo", (Object)rayResponse.getIdSheetNo());
                boolean b = this.checkPayCode(session, paramsObject, cacheModel.getOrder().getErpCode());
                if (!b) {
                    return new RespBase(Code.CODE_50015.getIndex(), "\u5546\u6236\u8ba2\u5355\u53f7\u6821\u9a8c\u5931\u8d25", vo.getCacheModel().getFlowNo());
                }
                if (!hasPayment.booleanValue()) {
                    PaymentMode payMode = PayModeUtils.getPayMode((String)getPayQueryInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                    Payment payment = new Payment();
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setRownoId(payment.getPuid());
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    payment.setPayCode(getPayQueryInfoIn.getPayCode());
                    payment.setPayName(getPayQueryInfoIn.getPayName());
                    payment.setAppType(this.getAppType(getPayQueryInfoIn.getPayType()));
                    payment.setPayNo(rayResponse.getIdSheetNo());
                    double money = 0.0;
                    money = CastUtil.castDouble((Object)rayResponse.getDiscounts()) + CastUtil.castDouble((Object)rayResponse.getActualCharge()) + CastUtil.castDouble((Object)rayResponse.getOtherDiscounts());
                    payment.setMoney(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setAmount(ManipulatePrecision.doubleConvert((double)(money / 100.0), (int)2, (int)1));
                    payment.setRate(1.0);
                    payment.setPrecision(String.valueOf(getPayQueryInfoIn.getPrecision()));
                    payment.setPrcutMode(getPayQueryInfoIn.getCutMode());
                    payment.setFlag("1");
                    payment.setTerminalNo(getPayQueryInfoIn.getTerminalNo());
                    payment.setTerminalSno(getPayQueryInfoIn.getTerminalSno());
                    payment.setDiscountValue((CastUtil.castDouble((Object)rayResponse.getDiscounts()) + CastUtil.castDouble((Object)rayResponse.getOtherDiscounts())) * 0.01);
                    payment.setMerchantDiscountValue(CastUtil.castDouble((Object)rayResponse.getDiscounts()) * 0.01);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)rayResponse.getOtherDiscounts()) * 0.01);
                    payment.setPayMemo(rayResponse.getCreateTime());
                    payment.setRefCode(rayResponse.getPayOrderId());
                    if ("67".equals(getPayQueryInfoIn.getPayType()) || "46".equals(getPayQueryInfoIn.getPayType()) || "D1".equals(getPayQueryInfoIn.getPayType())) {
                        payment.setPayNo(payment.getRefCode());
                        payment.setRefCode(rayResponse.getIdSheetNo());
                    }
                    if ("1".equals(getPayQueryInfoIn)) {
                        payment.setPopFlag("1");
                    }
                    payment.setPayType(payMode.getPaytype());
                    log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    vo.setCacheModel(cacheModel);
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                }
                return new RespBase(Code.FAIL, (Object)rayResponse, "");
            }
            return new RespBase(Code.CODE_500001.getIndex(), rayResponse.getReturnResult(), "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.CODE_50015.getIndex(), "\u652f\u4ed8\u5931\u8d25\u539f\u56e0:\u652f\u4ed8\u670d\u52a1\u5f02\u5e38", "");
        }
    }

    public RespBase saleRepealPay(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801]", "");
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801]", "");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u652f\u4ed8\u91d1\u989d]", "");
        }
        if (!paramsObject.containsKey((Object)"refundMoney") || paramsObject.getString("refundMoney").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u9000\u6b3e\u91d1\u989d]", "");
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6c47\u7387]", "");
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56db\u820d\u4e94\u5165\u7cbe\u5ea6]", "");
        }
        GetRepealPayInfoIn getRepealPayInfoIn = (GetRepealPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetRepealPayInfoIn.class);
        String obj = this.redisUtil.get(RedisKey.CACHEID + getRepealPayInfoIn.getShopCode() + getRepealPayInfoIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        Order order = cacheModel.getOrder();
        String merchantOrderNo = getRepealPayInfoIn.getShopCode() + getRepealPayInfoIn.getTerminalNo() + System.currentTimeMillis();
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                if (StringUtils.isBlank((String)paramsObject.getString("payShopCode"))) {
                    paramsObject.put("payShopCode", (Object)cacheModel.getOrder().getShopCode());
                }
                if (StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
                    paramsObject.put("payTerminalNo", (Object)cacheModel.getOrder().getTerminalNo());
                }
            }
        }
        catch (Exception e) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u672a\u8bbe\u7f6e[payShopCode]\u6216[payTerminalNo]", "");
        }
        getRepealPayInfoIn = (GetRepealPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetRepealPayInfoIn.class);
        log.info("getRepealPayInfoIn=>" + JSONObject.toJSONString((Object)getRepealPayInfoIn));
        getRepealPayInfoIn.setIdSheetNo(merchantOrderNo);
        RefundPayRequest refundRequest = new RefundPayRequest(getRepealPayInfoIn);
        if (CastUtil.castDouble((Object)refundRequest.getMoney()) > ManipulatePrecision.doubleConvert((double)(order.getRemainValue() * 100.0))) {
            return new RespBase(Code.CODE_50050.getIndex(), "\u539f\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u5269\u4f59\u4ed8\u6b3e", vo.getCacheModel().getFlowNo());
        }
        if (CastUtil.castDouble((Object)refundRequest.getMoney()) < CastUtil.castDouble((Object)refundRequest.getRefundMoney())) {
            return new RespBase(Code.CODE_50051.getIndex(), "\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u539f\u5355\u652f\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        double money = ManipulatePrecision.doubleConvert((double)CastUtil.castDouble((Object)getRepealPayInfoIn.getMoney()), (int)2, (int)1);
        log.info("salePay\u91cd\u7b97\u8ba2\u5355 Order[{}]", (Object)JSON.toJSONString((Object)cacheModel.getOrder()));
        if (remainValue <= 0.0) {
            return new RespBase(Code.CODE_500000.getIndex(), "\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01", vo.getCacheModel().getFlowNo());
        }
        if (remainValue - money < 0.0) {
            return new RespBase(Code.CODE_500000.getIndex(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        double originalAmount = 0.0;
        boolean isNeedQuery = true;
        if (null != cacheModel.getReturnPayments() && cacheModel.getReturnPayments().size() > 0) {
            for (Payment p : cacheModel.getReturnPayments()) {
                if (!"D4".equals(getRepealPayInfoIn.getPayType()) || !refundRequest.getOriginalIdSheetNo().equals(p.getRefCode())) continue;
                originalAmount = p.getAmount();
                isNeedQuery = false;
                getRepealPayInfoIn.setPayCode(p.getPayCode());
                break;
            }
        }
        if (isNeedQuery) {
            PayQueryRequest payQueryRequest = new PayQueryRequest(getRepealPayInfoIn);
            payQueryRequest.setExchangeCode("02");
            payQueryRequest.setIdSheetNo(refundRequest.getOriginalIdSheetNo());
            payQueryRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
            log.info("payQueryRequest ====>{}", (Object)payQueryRequest.toString());
            try {
                PayQueryResponse rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
                if (!SUCCESS.equals(rayResponse.getReturnCode())) {
                    return new RespBase(Code.CODE_50067.getIndex(), "\u5fae\u652f\u4ed8\u539f\u5355\u4fe1\u606f\u672a\u627e\u5230", vo.getCacheModel().getFlowNo());
                }
                originalAmount = ManipulatePrecision.doubleConvert((double)((CastUtil.castDouble((Object)rayResponse.getDiscounts()) + CastUtil.castDouble((Object)rayResponse.getActualCharge()) + CastUtil.castDouble((Object)rayResponse.getOtherDiscounts())) * 0.01), (int)2, (int)1);
                refundRequest.setOriginalCreateTime(rayResponse.getCreateTime());
            }
            catch (Exception e) {
                return new RespBase(Code.CODE_50067.getIndex(), "\u5fae\u652f\u4ed8\u67e5\u8be2\u539f\u5355\u652f\u4ed8\u4fe1\u606f\u5931\u8d25", vo.getCacheModel().getFlowNo());
            }
        }
        if (money > originalAmount) {
            return new RespBase(Code.CODE_50051.getIndex(), "\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u539f\u5355\u652f\u4ed8\u91d1\u989d", vo.getCacheModel().getFlowNo());
        }
        refundRequest.setMoney(String.valueOf((int)ManipulatePrecision.doubleConvert((double)(originalAmount * 100.0))));
        refundRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        try {
            log.info("\u5fae\u652f\u4ed8\u9000\u6b3e\u5165\u53c2\uff1a" + refundRequest.toString());
            RefundPayResponse refundPayResponse = this.allVPayTools.saleRefundPay(refundRequest);
            if (refundPayResponse.getReturnCode().equals(SUCCESS)) {
                if (refundPayResponse.getBusinessResult().equals(SUCCESS)) {
                    Payment payment = new Payment();
                    PaymentMode payMode = PayModeUtils.getPayMode((String)getRepealPayInfoIn.getPayCode(), (JSONObject)JSONObject.parseObject((String)obj));
                    payment.setPayCode(payMode.getCode());
                    payment.setPayName(payMode.getName());
                    payment.setAppType(this.getAppType(paramsObject.getString("payType")));
                    payment.setPayType(payMode.getPaytype());
                    payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    payment.setRownoId(payment.getPuid());
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    payment.setPayNo(refundRequest.getIdSheetNo());
                    if ("D1".equals(refundRequest.getPayType())) {
                        payment.setPayNo(refundPayResponse.getOriginalIdSheetNo());
                    }
                    payment.setAmount(CastUtil.castDouble((Object)refundRequest.getRefundMoney()) * 0.01);
                    payment.setMoney(CastUtil.castDouble((Object)refundRequest.getRefundMoney()) * 0.01);
                    payment.setFlag("1");
                    payment.setTerminalNo(refundRequest.getTerminalNo());
                    payment.setTerminalSno(refundRequest.getTerminalSno());
                    payment.setRate(getRepealPayInfoIn.getRate());
                    payment.setPrecision(String.valueOf(getRepealPayInfoIn.getPrecision()));
                    payment.setPrcutMode(getRepealPayInfoIn.getCutMode());
                    payment.setDiscountValue((CastUtil.castDouble((Object)refundPayResponse.getDiscounts()) + CastUtil.castDouble((Object)refundPayResponse.getOtherDiscounts())) * 0.01);
                    payment.setMerchantDiscountValue(CastUtil.castDouble((Object)refundPayResponse.getDiscounts()) * 0.01);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)refundPayResponse.getOtherDiscounts()) * 0.01);
                    payment.setPayMemo(refundRequest.getCreateTime());
                    payment.setRefCode(refundPayResponse.getOriginalIdSheetNo());
                    if (null != paramsObject.getBoolean("invoiceFlag")) {
                        payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                    }
                    if (null != paramsObject.getBoolean("creditsFlag")) {
                        payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                    }
                    cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                    vo.setCacheModel(cacheModel);
                    log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                    refundPayResponse.setRemainValue(order.getRemainValue());
                    refundPayResponse.setOughtPay(order.getOughtPay());
                    refundPayResponse.setOverageValue(order.getOverageValue());
                    refundPayResponse.setExistPay(order.getExistPay());
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                    ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                }
                if (refundPayResponse.getBusinessResult().equals(INPROCESS)) {
                    return new RespBase(Code.CODE_55555.getIndex(), merchantOrderNo, refundPayResponse.getReturnResult());
                }
            }
            return new RespBase(Code.CODE_50052.getIndex(), "\u9000\u6b3e\u5931\u8d25\u539f\u56e0:" + refundPayResponse.getReturnResult(), JSON.toJSONString((Object)refundPayResponse));
        }
        catch (Exception e) {
            e.printStackTrace();
            getRepealPayInfoIn.setOriginalIdSheetNo(merchantOrderNo);
            getRepealPayInfoIn.setOriginalCreateTime(refundRequest.getCreateTime());
            RepealPayRequest repealPayRequest = new RepealPayRequest(getRepealPayInfoIn);
            log.info("repealPayRequest===" + JSONObject.toJSONString((Object)repealPayRequest));
            try {
                RepealPayResponse rayResponse = this.allVPayTools.repealPay(repealPayRequest);
                log.info("rayResponse===" + JSONObject.toJSONString((Object)rayResponse));
                if (!rayResponse.getReturnCode().equals(SUCCESS)) {
                    return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0:" + rayResponse.getReturnResult(), JSON.toJSONString((Object)rayResponse));
                }
            }
            catch (Exception es) {
                es.printStackTrace();
                return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25:\u670d\u52a1\u5f02\u5e38" + es.getMessage());
            }
            return new RespBase(Code.FAIL.getIndex(), "\u9000\u6b3e\u5931\u8d25\uff1a\u652f\u4ed8\u670d\u52a1\u5f02\u5e38!", "");
        }
    }

    public RespBase saleRefundQuery(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        cacheModel = this.posLogicCompoment.calcBalance(cacheModel);
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        if (StringUtils.isBlank((String)paramsObject.getString("payShopCode"))) {
            paramsObject.put("payShopCode", (Object)cacheModel.getOrder().getShopCode());
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
            paramsObject.put("payTerminalNo", (Object)cacheModel.getOrder().getTerminalNo());
        }
        if (!paramsObject.containsKey((Object)"payTerminalNo") || paramsObject.getString("payTerminalNo").isEmpty() || "".equals(paramsObject.getString("payTerminalNo"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "[\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u7ec8\u7aef\u53f7]\u672a\u914d\u7f6e", "\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u7ec8\u7aef\u53f7");
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty() || "".equals(paramsObject.getString("payShopCode"))) {
            return new RespBase(Code.CODE_500001.getIndex(), "[\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7]\u672a\u914d\u7f6e", "\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7");
        }
        RefundPayQueryRequest refundQueryRequest = new RefundPayQueryRequest(paramsObject);
        refundQueryRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        log.info("\u9000\u6b3e\u67e5\u8be2\u5165\u53c2 ==>{}" + refundQueryRequest.toString());
        try {
            RefundPayQueryResponse refundPayQueryResponse = this.allVPayTools.saleRefundPayQuery(refundQueryRequest);
            if (refundPayQueryResponse.getReturnCode().equals(SUCCESS) && refundPayQueryResponse.getBusinessResult().equals(SUCCESS)) {
                Payment payment = new Payment();
                PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
                payment.setPayCode(payMode.getCode());
                payment.setPayName(payMode.getName());
                payment.setAppType(this.getAppType(paramsObject.getString("payType")));
                payment.setPayType(payMode.getPaytype());
                payment.setPuid(String.valueOf(UniqueID.getUniqueID()));
                payment.setRownoId(payment.getPuid());
                payment.setRowno(cacheModel.getPayments().size() + 1);
                payment.setPayNo(refundQueryRequest.getIdSheetNo());
                payment.setAmount(CastUtil.castDouble((Object)refundPayQueryResponse.getRefundMoney()) * 0.01);
                payment.setMoney(CastUtil.castDouble((Object)refundPayQueryResponse.getRefundMoney()) * 0.01);
                payment.setFlag("1");
                payment.setTerminalNo(refundQueryRequest.getTerminalNo());
                payment.setTerminalSno(refundQueryRequest.getTerminalSno());
                payment.setRate(payMode.getZlhl().doubleValue());
                payment.setPrecision(String.valueOf(payMode.getSswrjd()));
                payment.setPrcutMode(payMode.getSswrfs());
                payment.setDiscountValue((CastUtil.castDouble((Object)refundPayQueryResponse.getDiscounts()) + CastUtil.castDouble((Object)refundPayQueryResponse.getOtherDiscounts())) * 0.01);
                payment.setMerchantDiscountValue(CastUtil.castDouble((Object)refundPayQueryResponse.getDiscounts()) * 0.01);
                payment.setPayChannelDiscountValue(CastUtil.castDouble((Object)refundPayQueryResponse.getOtherDiscounts()) * 0.01);
                payment.setPayMemo(refundQueryRequest.getCreateTime());
                payment.setRefCode(refundPayQueryResponse.getOriginalIdSheetNo());
                if (null != paramsObject.getBoolean("invoiceFlag")) {
                    payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag").booleanValue());
                }
                if (null != paramsObject.getBoolean("creditsFlag")) {
                    payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag").booleanValue());
                }
                cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, payment);
                vo.setCacheModel(cacheModel);
                log.info("\u4ed8\u6b3e\u884c\uff1a{}", (Object)JSONObject.toJSONString((Object)payment));
                refundPayQueryResponse.setRemainValue(order.getRemainValue());
                refundPayQueryResponse.setOughtPay(order.getOughtPay());
                refundPayQueryResponse.setOverageValue(order.getOverageValue());
                refundPayQueryResponse.setExistPay(order.getExistPay());
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "");
            }
            return new RespBase(Code.CODE_50052.getIndex(), "\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\u539f\u56e0:" + refundPayQueryResponse.getReturnResult(), JSON.toJSONString((Object)refundPayQueryResponse));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.FAIL.getIndex(), "\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\u539f\u56e0\uff1a\u652f\u4ed8\u670d\u52a1\u5f02\u5e38!", "");
        }
    }

    public RespBase saleRefund(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u91d1\u989d]", "");
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[puid]", "");
        }
        GetRepealPayInfoIn getPayReFundInfoIn = (GetRepealPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetRepealPayInfoIn.class);
        String obj = this.redisUtil.get(RedisKey.CACHEID + getPayReFundInfoIn.getShopCode() + getPayReFundInfoIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_500001.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_50043.getRespBase(new Object[]{cacheModel.getFlowNo()});
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return new RespBase(Code.CODE_50053.getIndex(), "\u9000\u8d27\u652f\u4ed8\u884c\u4e0d\u5141\u8bb8\u64a4\u9500", "");
        }
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                paramsObject.put("payShopCode", (Object)(StringUtils.isNotBlank((String)this.getPayShopCode(obj)) ? this.getPayShopCode(obj) : cacheModel.getSyjmain().getSyjgz()));
                paramsObject.put("payTerminalNo", (Object)this.getPayTerminalNo(obj));
            } else {
                if (StringUtils.isBlank((String)paramsObject.getString("payShopCode"))) {
                    paramsObject.put("payShopCode", (Object)cacheModel.getOrder().getShopCode());
                }
                if (StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
                    paramsObject.put("payTerminalNo", (Object)cacheModel.getOrder().getTerminalNo());
                }
            }
        }
        catch (Exception e) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u672a\u8bbe\u7f6e[payShopCode]\u6216[payTerminalNo]", "");
        }
        String merchantOrderNo = getPayReFundInfoIn.getShopCode() + getPayReFundInfoIn.getTerminalNo() + System.currentTimeMillis();
        getPayReFundInfoIn = (GetRepealPayInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetRepealPayInfoIn.class);
        String puid = getPayReFundInfoIn.getPuid();
        getPayReFundInfoIn.setIdSheetNo(merchantOrderNo);
        RefundPayRequest repealPayRequest = new RefundPayRequest(getPayReFundInfoIn);
        if (StringUtils.isBlank((String)repealPayRequest.getOriginalCreateTime())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            LocalDateTime dateTime = LocalDateTime.parse(cacheModel.getOrder().getSaleDate(), df);
            repealPayRequest.setOriginalCreateTime(dateTime.format(df2));
        }
        DeletePaymentOut deletePaymentOut = new DeletePaymentOut();
        Payment payment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            payment = p;
            break;
        }
        if (("67".equals(getPayReFundInfoIn.getPayType()) || "46".equals(getPayReFundInfoIn.getPayType()) || "D4".equals(getPayReFundInfoIn.getPayType())) && null != payment) {
            repealPayRequest.setOriginalIdSheetNo(payment.getRefCode());
        }
        repealPayRequest.setOriginalCreateTime(payment.getPayMemo());
        repealPayRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
        log.info("\u5fae\u652f\u4ed8\u64a4\u9500\u5165\u53c2===" + repealPayRequest.toString());
        try {
            RefundPayResponse rayResponse = this.allVPayTools.saleRefundPay(repealPayRequest);
            if (rayResponse.getReturnCode().equals(SUCCESS)) {
                if (rayResponse.getBusinessResult().equals(SUCCESS)) {
                    if (payment != null) {
                        cacheModel.getPayments().remove(payment);
                        PayUtil.sortPayments((List)cacheModel.getPayments());
                        cacheModel.setPayments(cacheModel.getPayments());
                        cacheModel = this.posLogicCompoment.calcDeletePay(cacheModel);
                        if (cacheModel.getCalcResult() == -1) {
                            String errCode = String.valueOf(Code.CODE_500000.getIndex());
                            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                                errCode = cacheModel.getErrCode();
                            }
                            return Code.FAIL.getRespBase(new Object[]{errCode, cacheModel.getErrMsg()});
                        }
                        vo.setCacheModel(cacheModel);
                        deletePaymentOut.setExistPay(order.getExistPay());
                        deletePaymentOut.setFlowNo(order.getFlowNo());
                        deletePaymentOut.setOughtPay(order.getOughtPay());
                        deletePaymentOut.setOverageValue(order.getOverageValue());
                        deletePaymentOut.setTotalDiscountValue(order.getTotalDiscountValue());
                        deletePaymentOut.setRemainValue(order.getRemainValue());
                        deletePaymentOut.setSalePayments(cacheModel.getPayments());
                        BaseOutModel out = new BaseOutModel();
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                    }
                    return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[\u4ed8\u6b3e\u884c\u4e3a\u7a7a]!", "");
                }
                return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25:" + rayResponse.getReturnResult(), "");
            }
            return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0:" + rayResponse.getReturnResult(), "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.FAIL.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0\uff1a\u652f\u4ed8\u670d\u52a1\u5f02\u5e38!", "");
        }
    }

    public RespBase saleRefundVoid(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_3.getRespBase(new Object[]{"\u516c\u5171\u53c2\u6570\u7f3a\u5931"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u7c7b\u578b]", "");
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u5c0f\u7968\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u539f\u5355\u53f7]", "");
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u652f\u4ed8\u91d1\u989d]", "");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_500001.getIndex(), "POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355", vo.getCacheModel().getFlowNo());
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        try {
            if ("67".equals(paramsObject.getString("payType"))) {
                this.setPayShopCode(paramsObject, obj);
            } else {
                if (StringUtils.isBlank((String)paramsObject.getString("payShopCode"))) {
                    paramsObject.put("payShopCode", (Object)cacheModel.getOrder().getShopCode());
                }
                if (StringUtils.isBlank((String)paramsObject.getString("payTerminalNo"))) {
                    paramsObject.put("payTerminalNo", (Object)cacheModel.getOrder().getTerminalNo());
                }
            }
        }
        catch (Exception e) {
            return new RespBase(Code.CODE_500001.getIndex(), "\u672a\u8bbe\u7f6e[payShopCode]\u6216[payTerminalNo]", "");
        }
        String originalPayNo = paramsObject.getString("originalIdSheetNo");
        Payment pay = null;
        int rowNo = -1;
        for (int i = 0; i < cacheModel.getReturnPayments().size(); ++i) {
            Payment p = (Payment)cacheModel.getReturnPayments().get(i);
            if (!originalPayNo.equals(p.getPayNo())) continue;
            pay = (Payment)p.clone();
            rowNo = i;
            break;
        }
        if (null == pay) {
            return new RespBase(Code.CODE_50030, (Object)"\u6d88\u5355\u4f20\u5165\u5355\u53f7\u6709\u8bef", vo.getCacheModel().getFlowNo());
        }
        paramsObject.put("originalCreateTime", (Object)pay.getPayMemo());
        if (!pay.getIsSuccess()) {
            RefundPayRequest repealPayRequest = new RefundPayRequest(paramsObject);
            String merchantOrderNo = cacheModel.getOrder().getShopCode() + repealPayRequest.getTerminalNo() + System.currentTimeMillis();
            repealPayRequest.setOriginalCreateTime(pay.getPayMemo());
            repealPayRequest.setIdSheetNo(merchantOrderNo);
            String post = ModeDetailsVo.getSysParaValue((List)syspara, (String)"POST");
            log.info("post\u7cfb\u7edf\u53c2\u6570==>{}", (Object)post);
            if ("67".equals(paramsObject.getString("payType")) || "46".equals(paramsObject.getString("payType")) || "D4".equals(paramsObject.getString("payType"))) {
                repealPayRequest.setOriginalIdSheetNo(pay.getRefCode());
            } else if ("D1".equals(paramsObject.getString("payType"))) {
                if (null != post) {
                    repealPayRequest.setPayShopCode(post);
                } else {
                    repealPayRequest.setPayShopCode("AAAA");
                }
            }
            log.info("\u5fae\u652f\u4ed8\u64a4\u9500\u5165\u53c2===" + repealPayRequest.toString());
            repealPayRequest.setSyjip(modeDetailsVo.getSyjmain().getSyjip());
            try {
                log.info("\u5fae\u652f\u4ed8\u9000\u6b3e\u5165\u53c2\uff1a" + repealPayRequest.toString());
                RefundPayResponse rayResponse = this.allVPayTools.saleRefundPay(repealPayRequest);
                if (rayResponse.getReturnCode().equals(SUCCESS)) {
                    if (rayResponse.getBusinessResult().equals(SUCCESS)) {
                        PaymentMode payMode = PayModeUtils.getPayMode((String)paramsObject.getString("payCode"), (JSONObject)JSONObject.parseObject((String)obj));
                        pay.setPayType(payMode.getPaytype());
                        pay.setPuid(String.valueOf(UniqueID.getUniqueID()));
                        pay.setRownoId(pay.getPuid());
                        pay.setPayNo(originalPayNo);
                        pay.setAmount(CastUtil.castDouble((Object)repealPayRequest.getMoney()) * 0.01);
                        pay.setMoney(CastUtil.castDouble((Object)repealPayRequest.getMoney()) * 0.01);
                        pay.setFlag("1");
                        pay.setTerminalNo(repealPayRequest.getTerminalNo());
                        pay.setTerminalSno(repealPayRequest.getTerminalSno());
                        pay.setRefCode(originalPayNo);
                        pay.setRate(payMode.getZlhl().doubleValue());
                        pay.setPrecision(String.valueOf(payMode.getSswrjd()));
                        pay.setPrcutMode(payMode.getSswrfs());
                        pay.setIsSuccess(true);
                        pay.setRowno(cacheModel.getPayments().size() + 1);
                        ((Payment)cacheModel.getReturnPayments().get(rowNo)).setIsSuccess(true);
                        cacheModel = this.posLogicCompoment.calcPayAmout(cacheModel, pay);
                        vo.setCacheModel(cacheModel);
                        BaseOutModel out = new BaseOutModel();
                        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
                    }
                    return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25:" + rayResponse.getReturnResult(), "");
                }
                return new RespBase(Code.CODE_50053.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0:" + rayResponse.getReturnResult(), "");
            }
            catch (Exception e) {
                e.printStackTrace();
                return new RespBase(Code.FAIL.getIndex(), "\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0\uff1a\u652f\u4ed8\u670d\u52a1\u5f02\u5e38!", "");
            }
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "");
    }
}

