/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.alibaba.fastjson.JSON;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.df.DfCannelPayReq;
import com.efuture.business.model.df.DfOweInfoReq;
import com.efuture.business.model.df.DfPayReq;
import com.efuture.business.service.BaseService;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.SecuritySHA1Utils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
@Configuration
public class DfPayUtil
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(DfPayUtil.class);
    final String ARREARS_QUERY_URL = "/IPPService/nonBank/arrearsQuery";
    final String PAY_URL = "/IPPService/nonBank/dsPayFee";
    final String REPEALPAY_URL = "/IPPService/nonBank/repealPayCost";

    public static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String date = df.format(new Date());
        return date;
    }

    public static String getSysId() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = df.format(new Date());
        return date;
    }

    public ServiceResponse queryOweInfo(RestTemplate restTemplate, ServiceSession session, DfOweInfoReq dfOweInfoDef) throws Exception {
        ServiceResponse resp = null;
        log.info("dfIp:{}\uff0cdfPort\uff1a{}", (Object)GlobalInfo.dfIp, (Object)GlobalInfo.dfPort);
        String sign = SecuritySHA1Utils.shaEncode((String)(JSON.toJSONString((Object)dfOweInfoDef) + GlobalInfo.dfsignKey)).toUpperCase();
        log.info("\u7b7e\u540d:{}", (Object)sign);
        String postvalue = sign + JSON.toJSONString((Object)dfOweInfoDef);
        resp = this.httpUtils.doWslfPost(restTemplate, session, HttpUtils.RemoteService.POSSV, postvalue, null, "\u6e56\u5317\u901a\u4fe1", "\u6b20\u8d39\u4fe1\u606f\u67e5\u8be2", this.getUrl(GlobalInfo.dfIp, GlobalInfo.dfPort, "/IPPService/nonBank/arrearsQuery"));
        return resp;
    }

    public ServiceResponse payment(RestTemplate restTemplate, ServiceSession session, DfPayReq dfPayDef) throws Exception {
        ServiceResponse resp = null;
        log.info("dfIp:{}\uff0cdfPort\uff1a{}", (Object)GlobalInfo.dfIp, (Object)GlobalInfo.dfPort);
        String sign = SecuritySHA1Utils.shaEncode((String)(JSON.toJSONString((Object)dfPayDef) + GlobalInfo.dfsignKey)).toUpperCase();
        log.info("\u7b7e\u540d:{}", (Object)sign);
        String postvalue = sign + JSON.toJSONString((Object)dfPayDef);
        resp = this.httpUtils.doWslfPost(restTemplate, session, HttpUtils.RemoteService.POSSV, postvalue, null, "\u6e56\u5317\u901a\u4fe1", "\u7f34\u8d39", this.getUrl(GlobalInfo.dfIp, GlobalInfo.dfPort, "/IPPService/nonBank/dsPayFee"));
        return resp;
    }

    public ServiceResponse cancelPay(RestTemplate restTemplate, ServiceSession session, DfCannelPayReq dfCannelPayDef) throws Exception {
        ServiceResponse resp = null;
        log.info("dfIp:{}\uff0cdfPort\uff1a{}", (Object)GlobalInfo.dfIp, (Object)GlobalInfo.dfPort);
        String sign = SecuritySHA1Utils.shaEncode((String)(JSON.toJSONString((Object)dfCannelPayDef) + GlobalInfo.dfsignKey)).toUpperCase();
        log.info("\u7b7e\u540d:{}", (Object)sign);
        String postvalue = sign + JSON.toJSONString((Object)dfCannelPayDef);
        resp = this.httpUtils.doWslfPost(restTemplate, session, HttpUtils.RemoteService.POSSV, postvalue, null, "\u6e56\u5317\u901a\u4fe1", "\u7f34\u8d39\u53d6\u6d88", this.getUrl(GlobalInfo.dfIp, GlobalInfo.dfPort, "/IPPService/nonBank/repealPayCost"));
        return resp;
    }

    private String getUrl(String ip, int port, String method) {
        return "https://" + ip + ":" + port + method;
    }
}

