/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.wsykt.EcardPacket;
import com.efuture.business.model.wsykt.PacketInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TVicClient {
    private static final Logger log = LoggerFactory.getLogger(TVicClient.class);
    public static final String TAG = "TVicClient";
    static final int DATABASE_ERROR = -100;
    static final int CARD_CANCEL_COMMAND = 0;
    static final int CARD_READNO_TO_NO_COMMAND = 1;
    static final int CARD_WITHDRAW_COMMAND = 2;
    static final int MEMBER_QUERY_COMMAND = 3;
    static final int PROMOTION_QUERY_COMMAND = 4;
    static final int PROMOTION_SUBMIT_COMMAND = 5;
    static final int TICKET_GRANT_COMMAND = 6;
    static final int TICKET_QUERY_COMMAND = 7;
    static final int VIC_QUERY_COMMAND = 8;
    static final int VIC_WITHDRAW_QUERY_COMMAND = 9;
    static final int TVIC_QUERY_COMMAND = 21;
    static final int TVIC_CHECK_COMMAND = 22;
    static final int TVIC_SALE_COMMAND = 23;
    static final int TVIC_CANCEL_COMMAND = 24;
    private final String charset = "GB2312";
    private InetSocketAddress address;
    private int connTimeout = 9000;
    private int sendTimeout = 9000;
    private int recvTimeout = 9000;
    private Socket socket;
    private int version = 0;
    public String storeCode = "";
    private int errorCode = 0;
    public static String errorText = "";
    private String tranId = "";
    private String chargeId = "";
    private final Map<String, String> vicChargeMap = new HashMap();
    private final Map<String, String> reChargeAmtMap = new HashMap();
    private String serverIp;
    private int port;
    private int timeOut = 9000;
    private String branCode = "";

    public TVicClient() {
        log.info("address:{},ip:{}", (Object)GlobalInfo.vicIp, (Object)GlobalInfo.vicPort);
        this.address = new InetSocketAddress(GlobalInfo.vicIp, GlobalInfo.vicPort);
        this.storeCode = this.branCode;
    }

    protected TVicClient(String ip, int port, String storeCode) {
        this.address = new InetSocketAddress(ip, port);
        this.storeCode = storeCode;
    }

    private void connect() throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.address, this.timeOut);
        this.socket.setSoTimeout(this.timeOut);
    }

    private void disconnect() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
    }

    private void sendBlock(byte[] data, int offset, int count) throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(data, offset, count);
    }

    private void recvBlock(byte[] buffer, int offset, int count) throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        while (count > 0) {
            int recv = inputStream.read(buffer, offset, count);
            if (recv < 0) {
                throw new RuntimeException("\u4e00\u5361\u901a\u8fde\u63a5\u4e2d\u65ad");
            }
            count -= recv;
            offset += recv;
        }
    }

    private void sendInteger(int data) throws IOException {
        byte[] buffer = new byte[4];
        buffer[3] = (byte)(data >>> 24);
        buffer[2] = (byte)(data >>> 16);
        buffer[1] = (byte)(data >>> 8);
        buffer[0] = (byte)data;
        this.sendBlock(buffer, 0, 4);
    }

    private int recvInteger() throws IOException {
        byte[] buffer = new byte[4];
        this.recvBlock(buffer, 0, 4);
        int n = (buffer[3] & 0xFF) << 24;
        n += (buffer[2] & 0xFF) << 16;
        n += (buffer[1] & 0xFF) << 8;
        return n += buffer[0] & 0xFF;
    }

    private void sendString(String data) throws IOException {
        byte[] buffer = data.getBytes("GB2312");
        int length = buffer.length;
        this.sendInteger(length);
        this.sendBlock(buffer, 0, length);
    }

    private String recvString() throws IOException {
        int length = this.recvInteger();
        byte[] buffer = new byte[length];
        this.recvBlock(buffer, 0, length);
        return new String(buffer, 0, length, "GB2312");
    }

    private String recvTranId() throws IOException {
        int length = 18;
        byte[] buffer = new byte[length];
        this.recvBlock(buffer, 0, length);
        return new String(buffer, 0, length, "GB2312");
    }

    private String recvMsg() throws IOException {
        int length = 40;
        byte[] buffer = new byte[length];
        this.recvBlock(buffer, 0, length);
        return new String(buffer, 0, length, "GB2312");
    }

    private String recvMsg1() throws IOException {
        int length = 40;
        byte[] buffer = new byte[length];
        this.recvBlock(buffer, 0, length);
        return new String(buffer, 0, length, "utf-8");
    }

    public String tvicQuery(byte[] cardData) throws IOException {
        log.info("\u5f00\u59cb\u4e8e\u540c\u57ce\u8fdb\u884c\u4e00\u5361\u901a\u6821\u9a8c\u5bf9\u63a5");
        Date startTime = new Date();
        try {
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(21);
            this.sendBlock(cardData, 0, cardData.length);
            this.errorCode = this.recvInteger();
            log.info("", (Object)("tvic check return code : " + this.errorCode));
            if (this.errorCode >= 0) {
                String string = this.recvTranId();
                return string;
            }
            errorText = this.recvString();
            log.info(TAG, (Object)("startTime == " + startTime + ",TVic check Error | " + errorText));
            throw new RuntimeException(errorText);
        }
        finally {
            this.disconnect();
        }
    }

    public boolean tvicValidation(byte[] cardData) throws IOException {
        log.info("\u5f00\u59cb\u4e8e\u540c\u57ce\u8fdb\u884c\u4e00\u5361\u901a\u6821\u9a8c\u5bf9\u63a5");
        Date startTime = new Date();
        try {
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(22);
            this.sendBlock(cardData, 0, cardData.length);
            this.errorCode = this.recvInteger();
            log.info("", (Object)("tvic check return code : " + this.errorCode));
            if (this.errorCode >= 0) {
                boolean bl = true;
                return bl;
            }
            errorText = this.recvString();
            log.info(TAG, (Object)("startTime == " + startTime + ",TVic check Error | " + errorText));
            throw new RuntimeException(errorText);
        }
        finally {
            this.disconnect();
        }
    }

    public boolean vicRecharge(int packetCount, byte[] packetData) throws IOException {
        log.info("\u5f00\u59cb\u793c\u54c1\u5361\u5145\u503c");
        Date startTime = new Date();
        try {
            PacketInfo withdrawPacket = EcardPacket.getTVicRechargePacket();
            this.connect();
            this.sendInteger(this.version);
            this.sendString(this.storeCode);
            this.sendInteger(23);
            this.sendInteger(packetCount);
            this.sendBlock(packetData, 0, packetCount * withdrawPacket.getPacketSize());
            this.sendInteger(1);
            String mess = this.recvMsg().trim();
            log.info("\u6fc0\u6d3b\u8fd4\u56de{}", (Object)mess);
            this.errorCode = this.recvInteger();
            if (this.errorCode > 0) {
                boolean bl = true;
                return bl;
            }
            try {
                errorText = this.recvMsg().trim();
                log.info(TAG, (Object)("startTime == " + startTime + "CardWithdraw Error"));
                throw new RuntimeException(errorText);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(TAG, (Object)"CardWithdraw Error");
                throw new IOException(e.getMessage());
            }
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vicCancel(byte[] packetData) throws IOException {
        block5: {
            log.info("\u5f00\u59cb\u4e8e\u540c\u57ce\u8fdb\u884c\u793c\u54c1\u5361\u51b2\u6b63");
            Date startTime = new Date();
            try {
                this.connect();
                this.sendInteger(this.version);
                this.sendString(this.storeCode);
                this.sendInteger(24);
                this.sendBlock(packetData, 0, packetData.length);
                this.errorCode = this.recvInteger();
                log.info("", (Object)("tvic check return code : " + this.errorCode));
                if (this.errorCode >= 0) {
                    PacketInfo vicPacket = EcardPacket.getTVicCancelPacket();
                    int length = this.recvInteger();
                    if (length != vicPacket.getPacketSize()) {
                        throw new RuntimeException("\u4e00\u5361\u901a\u534f\u8bae\u9519\u8bef");
                    }
                    byte[] vicData = new byte[length];
                    this.recvBlock(vicData, 0, vicData.length);
                    log.info(TAG, (Object)("startTime == " + startTime + ",TVic check"));
                    break block5;
                }
                errorText = this.recvString();
                log.info(TAG, (Object)("startTime == " + startTime + ",TVic check Error | " + errorText));
                throw new RuntimeException(errorText);
            }
            finally {
                this.disconnect();
            }
        }
    }

    public Map<String, String> getVicChargeMap() {
        return this.vicChargeMap;
    }

    public Map<String, String> getReChargeAmtMap() {
        return this.reChargeAmtMap;
    }

    public String getTranId() {
        return this.tranId;
    }

    public void setTranId(String tranId) {
        this.tranId = tranId;
    }

    public String getChargeId() {
        return this.chargeId;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public int getRecvTimeout() {
        return this.recvTimeout;
    }

    public void setRecvTimeout(int recvTimeout) {
        this.recvTimeout = recvTimeout;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }
}

