/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.posManager.request.SendCancelOrderLogIn;
import com.efuture.business.javaPos.struct.posManager.request.SendWorkLogIn;
import com.efuture.business.service.FunctionRemoteService;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class PromotionTask {
    private static final Logger log = LoggerFactory.getLogger(PromotionTask.class);
    @SoaAnnotation(value="/apiFunctionRemoteService.do")
    public FunctionRemoteService FunctionRemoteService;

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type) {
        this.sendWorkLog(session, order, type, null, null);
    }

    @Async
    public void sendOrderDiscWorkLog(ServiceSession session, Order order, String type, double amount) {
        this.sendWorkLog(session, order, type, null, 0.0, amount, null, null, true);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, 0.0, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, null, count, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount) {
        this.sendWorkLog(session, order, type, null, count, amount, null, null);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, info, count, amount, goodsName, goodsCode, false);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode, boolean isOrderDisc) {
        try {
            SendWorkLogIn in = new SendWorkLogIn();
            in.setErpCode(order.getErpCode());
            in.setMkt(order.getShopCode());
            in.setSyjh(order.getTerminalNo());
            in.setSyyh(order.getTerminalOperator());
            in.setBillno(order.getTerminalSno());
            in.setGoodsName(goodsName);
            in.setGoodsCode(goodsCode);
            in.setLogtype(type);
            in.setLogdesc(info);
            in.setCount(count);
            in.setAmount(amount);
            if (!WorkLogType.regMember.equals(type)) {
                if (WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type)) {
                    if (!StringUtils.isBlank((String)order.getRefundAuthzCardNo()) && !order.getTerminalOperator().equals(order.getRefundAuthzCardNo())) {
                        in.setAuthorizeGh(order.getRefundAuthzCardNo());
                    }
                } else if (isOrderDisc && StringUtils.isNotBlank((String)order.getTotalDiscAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTotalDiscAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTotalDiscAuthzCardNo());
                } else if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
                }
            }
            if (WorkLogType.delGoods.equals(type) || WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type)) {
                in.setRowno(order.getFlowNo());
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            in.setRqsj(nowDateTime);
            this.FunctionRemoteService.posWorkLog(session, (JSONObject)JSON.toJSON((Object)in));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return;
        }
    }

    @Async
    public void sendCancelOrderLog(ServiceSession session, Order order, List<Goods> goodsList, String type, String info) {
        try {
            SendCancelOrderLogIn in = new SendCancelOrderLogIn();
            in.setDelOrder(new ArrayList());
            SendWorkLogIn inData = new SendWorkLogIn();
            inData.setErpCode(order.getErpCode());
            inData.setMkt(order.getShopCode());
            inData.setSyjh(order.getTerminalNo());
            inData.setSyyh(order.getTerminalOperator());
            inData.setBillno(order.getTerminalSno());
            inData.setLogtype(type);
            inData.setLogdesc(info);
            if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                inData.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            inData.setRqsj(nowDateTime);
            for (Goods sg : goodsList) {
                SendWorkLogIn realData = (SendWorkLogIn)inData.clone();
                realData.setGoodsName(sg.getGoodsName());
                realData.setGoodsCode(sg.getGoodsCode());
                realData.setAmount(sg.getSaleAmount());
                realData.setCount(sg.getQty());
                in.getDelOrder().add(realData);
            }
            this.FunctionRemoteService.posWorkLog(session, (JSONObject)JSON.toJSON((Object)in));
            return;
        }
        catch (Exception e) {
            return;
        }
    }
}

