/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.cust;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicServiceImpl;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.PopDetailForPos;
import com.efuture.business.javaPos.struct.posManager.request.ActivitySerchIn;
import com.efuture.business.javaPos.struct.posManager.response.ActivitySerchOut;
import com.efuture.business.javaPos.struct.promotionCentre.SellPayment;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalSaleReturnIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcafFirmIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcsingleIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponGainCalcIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcsingleOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponGainCalcOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponuseConsumeOut;
import com.efuture.business.javaPos.struct.request.SaleReturnIn;
import com.efuture.business.service.RebateCodeHeadRemoteService;
import com.efuture.business.service.cust.PromotionCentreService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PromotionOfMssServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(PromotionOfMssServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(PromotionOfMssServiceImpl.class);
    RestTemplate restTemplate;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    public PromotionCentreService promotionCentreService;
    @Autowired
    private GlobalInfo globalInfo;
    @SoaAnnotation(value="/apiRebateCodeHeadRemoteService.do")
    private RebateCodeHeadRemoteService rebateCodeHeadRemoteService;

    public ServiceResponse calcaffirm(ServiceSession session, CalcafFirmIn in) {
        return this.promotionCentreService.calcaffirm(this.restTemplate, session, in);
    }

    public CacheModel calcSinglePop(ServiceSession session, String calcMode, String guid, Goods goods, CacheModel cacheModel, List<PopDetail> popDetails, boolean isAdd, boolean isRefreshBillId) {
        Object calcResp;
        CalcsingleOut calcsingleOut = null;
        CalcsingleIn calcsingleIn = null;
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if ("0".equals(calcMode)) {
            cacheModel.callMarketClear();
            calcsingleIn = CalcsingleIn.buildGetSaleGoodsInfoCalc((ServiceSession)session, (String)calcMode, (Goods)goods, (Order)cacheModel.getOrder(), (boolean)isRefreshBillId);
            calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
            if (!"0".equals(calcResp.getReturncode())) {
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg(calcResp.getData().toString());
                return cacheModel;
            }
            calcsingleOut = (CalcsingleOut)calcResp.getData();
            cacheModel.getOrder().setSeqNo(calcsingleOut.getCalcBillid());
            if (isAdd) {
                cacheModel = this.addOneGoods(cacheModel, goods);
            }
        }
        if ("1".equals(calcMode)) {
            if (popDetails == null || popDetails.isEmpty()) {
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u6ca1\u6709\u9009\u62e9\u4fc3\u9500\uff0c\u6dfb\u52a0\u5931\u8d25");
                return cacheModel;
            }
            if (guid == null || StringUtils.isBlank((String)guid)) {
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u9009\u62e9\u4fc3\u9500\u540e\u91cd\u7b97\u5355\u884c\u5fc5\u987b\u8f93\u5165\u5305\u542bguid");
                return cacheModel;
            }
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                for (Goods goodsA : cacheModel.getGoodsList()) {
                    if (!goodsA.getGuid().equals(guid)) continue;
                    goods = goodsA;
                    break;
                }
            }
            if (goods == null) {
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u6216\u5df2\u88ab\u5220\u9664");
                return cacheModel;
            }
            goods.setPopDetailsInfo(popDetails);
            calcsingleIn = CalcsingleIn.buildGetSaleGoodsInfoCalc((ServiceSession)session, (String)calcMode, (Goods)goods, (Order)cacheModel.getOrder(), (boolean)isRefreshBillId);
            cacheModel.callMarketClear();
            calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
            if (!"0".equals(calcResp.getReturncode())) {
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u6216\u5df2\u88ab\u5220\u9664");
                return cacheModel;
            }
            calcsingleOut = (CalcsingleOut)calcResp.getData();
        }
        cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterSingle(cacheModel, calcsingleOut, goods.getFlowId());
        return cacheModel;
    }

    public CacheModel addOneGoods(CacheModel cacheModel, Goods goods) {
        if (goods == null) {
            throw new RuntimeException("\u5546\u54c1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String guid = goods.getGuid();
        if (StringUtils.isEmpty((String)guid)) {
            throw new RuntimeException("guid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List goodsList = cacheModel.getGoodsList();
        this.appendGoods(goodsList, Arrays.asList(goods));
        cacheModel.setGoodsList(goodsList);
        return cacheModel;
    }

    public List<Goods> appendGoods(List<Goods> originGoodsList, List<Goods> goodsList) {
        if (originGoodsList == null) {
            originGoodsList = new ArrayList<Goods>();
        }
        int sortStart = originGoodsList.size();
        for (Goods g : goodsList) {
            g.setFlowId(++sortStart);
        }
        originGoodsList.addAll(goodsList);
        return originGoodsList;
    }

    public CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, boolean isCalcGifts, boolean isNewCalcId, boolean isRemoveAdjustDisc) {
        CalcIn calcIn = new CalcIn();
        boolean isNeedContinue = false;
        boolean isAddGoods = false;
        cacheModel.getOrder().setCalcMarketingMode("0");
        do {
            isNeedContinue = false;
            LOGGER.info("\u8f6c\u8425\u9500\u4e4b\u524dGoodsList[{}]", (Object)JSONObject.toJSONString((Object)cacheModel.getGoodsList()));
            calcIn.fromCacheModel(cacheModel, isNewCalcId, isRemoveAdjustDisc);
            cacheModel.clearOrderlist();
            cacheModel.getGiftsGroup().clear();
            calcIn.setCalcMode(calcMode);
            ServiceResponse calcOutRes = this.promotionCentreService.callCalc(this.restTemplate, session, calcIn);
            if (!calcOutRes.getReturncode().equals("0")) {
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8ba1\u7b97\u6574\u5355\u4f18\u60e0\u5931\u8d25");
                return cacheModel;
            }
            CalcOut calcOut = (CalcOut)calcOutRes.getData();
            if ((cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterOrder(cacheModel, calcOut, calcMode, isCalcGifts, session)).getCalcResult() == -1) {
                return cacheModel;
            }
            cacheModel.getOrder().setSeqNo(calcOut.getCalcBillid());
            if (isCalcGifts) {
                if (!("0".equals(calcOut.getCalcResult()) || "2".equals(calcOut.getCalcResult()) || "3".equals(calcOut.getCalcResult()) || "4".equals(calcOut.getCalcResult()))) {
                    isNeedContinue = true;
                    cacheModel.getOrder().setCalcMarketingMode(calcOut.getCalcResult());
                    calcMode = calcOut.getCalcResult();
                }
                if ("4".equals(calcOut.getCalcResult()) && (null == cacheModel.getGiftsGroup() || cacheModel.getGiftsGroup().size() <= 0)) {
                    if (this.isNeedcalcXZK(cacheModel, session)) {
                        isNeedContinue = false;
                        cacheModel.setCalcResult(Integer.valueOf(99));
                    } else {
                        if (-1 == cacheModel.getCalcResult()) {
                            return cacheModel;
                        }
                        isNeedContinue = true;
                        cacheModel.getOrder().setCalcMarketingMode("7");
                        calcMode = "7";
                    }
                }
                LOGGER.info("\u5f00\u59cb\u5224\u65ad\u5b66\u5b50\u5361\u6d3b\u52a8CalcResult=[{}] ,RemainValue=[{}]", (Object)calcOut.getCalcResult(), (Object)cacheModel.getOrder().getRemainValue());
                if ("7".equals(calcOut.getCalcResult()) && ManipulatePrecision.doubleCompare((double)cacheModel.getOrder().getRemainValue(), (double)0.0, (int)2) > 0) {
                    if (this.isNeedcalcXZK(cacheModel, session)) {
                        isNeedContinue = false;
                        cacheModel.setCalcResult(Integer.valueOf(99));
                    } else {
                        if (-1 == cacheModel.getCalcResult()) {
                            return cacheModel;
                        }
                        isNeedContinue = true;
                    }
                }
            }
            this.posLogicServiceImpl.calcOrderAmount(cacheModel);
            if (-1 == cacheModel.getCalcResult()) {
                return cacheModel;
            }
            if (!isNeedContinue) continue;
            isNewCalcId = false;
        } while (isNeedContinue || cacheModel.getCalcResult() == -999);
        if (cacheModel.getGiftsGroup().size() <= 0 && cacheModel.getExceptPayDetails().size() <= 0 && cacheModel.getLimitedPayDetails().size() <= 0 && isAddGoods) {
            this.posLogicServiceImpl.calcOrderAmount(cacheModel);
            cacheModel.setCalcResult(Integer.valueOf(-3));
        }
        return cacheModel;
    }

    public CacheModel calcSinglePopMember(ServiceSession session, CacheModel cacheModel, boolean needCalcDisc) {
        CalcsingleIn calcsingleIn = CalcsingleIn.memberLoginCreateCalcsingleIn((Order)cacheModel.getOrder(), (List)cacheModel.getGoodsList());
        ServiceResponse calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
        if (!"0".equals(calcResp.getReturncode())) {
            cacheModel.setCalcResult(Integer.valueOf(-1));
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8425\u9500\u4e2d\u5fc3\u8ba1\u7b97\u5355\u884c\u51fa\u9519");
            return cacheModel;
        }
        CalcsingleOut calcsingleOut = (CalcsingleOut)calcResp.getData();
        cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterSingleAll(cacheModel, calcsingleOut, needCalcDisc);
        return cacheModel;
    }

    public CacheModel calcSinglePopAll(ServiceSession session, String calcMode, CacheModel cacheModel, boolean needCalcDisc) {
        CalcsingleIn calcsingleIn = CalcsingleIn.buildAddBatchGoodsCalc((ServiceSession)session, (List)cacheModel.getGoodsList(), (Order)cacheModel.getOrder());
        ServiceResponse calcResp = null;
        try {
            calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setCalcResult(Integer.valueOf(-1));
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8425\u9500\u4e2d\u5fc3\u8ba1\u7b97\u5355\u884c\u51fa\u9519:{" + e.getLocalizedMessage());
            return cacheModel;
        }
        if (!"0".equals(calcResp.getReturncode())) {
            cacheModel.setCalcResult(Integer.valueOf(-1));
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8425\u9500\u4e2d\u5fc3\u8ba1\u7b97\u5355\u884c\u51fa\u9519");
            return cacheModel;
        }
        CalcsingleOut calcsingleOut = (CalcsingleOut)calcResp.getData();
        cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterSingleAll(cacheModel, calcsingleOut, needCalcDisc);
        return cacheModel;
    }

    public CacheModel calcCouponGain(ServiceSession session, CacheModel cacheModel) throws Exception {
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        CouponGainCalcIn couponGainCalcIn = new CouponGainCalcIn();
        couponGainCalcIn.fromCacheModel(cacheModel);
        double discountAmount = this.posLogicServiceImpl.CalcPopDetail(cacheModel);
        ServiceResponse response = this.promotionCentreService.coupongainCalc(this.restTemplate, session, couponGainCalcIn);
        LOGGER.info("returncode = " + response.getReturncode());
        Object responseNew = null;
        if (!response.getReturncode().equals("0")) {
            if (YPopStatusType.returncode_88888.equals(response.getReturncode())) {
                couponGainCalcIn.setCalcBillid("");
                response = this.promotionCentreService.coupongainCalc(this.restTemplate, session, couponGainCalcIn);
                LOGGER.info("\u7b2c\u4e8c\u6b21returncode = " + response.getReturncode());
                if (!(response.getReturncode().equals("0") || "Y10".equals(cacheModel.getOrder().getOrderType()) || "Y11".equals(cacheModel.getOrder().getOrderType()) || SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType()))) {
                    if (!"60003".equals(response.getReturncode())) {
                        List reversePayments = couponuseConsumeIn.getSellPayments();
                        cacheModel.setReversePayments(reversePayments);
                        response.setReturncode(this.couponConsume(cacheModel, session, 2).getReturncode());
                    }
                    cacheModel.setCalcResult(Integer.valueOf(-1));
                    cacheModel.setErrCode(response.getReturncode());
                    cacheModel.setErrMsg("\u4fc3\u92b7\u4e2d\u5fc3\u4fdd\u5b58\u8a02\u55ae\u5931\u6557");
                    return cacheModel;
                }
            } else if (!("Y10".equals(cacheModel.getOrder().getOrderType()) || "Y11".equals(cacheModel.getOrder().getOrderType()) || SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType()))) {
                if (!"60003".equals(response.getReturncode())) {
                    List reversePayments = couponuseConsumeIn.getSellPayments();
                    cacheModel.setReversePayments(reversePayments);
                    response.setReturncode(this.couponConsume(cacheModel, session, 2).getReturncode());
                }
                cacheModel.setCalcResult(Integer.valueOf(-1));
                cacheModel.setErrCode(response.getReturncode());
                cacheModel.setErrMsg("\u4fc3\u92b7\u4e2d\u5fc3\u4fdd\u5b58\u8a02\u55ae\u5931\u6557");
                return cacheModel;
            }
        }
        LOGGER.info("\u8425\u9500\u4fdd\u5b58\u5b8c\u6bd5");
        CouponGainCalcOut couponGainCalcOut = (CouponGainCalcOut)response.getData();
        cacheModel = this.posLogicServiceImpl.RefreshOrderAfterOrderSave(cacheModel, couponGainCalcOut);
        if (cacheModel == null || !this.posLogicServiceImpl.JYPopDiscountAmount(discountAmount, cacheModel)) {
            cacheModel = this.posLogicServiceImpl.deletePopDetail(cacheModel);
            List reversePayments = couponuseConsumeIn.getSellPayments();
            cacheModel.setReversePayments(reversePayments);
            response = ServiceResponse.buildFailure((ServiceSession)session, (String)this.couponConsume(cacheModel, session, 3).getReturncode(), (String)"\u4fc3\u92b7\u6298\u6263\u4e0d\u4e00\u81f4!");
            cacheModel.setCalcResult(Integer.valueOf(-1));
            cacheModel.setErrCode(response.getReturncode());
            cacheModel.setErrMsg("\u4fc3\u92b7\u6298\u6263\u4e0d\u4e00\u81f4!");
            return cacheModel;
        }
        return cacheModel;
    }

    private ServiceResponse couponConsume(CacheModel cacheModel, ServiceSession session, int payConfirmStatus) {
        try {
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setType("1");
            ServiceResponse response = this.promotionCentreService.couponAndPointsConsume(this.restTemplate, session, couponuseConsumeIn);
            if ("0".equals(response.getReturncode()) || YPopStatusType.returncode_99998.equals(response.getReturncode())) {
                cacheModel.getReversePayments().clear();
                payConfirmStatus = 0;
                response.setReturncode("2000");
            } else {
                response.setReturncode("2001");
                payConfirmStatus = Integer.valueOf(payConfirmStatus + "1");
                String msg = "\u6c96\u6b63\u5931\u6557-" + payConfirmStatus + "-" + response.getData();
                response.setData((Object)msg);
            }
            cacheModel.setPayConfirmStatus(Integer.valueOf(payConfirmStatus));
            return response;
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
    }

    public CacheModel couponuseConsumeForPay(CacheModel cacheModel, ServiceSession session) {
        try {
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setType("0");
            List couponPayments = this.posLogicServiceImpl.getCouponPayments(cacheModel.getPayments());
            if (couponPayments != null && couponPayments.size() != 0) {
                LOGGER.info("\u8425\u9500\u5238\u6838\u9500\uff01");
                couponuseConsumeIn.setSellPayments(Payment.transferSellPayment((List)cacheModel.getPayments(), (boolean)SellType.ISBACK((String)cacheModel.getOrder().getOrderType())));
                ServiceResponse response = this.promotionCentreService.cpfconsume(this.restTemplate, session, couponuseConsumeIn);
                if (!"0".equals(response.getReturncode())) {
                    cacheModel.setCalcResult(Integer.valueOf(-1));
                    cacheModel.setErrCode(response.getReturncode());
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setErrMsg(response.getData().toString());
                    } else {
                        cacheModel.setErrMsg(response.getData().toString());
                    }
                    return cacheModel;
                }
                CouponuseConsumeOut couponuseConsumeOut = (CouponuseConsumeOut)response.getData();
                List orgPaylist = cacheModel.getPayments();
                ArrayList couponPayBatch = new ArrayList();
                ArrayList<Payment> couponPayDetails = new ArrayList<Payment>();
                if (null != couponuseConsumeOut && null != couponuseConsumeOut.getSellPayments()) {
                    block2: for (int i = 0; i < couponuseConsumeOut.getSellPayments().size(); ++i) {
                        boolean isBatchPay = false;
                        SellPayment p = (SellPayment)couponuseConsumeOut.getSellPayments().get(i);
                        if (null == p) continue;
                        for (Payment orgPay : cacheModel.getPayments()) {
                            if (p.getRowNoId().equals(orgPay.getPuid()) || p.getRowNoId().equals(orgPay.getRownoId())) {
                                orgPay.setRowno(p.getRowNo());
                                orgPay.setRownoId(p.getRowNoId());
                                continue block2;
                            }
                            if (StringUtils.isEmpty((String)orgPay.getBatchNo()) || StringUtils.isEmpty((String)p.getBatchId()) || !orgPay.getBatchNo().equals(p.getBatchId())) continue;
                            Payment couponPayDetail = (Payment)orgPay.clone();
                            couponPayDetail = Payment.SellPaymentToPayment((SellPayment)p, (Payment)couponPayDetail);
                            couponPayDetails.add(couponPayDetail);
                            continue block2;
                        }
                    }
                }
                if (couponPayDetails.size() > 0) {
                    Iterator iteraPay2 = cacheModel.getPayments().iterator();
                    block4: while (iteraPay2.hasNext()) {
                        Payment orgPay2 = (Payment)iteraPay2.next();
                        for (int i = 0; i < couponPayDetails.size(); ++i) {
                            Payment couponPayDetail2 = (Payment)couponPayDetails.get(i);
                            if (!couponPayDetail2.getBatchNo().equals(orgPay2.getBatchNo())) continue;
                            iteraPay2.remove();
                            continue block4;
                        }
                    }
                }
                cacheModel.getPayments().addAll(couponPayDetails);
            }
            return cacheModel;
        }
        catch (Exception e) {
            cacheModel.setCalcResult(Integer.valueOf(-1));
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg(e.getMessage());
            return cacheModel;
        }
    }

    protected boolean isNeedcalcXZK(CacheModel cacheModel, ServiceSession session) {
        boolean needCallXZK = false;
        List saleGoods = cacheModel.getGoodsList();
        for (Goods goods : saleGoods) {
            if (this.isHaveDiscount(goods)) continue;
            needCallXZK = true;
            break;
        }
        if (needCallXZK) {
            if ("0".equals(GlobalInfo.mssLocalIsOpen)) {
                ActivitySerchIn activitySerchIn = new ActivitySerchIn();
                activitySerchIn.setErpCode(cacheModel.getOrder().getErpCode());
                activitySerchIn.setMkt(cacheModel.getOrder().getShopCode());
                log.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{cacheModel.getFlowNo(), "\u67e5\u8be2\u5b66\u5b50\u5361\u4e3b\u9898\u6d3b\u52a8", JSONObject.toJSONString((Object)activitySerchIn)});
                RespBase resp = this.rebateCodeHeadRemoteService.search(session, (JSONObject)JSONObject.toJSON((Object)activitySerchIn));
                log.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{cacheModel.getFlowNo(), "\u67e5\u8be2\u5b66\u5b50\u5361\u4e3b\u9898\u6d3b\u52a8", JSONObject.toJSONString((Object)resp)});
                if (Code.CODE_70012.getIndex() == resp.getRetflag()) {
                    LOGGER.info("\u5f53\u524d\u6536\u94f6\u673a[\u8131\u673a]\u72b6\u6001\uff0c\u4e0d\u53c2\u4e0e\u5b66\u5b50\u5361\u5224\u65ad!");
                } else {
                    if (0 != resp.getRetflag()) {
                        LOGGER.info("\u67e5\u8be2\u95e8\u5e97\u5b66\u5b50\u5361\u6d3b\u52a8\u4e3b\u9898\u5931\u8d25!ErrorCode=[{}],msg=[{}]", (Object)resp.getRetflag(), resp.getData());
                        cacheModel.setCalcResult(Integer.valueOf(-1));
                        cacheModel.setErrCode(String.valueOf(resp.getRetflag()));
                        cacheModel.setErrMsg("\u67e5\u8be2\u95e8\u5e97\u5b66\u5b50\u5361\u6d3b\u52a8\u4e3b\u9898\u5931\u8d25!:" + resp.getRetmsg());
                        return false;
                    }
                    JSONObject respObj = (JSONObject)resp.getData();
                    ActivitySerchOut searchOut = (ActivitySerchOut)JSONObject.toJavaObject((JSON)respObj, ActivitySerchOut.class);
                    if (searchOut.getTotal_results() > 0) {
                        cacheModel.setRebatecodehead(searchOut.getRebatecodehead());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean isHaveDiscount(Goods goods) {
        if (goods.getTotalDiscountValue() > 0.0) {
            return true;
        }
        List pops = goods.getPopDetailsInfo();
        if (null == pops || pops.size() == 0) {
            return false;
        }
        LOGGER.info("goodsCode[{}] PopDetails{}", (Object)goods.getGoodsCode(), (Object)JSONObject.toJSONString((Object)pops));
        for (PopDetailForPos popDetail : pops) {
            if (!"0".equals(popDetail.getPopMode()) || !"GIFT".equals(popDetail.getPopPolicyGroup())) continue;
            LOGGER.info("goodsCode[{}] \u5df2\u7ecf\u9009\u8d60\u54c1\uff0c\u4e0d\u53c2\u4e0e\u5b66\u5b50\u5361\u6d3b\u52a8", (Object)goods.getGoodsCode());
            return true;
        }
        return false;
    }

    public ServiceResponse calSaleReturn(ServiceSession session, CacheModel cacheModel, SaleReturnIn salesReturnIn, String refundCalcMode) throws Exception {
        CalSaleReturnIn calSaleReturnIn = new CalSaleReturnIn(cacheModel, refundCalcMode);
        cacheModel.callMarketClear();
        ServiceResponse sr = this.promotionCentreService.calSaleReturn(this.restTemplate, session, calSaleReturnIn);
        return sr;
    }
}

