/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.cust;

import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicServiceImpl;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.service.ManualDiscountService;
import com.efuture.business.service.PromotionOfMssService;
import com.efuture.business.task.PromotionTask;
import com.efuture.business.util.CastUtil;
import com.efuture.business.vo.InputAllVO;
import com.efuture.business.vo.InputSingleVO;
import com.product.model.ServiceSession;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ManualDiscount
implements ManualDiscountService {
    private static final Logger log = LoggerFactory.getLogger(ManualDiscount.class);
    @Autowired
    private PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PromotionOfMssService promotionOfMssServiceImpl;
    @Autowired
    PromotionTask promotionTask;

    public RespBase<ResqVo> disc(ServiceSession session, InputAllVO inputAllVO) {
        log.info("\u624b\u6298\u6263\u5f00\u59cb!!!!");
        Double discountRate = inputAllVO.getDiscountRate();
        if (inputAllVO.getMode().equals("1")) {
            discountRate = Double.valueOf(100.0) - discountRate;
        } else if (inputAllVO.getMode().equals("0")) {
            // empty if block
        }
        if (discountRate == null) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputAllVO.getAccreditNo();
        CacheModel cacheModel = inputAllVO.getResqVO().getCacheModel();
        cacheModel.setCalcResult(0);
        if (cacheModel == null) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u8ba2\u5355\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c"});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1"});
        }
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivzpzkl() < 0.0) {
            return Code.CODE_30030.getRespBase(new Object[]{"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u6574\u5355\u6253\u6298"});
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        double tempZzr = cacheModel.getOrder().getTempZzr();
        cacheModel = this.posLogicCompoment.removeZzr(cacheModel);
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcOrderRebateByRateBeforeOrder(cacheModel, accreditNo, discountRate.doubleValue())).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return Code.CODE_30030.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return Code.CODE_60.getRespBase(new Object[0]);
        }
        if (tempZzr != 0.0) {
            cacheModel = this.posLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder(cacheModel, cacheModel.getCurGrant().getGh(), tempZzr, 0);
        }
        log.info("\u662f\u5426\u767b\u5f55\u5458\u5de5\u5361==>{}", (Object)cacheModel.getOrder().getStaffLogin());
        log.info("getStaffSale==>{}", (Object)cacheModel.getOrder().getStaffSale());
        log.info("getStaffCardNo==>{}", (Object)cacheModel.getOrder().getStaffCardNo());
        log.info("getStaffCreditCardNo==>{}", (Object)cacheModel.getOrder().getStaffCreditCardNo());
        log.info("getStaffNo==>{}", (Object)cacheModel.getOrder().getStaffNo());
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getStaffNo())) {
            log.info("cacheModel.getOrder().getDiscAmount()==>{}", (Object)cacheModel.getOrder().getDiscAmount());
            log.info("cacheModel.getOrder().getTempZzr()==>{}", (Object)cacheModel.getOrder().getTempZzr());
            log.info("cacheModel.getOrder().getTempZzk()==>{}", (Object)cacheModel.getOrder().getTempZzk());
            if (cacheModel.getOrder().getTempZzr() == 0.0 && (cacheModel.getOrder().getTempZzk() == 100.0 || cacheModel.getOrder().getTempZzk() == 0.0)) {
                log.info("\u6ca1\u6709\u624b\u5de5\u6298\u6263,\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u53ef\u7528");
                cacheModel.getOrder().setStaffSale(true);
            } else {
                log.info("\u624b\u5de5\u6298\u6263,\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u4e0d\u53ef\u7528");
                cacheModel.getOrder().setStaffSale(false);
            }
            if (inputAllVO.getDiscountRate() == 100.0 && "1".equals(inputAllVO.getMode())) {
                cacheModel.getOrder().setStaffSale(true);
            }
        } else {
            log.info("\u65e0\u5458\u5de5\u5361");
        }
        log.info("\u6574\u5355\u6298\u6263\u5224\u65ad\u662f\u5426\u5458\u5de5\u4ea4\u6613>>>{},PopMode==>{}", (Object)cacheModel.getOrder().getStaffSale(), (Object)cacheModel.getPopMode());
        if (cacheModel.getOrder().getStaffSale()) {
            log.info("\u6574\u5355\u6298\u6263\u6709\u5458\u5de5\u4f18\u60e0,\u53d6\u6d88\u8ba1\u7b97");
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2) {
                cacheModel = this.promotionOfMssServiceImpl.calcSinglePopAll(session, "0", cacheModel, false);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            cacheModel.getOrder().setStaffSale(false);
        }
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.promotionTask.sendOrderDiscWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)));
        inputAllVO.getResqVO().setCacheModel(cacheModel);
        log.info("\u624b\u6298\u6263\u7ed3\u675f!!!!");
        return new RespBase(Code.SUCCESS, (Object)inputAllVO.getResqVO());
    }

    public RespBase<ResqVo> discAmount(ServiceSession session, InputAllVO inputAllVO) {
        Double discountAmount = inputAllVO.getDiscountAmount();
        if (discountAmount == null) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u6298\u8ba9\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputAllVO.getAccreditNo();
        int mode = 0;
        if (!StringUtils.isBlank((String)inputAllVO.getMode())) {
            mode = CastUtil.castInt((Object)inputAllVO.getMode());
        }
        CacheModel cacheModel = inputAllVO.getResqVO().getCacheModel();
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if (cacheModel == null) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u8ba2\u5355\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c"});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1"});
        }
        if (-1 == cacheModel.getCalcResult()) {
            return Code.CODE_30040.getRespBase(new Object[]{"CalcResult-1\u65f6\u4e0d\u80fd\u4fee\u6539\u5546\u54c1"});
        }
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivzpzkl() < 0.0) {
            return Code.CODE_30040.getRespBase(new Object[]{"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u6574\u5355\u6253\u6298"});
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder(cacheModel, accreditNo, discountAmount.doubleValue(), mode)).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return Code.CODE_30040.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return Code.CODE_60.getRespBase(new Object[0]);
        }
        if (1 == mode) {
            cacheModel.getOrder().setDiscAmount(discountAmount.doubleValue());
        }
        inputAllVO.getResqVO().setCacheModel(cacheModel);
        if (-1 == cacheModel.getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return Code.CODE_30040.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        log.info("1\u662f\u5426\u767b\u5f55\u5458\u5de5\u5361==>{}", (Object)cacheModel.getOrder().getStaffLogin());
        log.info("1getStaffSale==>{}", (Object)cacheModel.getOrder().getStaffSale());
        log.info("1getStaffCardNo==>{}", (Object)cacheModel.getOrder().getStaffCardNo());
        log.info("1getStaffCreditCardNo==>{}", (Object)cacheModel.getOrder().getStaffCreditCardNo());
        log.info("1getStaffNo==>{}", (Object)cacheModel.getOrder().getStaffNo());
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getStaffNo())) {
            log.info("discAmount  getDiscAmount()==>{}", (Object)cacheModel.getOrder().getDiscAmount());
            log.info("discAmount  getOrder().getTempZzr()==>{}", (Object)cacheModel.getOrder().getTempZzr());
            log.info("discAmount  getOrder().getTempZzk()==>{}", (Object)cacheModel.getOrder().getTempZzk());
            if (!(cacheModel.getOrder().getStaffSale() || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 100.0 && cacheModel.getOrder().getTempZzk() != 0.0)) {
                log.info("\u6ca1\u6709\u624b\u5de5\u6298\u6263,\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u53ef\u7528");
                cacheModel.getOrder().setStaffSale(true);
            } else {
                log.info("\u624b\u5de5\u6298\u6263,\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u4e0d\u53ef\u7528");
                cacheModel.getOrder().setStaffSale(false);
            }
            if (inputAllVO.getDiscountAmount() == 0.0 && "1".equals(inputAllVO.getMode())) {
                cacheModel.getOrder().setStaffSale(true);
            }
        }
        log.info("\u5224\u65ad\u662f\u5426\u5458\u5de5\u4ea4\u6613!!!!!>>>{}", (Object)cacheModel.getOrder().getStaffSale());
        if (cacheModel.getOrder().getStaffSale()) {
            log.info(">>>>>\u5458\u5de5\u4ea4\u6613cacheModel.getPopMode()===>{}", (Object)cacheModel.getPopMode());
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2) {
                cacheModel = this.promotionOfMssServiceImpl.calcSinglePopAll(session, "0", cacheModel, false);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (-1 == cacheModel.getCalcResult()) {
                return Code.CODE_30040.getRespBase(new Object[]{cacheModel.getErrMsg()});
            }
            cacheModel.getOrder().setStaffSale(false);
        } else {
            log.info(">>>>>\u975e\u5458\u5de5\u4ea4\u6613");
        }
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.promotionTask.sendOrderDiscWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)));
        return new RespBase(Code.SUCCESS, (Object)inputAllVO.getResqVO());
    }

    public RespBase<ResqVo> singleDisc(ServiceSession session, InputSingleVO inputSingleVO) {
        Double discountRate = inputSingleVO.getDiscountRate();
        if (inputSingleVO.getMode().equals("1")) {
            discountRate = ManipulatePrecision.doubleConvert((double)(100.0 - discountRate));
        } else if (inputSingleVO.getMode().equals("0")) {
            // empty if block
        }
        if (discountRate == null) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputSingleVO.getAccreditNo();
        String guid = inputSingleVO.getGuid();
        if (guid == null || guid.isEmpty()) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u5546\u54c1\u884c\u552f\u4e00\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = inputSingleVO.getResqVO().getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        Goods existGood = Goods.findGoods((String)guid, (List)cacheModel.getGoodsList());
        if (null == existGood) {
            return Code.CODE_30010.getRespBase(new Object[]{"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230"});
        }
        if ("9".equals(existGood.getFlag())) {
            return Code.CODE_20107.getRespBase(new Object[]{"\u5370\u82b1\u7801\u5546\u54c1\u65e0\u6cd5\u6253\u6298"});
        }
        if (StringUtils.isNotBlank((String)existGood.getEBillFlowNo())) {
            return Code.CODE_20113.getRespBase(new Object[]{"\u7535\u5b50\u5f00\u7968\u5546\u54c1\u65e0\u6cd5\u5355\u884c\u6253\u6298"});
        }
        int flowId = existGood.getFlowId();
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivdpzkl() < 0.0) {
            return new RespBase(Code.CODE_1000.getIndex(), "\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u5355\u54c1\u6253\u6298", (Object)inputSingleVO.getResqVO());
        }
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcGoodsRebateByRateBeforeSingle(cacheModel, flowId, accreditNo, discountRate.doubleValue())).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputSingleVO.getResqVO());
        }
        if ("STAFF".equals(existGood.getKlm())) {
            if (cacheModel.getPopMode() == 1) {
                cacheModel = this.promotionOfMssServiceImpl.calcSinglePop(session, "0", "", existGood, cacheModel, null, false, false, false);
            } else if (cacheModel.getPopMode() == 2) {
                cacheModel = this.promotionOfMssServiceImpl.calcSinglePopAll(session, "0", cacheModel, false);
            }
            if (-1 == cacheModel.getCalcResult()) {
                return new RespBase(Integer.parseInt(cacheModel.getErrCode()), cacheModel.getErrMsg(), (Object)inputSingleVO.getResqVO());
            }
        }
        this.posLogicServiceImpl.calcOrderAmount(cacheModel);
        inputSingleVO.getResqVO().setCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.promotionTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGood.getGoodsName(), existGood.getGoodsCode());
        return new RespBase(Code.SUCCESS, (Object)inputSingleVO.getResqVO());
    }

    public RespBase<ResqVo> singleDiscAmount(ServiceSession session, InputSingleVO inputSingleVO) {
        Double discountAmount = inputSingleVO.getDiscountAmount();
        if (discountAmount == null) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u6298\u8ba9\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = inputSingleVO.getAccreditNo();
        String guid = inputSingleVO.getGuid();
        if (guid == null || guid.isEmpty()) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u5546\u54c1\u884c\u552f\u4e00\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = inputSingleVO.getResqVO().getCacheModel();
        if (null == cacheModel) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355"});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u8ba2\u5355\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1"});
        }
        Goods existGood = Goods.findGoods((String)guid, (List)cacheModel.getGoodsList());
        if (null == existGood) {
            return Code.CODE_30020.getRespBase(new Object[]{"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230"});
        }
        if ("9".equals(existGood.getFlag())) {
            return Code.CODE_20107.getRespBase(new Object[]{"\u5370\u82b1\u7801\u5546\u54c1\u65e0\u6cd5\u6253\u6298"});
        }
        if (StringUtils.isNotBlank((String)existGood.getEBillFlowNo())) {
            return Code.CODE_20113.getRespBase(new Object[]{"\u7535\u5b50\u5f00\u7968\u5546\u54c1\u65e0\u6cd5\u5355\u884c\u6253\u6298"});
        }
        int flowId = existGood.getFlowId();
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivdpzkl() < 0.0) {
            return new RespBase(Code.CODE_1000.getIndex(), "\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u5355\u54c1\u6253\u6298", (Object)inputSingleVO.getResqVO());
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcGoodsRebateByAmountBeforeSingle(cacheModel, flowId, accreditNo, discountAmount.doubleValue(), Integer.parseInt(inputSingleVO.getMode()), false)).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)inputSingleVO.getResqVO());
        }
        if ("STAFF".equals(existGood.getKlm())) {
            if (cacheModel.getPopMode() == 1) {
                cacheModel = this.promotionOfMssServiceImpl.calcSinglePop(session, "0", "", existGood, cacheModel, null, false, false, false);
            } else if (cacheModel.getPopMode() == 2) {
                cacheModel = this.promotionOfMssServiceImpl.calcSinglePopAll(session, "0", cacheModel, false);
            }
            if (-1 == cacheModel.getCalcResult()) {
                return new RespBase(Integer.parseInt(cacheModel.getErrCode()), cacheModel.getErrMsg(), (Object)inputSingleVO.getResqVO());
            }
        }
        inputSingleVO.getResqVO().setCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.promotionTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, ManipulatePrecision.doubleConvert((double)(oldAmount - newAmount)), existGood.getGoodsName(), existGood.getGoodsCode());
        return new RespBase(Code.SUCCESS, (Object)inputSingleVO.getResqVO());
    }
}

